(ns kixipipe.google.auth
  (:import [com.google.api.client.googleapis.auth.oauth2 GoogleCredential$Builder])
  (:require [clojure.java.io :as io]
            [clojure.tools.logging :as log]))

(def HTTP_TRANSPORT (com.google.api.client.http.javanet.NetHttpTransport.))
(def JSON_FACTORY (com.google.api.client.json.gson.GsonFactory.))

(defn build-credential [{:keys [email-address p12-file]} scopes]
  (-> (GoogleCredential$Builder.)
      (.setTransport HTTP_TRANSPORT)
      (.setJsonFactory JSON_FACTORY)
      (.setServiceAccountId email-address)
      (.setServiceAccountPrivateKeyFromP12File (io/as-file p12-file))
      (.setServiceAccountScopes scopes)
      (.build)))
  
(defn authenticate [{:keys [credential] :as session}]
  (if (.refreshToken credential)
    (log/info "Successfully refreshed token")
    (log/error "Failed to refresh token!"))
  session)


