(ns kixipipe.storage
  "Short package description."
  (:require [clj-time.core :as t]
            [clj-time.format :as tf]))

(def  date-formatter (:basic-date tf/formatters))

(defn date-as-string [dt]
  (when dt
    (let [date (if (= :now dt) (t/now))]
      (tf/unparse date-formatter date))))

(defn date-from-string [s]
  (when s
    (tf/parse date-formatter s)))

(defn item-from-key
  "Given a storage key produce an item containing the data stored in the key"
  [key]
  (if-let [[_ src feed-name feed-suffix date-str] (re-matches #"(\w+)/(\w+)(?:-(\w+))?/(\w+)/.*" key)]
    {:src-name src
     :feed-name feed-name
     :feed-suffix feed-suffix
     :date (date-from-string date-str)}))
