(ns kixipipe.string
  "String utilities."
  (:require [clojure.string :as str]))

(defn map-replace 
  "for each occurrence of {key} in s replace all occurences with the value of that key in m

   (string-map-replace \"{foo} or {bar}\" {:foo 1 :bar 2}) => \"1 or 2\""
  [s m]
  (reduce-kv (fn [ret k v]
               (str/replace ret
                            (re-pattern (str "\\{" (name k) "\\}"))
                            (str v)))
             s m))
