(ns kixipipe.protocols
  "Various useful protocols")

(defprotocol ^{:no-doc true} Mappable
  "Convert a value into a Clojure map."
  (^{:no-doc true} ->map [x] "Return a map of the value."))

;;; Services should provide a function `mk-session` that returns something implementing
;;; the `FeedSession` protocol. This session should encapsulate everything required to maintain
;;; a logical session with some remote service
(defprotocol FeedSession
  (feed-details [session name options]))

(defprotocol FeedItem
  (src-name [item])
  (download! [item session])
  (matches? [item item]))

;;; StorageSession
(defprotocol StorageSession
  (list-items [session src-name feed-name options]))

(defprotocol Lifecycle
  (start [system])
  (stop [system]))
