(ns kixipipe.window
  (:require [clojure.core.match :refer (match)]
            [clj-time.core :as t]
            [clj-time.periodic :as p]))

(defmulti period->offset (fn [period _] period))
(defmethod period->offset :start-of-month [_ offset]
  (let [m (period->offset :month offset)]
    (t/date-time (t/year m) (t/month m))))
(defmethod period->offset :month [_ offset]
  (t/plus (t/today-at-midnight) (t/months offset)))
(defmethod period->offset :day [_ offset]
  (t/plus (t/today-at-midnight) (t/days offset)))
(defmethod period->offset :hour [_ offset]
  (t/plus (apply t/date-time ((juxt t/year t/month t/day t/hour) (t/now))) ; now, no mins
          (t/hours offset)))

(defmulti keyword->offset identity)
(defmethod keyword->offset :today [_] (t/today-at-midnight))
(defmethod keyword->offset :now [_] (t/now))
(defmethod keyword->offset :last-week [_] (period->offset :day -7))
(defmethod keyword->offset :last-fortnight [_] (period->offset :day -14))

(defn dates-in-window [[s e]]
  (let [[start end]  (match [s e]
                            [[p o] [p' o']] [(period->offset p o) (period->offset p' o')]
                            [[p o] k]       [(period->offset p o) (keyword->offset k)]
                            [k [p o]]       [(keyword->offset k) (period->offset p o)])]
    (take-while #(t/before? % end) (p/periodic-seq start (t/days 1)))))

(defn hours-in-window [[s e]]
  (let [[start end]  (match [s e]
                            [[p o] [p' o']] [(period->offset p o) (period->offset p' o')]
                            [[p o] k]       [(period->offset p o) (keyword->offset k)]
                            [k [p o]]       [(keyword->offset k) (period->offset p o)])]
    (take-while #(t/before? % end) (p/periodic-seq start (t/hours 1)))))
