(ns integral.schema
   (:require [schema.core :as s]
             [schema-contrib.core :as sc]))

(def integral
  [(s/one sc/ISO-Date-Time "date_received")
   (s/one s/Int "hit_hour")
   (s/one s/Int "time_received") ;;no bigint
   (s/one s/Str "ip_address")
   (s/one s/Str "full_url")
   (s/one s/Int "ext_adnetwork_id")
   (s/one s/Int "ext_advertiser_id") ;;no bigint
   (s/one s/Int "ext_campaign_id") ;;no bigint
   (s/one s/Int "ext_plan_id") ;;no bigint
   (s/one s/Int "ext_publisher_id") ;;no bigint
   (s/one s/Int "ext_channel_id") ;;no bigint
   (s/one s/Int "ext_placement_id") ;;no bigint
   (s/one s/Int "adult_sc")
   (s/one s/Int "alcohol_sc")
   (s/one s/Int "download_sc")
   (s/one s/Int "drug_sc")
   (s/one s/Int "hate_sc")
   (s/one s/Int "offensive_language_sc")
   (s/one s/Str "in_viewability_sample")
   (s/one s/Str "in_view_field")
   (s/one s/Int "viewability_enum")
   (s/one s/Num "sad_risk")
   (s/one s/Str "confidence")
   (s/one s/Str "no_viewability_reason")
   (s/one s/Num "max_fraction_in_view")
   (s/one s/Int "ext_uid") ;;no bigint
   (s/one s/Int "ext_imp_id") ;;no bigint
   (s/one s/Str "user_agent_str")
   (s/one s/Str "browser")
   (s/one s/Str "platform")
   (s/one s/Str "os")
   (s/one s/Str "action")
   (s/one s/Str "reason")
   (s/one s/Str "country")
   (s/one s/Str "state")
   (s/one s/Str "dma")
   (s/one s/Str "iab_categories")
   (s/one s/Num "in_view_time")
   (s/one s/Num "in_view_1s")
   (s/one s/Num "in_view_5s")
   (s/one s/Num "in_view_15s")
   (s/one s/Str "ext_bid_url")
   (s/one s/Num "ext_bid_price")
   (s/one s/Str "traq_bucket")])
