(ns appnexus.schema
  (:require [schema.core :as s]
            [schema-contrib.core :as sc]))

(def standard_feed
  [(s/one s/Int "auction_id_64") ;;no bigint
   (s/one sc/ISO-Date-Time "datetime")
   (s/one s/Int "user_tz_offset")
   (s/one s/Int "width")
   (s/one s/Int "height")
   (s/one s/Int "media_type")
   (s/one s/Int "fold_position")
   (s/one s/Str "event_typeimpression")
   (s/one s/Int "imp_type")
   (s/one s/Int "payment_type")
   (s/one s/Num "media_cost_dollars_cpm")
   (s/one s/Int "revenue_type")
   (s/one s/Num "buyer_spend")
   (s/one s/Num "buyer_bid")
   (s/one s/Num "ecp")
   (s/one s/Num "eap")
   (s/one s/Int "is_imp")
   (s/one s/Int "is_learn")
   (s/one s/Int "predict_type_rev")
   (s/one s/Int "othuser_id_64") ;;no bigint
   (s/one s/Str "ip_address")
   (s/one s/Str "ip_address_trunc")
   (s/one s/Str "geo_country")
   (s/one s/Str "geo_region")
   (s/one s/Int "operating_system")
   (s/one s/Int "browser")
   (s/one s/Int "language")
   (s/one s/Int "venue_id")
   (s/one s/Int "seller_member_id")   
   (s/one s/Int "publisher_id")
   (s/one s/Int "site_id")
   (s/one s/Str "site_domain")
   (s/one s/Int "tag_id")
   (s/one s/Int "external_inv_id")
   (s/one s/Num "reserve_price")
   (s/one s/Num "seller_revenue_cpm")
   (s/one s/Num "media_buy_rev_share_pct")
   (s/one s/Int "pub_rule_id")
   (s/one s/Str "seller_currency")
   (s/one s/Str "publisher_currency")
   (s/one s/Num "publisher_exchange_rate")
   (s/one s/Num "serving_fees_cpm")
   (s/one s/Num "serving_fees_revshare")
   (s/one s/Int "buyer_member_id")
   (s/one s/Int "advertiser_id")
   (s/one s/Int "brand_id")
   (s/one s/Int "advertiser_frequency")   
   (s/one s/Int "advertiser_recency")
   (s/one s/Int "insertion_order_id")
   (s/one s/Int "campaign_group_id")
   (s/one s/Int "campaign_id")
   (s/one s/Int "creative_id")
   (s/one s/Int "creative_freq")  
   (s/one s/Int "creative_rec")
   (s/one s/Num "cadence_modifier")
   (s/one s/Int "can_convert")
   (s/one s/Int "user_group_id")
   (s/one s/Int "is_control")  
   (s/one s/Int "control_pct")
   (s/one s/Int "control_creative_id")
   (s/one s/Int "is_click")
   (s/one s/Int "pixel_id")
   (s/one s/Int "is_remarketing")
   (s/one s/Int "post_click_conv")  
   (s/one s/Int "post_view_conv")
   (s/one s/Num "post_click_revenue")
   (s/one s/Num "post_view_revenue")
   (s/one s/Str "order_id")
   (s/one s/Str "external_data")
   (s/one s/Str "pricing_type")
   (s/one s/Num "booked_revenue_dollars")
   (s/one s/Num "booked_revenue_adv_curr")
   (s/one s/Num "commission_cpm")
   (s/one s/Num "commission_revshare")
   (s/one s/Num "auction_service_deduction")
   (s/one s/Num "auction_service_fees")
   (s/one s/Num "creative_overage_fees")
   (s/one s/Num "clear_fees")
   (s/one s/Str "buyer_currency")
   (s/one s/Str "advertiser_currency")
   (s/one s/Num "advertiser_exchange_rate")])

(def segment_feed
  [(s/one sc/ISO-Date-Time "datetime")
   (s/one s/Int "user_id_64") ;;no bigint
   (s/one s/Int "member_id")
   (s/one s/Int "segment_id")
   (s/one s/Int "is_daily_unique")
   (s/one s/Int "is_monthly_unique")
   (s/one s/Int "value")])

(def bid_landscape_feed
  [(s/one sc/ISO-Date-Time "datetime")
   (s/one s/Int "auction_id_64")  ;;no bigint
   (s/one s/Int "user_id_64")  ;;no bigint
   (s/one s/Int "brand_id")
   (s/one s/Int "creative_id")
   (s/one s/Num "actual_bid_price")
   (s/one s/Num "biased_bid_price")
   (s/one s/Int "bid_reject_reason") ;;smallint
   (s/one s/Int "ym_floor_id")
   (s/one s/Int "ym_bias_id")
   (s/one s/Int "bidder_id")
   (s/one s/Int "buyer_member_id")
   (s/one s/Int "seller_member_id")
   (s/one s/Num "total_bid_modifier")])

(def brand
  [(s/one s/Int "id") ;;no bigint
   (s/one s/Str "name")])

(def category
  [(s/one s/Int "id") ;;no bigint
   (s/one s/Str "name")])

(def segment
  [(s/one s/Int "id")
   (s/one s/Str "code")
   (s/one s/Str "state")
   (s/one s/Str "short_name")
   (s/one s/Str "description")
   (s/one s/Int "member_id")
   (s/one s/Str "category")
   (s/one s/Num "price")
   (s/one s/Int "expire_minutes")
   (s/one s/Bool "enable_rm_piggyback")
   (s/one s/Int "max_usersync_pixels")
   (s/one sc/ISO-Date-Time "last_modified")
   (s/one s/Str "provider")
   (s/one s/Int "advertiser_id")
   (s/one s/Str "piggyback_pixels")
   (s/one s/Int "parent_segment_id")
   (s/one s/Str "querystring_mapping")
   (s/one s/Str "search")])

(def xaxis_conversions
  [(s/one sc/ISO-Date-Time "")
   (s/one s/Int "")
   (s/one s/Int "")  ;;no bigint
   (s/one s/Int "")]) ;;no bigint

(def gdm_conversions
  [(s/one sc/ISO-Date-Time "datetime")
   (s/one s/Int "auction_id_64") ;;no bigint
   (s/one s/Int "post_click_conv")
   (s/one s/Int "post_view_conv")])

(def groupmuk_conversions
  [(s/one sc/ISO-Date-Time "datetime")
   (s/one s/Int "auction_id_64") ;;no bigint
   (s/one s/Int "post_click_conv")
   (s/one s/Int "post_view_conv")])
