/*
 * Decompiled with CFR 0.152.
 */
package com.boundary.ordasity;

import com.boundary.ordasity.ClusterConfig;
import com.twitter.common.zookeeper.ZooKeeperClient;
import com.twitter.common.zookeeper.ZooKeeperUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ZKUtils$
implements ScalaObject {
    public static final ZKUtils$ MODULE$;
    private final Logger log;

    static {
        new ZKUtils$();
    }

    public Logger log() {
        return this.log;
    }

    public void ensureOrdasityPaths(ZooKeeperClient zk, String name, ClusterConfig config) {
        ArrayList acl = ZooDefs.Ids.OPEN_ACL_UNSAFE;
        ZooKeeperUtils.ensurePath((ZooKeeperClient)zk, (List)acl, (String)Predef$.MODULE$.augmentString("/%s/nodes").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
        ZooKeeperUtils.ensurePath((ZooKeeperClient)zk, (List)acl, (String)Predef$.MODULE$.augmentString("%s/%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{config.workUnitZkChRoot().getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "";
            }
        }), config.workUnitName()})));
        ZooKeeperUtils.ensurePath((ZooKeeperClient)zk, (List)acl, (String)Predef$.MODULE$.augmentString("/%s/meta/rebalance").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
        ZooKeeperUtils.ensurePath((ZooKeeperClient)zk, (List)acl, (String)Predef$.MODULE$.augmentString("/%s/meta/workload").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
        ZooKeeperUtils.ensurePath((ZooKeeperClient)zk, (List)acl, (String)Predef$.MODULE$.augmentString("/%s/claimed-%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, config.workUnitShortName()})));
        ZooKeeperUtils.ensurePath((ZooKeeperClient)zk, (List)acl, (String)Predef$.MODULE$.augmentString("/%s/handoff-requests").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
        ZooKeeperUtils.ensurePath((ZooKeeperClient)zk, (List)acl, (String)Predef$.MODULE$.augmentString("/%s/handoff-result").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
    }

    public boolean createEphemeral(ZooKeeperClient zk, String path, String value) {
        boolean exceptionResult1 = false;
        try {
            zk.get().create(path, value.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
            exceptionResult1 = true;
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            exceptionResult1 = false;
        }
        boolean created = exceptionResult1;
        return created;
    }

    public String createEphemeral$default$3() {
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public boolean delete(ZooKeeperClient zk, String path) {
        void var3_3;
        boolean exceptionResult2 = false;
        try {
            zk.get().delete(path, -1);
            exceptionResult2 = true;
        }
        catch (Exception exception) {
            this.log().error(Predef$.MODULE$.augmentString("Unexpected error deleting ZK node %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})), (Throwable)exception);
            exceptionResult2 = false;
        }
        catch (KeeperException.NoNodeException noNodeException) {
            this.log().warn(Predef$.MODULE$.augmentString("No ZNode to delete for %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
            exceptionResult2 = false;
        }
        return (boolean)var3_3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean deleteAtomic(ZooKeeperClient zk, String path, String expectedValue) {
        Stat stat = new Stat();
        String value = this.getWithStat(zk, path, (Option<Stat>)new Some((Object)stat));
        if (!expectedValue.equals(value)) return false;
        boolean exceptionResult3 = false;
        try {
            zk.get().delete(path, stat.getVersion());
            return true;
        }
        catch (Exception exception) {
            this.log().error(Predef$.MODULE$.augmentString("Failed to delete path %s with expected value %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path, expectedValue})), (Throwable)exception);
            return false;
        }
    }

    public boolean set(ZooKeeperClient zk, String path, String data) {
        boolean exceptionResult4 = false;
        try {
            zk.get().setData(path, data.getBytes(), -1);
            exceptionResult4 = true;
        }
        catch (Exception exception) {
            this.log().error(Predef$.MODULE$.augmentString("Error setting %s to %s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path, data})), (Throwable)exception);
            exceptionResult4 = false;
        }
        return exceptionResult4;
    }

    public void setOrCreate(ZooKeeperClient zk, String path, String data, CreateMode mode) {
        try {
            zk.get().setData(path, data.getBytes(), -1);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            zk.get().create(path, data.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, mode);
        }
    }

    public CreateMode setOrCreate$default$4() {
        return CreateMode.EPHEMERAL;
    }

    public String get(ZooKeeperClient zk, String path) {
        return this.getWithStat(zk, path, (Option<Stat>)None$.MODULE$);
    }

    public String getWithStat(ZooKeeperClient zk, String path, Option<Stat> stat) {
        String exceptionResult5 = null;
        try {
            byte[] value = zk.get().getData(path, false, (Stat)stat.orNull(Predef$.MODULE$.conforms()));
            exceptionResult5 = new String(value);
        }
        catch (Exception exception) {
            this.log().error(Predef$.MODULE$.augmentString("Error getting data for ZNode at path %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})), (Throwable)exception);
            exceptionResult5 = null;
        }
        catch (KeeperException.NoNodeException noNodeException) {
            exceptionResult5 = null;
        }
        return exceptionResult5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Stat> exists(ZooKeeperClient zk, String path, Watcher watcher) {
        Option exceptionResult6 = null;
        try {
            return Option$.MODULE$.apply((Object)zk.get().exists(path, watcher));
        }
        catch (Exception exception) {
            this.log().error(Predef$.MODULE$.augmentString("Failed to get stat for ZNode at path %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
            return None$.MODULE$;
        }
        catch (InterruptedException interruptedException) {
            throw interruptedException;
        }
    }

    public Watcher exists$default$3() {
        return null;
    }

    private ZKUtils$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

