/*
 * Copyright (c) 2009, Giuseppe Cardone <ippatsuman@gmail.com>
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of the author nor the names of the contributors may be
 *    used to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY GIUSEPPE CARDONE ''AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL GIUSEPPE CARDONE BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
package net.sf.junidecode;

/**
 * Character map for Unicode characters with codepoint U+BAxx.
 * @author Giuseppe Cardone
 * @version 0.1
 */
class Xba {

    public static final String[] map = new String[]{
        "mya", // 0x00
        "myag", // 0x01
        "myagg", // 0x02
        "myags", // 0x03
        "myan", // 0x04
        "myanj", // 0x05
        "myanh", // 0x06
        "myad", // 0x07
        "myal", // 0x08
        "myalg", // 0x09
        "myalm", // 0x0a
        "myalb", // 0x0b
        "myals", // 0x0c
        "myalt", // 0x0d
        "myalp", // 0x0e
        "myalh", // 0x0f
        "myam", // 0x10
        "myab", // 0x11
        "myabs", // 0x12
        "myas", // 0x13
        "myass", // 0x14
        "myang", // 0x15
        "myaj", // 0x16
        "myac", // 0x17
        "myak", // 0x18
        "myat", // 0x19
        "myap", // 0x1a
        "myah", // 0x1b
        "myae", // 0x1c
        "myaeg", // 0x1d
        "myaegg", // 0x1e
        "myaegs", // 0x1f
        "myaen", // 0x20
        "myaenj", // 0x21
        "myaenh", // 0x22
        "myaed", // 0x23
        "myael", // 0x24
        "myaelg", // 0x25
        "myaelm", // 0x26
        "myaelb", // 0x27
        "myaels", // 0x28
        "myaelt", // 0x29
        "myaelp", // 0x2a
        "myaelh", // 0x2b
        "myaem", // 0x2c
        "myaeb", // 0x2d
        "myaebs", // 0x2e
        "myaes", // 0x2f
        "myaess", // 0x30
        "myaeng", // 0x31
        "myaej", // 0x32
        "myaec", // 0x33
        "myaek", // 0x34
        "myaet", // 0x35
        "myaep", // 0x36
        "myaeh", // 0x37
        "meo", // 0x38
        "meog", // 0x39
        "meogg", // 0x3a
        "meogs", // 0x3b
        "meon", // 0x3c
        "meonj", // 0x3d
        "meonh", // 0x3e
        "meod", // 0x3f
        "meol", // 0x40
        "meolg", // 0x41
        "meolm", // 0x42
        "meolb", // 0x43
        "meols", // 0x44
        "meolt", // 0x45
        "meolp", // 0x46
        "meolh", // 0x47
        "meom", // 0x48
        "meob", // 0x49
        "meobs", // 0x4a
        "meos", // 0x4b
        "meoss", // 0x4c
        "meong", // 0x4d
        "meoj", // 0x4e
        "meoc", // 0x4f
        "meok", // 0x50
        "meot", // 0x51
        "meop", // 0x52
        "meoh", // 0x53
        "me", // 0x54
        "meg", // 0x55
        "megg", // 0x56
        "megs", // 0x57
        "men", // 0x58
        "menj", // 0x59
        "menh", // 0x5a
        "med", // 0x5b
        "mel", // 0x5c
        "melg", // 0x5d
        "melm", // 0x5e
        "melb", // 0x5f
        "mels", // 0x60
        "melt", // 0x61
        "melp", // 0x62
        "melh", // 0x63
        "mem", // 0x64
        "meb", // 0x65
        "mebs", // 0x66
        "mes", // 0x67
        "mess", // 0x68
        "meng", // 0x69
        "mej", // 0x6a
        "mec", // 0x6b
        "mek", // 0x6c
        "met", // 0x6d
        "mep", // 0x6e
        "meh", // 0x6f
        "myeo", // 0x70
        "myeog", // 0x71
        "myeogg", // 0x72
        "myeogs", // 0x73
        "myeon", // 0x74
        "myeonj", // 0x75
        "myeonh", // 0x76
        "myeod", // 0x77
        "myeol", // 0x78
        "myeolg", // 0x79
        "myeolm", // 0x7a
        "myeolb", // 0x7b
        "myeols", // 0x7c
        "myeolt", // 0x7d
        "myeolp", // 0x7e
        "myeolh", // 0x7f
        "myeom", // 0x80
        "myeob", // 0x81
        "myeobs", // 0x82
        "myeos", // 0x83
        "myeoss", // 0x84
        "myeong", // 0x85
        "myeoj", // 0x86
        "myeoc", // 0x87
        "myeok", // 0x88
        "myeot", // 0x89
        "myeop", // 0x8a
        "myeoh", // 0x8b
        "mye", // 0x8c
        "myeg", // 0x8d
        "myegg", // 0x8e
        "myegs", // 0x8f
        "myen", // 0x90
        "myenj", // 0x91
        "myenh", // 0x92
        "myed", // 0x93
        "myel", // 0x94
        "myelg", // 0x95
        "myelm", // 0x96
        "myelb", // 0x97
        "myels", // 0x98
        "myelt", // 0x99
        "myelp", // 0x9a
        "myelh", // 0x9b
        "myem", // 0x9c
        "myeb", // 0x9d
        "myebs", // 0x9e
        "myes", // 0x9f
        "myess", // 0xa0
        "myeng", // 0xa1
        "myej", // 0xa2
        "myec", // 0xa3
        "myek", // 0xa4
        "myet", // 0xa5
        "myep", // 0xa6
        "myeh", // 0xa7
        "mo", // 0xa8
        "mog", // 0xa9
        "mogg", // 0xaa
        "mogs", // 0xab
        "mon", // 0xac
        "monj", // 0xad
        "monh", // 0xae
        "mod", // 0xaf
        "mol", // 0xb0
        "molg", // 0xb1
        "molm", // 0xb2
        "molb", // 0xb3
        "mols", // 0xb4
        "molt", // 0xb5
        "molp", // 0xb6
        "molh", // 0xb7
        "mom", // 0xb8
        "mob", // 0xb9
        "mobs", // 0xba
        "mos", // 0xbb
        "moss", // 0xbc
        "mong", // 0xbd
        "moj", // 0xbe
        "moc", // 0xbf
        "mok", // 0xc0
        "mot", // 0xc1
        "mop", // 0xc2
        "moh", // 0xc3
        "mwa", // 0xc4
        "mwag", // 0xc5
        "mwagg", // 0xc6
        "mwags", // 0xc7
        "mwan", // 0xc8
        "mwanj", // 0xc9
        "mwanh", // 0xca
        "mwad", // 0xcb
        "mwal", // 0xcc
        "mwalg", // 0xcd
        "mwalm", // 0xce
        "mwalb", // 0xcf
        "mwals", // 0xd0
        "mwalt", // 0xd1
        "mwalp", // 0xd2
        "mwalh", // 0xd3
        "mwam", // 0xd4
        "mwab", // 0xd5
        "mwabs", // 0xd6
        "mwas", // 0xd7
        "mwass", // 0xd8
        "mwang", // 0xd9
        "mwaj", // 0xda
        "mwac", // 0xdb
        "mwak", // 0xdc
        "mwat", // 0xdd
        "mwap", // 0xde
        "mwah", // 0xdf
        "mwae", // 0xe0
        "mwaeg", // 0xe1
        "mwaegg", // 0xe2
        "mwaegs", // 0xe3
        "mwaen", // 0xe4
        "mwaenj", // 0xe5
        "mwaenh", // 0xe6
        "mwaed", // 0xe7
        "mwael", // 0xe8
        "mwaelg", // 0xe9
        "mwaelm", // 0xea
        "mwaelb", // 0xeb
        "mwaels", // 0xec
        "mwaelt", // 0xed
        "mwaelp", // 0xee
        "mwaelh", // 0xef
        "mwaem", // 0xf0
        "mwaeb", // 0xf1
        "mwaebs", // 0xf2
        "mwaes", // 0xf3
        "mwaess", // 0xf4
        "mwaeng", // 0xf5
        "mwaej", // 0xf6
        "mwaec", // 0xf7
        "mwaek", // 0xf8
        "mwaet", // 0xf9
        "mwaep", // 0xfa
        "mwaeh", // 0xfb
        "moe", // 0xfc
        "moeg", // 0xfd
        "moegg", // 0xfe
        "moegs" // 0xff
    };
}
