/*
 * Copyright (c) 2009, Giuseppe Cardone <ippatsuman@gmail.com>
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of the author nor the names of the contributors may be
 *    used to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY GIUSEPPE CARDONE ''AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL GIUSEPPE CARDONE BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
package net.sf.junidecode;

/**
 * Character map for Unicode characters with codepoint U+B4xx.
 * @author Giuseppe Cardone
 * @version 0.1
 */
class Xb4 {

    public static final String[] map = new String[]{
        "dwaen", // 0x00
        "dwaenj", // 0x01
        "dwaenh", // 0x02
        "dwaed", // 0x03
        "dwael", // 0x04
        "dwaelg", // 0x05
        "dwaelm", // 0x06
        "dwaelb", // 0x07
        "dwaels", // 0x08
        "dwaelt", // 0x09
        "dwaelp", // 0x0a
        "dwaelh", // 0x0b
        "dwaem", // 0x0c
        "dwaeb", // 0x0d
        "dwaebs", // 0x0e
        "dwaes", // 0x0f
        "dwaess", // 0x10
        "dwaeng", // 0x11
        "dwaej", // 0x12
        "dwaec", // 0x13
        "dwaek", // 0x14
        "dwaet", // 0x15
        "dwaep", // 0x16
        "dwaeh", // 0x17
        "doe", // 0x18
        "doeg", // 0x19
        "doegg", // 0x1a
        "doegs", // 0x1b
        "doen", // 0x1c
        "doenj", // 0x1d
        "doenh", // 0x1e
        "doed", // 0x1f
        "doel", // 0x20
        "doelg", // 0x21
        "doelm", // 0x22
        "doelb", // 0x23
        "doels", // 0x24
        "doelt", // 0x25
        "doelp", // 0x26
        "doelh", // 0x27
        "doem", // 0x28
        "doeb", // 0x29
        "doebs", // 0x2a
        "does", // 0x2b
        "doess", // 0x2c
        "doeng", // 0x2d
        "doej", // 0x2e
        "doec", // 0x2f
        "doek", // 0x30
        "doet", // 0x31
        "doep", // 0x32
        "doeh", // 0x33
        "dyo", // 0x34
        "dyog", // 0x35
        "dyogg", // 0x36
        "dyogs", // 0x37
        "dyon", // 0x38
        "dyonj", // 0x39
        "dyonh", // 0x3a
        "dyod", // 0x3b
        "dyol", // 0x3c
        "dyolg", // 0x3d
        "dyolm", // 0x3e
        "dyolb", // 0x3f
        "dyols", // 0x40
        "dyolt", // 0x41
        "dyolp", // 0x42
        "dyolh", // 0x43
        "dyom", // 0x44
        "dyob", // 0x45
        "dyobs", // 0x46
        "dyos", // 0x47
        "dyoss", // 0x48
        "dyong", // 0x49
        "dyoj", // 0x4a
        "dyoc", // 0x4b
        "dyok", // 0x4c
        "dyot", // 0x4d
        "dyop", // 0x4e
        "dyoh", // 0x4f
        "du", // 0x50
        "dug", // 0x51
        "dugg", // 0x52
        "dugs", // 0x53
        "dun", // 0x54
        "dunj", // 0x55
        "dunh", // 0x56
        "dud", // 0x57
        "dul", // 0x58
        "dulg", // 0x59
        "dulm", // 0x5a
        "dulb", // 0x5b
        "duls", // 0x5c
        "dult", // 0x5d
        "dulp", // 0x5e
        "dulh", // 0x5f
        "dum", // 0x60
        "dub", // 0x61
        "dubs", // 0x62
        "dus", // 0x63
        "duss", // 0x64
        "dung", // 0x65
        "duj", // 0x66
        "duc", // 0x67
        "duk", // 0x68
        "dut", // 0x69
        "dup", // 0x6a
        "duh", // 0x6b
        "dweo", // 0x6c
        "dweog", // 0x6d
        "dweogg", // 0x6e
        "dweogs", // 0x6f
        "dweon", // 0x70
        "dweonj", // 0x71
        "dweonh", // 0x72
        "dweod", // 0x73
        "dweol", // 0x74
        "dweolg", // 0x75
        "dweolm", // 0x76
        "dweolb", // 0x77
        "dweols", // 0x78
        "dweolt", // 0x79
        "dweolp", // 0x7a
        "dweolh", // 0x7b
        "dweom", // 0x7c
        "dweob", // 0x7d
        "dweobs", // 0x7e
        "dweos", // 0x7f
        "dweoss", // 0x80
        "dweong", // 0x81
        "dweoj", // 0x82
        "dweoc", // 0x83
        "dweok", // 0x84
        "dweot", // 0x85
        "dweop", // 0x86
        "dweoh", // 0x87
        "dwe", // 0x88
        "dweg", // 0x89
        "dwegg", // 0x8a
        "dwegs", // 0x8b
        "dwen", // 0x8c
        "dwenj", // 0x8d
        "dwenh", // 0x8e
        "dwed", // 0x8f
        "dwel", // 0x90
        "dwelg", // 0x91
        "dwelm", // 0x92
        "dwelb", // 0x93
        "dwels", // 0x94
        "dwelt", // 0x95
        "dwelp", // 0x96
        "dwelh", // 0x97
        "dwem", // 0x98
        "dweb", // 0x99
        "dwebs", // 0x9a
        "dwes", // 0x9b
        "dwess", // 0x9c
        "dweng", // 0x9d
        "dwej", // 0x9e
        "dwec", // 0x9f
        "dwek", // 0xa0
        "dwet", // 0xa1
        "dwep", // 0xa2
        "dweh", // 0xa3
        "dwi", // 0xa4
        "dwig", // 0xa5
        "dwigg", // 0xa6
        "dwigs", // 0xa7
        "dwin", // 0xa8
        "dwinj", // 0xa9
        "dwinh", // 0xaa
        "dwid", // 0xab
        "dwil", // 0xac
        "dwilg", // 0xad
        "dwilm", // 0xae
        "dwilb", // 0xaf
        "dwils", // 0xb0
        "dwilt", // 0xb1
        "dwilp", // 0xb2
        "dwilh", // 0xb3
        "dwim", // 0xb4
        "dwib", // 0xb5
        "dwibs", // 0xb6
        "dwis", // 0xb7
        "dwiss", // 0xb8
        "dwing", // 0xb9
        "dwij", // 0xba
        "dwic", // 0xbb
        "dwik", // 0xbc
        "dwit", // 0xbd
        "dwip", // 0xbe
        "dwih", // 0xbf
        "dyu", // 0xc0
        "dyug", // 0xc1
        "dyugg", // 0xc2
        "dyugs", // 0xc3
        "dyun", // 0xc4
        "dyunj", // 0xc5
        "dyunh", // 0xc6
        "dyud", // 0xc7
        "dyul", // 0xc8
        "dyulg", // 0xc9
        "dyulm", // 0xca
        "dyulb", // 0xcb
        "dyuls", // 0xcc
        "dyult", // 0xcd
        "dyulp", // 0xce
        "dyulh", // 0xcf
        "dyum", // 0xd0
        "dyub", // 0xd1
        "dyubs", // 0xd2
        "dyus", // 0xd3
        "dyuss", // 0xd4
        "dyung", // 0xd5
        "dyuj", // 0xd6
        "dyuc", // 0xd7
        "dyuk", // 0xd8
        "dyut", // 0xd9
        "dyup", // 0xda
        "dyuh", // 0xdb
        "deu", // 0xdc
        "deug", // 0xdd
        "deugg", // 0xde
        "deugs", // 0xdf
        "deun", // 0xe0
        "deunj", // 0xe1
        "deunh", // 0xe2
        "deud", // 0xe3
        "deul", // 0xe4
        "deulg", // 0xe5
        "deulm", // 0xe6
        "deulb", // 0xe7
        "deuls", // 0xe8
        "deult", // 0xe9
        "deulp", // 0xea
        "deulh", // 0xeb
        "deum", // 0xec
        "deub", // 0xed
        "deubs", // 0xee
        "deus", // 0xef
        "deuss", // 0xf0
        "deung", // 0xf1
        "deuj", // 0xf2
        "deuc", // 0xf3
        "deuk", // 0xf4
        "deut", // 0xf5
        "deup", // 0xf6
        "deuh", // 0xf7
        "dyi", // 0xf8
        "dyig", // 0xf9
        "dyigg", // 0xfa
        "dyigs", // 0xfb
        "dyin", // 0xfc
        "dyinj", // 0xfd
        "dyinh", // 0xfe
        "dyid" // 0xff
    };
}
