/*
 * Copyright (c) 2009, Giuseppe Cardone <ippatsuman@gmail.com>
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of the author nor the names of the contributors may be
 *    used to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY GIUSEPPE CARDONE ''AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL GIUSEPPE CARDONE BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
package net.sf.junidecode;

/**
 * Character map for Unicode characters with codepoint U+92xx.
 * @author Giuseppe Cardone
 * @version 0.1
 */
class X92 {

    public static final String[] map = new String[]{
        "Ba ", // 0x00
        "Fang ", // 0x01
        "Chen ", // 0x02
        "Xing ", // 0x03
        "Tou ", // 0x04
        "Yue ", // 0x05
        "Yan ", // 0x06
        "Fu ", // 0x07
        "Pi ", // 0x08
        "Na ", // 0x09
        "Xin ", // 0x0a
        "E ", // 0x0b
        "Jue ", // 0x0c
        "Dun ", // 0x0d
        "Gou ", // 0x0e
        "Yin ", // 0x0f
        "Qian ", // 0x10
        "Ban ", // 0x11
        "Ji ", // 0x12
        "Ren ", // 0x13
        "Chao ", // 0x14
        "Niu ", // 0x15
        "Fen ", // 0x16
        "Yun ", // 0x17
        "Ji ", // 0x18
        "Qin ", // 0x19
        "Pi ", // 0x1a
        "Guo ", // 0x1b
        "Hong ", // 0x1c
        "Yin ", // 0x1d
        "Jun ", // 0x1e
        "Shi ", // 0x1f
        "Yi ", // 0x20
        "Zhong ", // 0x21
        "Nie ", // 0x22
        "Gai ", // 0x23
        "Ri ", // 0x24
        "Huo ", // 0x25
        "Tai ", // 0x26
        "Kang ", // 0x27
        "Habaki ", // 0x28
        "Irori ", // 0x29
        "Ngaak ", // 0x2a
        "[?] ", // 0x2b
        "Duo ", // 0x2c
        "Zi ", // 0x2d
        "Ni ", // 0x2e
        "Tu ", // 0x2f
        "Shi ", // 0x30
        "Min ", // 0x31
        "Gu ", // 0x32
        "E ", // 0x33
        "Ling ", // 0x34
        "Bing ", // 0x35
        "Yi ", // 0x36
        "Gu ", // 0x37
        "Ba ", // 0x38
        "Pi ", // 0x39
        "Yu ", // 0x3a
        "Si ", // 0x3b
        "Zuo ", // 0x3c
        "Bu ", // 0x3d
        "You ", // 0x3e
        "Dian ", // 0x3f
        "Jia ", // 0x40
        "Zhen ", // 0x41
        "Shi ", // 0x42
        "Shi ", // 0x43
        "Tie ", // 0x44
        "Ju ", // 0x45
        "Zhan ", // 0x46
        "Shi ", // 0x47
        "She ", // 0x48
        "Xuan ", // 0x49
        "Zhao ", // 0x4a
        "Bao ", // 0x4b
        "He ", // 0x4c
        "Bi ", // 0x4d
        "Sheng ", // 0x4e
        "Chu ", // 0x4f
        "Shi ", // 0x50
        "Bo ", // 0x51
        "Zhu ", // 0x52
        "Chi ", // 0x53
        "Za ", // 0x54
        "Po ", // 0x55
        "Tong ", // 0x56
        "Qian ", // 0x57
        "Fu ", // 0x58
        "Zhai ", // 0x59
        "Liu ", // 0x5a
        "Qian ", // 0x5b
        "Fu ", // 0x5c
        "Li ", // 0x5d
        "Yue ", // 0x5e
        "Pi ", // 0x5f
        "Yang ", // 0x60
        "Ban ", // 0x61
        "Bo ", // 0x62
        "Jie ", // 0x63
        "Gou ", // 0x64
        "Shu ", // 0x65
        "Zheng ", // 0x66
        "Mu ", // 0x67
        "Ni ", // 0x68
        "Nie ", // 0x69
        "Di ", // 0x6a
        "Jia ", // 0x6b
        "Mu ", // 0x6c
        "Dan ", // 0x6d
        "Shen ", // 0x6e
        "Yi ", // 0x6f
        "Si ", // 0x70
        "Kuang ", // 0x71
        "Ka ", // 0x72
        "Bei ", // 0x73
        "Jian ", // 0x74
        "Tong ", // 0x75
        "Xing ", // 0x76
        "Hong ", // 0x77
        "Jiao ", // 0x78
        "Chi ", // 0x79
        "Er ", // 0x7a
        "Ge ", // 0x7b
        "Bing ", // 0x7c
        "Shi ", // 0x7d
        "Mou ", // 0x7e
        "Jia ", // 0x7f
        "Yin ", // 0x80
        "Jun ", // 0x81
        "Zhou ", // 0x82
        "Chong ", // 0x83
        "Shang ", // 0x84
        "Tong ", // 0x85
        "Mo ", // 0x86
        "Lei ", // 0x87
        "Ji ", // 0x88
        "Yu ", // 0x89
        "Xu ", // 0x8a
        "Ren ", // 0x8b
        "Zun ", // 0x8c
        "Zhi ", // 0x8d
        "Qiong ", // 0x8e
        "Shan ", // 0x8f
        "Chi ", // 0x90
        "Xian ", // 0x91
        "Xing ", // 0x92
        "Quan ", // 0x93
        "Pi ", // 0x94
        "Tie ", // 0x95
        "Zhu ", // 0x96
        "Hou ", // 0x97
        "Ming ", // 0x98
        "Kua ", // 0x99
        "Yao ", // 0x9a
        "Xian ", // 0x9b
        "Xian ", // 0x9c
        "Xiu ", // 0x9d
        "Jun ", // 0x9e
        "Cha ", // 0x9f
        "Lao ", // 0xa0
        "Ji ", // 0xa1
        "Pi ", // 0xa2
        "Ru ", // 0xa3
        "Mi ", // 0xa4
        "Yi ", // 0xa5
        "Yin ", // 0xa6
        "Guang ", // 0xa7
        "An ", // 0xa8
        "Diou ", // 0xa9
        "You ", // 0xaa
        "Se ", // 0xab
        "Kao ", // 0xac
        "Qian ", // 0xad
        "Luan ", // 0xae
        "Kasugai ", // 0xaf
        "Ai ", // 0xb0
        "Diao ", // 0xb1
        "Han ", // 0xb2
        "Rui ", // 0xb3
        "Shi ", // 0xb4
        "Keng ", // 0xb5
        "Qiu ", // 0xb6
        "Xiao ", // 0xb7
        "Zhe ", // 0xb8
        "Xiu ", // 0xb9
        "Zang ", // 0xba
        "Ti ", // 0xbb
        "Cuo ", // 0xbc
        "Gua ", // 0xbd
        "Gong ", // 0xbe
        "Zhong ", // 0xbf
        "Dou ", // 0xc0
        "Lu ", // 0xc1
        "Mei ", // 0xc2
        "Lang ", // 0xc3
        "Wan ", // 0xc4
        "Xin ", // 0xc5
        "Yun ", // 0xc6
        "Bei ", // 0xc7
        "Wu ", // 0xc8
        "Su ", // 0xc9
        "Yu ", // 0xca
        "Chan ", // 0xcb
        "Ting ", // 0xcc
        "Bo ", // 0xcd
        "Han ", // 0xce
        "Jia ", // 0xcf
        "Hong ", // 0xd0
        "Cuan ", // 0xd1
        "Feng ", // 0xd2
        "Chan ", // 0xd3
        "Wan ", // 0xd4
        "Zhi ", // 0xd5
        "Si ", // 0xd6
        "Xuan ", // 0xd7
        "Wu ", // 0xd8
        "Wu ", // 0xd9
        "Tiao ", // 0xda
        "Gong ", // 0xdb
        "Zhuo ", // 0xdc
        "Lue ", // 0xdd
        "Xing ", // 0xde
        "Qian ", // 0xdf
        "Shen ", // 0xe0
        "Han ", // 0xe1
        "Lue ", // 0xe2
        "Xie ", // 0xe3
        "Chu ", // 0xe4
        "Zheng ", // 0xe5
        "Ju ", // 0xe6
        "Xian ", // 0xe7
        "Tie ", // 0xe8
        "Mang ", // 0xe9
        "Pu ", // 0xea
        "Li ", // 0xeb
        "Pan ", // 0xec
        "Rui ", // 0xed
        "Cheng ", // 0xee
        "Gao ", // 0xef
        "Li ", // 0xf0
        "Te ", // 0xf1
        "Pyeng ", // 0xf2
        "Zhu ", // 0xf3
        "[?] ", // 0xf4
        "Tu ", // 0xf5
        "Liu ", // 0xf6
        "Zui ", // 0xf7
        "Ju ", // 0xf8
        "Chang ", // 0xf9
        "Yuan ", // 0xfa
        "Jian ", // 0xfb
        "Gang ", // 0xfc
        "Diao ", // 0xfd
        "Tao ", // 0xfe
        "Chang " // 0xff
    };
}
