/*
 * Copyright (c) 2009, Giuseppe Cardone <ippatsuman@gmail.com>
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of the author nor the names of the contributors may be
 *    used to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY GIUSEPPE CARDONE ''AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL GIUSEPPE CARDONE BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
package net.sf.junidecode;

/**
 * Character map for Unicode characters with codepoint U+8Fxx.
 * @author Giuseppe Cardone
 * @version 0.1
 */
class X8f {

    public static final String[] map = new String[]{
        "Er ", // 0x00
        "Qiong ", // 0x01
        "Ju ", // 0x02
        "Jiao ", // 0x03
        "Guang ", // 0x04
        "Lu ", // 0x05
        "Kai ", // 0x06
        "Quan ", // 0x07
        "Zhou ", // 0x08
        "Zai ", // 0x09
        "Zhi ", // 0x0a
        "She ", // 0x0b
        "Liang ", // 0x0c
        "Yu ", // 0x0d
        "Shao ", // 0x0e
        "You ", // 0x0f
        "Huan ", // 0x10
        "Yun ", // 0x11
        "Zhe ", // 0x12
        "Wan ", // 0x13
        "Fu ", // 0x14
        "Qing ", // 0x15
        "Zhou ", // 0x16
        "Ni ", // 0x17
        "Ling ", // 0x18
        "Zhe ", // 0x19
        "Zhan ", // 0x1a
        "Liang ", // 0x1b
        "Zi ", // 0x1c
        "Hui ", // 0x1d
        "Wang ", // 0x1e
        "Chuo ", // 0x1f
        "Guo ", // 0x20
        "Kan ", // 0x21
        "Yi ", // 0x22
        "Peng ", // 0x23
        "Qian ", // 0x24
        "Gun ", // 0x25
        "Nian ", // 0x26
        "Pian ", // 0x27
        "Guan ", // 0x28
        "Bei ", // 0x29
        "Lun ", // 0x2a
        "Pai ", // 0x2b
        "Liang ", // 0x2c
        "Ruan ", // 0x2d
        "Rou ", // 0x2e
        "Ji ", // 0x2f
        "Yang ", // 0x30
        "Xian ", // 0x31
        "Chuan ", // 0x32
        "Cou ", // 0x33
        "Qun ", // 0x34
        "Ge ", // 0x35
        "You ", // 0x36
        "Hong ", // 0x37
        "Shu ", // 0x38
        "Fu ", // 0x39
        "Zi ", // 0x3a
        "Fu ", // 0x3b
        "Wen ", // 0x3c
        "Ben ", // 0x3d
        "Zhan ", // 0x3e
        "Yu ", // 0x3f
        "Wen ", // 0x40
        "Tao ", // 0x41
        "Gu ", // 0x42
        "Zhen ", // 0x43
        "Xia ", // 0x44
        "Yuan ", // 0x45
        "Lu ", // 0x46
        "Jiu ", // 0x47
        "Chao ", // 0x48
        "Zhuan ", // 0x49
        "Wei ", // 0x4a
        "Hun ", // 0x4b
        "Sori ", // 0x4c
        "Che ", // 0x4d
        "Jiao ", // 0x4e
        "Zhan ", // 0x4f
        "Pu ", // 0x50
        "Lao ", // 0x51
        "Fen ", // 0x52
        "Fan ", // 0x53
        "Lin ", // 0x54
        "Ge ", // 0x55
        "Se ", // 0x56
        "Kan ", // 0x57
        "Huan ", // 0x58
        "Yi ", // 0x59
        "Ji ", // 0x5a
        "Dui ", // 0x5b
        "Er ", // 0x5c
        "Yu ", // 0x5d
        "Xian ", // 0x5e
        "Hong ", // 0x5f
        "Lei ", // 0x60
        "Pei ", // 0x61
        "Li ", // 0x62
        "Li ", // 0x63
        "Lu ", // 0x64
        "Lin ", // 0x65
        "Che ", // 0x66
        "Ya ", // 0x67
        "Gui ", // 0x68
        "Xuan ", // 0x69
        "Di ", // 0x6a
        "Ren ", // 0x6b
        "Zhuan ", // 0x6c
        "E ", // 0x6d
        "Lun ", // 0x6e
        "Ruan ", // 0x6f
        "Hong ", // 0x70
        "Ku ", // 0x71
        "Ke ", // 0x72
        "Lu ", // 0x73
        "Zhou ", // 0x74
        "Zhi ", // 0x75
        "Yi ", // 0x76
        "Hu ", // 0x77
        "Zhen ", // 0x78
        "Li ", // 0x79
        "Yao ", // 0x7a
        "Qing ", // 0x7b
        "Shi ", // 0x7c
        "Zai ", // 0x7d
        "Zhi ", // 0x7e
        "Jiao ", // 0x7f
        "Zhou ", // 0x80
        "Quan ", // 0x81
        "Lu ", // 0x82
        "Jiao ", // 0x83
        "Zhe ", // 0x84
        "Fu ", // 0x85
        "Liang ", // 0x86
        "Nian ", // 0x87
        "Bei ", // 0x88
        "Hui ", // 0x89
        "Gun ", // 0x8a
        "Wang ", // 0x8b
        "Liang ", // 0x8c
        "Chuo ", // 0x8d
        "Zi ", // 0x8e
        "Cou ", // 0x8f
        "Fu ", // 0x90
        "Ji ", // 0x91
        "Wen ", // 0x92
        "Shu ", // 0x93
        "Pei ", // 0x94
        "Yuan ", // 0x95
        "Xia ", // 0x96
        "Zhan ", // 0x97
        "Lu ", // 0x98
        "Che ", // 0x99
        "Lin ", // 0x9a
        "Xin ", // 0x9b
        "Gu ", // 0x9c
        "Ci ", // 0x9d
        "Ci ", // 0x9e
        "Pi ", // 0x9f
        "Zui ", // 0xa0
        "Bian ", // 0xa1
        "La ", // 0xa2
        "La ", // 0xa3
        "Ci ", // 0xa4
        "Xue ", // 0xa5
        "Ban ", // 0xa6
        "Bian ", // 0xa7
        "Bian ", // 0xa8
        "Bian ", // 0xa9
        "[?] ", // 0xaa
        "Bian ", // 0xab
        "Ban ", // 0xac
        "Ci ", // 0xad
        "Bian ", // 0xae
        "Bian ", // 0xaf
        "Chen ", // 0xb0
        "Ru ", // 0xb1
        "Nong ", // 0xb2
        "Nong ", // 0xb3
        "Zhen ", // 0xb4
        "Chuo ", // 0xb5
        "Chuo ", // 0xb6
        "Suberu ", // 0xb7
        "Reng ", // 0xb8
        "Bian ", // 0xb9
        "Bian ", // 0xba
        "Sip ", // 0xbb
        "Ip ", // 0xbc
        "Liao ", // 0xbd
        "Da ", // 0xbe
        "Chan ", // 0xbf
        "Gan ", // 0xc0
        "Qian ", // 0xc1
        "Yu ", // 0xc2
        "Yu ", // 0xc3
        "Qi ", // 0xc4
        "Xun ", // 0xc5
        "Yi ", // 0xc6
        "Guo ", // 0xc7
        "Mai ", // 0xc8
        "Qi ", // 0xc9
        "Za ", // 0xca
        "Wang ", // 0xcb
        "Jia ", // 0xcc
        "Zhun ", // 0xcd
        "Ying ", // 0xce
        "Ti ", // 0xcf
        "Yun ", // 0xd0
        "Jin ", // 0xd1
        "Hang ", // 0xd2
        "Ya ", // 0xd3
        "Fan ", // 0xd4
        "Wu ", // 0xd5
        "Da ", // 0xd6
        "E ", // 0xd7
        "Huan ", // 0xd8
        "Zhe ", // 0xd9
        "Totemo ", // 0xda
        "Jin ", // 0xdb
        "Yuan ", // 0xdc
        "Wei ", // 0xdd
        "Lian ", // 0xde
        "Chi ", // 0xdf
        "Che ", // 0xe0
        "Ni ", // 0xe1
        "Tiao ", // 0xe2
        "Zhi ", // 0xe3
        "Yi ", // 0xe4
        "Jiong ", // 0xe5
        "Jia ", // 0xe6
        "Chen ", // 0xe7
        "Dai ", // 0xe8
        "Er ", // 0xe9
        "Di ", // 0xea
        "Po ", // 0xeb
        "Wang ", // 0xec
        "Die ", // 0xed
        "Ze ", // 0xee
        "Tao ", // 0xef
        "Shu ", // 0xf0
        "Tuo ", // 0xf1
        "Kep ", // 0xf2
        "Jing ", // 0xf3
        "Hui ", // 0xf4
        "Tong ", // 0xf5
        "You ", // 0xf6
        "Mi ", // 0xf7
        "Beng ", // 0xf8
        "Ji ", // 0xf9
        "Nai ", // 0xfa
        "Yi ", // 0xfb
        "Jie ", // 0xfc
        "Zhui ", // 0xfd
        "Lie ", // 0xfe
        "Xun " // 0xff
    };
}
