/*
 * Copyright (c) 2009, Giuseppe Cardone <ippatsuman@gmail.com>
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of the author nor the names of the contributors may be
 *    used to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY GIUSEPPE CARDONE ''AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL GIUSEPPE CARDONE BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
package net.sf.junidecode;

/**
 * Character map for Unicode characters with codepoint U+7Fxx.
 * @author Giuseppe Cardone
 * @version 0.1
 */
class X7f {

    public static final String[] map = new String[]{
        "Zhui ", // 0x00
        "Zi ", // 0x01
        "Ke ", // 0x02
        "Xiang ", // 0x03
        "Jian ", // 0x04
        "Mian ", // 0x05
        "Lan ", // 0x06
        "Ti ", // 0x07
        "Miao ", // 0x08
        "Qi ", // 0x09
        "Yun ", // 0x0a
        "Hui ", // 0x0b
        "Si ", // 0x0c
        "Duo ", // 0x0d
        "Duan ", // 0x0e
        "Bian ", // 0x0f
        "Xian ", // 0x10
        "Gou ", // 0x11
        "Zhui ", // 0x12
        "Huan ", // 0x13
        "Di ", // 0x14
        "Lu ", // 0x15
        "Bian ", // 0x16
        "Min ", // 0x17
        "Yuan ", // 0x18
        "Jin ", // 0x19
        "Fu ", // 0x1a
        "Ru ", // 0x1b
        "Zhen ", // 0x1c
        "Feng ", // 0x1d
        "Shuai ", // 0x1e
        "Gao ", // 0x1f
        "Chan ", // 0x20
        "Li ", // 0x21
        "Yi ", // 0x22
        "Jian ", // 0x23
        "Bin ", // 0x24
        "Piao ", // 0x25
        "Man ", // 0x26
        "Lei ", // 0x27
        "Ying ", // 0x28
        "Suo ", // 0x29
        "Mou ", // 0x2a
        "Sao ", // 0x2b
        "Xie ", // 0x2c
        "Liao ", // 0x2d
        "Shan ", // 0x2e
        "Zeng ", // 0x2f
        "Jiang ", // 0x30
        "Qian ", // 0x31
        "Zao ", // 0x32
        "Huan ", // 0x33
        "Jiao ", // 0x34
        "Zuan ", // 0x35
        "Fou ", // 0x36
        "Xie ", // 0x37
        "Gang ", // 0x38
        "Fou ", // 0x39
        "Que ", // 0x3a
        "Fou ", // 0x3b
        "Kaakeru ", // 0x3c
        "Bo ", // 0x3d
        "Ping ", // 0x3e
        "Hou ", // 0x3f
        "[?] ", // 0x40
        "Gang ", // 0x41
        "Ying ", // 0x42
        "Ying ", // 0x43
        "Qing ", // 0x44
        "Xia ", // 0x45
        "Guan ", // 0x46
        "Zun ", // 0x47
        "Tan ", // 0x48
        "Chang ", // 0x49
        "Qi ", // 0x4a
        "Weng ", // 0x4b
        "Ying ", // 0x4c
        "Lei ", // 0x4d
        "Tan ", // 0x4e
        "Lu ", // 0x4f
        "Guan ", // 0x50
        "Wang ", // 0x51
        "Wang ", // 0x52
        "Gang ", // 0x53
        "Wang ", // 0x54
        "Han ", // 0x55
        "[?] ", // 0x56
        "Luo ", // 0x57
        "Fu ", // 0x58
        "Mi ", // 0x59
        "Fa ", // 0x5a
        "Gu ", // 0x5b
        "Zhu ", // 0x5c
        "Ju ", // 0x5d
        "Mao ", // 0x5e
        "Gu ", // 0x5f
        "Min ", // 0x60
        "Gang ", // 0x61
        "Ba ", // 0x62
        "Gua ", // 0x63
        "Ti ", // 0x64
        "Juan ", // 0x65
        "Fu ", // 0x66
        "Lin ", // 0x67
        "Yan ", // 0x68
        "Zhao ", // 0x69
        "Zui ", // 0x6a
        "Gua ", // 0x6b
        "Zhuo ", // 0x6c
        "Yu ", // 0x6d
        "Zhi ", // 0x6e
        "An ", // 0x6f
        "Fa ", // 0x70
        "Nan ", // 0x71
        "Shu ", // 0x72
        "Si ", // 0x73
        "Pi ", // 0x74
        "Ma ", // 0x75
        "Liu ", // 0x76
        "Ba ", // 0x77
        "Fa ", // 0x78
        "Li ", // 0x79
        "Chao ", // 0x7a
        "Wei ", // 0x7b
        "Bi ", // 0x7c
        "Ji ", // 0x7d
        "Zeng ", // 0x7e
        "Tong ", // 0x7f
        "Liu ", // 0x80
        "Ji ", // 0x81
        "Juan ", // 0x82
        "Mi ", // 0x83
        "Zhao ", // 0x84
        "Luo ", // 0x85
        "Pi ", // 0x86
        "Ji ", // 0x87
        "Ji ", // 0x88
        "Luan ", // 0x89
        "Yang ", // 0x8a
        "Mie ", // 0x8b
        "Qiang ", // 0x8c
        "Ta ", // 0x8d
        "Mei ", // 0x8e
        "Yang ", // 0x8f
        "You ", // 0x90
        "You ", // 0x91
        "Fen ", // 0x92
        "Ba ", // 0x93
        "Gao ", // 0x94
        "Yang ", // 0x95
        "Gu ", // 0x96
        "Qiang ", // 0x97
        "Zang ", // 0x98
        "Gao ", // 0x99
        "Ling ", // 0x9a
        "Yi ", // 0x9b
        "Zhu ", // 0x9c
        "Di ", // 0x9d
        "Xiu ", // 0x9e
        "Qian ", // 0x9f
        "Yi ", // 0xa0
        "Xian ", // 0xa1
        "Rong ", // 0xa2
        "Qun ", // 0xa3
        "Qun ", // 0xa4
        "Qian ", // 0xa5
        "Huan ", // 0xa6
        "Zui ", // 0xa7
        "Xian ", // 0xa8
        "Yi ", // 0xa9
        "Yashinau ", // 0xaa
        "Qiang ", // 0xab
        "Xian ", // 0xac
        "Yu ", // 0xad
        "Geng ", // 0xae
        "Jie ", // 0xaf
        "Tang ", // 0xb0
        "Yuan ", // 0xb1
        "Xi ", // 0xb2
        "Fan ", // 0xb3
        "Shan ", // 0xb4
        "Fen ", // 0xb5
        "Shan ", // 0xb6
        "Lian ", // 0xb7
        "Lei ", // 0xb8
        "Geng ", // 0xb9
        "Nou ", // 0xba
        "Qiang ", // 0xbb
        "Chan ", // 0xbc
        "Yu ", // 0xbd
        "Gong ", // 0xbe
        "Yi ", // 0xbf
        "Chong ", // 0xc0
        "Weng ", // 0xc1
        "Fen ", // 0xc2
        "Hong ", // 0xc3
        "Chi ", // 0xc4
        "Chi ", // 0xc5
        "Cui ", // 0xc6
        "Fu ", // 0xc7
        "Xia ", // 0xc8
        "Pen ", // 0xc9
        "Yi ", // 0xca
        "La ", // 0xcb
        "Yi ", // 0xcc
        "Pi ", // 0xcd
        "Ling ", // 0xce
        "Liu ", // 0xcf
        "Zhi ", // 0xd0
        "Qu ", // 0xd1
        "Xi ", // 0xd2
        "Xie ", // 0xd3
        "Xiang ", // 0xd4
        "Xi ", // 0xd5
        "Xi ", // 0xd6
        "Qi ", // 0xd7
        "Qiao ", // 0xd8
        "Hui ", // 0xd9
        "Hui ", // 0xda
        "Xiao ", // 0xdb
        "Se ", // 0xdc
        "Hong ", // 0xdd
        "Jiang ", // 0xde
        "Di ", // 0xdf
        "Cui ", // 0xe0
        "Fei ", // 0xe1
        "Tao ", // 0xe2
        "Sha ", // 0xe3
        "Chi ", // 0xe4
        "Zhu ", // 0xe5
        "Jian ", // 0xe6
        "Xuan ", // 0xe7
        "Shi ", // 0xe8
        "Pian ", // 0xe9
        "Zong ", // 0xea
        "Wan ", // 0xeb
        "Hui ", // 0xec
        "Hou ", // 0xed
        "He ", // 0xee
        "He ", // 0xef
        "Han ", // 0xf0
        "Ao ", // 0xf1
        "Piao ", // 0xf2
        "Yi ", // 0xf3
        "Lian ", // 0xf4
        "Qu ", // 0xf5
        "[?] ", // 0xf6
        "Lin ", // 0xf7
        "Pen ", // 0xf8
        "Qiao ", // 0xf9
        "Ao ", // 0xfa
        "Fan ", // 0xfb
        "Yi ", // 0xfc
        "Hui ", // 0xfd
        "Xuan ", // 0xfe
        "Dao " // 0xff
    };
}
