(ns kepler16.pom
  (:require [clojure.xml :as xml]
            [clojure.zip :as zip]
            [clojure.data.zip.xml :as zip-xml]
            [clojure.java.io :as io]))

(defn load-pom! []
  (-> ^String (slurp "pom.xml")
      (.getBytes)
      (io/input-stream)
      xml/parse
      zip/xml-zip))

(defn pom->group-id [pom-zipper]
  (first
   (zip-xml/xml->
    pom-zipper
    :groupId
    zip-xml/text)))

(defn pom->artifact [pom-zipper]
  (first
   (zip-xml/xml->
    pom-zipper
    :name
    zip-xml/text)))

(defn pom->version [pom-zipper]
  (first
   (zip-xml/xml->
    pom-zipper
    :version
    zip-xml/text)))
