/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.openal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.newdawn.slick.openal.Audio;
import org.newdawn.slick.openal.SoundStore;

public class AudioLoader {
    private static final String AIF = "AIF";
    private static final String WAV = "WAV";
    private static final String OGG = "OGG";
    private static final String MOD = "MOD";
    private static final String XM = "XM";
    private static boolean inited = false;

    private static void init() {
        if (!inited) {
            SoundStore.get().init();
            inited = true;
        }
    }

    public static Audio getAudio(String format2, InputStream in) throws IOException {
        AudioLoader.init();
        if (format2.equals(AIF)) {
            return SoundStore.get().getAIF(in);
        }
        if (format2.equals(WAV)) {
            return SoundStore.get().getWAV(in);
        }
        if (format2.equals(OGG)) {
            return SoundStore.get().getOgg(in);
        }
        throw new IOException("Unsupported format for non-streaming Audio: " + format2);
    }

    public static Audio getStreamingAudio(String format2, URL url) throws IOException {
        AudioLoader.init();
        if (format2.equals(OGG)) {
            return SoundStore.get().getOggStream(url);
        }
        if (format2.equals(MOD)) {
            return SoundStore.get().getMOD(url.openStream());
        }
        if (format2.equals(XM)) {
            return SoundStore.get().getMOD(url.openStream());
        }
        throw new IOException("Unsupported format for streaming Audio: " + format2);
    }

    public static void update() {
        AudioLoader.init();
        SoundStore.get().poll(0);
    }
}

