/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.opengl.APIUtils;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;

public final class ARBShadingLanguageInclude {
    public static final int GL_SHADER_INCLUDE_ARB = 36270;
    public static final int GL_NAMED_STRING_LENGTH_ARB = 36329;
    public static final int GL_NAMED_STRING_TYPE_ARB = 36330;

    private ARBShadingLanguageInclude() {
    }

    public static void glNamedStringARB(int type2, ByteBuffer name2, ByteBuffer string2) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.ARB_shading_language_include_glNamedStringARB_pointer;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkDirect(name2);
        BufferChecks.checkDirect(string2);
        ARBShadingLanguageInclude.nglNamedStringARB(type2, name2.remaining(), name2, name2.position(), string2.remaining(), string2, string2.position(), function_pointer);
    }

    private static native void nglNamedStringARB(int var0, int var1, ByteBuffer var2, int var3, int var4, ByteBuffer var5, int var6, long var7);

    public static void glNamedStringARB(int type2, CharSequence name2, CharSequence string2) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.ARB_shading_language_include_glNamedStringARB_pointer;
        BufferChecks.checkFunctionAddress(function_pointer);
        ARBShadingLanguageInclude.nglNamedStringARB(type2, name2.length(), APIUtils.getBuffer(name2), 0, string2.length(), APIUtils.getBuffer(string2, name2.length()), name2.length(), function_pointer);
    }

    public static void glDeleteNamedStringARB(ByteBuffer name2) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.ARB_shading_language_include_glDeleteNamedStringARB_pointer;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkDirect(name2);
        ARBShadingLanguageInclude.nglDeleteNamedStringARB(name2.remaining(), name2, name2.position(), function_pointer);
    }

    private static native void nglDeleteNamedStringARB(int var0, ByteBuffer var1, int var2, long var3);

    public static void glDeleteNamedStringARB(CharSequence name2) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.ARB_shading_language_include_glDeleteNamedStringARB_pointer;
        BufferChecks.checkFunctionAddress(function_pointer);
        ARBShadingLanguageInclude.nglDeleteNamedStringARB(name2.length(), APIUtils.getBuffer(name2), 0, function_pointer);
    }

    public static void glCompileShaderIncludeARB(int shader, int count2, ByteBuffer path2) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.ARB_shading_language_include_glCompileShaderIncludeARB_pointer;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkDirect(path2);
        BufferChecks.checkNullTerminated(path2, count2);
        ARBShadingLanguageInclude.nglCompileShaderIncludeARB(shader, count2, path2, path2.position(), null, 0, function_pointer);
    }

    private static native void nglCompileShaderIncludeARB(int var0, int var1, ByteBuffer var2, int var3, IntBuffer var4, int var5, long var6);

    public static void glCompileShaderIncludeARB(int shader, CharSequence[] path2) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.ARB_shading_language_include_glCompileShaderIncludeARB_pointer;
        BufferChecks.checkFunctionAddress(function_pointer);
        ARBShadingLanguageInclude.nglCompileShaderIncludeARB2(shader, path2.length, APIUtils.getBuffer(path2), 0, APIUtils.getLengths(path2), 0, function_pointer);
    }

    private static native void nglCompileShaderIncludeARB2(int var0, int var1, ByteBuffer var2, int var3, IntBuffer var4, int var5, long var6);

    public static boolean glIsNamedStringARB(ByteBuffer name2) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.ARB_shading_language_include_glIsNamedStringARB_pointer;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkDirect(name2);
        boolean __result = ARBShadingLanguageInclude.nglIsNamedStringARB(name2.remaining(), name2, name2.position(), function_pointer);
        return __result;
    }

    private static native boolean nglIsNamedStringARB(int var0, ByteBuffer var1, int var2, long var3);

    public static boolean glIsNamedStringARB(CharSequence name2) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.ARB_shading_language_include_glIsNamedStringARB_pointer;
        BufferChecks.checkFunctionAddress(function_pointer);
        boolean __result = ARBShadingLanguageInclude.nglIsNamedStringARB(name2.length(), APIUtils.getBuffer(name2), 0, function_pointer);
        return __result;
    }

    public static void glGetNamedStringARB(ByteBuffer name2, IntBuffer stringlen, ByteBuffer string2) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.ARB_shading_language_include_glGetNamedStringARB_pointer;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkDirect(name2);
        if (stringlen != null) {
            BufferChecks.checkBuffer(stringlen, 1);
        }
        BufferChecks.checkDirect(string2);
        ARBShadingLanguageInclude.nglGetNamedStringARB(name2.remaining(), name2, name2.position(), string2.remaining(), stringlen, stringlen != null ? stringlen.position() : 0, string2, string2.position(), function_pointer);
    }

    private static native void nglGetNamedStringARB(int var0, ByteBuffer var1, int var2, int var3, IntBuffer var4, int var5, ByteBuffer var6, int var7, long var8);

    public static void glGetNamedStringARB(CharSequence name2, IntBuffer stringlen, ByteBuffer string2) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.ARB_shading_language_include_glGetNamedStringARB_pointer;
        BufferChecks.checkFunctionAddress(function_pointer);
        if (stringlen != null) {
            BufferChecks.checkBuffer(stringlen, 1);
        }
        BufferChecks.checkDirect(string2);
        ARBShadingLanguageInclude.nglGetNamedStringARB(name2.length(), APIUtils.getBuffer(name2), 0, string2.remaining(), stringlen, stringlen != null ? stringlen.position() : 0, string2, string2.position(), function_pointer);
    }

    public static String glGetNamedStringARB(CharSequence name2, int bufSize) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.ARB_shading_language_include_glGetNamedStringARB_pointer;
        BufferChecks.checkFunctionAddress(function_pointer);
        IntBuffer string_length = APIUtils.getLengths();
        ByteBuffer string2 = APIUtils.getBufferByte(bufSize + name2.length());
        ARBShadingLanguageInclude.nglGetNamedStringARB(name2.length(), APIUtils.getBuffer(name2), 0, bufSize, string_length, 0, string2, string2.position(), function_pointer);
        string2.limit(name2.length() + string_length.get(0));
        return APIUtils.getString(string2);
    }

    public static void glGetNamedStringARB(ByteBuffer name2, int pname, IntBuffer params) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.ARB_shading_language_include_glGetNamedStringivARB_pointer;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkDirect(name2);
        BufferChecks.checkBuffer(params, 1);
        ARBShadingLanguageInclude.nglGetNamedStringivARB(name2.remaining(), name2, name2.position(), pname, params, params.position(), function_pointer);
    }

    private static native void nglGetNamedStringivARB(int var0, ByteBuffer var1, int var2, int var3, IntBuffer var4, int var5, long var6);

    public static void glGetNamedStringiARB(CharSequence name2, int pname, IntBuffer params) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.ARB_shading_language_include_glGetNamedStringivARB_pointer;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkBuffer(params, 1);
        ARBShadingLanguageInclude.nglGetNamedStringivARB(name2.length(), APIUtils.getBuffer(name2), 0, pname, params, params.position(), function_pointer);
    }

    public static int glGetNamedStringiARB(CharSequence name2, int pname) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.ARB_shading_language_include_glGetNamedStringivARB_pointer;
        BufferChecks.checkFunctionAddress(function_pointer);
        IntBuffer params = APIUtils.getBufferInt();
        ARBShadingLanguageInclude.nglGetNamedStringivARB(name2.length(), APIUtils.getBuffer(name2), 0, pname, params, params.position(), function_pointer);
        return params.get(0);
    }
}

