/*
 * Decompiled with CFR 0.152.
 */
package penumbra;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import penumbra.PenumbraSystem;

public class Natives {
    private static final Logger logger = Logger.getLogger(Natives.class.getName());
    private static final byte[] buf = new byte[1024];
    private static File workingDir = new File("").getAbsoluteFile();

    public static void setExtractionDir(String string) {
        workingDir = new File(string).getAbsoluteFile();
    }

    protected static void extractNativeLib(String string, String string2) throws IOException {
        String string3 = System.mapLibraryName(string2);
        String string4 = "native/" + string + "/" + string3;
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string4);
        if (inputStream == null) {
            logger.log(Level.WARNING, "Cannot locate native library: {0}/{1}", new String[]{string, string3});
            return;
        }
        File file = new File(workingDir, string3);
        try {
            int n;
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            while ((n = inputStream.read(buf)) > 0) {
                ((OutputStream)fileOutputStream).write(buf, 0, n);
            }
            inputStream.close();
            ((OutputStream)fileOutputStream).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (fileNotFoundException.getMessage().contains("used by another process")) {
                return;
            }
            throw fileNotFoundException;
        }
        logger.log(Level.FINE, "Copied {0} to {1}", new Object[]{string3, file});
    }

    private static String getExtractionDir() {
        URL uRL = Natives.class.getResource("");
        if (uRL != null) {
            StringBuilder stringBuilder = new StringBuilder(uRL.toString());
            if (stringBuilder.indexOf("jar:") == 0) {
                stringBuilder.delete(0, 4);
                stringBuilder.delete(stringBuilder.indexOf("!"), stringBuilder.length());
                stringBuilder.delete(stringBuilder.lastIndexOf("/") + 1, stringBuilder.length());
            }
            try {
                return new URL(stringBuilder.toString()).toString();
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        return null;
    }

    public static void extractNativeLibs(PenumbraSystem.Platform platform, String string) throws IOException {
        String string2 = "LWJGL";
        String string3 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        if (string2 != null) {
            if (string2.startsWith("LWJGL")) {
                bl = true;
            } else if (string2.startsWith("JOGL")) {
                bl2 = true;
                bl3 = true;
            }
        }
        if (string3 != null) {
            if (string3.equals("LWJGL")) {
                bl = true;
                bl5 = true;
            } else if (string3.equals("JOAL")) {
                bl4 = true;
                bl2 = true;
                bl5 = true;
            }
        }
        if (bl) {
            logger.log(Level.INFO, "Extraction Directory #1: {0}", Natives.getExtractionDir());
            logger.log(Level.INFO, "Extraction Directory #2: {0}", workingDir.toString());
            logger.log(Level.INFO, "Extraction Directory #3: {0}", System.getProperty("user.dir"));
            System.setProperty("org.lwjgl.librarypath", workingDir.toString());
        }
        switch (platform) {
            case Windows64: {
                if (bl) {
                    Natives.extractNativeLib("windows", "lwjgl64");
                }
                if (bl3) {
                    Natives.extractNativeLib("win64", "jogl_awt");
                    Natives.extractNativeLib("win64", "jogl");
                }
                if (bl4) {
                    Natives.extractNativeLib("win64", "joal_native");
                }
                if (bl2) {
                    Natives.extractNativeLib("win64", "gluegen-rt");
                }
                if (bl5) {
                    Natives.extractNativeLib("windows", "OpenAL64");
                }
                if (!bl6) break;
                Natives.extractNativeLib("windows", "jinput-dx8_64");
                Natives.extractNativeLib("windows", "jinput-raw_64");
                break;
            }
            case Windows32: {
                if (bl) {
                    Natives.extractNativeLib("windows", "lwjgl");
                }
                if (bl3) {
                    Natives.extractNativeLib("win32", "jogl_awt");
                    Natives.extractNativeLib("win32", "jogl");
                }
                if (bl4) {
                    Natives.extractNativeLib("win32", "joal_native");
                }
                if (bl2) {
                    Natives.extractNativeLib("win32", "gluegen-rt");
                }
                if (bl5) {
                    Natives.extractNativeLib("windows", "OpenAL32");
                }
                if (!bl6) break;
                Natives.extractNativeLib("windows", "jinput-dx8");
                Natives.extractNativeLib("windows", "jinput-raw");
                break;
            }
            case Linux64: {
                if (bl) {
                    Natives.extractNativeLib("linux", "lwjgl64");
                }
                if (bl3) {
                    Natives.extractNativeLib("linux64", "jogl_awt");
                    Natives.extractNativeLib("linux64", "jogl");
                }
                if (bl4) {
                    Natives.extractNativeLib("linux64", "joal_native");
                }
                if (bl2) {
                    Natives.extractNativeLib("linux64", "gluegen-rt");
                }
                if (bl6) {
                    Natives.extractNativeLib("linux", "jinput-linux64");
                }
                if (!bl5) break;
                Natives.extractNativeLib("linux", "openal64");
                break;
            }
            case Linux32: {
                if (bl) {
                    Natives.extractNativeLib("linux", "lwjgl");
                }
                if (bl3) {
                    Natives.extractNativeLib("linux32", "jogl_awt");
                    Natives.extractNativeLib("linux32", "jogl");
                }
                if (bl4) {
                    Natives.extractNativeLib("linux32", "joal_native");
                }
                if (bl2) {
                    Natives.extractNativeLib("linux32", "gluegen-rt");
                }
                if (bl6) {
                    Natives.extractNativeLib("linux", "jinput-linux");
                }
                if (!bl5) break;
                Natives.extractNativeLib("linux", "openal");
                break;
            }
            case MacOSX_PPC32: {
                if (bl) {
                    Natives.extractNativeLib("macosx", "lwjgl");
                }
                if (bl3) {
                    Natives.extractNativeLib("macosx_ppc", "jogl_awt");
                    Natives.extractNativeLib("macosx_ppc", "jogl");
                }
                if (bl4) {
                    throw new UnsupportedOperationException("JOAL not available on Mac OS PPC");
                }
                if (bl2) {
                    Natives.extractNativeLib("macosx_ppc", "gluegen-rt");
                }
                if (!bl6) break;
                Natives.extractNativeLib("macosx", "jinput-osx");
                break;
            }
            case MacOSX32: {
                if (bl) {
                    Natives.extractNativeLib("macosx", "lwjgl");
                }
                if (bl3) {
                    Natives.extractNativeLib("macosx_universal", "jogl_awt");
                    Natives.extractNativeLib("macosx_universal", "jogl");
                }
                if (bl4) {
                    Natives.extractNativeLib("macosx_universal", "joal_native");
                }
                if (bl2) {
                    Natives.extractNativeLib("macosx_universal", "gluegen-rt");
                }
                if (!bl6) break;
                Natives.extractNativeLib("macosx", "jinput-osx");
                break;
            }
            case MacOSX_PPC64: {
                if (bl) {
                    Natives.extractNativeLib("macosx", "lwjgl");
                }
                if (bl3) {
                    Natives.extractNativeLib("macosx_ppc", "jogl_awt");
                    Natives.extractNativeLib("macosx_ppc", "jogl");
                }
                if (bl4) {
                    throw new UnsupportedOperationException("JOAL not available on Mac OS 64 bit");
                }
                if (bl2) {
                    Natives.extractNativeLib("macosx_ppc", "gluegen-rt");
                }
                if (!bl6) break;
                Natives.extractNativeLib("macosx", "jinput-osx");
                break;
            }
            case MacOSX64: {
                if (bl) {
                    Natives.extractNativeLib("macosx", "lwjgl");
                }
                if (bl3) {
                    Natives.extractNativeLib("macosx_universal", "jogl_awt");
                    Natives.extractNativeLib("macosx_universal", "jogl");
                }
                if (bl4) {
                    throw new UnsupportedOperationException("JOAL not available on Mac OS 64 bit");
                }
                if (bl2) {
                    Natives.extractNativeLib("macosx_universal", "gluegen-rt");
                }
                if (!bl6) break;
                Natives.extractNativeLib("macosx", "jinput-osx");
            }
        }
    }
}

