package org.ode4j.tests.libccd;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.ode4j.tests.libccd.CCDTestSupport.ccd_sphere_t;

import static org.junit.Assert.*;
import static org.ode4j.ode.internal.libccd.CCD.*;
import static org.ode4j.ode.internal.libccd.CCDVec3.*;
import static org.ode4j.tests.libccd.CCDTestSupport.*;

public class TestSphereSphere {

	@Before
	public void spheresphereSetUp()
	{
	}

	@After
	public void spheresphereTearDown()
	{
	}

	@Test
	public void spheresphereAlignedX()
	{
	    ccd_t ccd = new ccd_t();
	    ccd_sphere_t s1 = CCD_SPHERE();
	    ccd_sphere_t s2 = CCD_SPHERE();
	    int i;
	    boolean res;

	    CCD_INIT(ccd);
	    ccd.support1 = ccdSupport;
	    ccd.support2 = ccdSupport;

	    s1.radius = 0.35;
	    s2.radius = .5;

	    ccdVec3Set(s1.pos, -5., 0., 0.);
	    for (i = 0; i < 100; i++){
	        res = ccdGJKIntersect(s1, s2, ccd);

	        if (i < 42 || i > 58){
	            assertFalse(res);
	        }else{
	            assertTrue(res);
	        }

	        s1.pos.add(0, 0.1);
	    }
	}

	@Test
	public void spheresphereAlignedY()
	{
	    ccd_t ccd = new ccd_t();
	    ccd_sphere_t s1 = CCD_SPHERE();
	    ccd_sphere_t s2 = CCD_SPHERE();
	    int i;
	    boolean res;

	    CCD_INIT(ccd);
	    ccd.support1 = ccdSupport;
	    ccd.support2 = ccdSupport;

	    s1.radius = 0.35;
	    s2.radius = .5;

	    ccdVec3Set(s1.pos, 0., -5., 0.);
	    for (i = 0; i < 100; i++){
	        res = ccdGJKIntersect(s1, s2, ccd);

	        if (i < 42 || i > 58){
	            assertFalse(res);
	        }else{
	            assertTrue(res);
	        }

	        s1.pos.add(1, 0.1);
	    }
	}

	@Test
	public void spheresphereAlignedZ()
	{
	    ccd_t ccd = new ccd_t();
	    ccd_sphere_t s1 = CCD_SPHERE();
	    ccd_sphere_t s2 = CCD_SPHERE();
	    int i;
	    boolean res;

	    CCD_INIT(ccd);
	    ccd.support1 = ccdSupport;
	    ccd.support2 = ccdSupport;

	    s1.radius = 0.35;
	    s2.radius = .5;

	    ccdVec3Set(s1.pos, 0., 0., -5.);
	    for (i = 0; i < 100; i++){
	        res = ccdGJKIntersect(s1, s2, ccd);

	        if (i < 42 || i > 58){
	            assertFalse(res);
	        }else{
	            assertTrue(res);
	        }

	        s1.pos.add(2, 0.1);
	    }
	}

}
