package org.ode4j.tests.libccd;

import static org.ode4j.ode.internal.libccd.CCD.*;
import static org.ode4j.ode.internal.libccd.CCDMPR.*;
import static org.ode4j.ode.internal.libccd.CCDQuat.*;
import static org.ode4j.ode.internal.libccd.CCDVec3.*;
import static org.ode4j.tests.libccd.CCDTestSupport.*;

import org.cpp4j.java.RefDouble;
import org.junit.Assert;
import org.ode4j.ode.internal.libccd.CCD.ccd_t;
import org.ode4j.ode.internal.libccd.CCDQuat.ccd_quat_t;
import org.ode4j.ode.internal.libccd.CCDVec3.ccd_vec3_t;

public class CCDTestBench2 {

	private static int bench_num = 1;
	private static int cycles = 10000;

	private static void runBench(final Object o1, final Object o2, final ccd_t ccd)
	{
	    RefDouble depth = new RefDouble();
	    final ccd_vec3_t dir = new ccd_vec3_t(), pos = new ccd_vec3_t();
	    int res = 0;
	    int i;
	    //const struct timespec *timer;

	    //cuTimerStart();
	    long t1 = System.currentTimeMillis();//cuTimerStart();
	    for (i = 0; i < cycles; i++){
	        res = ccdMPRPenetration(o1, o2, ccd, depth, dir, pos);
	    }
	    long t2 = System.currentTimeMillis();//timer = cuTimerStop();
//	    timer = cuTimerStop();
//	    fprintf(stdout, "%02d: %ld %ld\n", bench_num,
//	                    (long)timer->tv_sec, (long)timer->tv_nsec);
//	    fflush(stdout);
	    System.out.println(bench_num + ": " + (t2-t1));

	    //TZ to avoid inlining and warning
	    Assert.assertTrue(res > -10);
	    
	    bench_num++;
	}

	private static void boxbox()
	{
	    //fprintf(stdout, "%s:\n", __func__);
		System.out.println("CCDBench.boxbox(): ");

	    ccd_t ccd = new ccd_t();
	    ccd_box_t box1 = CCD_BOX();
	    ccd_box_t box2 = CCD_BOX();
	    ccd_vec3_t axis = new ccd_vec3_t();
	    ccd_quat_t rot = new ccd_quat_t();

	    box1.x = box1.y = box1.z = 1.;
	    box2.x = 0.5;
	    box2.y = 1.;
	    box2.z = 1.5;

	    bench_num = 1;

	    CCD_INIT(ccd);
	    ccd.support1 = ccdSupport;
	    ccd.support2 = ccdSupport;
	    ccd.center1 = ccdObjCenter;
	    ccd.center2 = ccdObjCenter;

	    runBench(box1, box2, ccd);
	    runBench(box2, box1, ccd);

	    ccdVec3Set(box1.pos, -0.3, 0.5, 1.);
	    runBench(box1, box2, ccd);
	    runBench(box2, box1, ccd);

	    box1.x = box1.y = box1.z = 1.;
	    box2.x = box2.y = box2.z = 1.;
	    ccdVec3Set(axis, 0., 0., 1.);
	    ccdQuatSetAngleAxis(box1.quat, M_PI / 4., axis);
	    ccdVec3Set(box1.pos, 0., 0., 0.);
	    runBench(box1, box2, ccd);
	    runBench(box2, box1, ccd);

	    box1.x = box1.y = box1.z = 1.;
	    box2.x = box2.y = box2.z = 1.;
	    ccdVec3Set(axis, 0., 0., 1.);
	    ccdQuatSetAngleAxis(box1.quat, M_PI / 4., axis);
	    ccdVec3Set(box1.pos, -0.5, 0., 0.);
	    runBench(box1, box2, ccd);
	    runBench(box2, box1, ccd);

	    box1.x = box1.y = box1.z = 1.;
	    box2.x = box2.y = box2.z = 1.;
	    ccdVec3Set(axis, 0., 0., 1.);
	    ccdQuatSetAngleAxis(box1.quat, M_PI / 4., axis);
	    ccdVec3Set(box1.pos, -0.5, 0.5, 0.);
	    runBench(box1, box2, ccd);
	    runBench(box2, box1, ccd);

	    box1.x = box1.y = box1.z = 1.;
	    ccdVec3Set(axis, 0., 1., 1.);
	    ccdQuatSetAngleAxis(box1.quat, M_PI / 4., axis);
	    ccdVec3Set(box1.pos, -0.5, 0.1, 0.4);
	    runBench(box1, box2, ccd);
	    runBench(box2, box1, ccd);

	    box1.x = box1.y = box1.z = 1.;
	    ccdVec3Set(axis, 0., 1., 1.);
	    ccdQuatSetAngleAxis(box1.quat, M_PI / 4., axis);
	    ccdVec3Set(axis, 1., 1., 1.);
	    ccdQuatSetAngleAxis(rot, M_PI / 4., axis);
	    ccdQuatMul(box1.quat, rot);
	    ccdVec3Set(box1.pos, -0.5, 0.1, 0.4);
	    runBench(box1, box2, ccd);
	    runBench(box2, box1, ccd);


	    box1.x = box1.y = box1.z = 1.;
	    box2.x = 0.2; box2.y = 0.5; box2.z = 1.;
	    box2.x = box2.y = box2.z = 1.;

	    ccdVec3Set(axis, 0., 0., 1.);
	    ccdQuatSetAngleAxis(box1.quat, M_PI / 4., axis);
	    ccdVec3Set(axis, 1., 0., 0.);
	    ccdQuatSetAngleAxis(rot, M_PI / 4., axis);
	    ccdQuatMul(box1.quat, rot);
	    ccdVec3Set(box1.pos, -1.3, 0., 0.);

	    ccdVec3Set(box2.pos, 0., 0., 0.);
	    runBench(box1, box2, ccd);
	    runBench(box2, box1, ccd);


	    //fprintf(stdout, "\n----\n\n");
	    System.out.println("\n----\n");
	}

	private static void cylcyl()
	{
	    //fprintf(stdout, "%s:\n", __func__);
		System.out.println("CCDBench.cylcyl(): ");

	    ccd_t ccd = new ccd_t();
	    ccd_cyl_t cyl1 = CCD_CYL();
	    ccd_cyl_t cyl2 = CCD_CYL();
	    ccd_vec3_t axis = new ccd_vec3_t();

	    cyl1.radius = 0.35;
	    cyl1.height = 0.5;
	    cyl2.radius = 0.5;
	    cyl2.height = 1.;

	    CCD_INIT(ccd);
	    ccd.support1 = ccdSupport;
	    ccd.support2 = ccdSupport;
	    ccd.center1 = ccdObjCenter;
	    ccd.center2 = ccdObjCenter;

	    runBench(cyl1, cyl2, ccd);
	    runBench(cyl2, cyl1, ccd);

	    ccdVec3Set(cyl1.pos, 0.3, 0.1, 0.1);
	    runBench(cyl1, cyl2, ccd);
	    runBench(cyl2, cyl1, ccd);

	    ccdVec3Set(axis, 0., 1., 1.);
	    ccdQuatSetAngleAxis(cyl2.quat, M_PI / 4., axis);
	    ccdVec3Set(cyl2.pos, 0., 0., 0.);
	    runBench(cyl1, cyl2, ccd);
	    runBench(cyl2, cyl1, ccd);

	    ccdVec3Set(axis, 0., 1., 1.);
	    ccdQuatSetAngleAxis(cyl2.quat, M_PI / 4., axis);
	    ccdVec3Set(cyl2.pos, -0.2, 0.7, 0.2);
	    runBench(cyl1, cyl2, ccd);
	    runBench(cyl2, cyl1, ccd);

	    ccdVec3Set(axis, 0.567, 1.2, 1.);
	    ccdQuatSetAngleAxis(cyl2.quat, M_PI / 4., axis);
	    ccdVec3Set(cyl2.pos, 0.6, -0.7, 0.2);
	    runBench(cyl1, cyl2, ccd);
	    runBench(cyl2, cyl1, ccd);

	    ccdVec3Set(axis, -4.567, 1.2, 0.);
	    ccdQuatSetAngleAxis(cyl2.quat, M_PI / 3., axis);
	    ccdVec3Set(cyl2.pos, 0.6, -0.7, 0.2);
	    runBench(cyl1, cyl2, ccd);
	    runBench(cyl2, cyl1, ccd);

	    //fprintf(stdout, "\n----\n\n");
	    System.out.println("\n----\n");
	}

	private static void boxcyl()
	{
	    //fprintf(stdout, "%s:\n", __func__);
		System.out.println("CCDBench.boxcyl(): ");

	    ccd_t ccd = new ccd_t();
	    ccd_box_t box = CCD_BOX();
	    ccd_cyl_t cyl = CCD_CYL();
	    ccd_vec3_t axis = new ccd_vec3_t();

	    box.x = 0.5;
	    box.y = 1.;
	    box.z = 1.5;
	    cyl.radius = 0.4;
	    cyl.height = 0.7;

	    CCD_INIT(ccd);
	    ccd.support1 = ccdSupport;
	    ccd.support2 = ccdSupport;
	    ccd.center1 = ccdObjCenter;
	    ccd.center2 = ccdObjCenter;

	    runBench(box, cyl, ccd);
	    runBench(cyl, box, ccd);

	    ccdVec3Set(cyl.pos, .6, 0., 0.);
	    runBench(box, cyl, ccd);
	    runBench(cyl, box, ccd);

	    ccdVec3Set(cyl.pos, .6, 0.6, 0.);
	    runBench(box, cyl, ccd);
	    runBench(cyl, box, ccd);

	    ccdVec3Set(cyl.pos, .6, 0.6, 0.5);
	    runBench(box, cyl, ccd);
	    runBench(cyl, box, ccd);

	    ccdVec3Set(axis, 0., 1., 0.);
	    ccdQuatSetAngleAxis(cyl.quat, M_PI / 3., axis);
	    ccdVec3Set(cyl.pos, .6, 0.6, 0.5);
	    runBench(box, cyl, ccd);
	    runBench(cyl, box, ccd);

	    ccdVec3Set(axis, 0.67, 1.1, 0.12);
	    ccdQuatSetAngleAxis(cyl.quat, M_PI / 4., axis);
	    ccdVec3Set(cyl.pos, .6, 0., 0.5);
	    runBench(box, cyl, ccd);
	    runBench(cyl, box, ccd);

	    ccdVec3Set(axis, -0.1, 2.2, -1.);
	    ccdQuatSetAngleAxis(cyl.quat, M_PI / 5., axis);
	    ccdVec3Set(cyl.pos, .6, 0., 0.5);
	    ccdVec3Set(axis, 1., 1., 0.);
	    ccdQuatSetAngleAxis(box.quat, -M_PI / 4., axis);
	    ccdVec3Set(box.pos, .6, 0., 0.5);
	    runBench(box, cyl, ccd);
	    runBench(cyl, box, ccd);

	    ccdVec3Set(axis, -0.1, 2.2, -1.);
	    ccdQuatSetAngleAxis(cyl.quat, M_PI / 5., axis);
	    ccdVec3Set(cyl.pos, .6, 0., 0.5);
	    ccdVec3Set(axis, 1., 1., 0.);
	    ccdQuatSetAngleAxis(box.quat, -M_PI / 4., axis);
	    ccdVec3Set(box.pos, .9, 0.8, 0.5);
	    runBench(box, cyl, ccd);
	    runBench(cyl, box, ccd);

	    //fprintf(stdout, "\n----\n\n");
	    System.out.println("\n----\n");
	}

	public static void main(String[] args) {
	    if (args.length > 1){
	        cycles = Integer.parseInt(args[0]);
	    }

//	    fprintf(stdout, "Cycles: %u\n", cycles);
//	    fprintf(stdout, "\n");

	    boxbox();
	    cylcyl();
	    boxcyl();

	    //return 0;
	}

}
