/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal.stuff;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public final class SerTimer {
    private final Map<String, Entry> _data = new HashMap<String, Entry>();
    private long _prev = 0L;
    private int _nStart = 0;

    public final void start() {
        this._prev = System.currentTimeMillis();
        ++this._nStart;
    }

    public final void take(String key) {
        long now = System.currentTimeMillis();
        Entry e = this._data.get(key);
        if (e == null) {
            e = new Entry();
            this._data.put(key, e);
        }
        this._data.get(key).add(now - this._prev);
        this._prev = now;
    }

    public final void print() {
        LinkedList<String> keys = new LinkedList<String>();
        keys.addAll(this._data.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            System.out.println(String.valueOf(this._data.get(key).print()) + " :: " + key);
        }
    }

    public final void reset() {
        this._data.clear();
    }

    public final int getNStart() {
        return this._nStart;
    }

    private static final class Entry {
        long _total = 0L;
        long _nCalls = 0L;

        private Entry() {
        }

        public final String print() {
            StringBuffer b = new StringBuffer();
            b.append("Calls: " + this._nCalls);
            while (b.length() < 25) {
                b.append(' ');
            }
            b.append("Time [ms]: " + this._total);
            while (b.length() < 50) {
                b.append(' ');
            }
            b.append("T/C [ms]: " + (double)this._total / (double)this._nCalls);
            return b.toString();
        }

        public final void add(long time) {
            this._total += time;
            ++this._nCalls;
        }
    }
}

