/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal.stuff;

import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;

public final class Performator {
    private static final ConcurrentHashMap<String, Entry> data = new ConcurrentHashMap();

    public static final void begin(String key) {
        Entry e = data.get(key);
        if (e == null) {
            e = new Entry();
            data.put(key, e);
        }
        e.begin();
    }

    public static final void end(String key) {
        data.get(key).end();
    }

    public static final void print() {
        LinkedList keys = new LinkedList();
        keys.addAll(data.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            System.out.println(String.valueOf(data.get(key).print()) + " :: " + key);
        }
    }

    public static final void reset() {
        data.clear();
    }

    private static final class Entry {
        long _total = 0L;
        long _nCalls = 0L;

        private Entry() {
        }

        public final String print() {
            StringBuffer b = new StringBuffer();
            b.append("Calls: " + this._nCalls);
            while (b.length() < 25) {
                b.append(' ');
            }
            b.append("Time [ms]: " + this._total);
            while (b.length() < 50) {
                b.append(' ');
            }
            b.append("T/C [ms]: " + (double)this._total / (double)this._nCalls);
            return b.toString();
        }

        public final void end() {
            this._total += System.currentTimeMillis();
            ++this._nCalls;
        }

        public final void begin() {
            this._total -= System.currentTimeMillis();
        }
    }
}

