/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal.processmem;

import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DxBody;
import org.ode4j.ode.internal.joints.DxJoint;
import org.ode4j.ode.internal.processmem.DxUtil;
import org.ode4j.ode.internal.processmem.DxWorldProcessMemoryManager;
import org.ode4j.ode.internal.processmem.DxWorldProcessMemoryReserveInfo;

public final class DxWorldProcessMemArena {
    private DxUtil.BlockPointer m_pAllocBegin;
    private DxUtil.BlockPointer m_pAllocEnd;
    private DxUtil.BlockPointer m_pAllocCurrent;
    private DxUtil.BlockPointer m_pArenaBegin;
    DxWorldProcessMemoryManager m_pArenaMemMgr;

    private static final int BUFFER_TO_ARENA_EXTRA() {
        return 16 + DxUtil.dEFFICIENT_SIZE(DxUtil.sizeof(DxWorldProcessMemArena.class));
    }

    static boolean IsArenaPossible(int nBufferSize) {
        return Integer.MAX_VALUE - DxWorldProcessMemArena.BUFFER_TO_ARENA_EXTRA() >= nBufferSize;
    }

    static int MakeBufferSize(int nArenaSize) {
        return nArenaSize - DxWorldProcessMemArena.BUFFER_TO_ARENA_EXTRA();
    }

    static int MakeArenaSize(int nBufferSize) {
        return DxWorldProcessMemArena.BUFFER_TO_ARENA_EXTRA() + nBufferSize;
    }

    boolean IsStructureValid() {
        return this.m_pAllocBegin != null && this.m_pAllocEnd != null && this.m_pAllocBegin.toInt() <= this.m_pAllocEnd.toInt() && this.m_pAllocCurrent == this.m_pAllocBegin && this.m_pArenaBegin != null && this.m_pArenaBegin.toInt() <= this.m_pAllocBegin.toInt();
    }

    int GetMemorySize() {
        return this.m_pAllocEnd.toInt() - this.m_pAllocBegin.toInt();
    }

    DxUtil.BlockPointer SaveState() {
        return this.m_pAllocCurrent;
    }

    void RestoreState(DxUtil.BlockPointer state) {
        this.m_pAllocCurrent = state;
    }

    void ResetState() {
        this.m_pAllocCurrent = this.m_pAllocBegin;
    }

    public DxUtil.BlockPointer PeekBufferRemainder() {
        return this.m_pAllocCurrent;
    }

    DxUtil.BlockPointer AllocateBlock(int size) {
        DxUtil.BlockPointer block = this.m_pAllocCurrent;
        this.m_pAllocCurrent = DxUtil.dOFFSET_EFFICIENTLY(block, size);
        Common.dIASSERT(this.m_pAllocCurrent.toInt() <= this.m_pAllocEnd.toInt());
        return block;
    }

    static DxWorldProcessMemArena ReallocateMemArena(DxWorldProcessMemArena oldarena, int memreq, DxWorldProcessMemoryManager memmgr, double rsrvfactor, int rsrvminimum) {
        DxUtil.BlockPointer pOldArenaBuffer;
        int nOldArenaSize;
        boolean allocsuccess;
        DxWorldProcessMemArena arena;
        block7: {
            block6: {
                DxUtil.BlockPointer pNewArenaBuffer;
                int oldmemsize;
                arena = oldarena;
                allocsuccess = false;
                nOldArenaSize = 0;
                pOldArenaBuffer = null;
                int n = oldmemsize = oldarena != null ? oldarena.GetMemorySize() : 0;
                if (oldarena != null && oldmemsize >= memreq) break block6;
                nOldArenaSize = oldarena != null ? DxWorldProcessMemArena.MakeArenaSize(oldmemsize) : 0;
                DxUtil.BlockPointer blockPointer = pOldArenaBuffer = oldarena != null ? oldarena.m_pArenaBegin : null;
                if (!DxWorldProcessMemArena.IsArenaPossible(memreq)) break block7;
                int arenareq = DxWorldProcessMemArena.MakeArenaSize(memreq);
                int arenareq_with_reserve = DxWorldProcessMemArena.AdjustArenaSizeForReserveRequirements(arenareq, rsrvfactor, rsrvminimum);
                int memreq_with_reserve = memreq + (arenareq_with_reserve - arenareq);
                if (oldarena != null) {
                    oldarena.m_pArenaMemMgr.m_fnFree.run(pOldArenaBuffer, nOldArenaSize);
                    oldarena = null;
                    pOldArenaBuffer = null;
                    nOldArenaSize = 0;
                }
                if ((pNewArenaBuffer = memmgr.m_fnAlloc.run(arenareq_with_reserve)) == null) break block7;
                arena = DxUtil.dEFFICIENT_PTR(pNewArenaBuffer).asDxWorldProcessMemArena();
                DxUtil.BlockPointer blockbegin = DxUtil.dEFFICIENT_PTR(arena, 1);
                DxUtil.BlockPointer blockend = DxUtil.dOFFSET_EFFICIENTLY(blockbegin, memreq_with_reserve);
                arena.m_pAllocBegin = blockbegin;
                arena.m_pAllocEnd = blockend;
                arena.m_pArenaBegin = pNewArenaBuffer;
                arena.m_pAllocCurrent = blockbegin;
                arena.m_pArenaMemMgr = memmgr;
            }
            allocsuccess = true;
        }
        if (!allocsuccess) {
            if (pOldArenaBuffer != null) {
                Common.dIASSERT(oldarena != null);
                oldarena.m_pArenaMemMgr.m_fnFree.run(pOldArenaBuffer, nOldArenaSize);
            }
            arena = null;
        }
        return arena;
    }

    static void FreeMemArena(DxWorldProcessMemArena arena) {
        int memsize = arena.GetMemorySize();
        int arenasize = DxWorldProcessMemArena.MakeArenaSize(memsize);
        DxUtil.BlockPointer pArenaBegin = arena.m_pArenaBegin;
        arena.m_pArenaMemMgr.m_fnFree.run(pArenaBegin, arenasize);
    }

    static int AdjustArenaSizeForReserveRequirements(int arenareq, double rsrvfactor, int rsrvminimum) {
        double scaledarena = (double)arenareq * rsrvfactor;
        int adjustedarena = scaledarena < 2.147483647E9 ? (int)scaledarena : Integer.MAX_VALUE;
        int boundedarena = adjustedarena > rsrvminimum ? adjustedarena : rsrvminimum;
        return DxUtil.dEFFICIENT_SIZE(boundedarena);
    }

    static DxWorldProcessMemArena dxAllocateTemporaryWorldProcessMemArena(int memreq, DxWorldProcessMemoryManager memmgr, DxWorldProcessMemoryReserveInfo reserveinfo) {
        DxWorldProcessMemoryManager surememmgr = memmgr != null ? memmgr : DxUtil.g_WorldProcessMallocMemoryManager;
        DxWorldProcessMemoryReserveInfo surereserveinfo = reserveinfo != null ? reserveinfo : DxUtil.g_WorldProcessDefaultReserveInfo;
        DxWorldProcessMemArena arena = DxWorldProcessMemArena.ReallocateMemArena(null, memreq, surememmgr, surereserveinfo.m_fReserveFactor, surereserveinfo.m_uiReserveMinimum);
        return arena;
    }

    static void dxFreeTemporaryWorldProcessMemArena(DxWorldProcessMemArena arena) {
        DxWorldProcessMemArena.FreeMemArena(arena);
    }

    public final double[] AllocateArrayDReal(int size) {
        return new double[size];
    }

    public final int[] AllocateArrayInt(int size) {
        return new int[size];
    }

    public static final void dummy() {
    }

    public final void ShrinkArrayDJointWithInfo1(Object[] jointiinfos, int _nj, int njXXX) {
    }

    public final double[][] AllocateArrayDRealDReal(int n) {
        return new double[n][];
    }

    public final boolean[] AllocateArrayBool(int n) {
        return new boolean[n];
    }

    public DxUtil.BlockPointer BEGIN_STATE_SAVE() {
        return this.SaveState();
    }

    public void END_STATE_SAVE(DxUtil.BlockPointer saveInner) {
        this.RestoreState(saveInner);
    }

    public static DxWorldProcessMemArena allocateTemporary(int memreq, Object object, Object object2) {
        return new DxWorldProcessMemArena();
    }

    public static void freeTemporary(DxWorldProcessMemArena arena) {
    }

    public DxBody[] AllocateArrayDxBody(int nb) {
        return new DxBody[nb];
    }

    public DxJoint[] AllocateArrayDxJoint(int nj) {
        return new DxJoint[nj];
    }
}

