/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal.processmem;

import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DxBody;
import org.ode4j.ode.internal.DxWorld;
import org.ode4j.ode.internal.joints.DxJoint;
import org.ode4j.ode.internal.joints.DxJointNode;
import org.ode4j.ode.internal.processmem.DxUtil;
import org.ode4j.ode.internal.processmem.DxWorldProcessMemArena;

public class DxWorldProcessIslandsInfo {
    private int m_IslandCount;
    private int[] m_pIslandSizes;
    private DxBody[] m_pBodies;
    private DxJoint[] m_pJoints;

    void AssignInfo(int islandcount, int[] islandsizes, DxBody[] bodies, DxJoint[] joints) {
        this.m_IslandCount = islandcount;
        this.m_pIslandSizes = islandsizes;
        this.m_pBodies = bodies;
        this.m_pJoints = joints;
    }

    public int GetIslandsCount() {
        return this.m_IslandCount;
    }

    public int[] GetIslandSizes() {
        return this.m_pIslandSizes;
    }

    public DxBody[] GetBodiesArray() {
        return this.m_pBodies;
    }

    public DxJoint[] GetJointsArray() {
        return this.m_pJoints;
    }

    static int BuildIslandsAndEstimateStepperMemoryRequirements(DxWorldProcessIslandsInfo islandsinfo, DxWorldProcessMemArena memarena, DxWorld world, double stepsize, dmemestimate_fn_t stepperestimate) {
        int sizeelements = 2;
        int maxreq = 0;
        world.dInternalHandleAutoDisabling(stepsize);
        int nb = world.nb;
        int nj = world.nj;
        int[] islandsizes = memarena.AllocateArrayInt(2 * nb);
        DxBody[] body = memarena.AllocateArrayDxBody(nb);
        DxJoint[] joint = memarena.AllocateArrayDxJoint(nj);
        DxUtil.BlockPointer stackstate = memarena.BEGIN_STATE_SAVE();
        int stackalloc = nj < nb ? nj : nb;
        DxBody[] stack = memarena.AllocateArrayDxBody(stackalloc);
        DxBody b = world.firstbody.get();
        while (b != null) {
            b.tag = 0;
            b = (DxBody)b.getNext();
        }
        DxJoint j = world.firstjoint.get();
        while (j != null) {
            j.tag = 0;
            j = (DxJoint)j.getNext();
        }
        int sizescurrP = 0;
        int bodystart = 0;
        int jointstart = 0;
        DxBody bb = world.firstbody.get();
        while (bb != null) {
            if (bb.tag == 0) {
                if (bb.dBodyIsEnabled()) {
                    bb.tag = 1;
                    int bodycurr = bodystart;
                    int jointcurr = jointstart;
                    body[bodycurr++] = bb;
                    int stacksize = 0;
                    DxBody b2 = bb;
                    while (true) {
                        DxJointNode n = b2.firstjoint.get();
                        while (n != null) {
                            DxJoint njoint = n.joint;
                            if (njoint.tag == 0) {
                                if (njoint.isEnabled()) {
                                    njoint.tag = 1;
                                    joint[jointcurr++] = njoint;
                                    DxBody nbody = n.body;
                                    if (nbody != null && nbody.tag <= 0) {
                                        nbody.tag = 1;
                                        nbody.dBodyEnable_noAdis();
                                        stack[stacksize++] = nbody;
                                    }
                                } else {
                                    njoint.tag = -1;
                                }
                            }
                            n = n.next;
                        }
                        Common.dIASSERT(stacksize <= world.nb);
                        Common.dIASSERT(stacksize <= world.nj);
                        if (stacksize == 0) break;
                        b2 = stack[--stacksize];
                        body[bodycurr++] = b2;
                    }
                    int bcount = bodycurr - bodystart;
                    int jcount = jointcurr - jointstart;
                    Common.dIASSERT(bodycurr - bodystart <= Integer.MAX_VALUE);
                    Common.dIASSERT(jointcurr - jointstart <= Integer.MAX_VALUE);
                    islandsizes[sizescurrP + 0] = bcount;
                    islandsizes[sizescurrP + 1] = jcount;
                    sizescurrP += 2;
                    int islandreq = stepperestimate.dxEstimateMemoryRequirements(body, bodystart, bcount, joint, jointstart, jcount);
                    maxreq = maxreq > islandreq ? maxreq : islandreq;
                    bodystart = bodycurr;
                    jointstart = jointcurr;
                } else {
                    bb.tag = -1;
                }
            }
            bb = (DxBody)bb.getNext();
        }
        memarena.END_STATE_SAVE(stackstate);
        DxBody b3 = world.firstbody.get();
        while (b3 != null) {
            if (!b3.isEnabled()) {
                if (b3.tag > 0) {
                    Common.dDebug(0, "disabled body tagged", new Object[0]);
                }
            } else if (b3.tag <= 0) {
                Common.dDebug(0, "enabled body not tagged", new Object[0]);
            }
            b3 = (DxBody)b3.getNext();
        }
        DxJoint j2 = world.firstjoint.get();
        while (j2 != null) {
            if ((j2.node[0].body != null && j2.node[0].body.isEnabled() || j2.node[1].body != null && j2.node[1].body.isEnabled()) && j2.isEnabled()) {
                if (j2.tag <= 0) {
                    Common.dDebug(0, "attached enabled joint not tagged", new Object[0]);
                }
            } else if (j2.tag > 0) {
                Common.dDebug(0, "unattached or disabled joint tagged", new Object[0]);
            }
            j2 = (DxJoint)j2.getNext();
        }
        int islandcount = sizescurrP / 2;
        islandsinfo.AssignInfo(islandcount, islandsizes, body, joint);
        return maxreq;
    }

    public static interface dmemestimate_fn_t {
        public int dxEstimateMemoryRequirements(DxBody[] var1, int var2, int var3, DxJoint[] var4, int var5, int var6);
    }
}

