/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal.processmem;

import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DxWorld;
import org.ode4j.ode.internal.processmem.DxStepWorkingMemory;
import org.ode4j.ode.internal.processmem.DxUtil;
import org.ode4j.ode.internal.processmem.DxWorldProcessIslandsInfo;
import org.ode4j.ode.internal.processmem.DxWorldProcessMemArena;
import org.ode4j.ode.internal.processmem.DxWorldProcessMemoryManager;
import org.ode4j.ode.internal.processmem.DxWorldProcessMemoryReserveInfo;

public class DxWorldProcessContext {
    private DxWorldProcessMemArena m_pmaIslandsArena = null;
    private DxWorldProcessMemArena m_pmaStepperArena = null;

    public DxWorldProcessMemArena GetIslandsMemArena() {
        return this.m_pmaIslandsArena;
    }

    public DxWorldProcessMemArena GetStepperMemArena() {
        return this.m_pmaStepperArena;
    }

    private void SetIslandsMemArena(DxWorldProcessMemArena pmaInstance) {
        this.m_pmaIslandsArena = pmaInstance;
    }

    private void SetStepperMemArena(DxWorldProcessMemArena pmaInstance) {
        this.m_pmaStepperArena = pmaInstance;
    }

    DxWorldProcessContext() {
    }

    public void DESTRUCTOR() {
        if (this.m_pmaIslandsArena != null) {
            DxWorldProcessMemArena.FreeMemArena(this.m_pmaIslandsArena);
        }
        if (this.m_pmaStepperArena != null) {
            DxWorldProcessMemArena.FreeMemArena(this.m_pmaStepperArena);
        }
    }

    boolean IsStructureValid() {
        return !(this.m_pmaIslandsArena != null && !this.m_pmaIslandsArena.IsStructureValid() || this.m_pmaStepperArena != null && !this.m_pmaStepperArena.IsStructureValid());
    }

    void CleanupContext() {
        if (this.m_pmaIslandsArena != null) {
            this.m_pmaIslandsArena.ResetState();
        }
        if (this.m_pmaStepperArena != null) {
            this.m_pmaStepperArena.ResetState();
        }
    }

    DxWorldProcessMemArena ReallocateIslandsMemArena(int nMemoryRequirement, DxWorldProcessMemoryManager pmmMemortManager, double fReserveFactor, int uiReserveMinimum) {
        DxWorldProcessMemArena pmaExistingArena = this.GetIslandsMemArena();
        DxWorldProcessMemArena pmaNewMemArena = DxWorldProcessMemArena.ReallocateMemArena(pmaExistingArena, nMemoryRequirement, pmmMemortManager, fReserveFactor, uiReserveMinimum);
        this.SetIslandsMemArena(pmaNewMemArena);
        return pmaNewMemArena;
    }

    DxWorldProcessMemArena ReallocateStepperMemArena(int nMemoryRequirement, DxWorldProcessMemoryManager pmmMemortManager, double fReserveFactor, int uiReserveMinimum) {
        DxWorldProcessMemArena pmaExistingArena = this.GetStepperMemArena();
        DxWorldProcessMemArena pmaNewMemArena = DxWorldProcessMemArena.ReallocateMemArena(pmaExistingArena, nMemoryRequirement, pmmMemortManager, fReserveFactor, uiReserveMinimum);
        this.SetStepperMemArena(pmaNewMemArena);
        return pmaNewMemArena;
    }

    public static boolean dxReallocateWorldProcessContext(DxWorld world, DxWorldProcessIslandsInfo islandsinfo, double stepsize, DxWorldProcessIslandsInfo.dmemestimate_fn_t stepperestimate) {
        DxStepWorkingMemory wmem;
        if (world.wmem == null) {
            world.wmem = new DxStepWorkingMemory();
        }
        if ((wmem = world.wmem) == null) {
            return false;
        }
        DxWorldProcessContext context = wmem.SureGetWorldProcessingContext();
        if (context == null) {
            return false;
        }
        Common.dIASSERT(context.IsStructureValid());
        DxWorldProcessMemoryReserveInfo reserveinfo = wmem.SureGetMemoryReserveInfo();
        DxWorldProcessMemoryManager memmgr = wmem.SureGetMemoryManager();
        int islandsreq = world.EstimateIslandsProcessingMemoryRequirements();
        Common.dIASSERT(islandsreq == DxUtil.dEFFICIENT_SIZE(islandsreq));
        DxWorldProcessMemArena stepperarena = null;
        DxWorldProcessMemArena islandsarena = context.ReallocateIslandsMemArena(islandsreq, memmgr, 1.0, reserveinfo.m_uiReserveMinimum);
        if (islandsarena != null) {
            int stepperreq = DxWorldProcessIslandsInfo.BuildIslandsAndEstimateStepperMemoryRequirements(islandsinfo, islandsarena, world, stepsize, stepperestimate);
            Common.dIASSERT(stepperreq == DxUtil.dEFFICIENT_SIZE(stepperreq));
            stepperarena = context.ReallocateStepperMemArena(stepperreq, memmgr, reserveinfo.m_fReserveFactor, reserveinfo.m_uiReserveMinimum);
        }
        return stepperarena != null;
    }

    public static void dxCleanupWorldProcessContext(DxWorld world) {
        DxWorldProcessContext context;
        DxStepWorkingMemory wmem = world.wmem;
        if (wmem != null && (context = wmem.GetWorldProcessingContext()) != null) {
            context.CleanupContext();
            Common.dIASSERT(context.IsStructureValid());
        }
    }
}

