/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal.libccd;

import org.ode4j.math.DVector3C;

public class CCDVec3 {
    public static final double M_PI = Math.PI;
    public static final double CCD_EPS = 2.220446049250313E-16;
    public static final double CCD_REAL_MAX = Double.MAX_VALUE;
    public static final double CCD_ONE = 1.0;
    public static final double CCD_ZERO = 0.0;
    static ccd_vec3_t ccd_vec3_origin = CCDVec3.CCD_VEC3(0.0, 0.0, 0.0);
    static ccd_vec3_t[] points_on_sphere = new ccd_vec3_t[]{CCDVec3.CCD_VEC3_STATIC(0.0, -0.0, -1.0), CCDVec3.CCD_VEC3_STATIC(0.723608, -0.525725, -0.447219), CCDVec3.CCD_VEC3_STATIC(-0.276388, -0.850649, -0.447219), CCDVec3.CCD_VEC3_STATIC(-0.894426, -0.0, -0.447216), CCDVec3.CCD_VEC3_STATIC(-0.276388, 0.850649, -0.44722), CCDVec3.CCD_VEC3_STATIC(0.723608, 0.525725, -0.447219), CCDVec3.CCD_VEC3_STATIC(0.276388, -0.850649, 0.44722), CCDVec3.CCD_VEC3_STATIC(-0.723608, -0.525725, 0.447219), CCDVec3.CCD_VEC3_STATIC(-0.723608, 0.525725, 0.447219), CCDVec3.CCD_VEC3_STATIC(0.276388, 0.850649, 0.447219), CCDVec3.CCD_VEC3_STATIC(0.894426, 0.0, 0.447216), CCDVec3.CCD_VEC3_STATIC(-0.0, 0.0, 1.0), CCDVec3.CCD_VEC3_STATIC(0.425323, -0.309011, -0.850654), CCDVec3.CCD_VEC3_STATIC(-0.162456, -0.499995, -0.850654), CCDVec3.CCD_VEC3_STATIC(0.262869, -0.809012, -0.525738), CCDVec3.CCD_VEC3_STATIC(0.425323, 0.309011, -0.850654), CCDVec3.CCD_VEC3_STATIC(0.850648, -0.0, -0.525736), CCDVec3.CCD_VEC3_STATIC(-0.52573, -0.0, -0.850652), CCDVec3.CCD_VEC3_STATIC(-0.68819, -0.499997, -0.525736), CCDVec3.CCD_VEC3_STATIC(-0.162456, 0.499995, -0.850654), CCDVec3.CCD_VEC3_STATIC(-0.68819, 0.499997, -0.525736), CCDVec3.CCD_VEC3_STATIC(0.262869, 0.809012, -0.525738), CCDVec3.CCD_VEC3_STATIC(0.951058, 0.309013, 0.0), CCDVec3.CCD_VEC3_STATIC(0.951058, -0.309013, 0.0), CCDVec3.CCD_VEC3_STATIC(0.587786, -0.809017, 0.0), CCDVec3.CCD_VEC3_STATIC(0.0, -1.0, 0.0), CCDVec3.CCD_VEC3_STATIC(-0.587786, -0.809017, 0.0), CCDVec3.CCD_VEC3_STATIC(-0.951058, -0.309013, -0.0), CCDVec3.CCD_VEC3_STATIC(-0.951058, 0.309013, -0.0), CCDVec3.CCD_VEC3_STATIC(-0.587786, 0.809017, -0.0), CCDVec3.CCD_VEC3_STATIC(-0.0, 1.0, -0.0), CCDVec3.CCD_VEC3_STATIC(0.587786, 0.809017, -0.0), CCDVec3.CCD_VEC3_STATIC(0.68819, -0.499997, 0.525736), CCDVec3.CCD_VEC3_STATIC(-0.262869, -0.809012, 0.525738), CCDVec3.CCD_VEC3_STATIC(-0.850648, 0.0, 0.525736), CCDVec3.CCD_VEC3_STATIC(-0.262869, 0.809012, 0.525738), CCDVec3.CCD_VEC3_STATIC(0.68819, 0.499997, 0.525736), CCDVec3.CCD_VEC3_STATIC(0.52573, 0.0, 0.850652), CCDVec3.CCD_VEC3_STATIC(0.162456, -0.499995, 0.850654), CCDVec3.CCD_VEC3_STATIC(-0.425323, -0.309011, 0.850654), CCDVec3.CCD_VEC3_STATIC(-0.425323, 0.309011, 0.850654), CCDVec3.CCD_VEC3_STATIC(0.162456, 0.499995, 0.850654)};
    static final ccd_vec3_t[] ccd_points_on_sphere = points_on_sphere;
    static final int ccd_points_on_sphere_len = points_on_sphere.length;

    public static final double CCD_SQRT(double x) {
        return Math.sqrt(x);
    }

    private static final double CCD_FABS(double x) {
        return Math.abs(x);
    }

    static final double CCD_FMIN(double x, double y) {
        return x < y ? x : y;
    }

    private static final ccd_vec3_t CCD_VEC3_STATIC(double x, double y, double z) {
        return new ccd_vec3_t(x, y, z);
    }

    private static final ccd_vec3_t CCD_VEC3(double x, double y, double z) {
        return new ccd_vec3_t(x, y, z);
    }

    public static final int ccdSign(double val) {
        if (CCDVec3.ccdIsZero(val)) {
            return 0;
        }
        if (val < 0.0) {
            return -1;
        }
        return 1;
    }

    public static final boolean ccdIsZero(double val) {
        return CCDVec3.CCD_FABS(val) < 2.220446049250313E-16;
    }

    public static final boolean ccdEq(double _a, double _b) {
        double ab = CCDVec3.CCD_FABS(_a - _b);
        if (CCDVec3.CCD_FABS(ab) < 2.220446049250313E-16) {
            return true;
        }
        double a = CCDVec3.CCD_FABS(_a);
        double b = CCDVec3.CCD_FABS(_b);
        if (b > a) {
            return ab < 2.220446049250313E-16 * b;
        }
        return ab < 2.220446049250313E-16 * a;
    }

    public static final double ccdVec3X(ccd_vec3_t v) {
        return v.v0;
    }

    public static final double ccdVec3Y(ccd_vec3_t v) {
        return v.v1;
    }

    public static final double ccdVec3Z(ccd_vec3_t v) {
        return v.v2;
    }

    public static final boolean ccdVec3Eq(ccd_vec3_t a, ccd_vec3_t b) {
        return CCDVec3.ccdEq(CCDVec3.ccdVec3X(a), CCDVec3.ccdVec3X(b)) && CCDVec3.ccdEq(CCDVec3.ccdVec3Y(a), CCDVec3.ccdVec3Y(b)) && CCDVec3.ccdEq(CCDVec3.ccdVec3Z(a), CCDVec3.ccdVec3Z(b));
    }

    public static final double ccdVec3Len2(ccd_vec3_t v) {
        return CCDVec3.ccdVec3Dot(v, v);
    }

    public static final double ccdVec3Dist2(ccd_vec3_t a, ccd_vec3_t b) {
        ccd_vec3_t ab = new ccd_vec3_t();
        CCDVec3.ccdVec3Sub2(ab, a, b);
        return CCDVec3.ccdVec3Len2(ab);
    }

    public static final void ccdVec3Set(ccd_vec3_t v, double x, double y, double z) {
        v.v0 = x;
        v.v1 = y;
        v.v2 = z;
    }

    public static final void ccdVec3Set(ccd_vec3_t v, DVector3C xyz) {
        v.v0 = xyz.get0();
        v.v1 = xyz.get1();
        v.v2 = xyz.get2();
    }

    public static final void ccdVec3Copy(ccd_vec3_t v, ccd_vec3_t w) {
        v.v0 = w.v0;
        v.v1 = w.v1;
        v.v2 = w.v2;
    }

    static final void ccdVec3Sub(ccd_vec3_t v, ccd_vec3_t w) {
        v.v0 -= w.v0;
        v.v1 -= w.v1;
        v.v2 -= w.v2;
    }

    static final void ccdVec3Sub2(ccd_vec3_t d, ccd_vec3_t v, ccd_vec3_t w) {
        d.v0 = v.v0 - w.v0;
        d.v1 = v.v1 - w.v1;
        d.v2 = v.v2 - w.v2;
    }

    public static final void ccdVec3Add(ccd_vec3_t v, ccd_vec3_t w) {
        v.v0 += w.v0;
        v.v1 += w.v1;
        v.v2 += w.v2;
    }

    public static final void ccdVec3Scale(ccd_vec3_t d, double k) {
        d.v0 *= k;
        d.v1 *= k;
        d.v2 *= k;
    }

    static final void ccdVec3Normalize(ccd_vec3_t d) {
        double k = 1.0 / CCDVec3.CCD_SQRT(CCDVec3.ccdVec3Len2(d));
        CCDVec3.ccdVec3Scale(d, k);
    }

    public static final double ccdVec3Dot(ccd_vec3_t a, ccd_vec3_t b) {
        double dot = a.v0 * b.v0;
        dot += a.v1 * b.v1;
        return dot += a.v2 * b.v2;
    }

    static final void ccdVec3Cross(ccd_vec3_t d, ccd_vec3_t a, ccd_vec3_t b) {
        d.v0 = a.v1 * b.v2 - a.v2 * b.v1;
        d.v1 = a.v2 * b.v0 - a.v0 * b.v2;
        d.v2 = a.v0 * b.v1 - a.v1 * b.v0;
    }

    static final double __ccdVec3PointSegmentDist2(ccd_vec3_t P, ccd_vec3_t x0, ccd_vec3_t b, ccd_vec3_t witness) {
        double dist;
        ccd_vec3_t d = new ccd_vec3_t();
        ccd_vec3_t a = new ccd_vec3_t();
        CCDVec3.ccdVec3Sub2(d, b, x0);
        CCDVec3.ccdVec3Sub2(a, x0, P);
        double t = -1.0 * CCDVec3.ccdVec3Dot(a, d);
        if ((t /= CCDVec3.ccdVec3Len2(d)) < 0.0 || CCDVec3.ccdIsZero(t)) {
            dist = CCDVec3.ccdVec3Dist2(x0, P);
            if (witness != null) {
                CCDVec3.ccdVec3Copy(witness, x0);
            }
        } else if (t > 1.0 || CCDVec3.ccdEq(t, 1.0)) {
            dist = CCDVec3.ccdVec3Dist2(b, P);
            if (witness != null) {
                CCDVec3.ccdVec3Copy(witness, b);
            }
        } else if (witness != null) {
            CCDVec3.ccdVec3Copy(witness, d);
            CCDVec3.ccdVec3Scale(witness, t);
            CCDVec3.ccdVec3Add(witness, x0);
            dist = CCDVec3.ccdVec3Dist2(witness, P);
        } else {
            CCDVec3.ccdVec3Scale(d, t);
            CCDVec3.ccdVec3Add(d, a);
            dist = CCDVec3.ccdVec3Len2(d);
        }
        return dist;
    }

    public static double ccdVec3PointSegmentDist2(ccd_vec3_t P, ccd_vec3_t x0, ccd_vec3_t b, ccd_vec3_t witness) {
        return CCDVec3.__ccdVec3PointSegmentDist2(P, x0, b, witness);
    }

    public static double ccdVec3PointTriDist2(ccd_vec3_t P, ccd_vec3_t x0, ccd_vec3_t B, ccd_vec3_t C, ccd_vec3_t witness) {
        double dist;
        ccd_vec3_t d1 = new ccd_vec3_t();
        ccd_vec3_t d2 = new ccd_vec3_t();
        ccd_vec3_t a = new ccd_vec3_t();
        ccd_vec3_t witness2 = new ccd_vec3_t();
        CCDVec3.ccdVec3Sub2(d1, B, x0);
        CCDVec3.ccdVec3Sub2(d2, C, x0);
        CCDVec3.ccdVec3Sub2(a, x0, P);
        double u = CCDVec3.ccdVec3Dot(a, a);
        double v = CCDVec3.ccdVec3Dot(d1, d1);
        double w = CCDVec3.ccdVec3Dot(d2, d2);
        double p = CCDVec3.ccdVec3Dot(a, d1);
        double q = CCDVec3.ccdVec3Dot(a, d2);
        double r = CCDVec3.ccdVec3Dot(d1, d2);
        double s = (q * r - w * p) / (w * v - r * r);
        double t = (-s * r - q) / w;
        if ((CCDVec3.ccdIsZero(s) || s > 0.0) && (CCDVec3.ccdEq(s, 1.0) || s < 1.0) && (CCDVec3.ccdIsZero(t) || t > 0.0) && (CCDVec3.ccdEq(t, 1.0) || t < 1.0) && (CCDVec3.ccdEq(t + s, 1.0) || t + s < 1.0)) {
            if (witness != null) {
                CCDVec3.ccdVec3Scale(d1, s);
                CCDVec3.ccdVec3Scale(d2, t);
                CCDVec3.ccdVec3Copy(witness, x0);
                CCDVec3.ccdVec3Add(witness, d1);
                CCDVec3.ccdVec3Add(witness, d2);
                dist = CCDVec3.ccdVec3Dist2(witness, P);
            } else {
                dist = s * s * v;
                dist += t * t * w;
                dist += 2.0 * s * t * r;
                dist += 2.0 * s * p;
                dist += 2.0 * t * q;
                dist += u;
            }
        } else {
            dist = CCDVec3.__ccdVec3PointSegmentDist2(P, x0, B, witness);
            double dist2 = CCDVec3.__ccdVec3PointSegmentDist2(P, x0, C, witness2);
            if (dist2 < dist) {
                dist = dist2;
                if (witness != null) {
                    CCDVec3.ccdVec3Copy(witness, witness2);
                }
            }
            if ((dist2 = CCDVec3.__ccdVec3PointSegmentDist2(P, B, C, witness2)) < dist) {
                dist = dist2;
                if (witness != null) {
                    CCDVec3.ccdVec3Copy(witness, witness2);
                }
            }
        }
        return dist;
    }

    public static class ccd_vec3_t {
        double v0;
        double v1;
        double v2;

        public ccd_vec3_t(double x, double y, double z) {
            this.v0 = x;
            this.v1 = y;
            this.v2 = z;
        }

        public ccd_vec3_t() {
        }

        public void set(double x, double y, double z) {
            this.v0 = x;
            this.v1 = y;
            this.v2 = z;
        }

        public double get0() {
            return this.v0;
        }

        public double get1() {
            return this.v1;
        }

        public double get2() {
            return this.v2;
        }

        public void add(int pos, double d) {
            switch (pos) {
                case 0: {
                    this.v0 += d;
                    break;
                }
                case 1: {
                    this.v1 += d;
                    break;
                }
                case 2: {
                    this.v2 += d;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
    }
}

