/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal.libccd;

import org.ode4j.ode.internal.libccd.CCDVec3;

public class CCDQuat {
    static final double ccdQuatLen2(ccd_quat_t q) {
        double len = q.q0 * q.q0;
        len += q.q1 * q.q1;
        len += q.q2 * q.q2;
        return len += q.q3 * q.q3;
    }

    static final double ccdQuatLen(ccd_quat_t q) {
        return CCDVec3.CCD_SQRT(CCDQuat.ccdQuatLen2(q));
    }

    public static final void ccdQuatSet(ccd_quat_t q, double x, double y, double z, double w) {
        q.q0 = x;
        q.q1 = y;
        q.q2 = z;
        q.q3 = w;
    }

    static final void ccdQuatCopy(ccd_quat_t dest, ccd_quat_t src) {
        dest.q0 = src.q0;
        dest.q1 = src.q1;
        dest.q2 = src.q2;
        dest.q3 = src.q3;
    }

    static final int ccdQuatNormalize(ccd_quat_t q) {
        double len = CCDQuat.ccdQuatLen(q);
        if (len < 2.220446049250313E-16) {
            return 0;
        }
        CCDQuat.ccdQuatScale(q, 1.0 / len);
        return 1;
    }

    public static final void ccdQuatSetAngleAxis(ccd_quat_t q, double angle, CCDVec3.ccd_vec3_t axis) {
        double z;
        double y;
        double a = angle / 2.0;
        double x = CCDVec3.ccdVec3X(axis);
        double n = CCDVec3.CCD_SQRT(x * x + (y = CCDVec3.ccdVec3Y(axis)) * y + (z = CCDVec3.ccdVec3Z(axis)) * z);
        if (n < 2.220446049250313E-16) {
            q.q2 = 0.0;
            q.q1 = 0.0;
            q.q0 = 0.0;
            q.q3 = 1.0;
        } else {
            double s = Math.sin(a) / n;
            q.q3 = Math.cos(a);
            q.q0 = x * s;
            q.q1 = y * s;
            q.q2 = z * s;
            CCDQuat.ccdQuatNormalize(q);
        }
    }

    static final void ccdQuatScale(ccd_quat_t q, double k) {
        q.q0 *= k;
        q.q1 *= k;
        q.q2 *= k;
        q.q3 *= k;
    }

    public static final void ccdQuatMul(ccd_quat_t q, ccd_quat_t q2) {
        ccd_quat_t a = new ccd_quat_t();
        CCDQuat.ccdQuatCopy(a, q);
        CCDQuat.ccdQuatMul2(q, a, q2);
    }

    static final void ccdQuatMul2(ccd_quat_t q, ccd_quat_t a, ccd_quat_t b) {
        q.q0 = a.q3 * b.q0 + a.q0 * b.q3 + a.q1 * b.q2 - a.q2 * b.q1;
        q.q1 = a.q3 * b.q1 + a.q1 * b.q3 - a.q0 * b.q2 + a.q2 * b.q0;
        q.q2 = a.q3 * b.q2 + a.q2 * b.q3 + a.q0 * b.q1 - a.q1 * b.q0;
        q.q3 = a.q3 * b.q3 - a.q0 * b.q0 - a.q1 * b.q1 - a.q2 * b.q2;
    }

    static final int ccdQuatInvert(ccd_quat_t q) {
        double len2 = CCDQuat.ccdQuatLen2(q);
        if (len2 < 2.220446049250313E-16) {
            return -1;
        }
        len2 = 1.0 / len2;
        q.q0 = -q.q0 * len2;
        q.q1 = -q.q1 * len2;
        q.q2 = -q.q2 * len2;
        q.q3 *= len2;
        return 0;
    }

    public static final int ccdQuatInvert2(ccd_quat_t dest, ccd_quat_t src) {
        CCDQuat.ccdQuatCopy(dest, src);
        return CCDQuat.ccdQuatInvert(dest);
    }

    public static final void ccdQuatRotVec(CCDVec3.ccd_vec3_t v, ccd_quat_t q) {
        double w = q.q3;
        double x = q.q0;
        double y = q.q1;
        double z = q.q2;
        double ww = w * w;
        double xx = x * x;
        double yy = y * y;
        double zz = z * z;
        double wx = w * x;
        double wy = w * y;
        double wz = w * z;
        double xy = x * y;
        double xz = x * z;
        double yz = y * z;
        double vx = ww * CCDVec3.ccdVec3X(v) + xx * CCDVec3.ccdVec3X(v) - yy * CCDVec3.ccdVec3X(v) - zz * CCDVec3.ccdVec3X(v) + 2.0 * ((xy - wz) * CCDVec3.ccdVec3Y(v) + (xz + wy) * CCDVec3.ccdVec3Z(v));
        double vy = ww * CCDVec3.ccdVec3Y(v) - xx * CCDVec3.ccdVec3Y(v) + yy * CCDVec3.ccdVec3Y(v) - zz * CCDVec3.ccdVec3Y(v) + 2.0 * ((xy + wz) * CCDVec3.ccdVec3X(v) + (yz - wx) * CCDVec3.ccdVec3Z(v));
        double vz = ww * CCDVec3.ccdVec3Z(v) - xx * CCDVec3.ccdVec3Z(v) - yy * CCDVec3.ccdVec3Z(v) + zz * CCDVec3.ccdVec3Z(v) + 2.0 * ((xz - wy) * CCDVec3.ccdVec3X(v) + (yz + wx) * CCDVec3.ccdVec3Y(v));
        CCDVec3.ccdVec3Set(v, vx, vy, vz);
    }

    public static class ccd_quat_t {
        double q0;
        double q1;
        double q2;
        double q3;

        public void set(double x, double y, double z, double w) {
            this.q0 = x;
            this.q1 = y;
            this.q2 = z;
            this.q3 = w;
        }

        public Object get0() {
            return this.q0;
        }

        public Object get1() {
            return this.q1;
        }

        public Object get2() {
            return this.q2;
        }

        public Object get3() {
            return this.q3;
        }
    }
}

