/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal.libccd;

import org.cpp4j.Cstdio;
import org.cpp4j.FILE;
import org.ode4j.ode.internal.libccd.CCDList;
import org.ode4j.ode.internal.libccd.CCDSupport;
import org.ode4j.ode.internal.libccd.CCDVec3;

public class CCDPolyTope {
    public static final int CCD_PT_VERTEX = 1;
    public static final int CCD_PT_EDGE = 2;
    public static final int CCD_PT_FACE = 3;

    public static final ccd_pt_vertex_t ccdPtAddVertexCoords(ccd_pt_t pt, double x, double y, double z) {
        CCDSupport.ccd_support_t s = new CCDSupport.ccd_support_t();
        CCDVec3.ccdVec3Set(s.v, x, y, z);
        return CCDPolyTope.ccdPtAddVertex(pt, s);
    }

    public static final int ccdPtDelVertex(ccd_pt_t pt, ccd_pt_vertex_t v) {
        if (!CCDList.ccdListEmpty(v.edges)) {
            return -1;
        }
        CCDList.ccdListDel(v.list);
        if (pt.nearest == v) {
            pt.nearest = null;
        }
        return 0;
    }

    public static final int ccdPtDelEdge(ccd_pt_t pt, ccd_pt_edge_t e) {
        if (e.faces0 != null) {
            return -1;
        }
        CCDList.ccdListDel(e.vertex_list0);
        CCDList.ccdListDel(e.vertex_list1);
        CCDList.ccdListDel(e.list);
        if (pt.nearest == e) {
            pt.nearest = null;
        }
        return 0;
    }

    public static final int ccdPtDelFace(ccd_pt_t pt, ccd_pt_face_t f) {
        int i = 0;
        while (i < 3) {
            ccd_pt_edge_t e = f.edge(i);
            if (e.faces0 == f) {
                e.faces0 = e.faces1;
            }
            e.faces1 = null;
            ++i;
        }
        CCDList.ccdListDel(f.list);
        if (pt.nearest == f) {
            pt.nearest = null;
        }
        return 0;
    }

    @Deprecated
    static final void ccdPtFaceVec3(ccd_pt_face_t face, CCDVec3.ccd_vec3_t[][] a, CCDVec3.ccd_vec3_t[][] b, CCDVec3.ccd_vec3_t[][] c) {
        throw new UnsupportedOperationException("This should be inlined manually");
    }

    @Deprecated
    static final void ccdPtFaceVertices(ccd_pt_face_t face, ccd_pt_vertex_t[][] a, ccd_pt_vertex_t[][] b, ccd_pt_vertex_t[][] c) {
        throw new UnsupportedOperationException();
    }

    static final void ccdPtFaceEdges(ccd_pt_face_t f, ccd_pt_edge_t[] abc, int pos1, int pos2, int pos3) {
        abc[pos1] = f.edge0;
        abc[pos2] = f.edge1;
        abc[pos3] = f.edge2;
    }

    @Deprecated
    static final void ccdPtEdgeVec3(ccd_pt_edge_t e, CCDVec3.ccd_vec3_t[][] a, CCDVec3.ccd_vec3_t[][] b) {
        throw new UnsupportedOperationException("This should be inlined manually");
    }

    static final void ccdPtEdgeVertices(ccd_pt_edge_t e, ccd_pt_vertex_t[] ab, int a1, int a2) {
        ab[a1] = e.vertex0;
        ab[a2] = e.vertex1;
    }

    static final void ccdPtEdgeFaces(ccd_pt_edge_t e, ccd_pt_face_t[] f12, int pos1, int pos2) {
        f12[pos1] = e.faces0;
        f12[pos2] = e.faces1;
    }

    private static final void _ccdPtNearestUpdate(ccd_pt_t pt, ccd_pt_el_t el) {
        if (CCDVec3.ccdEq(pt.nearest_dist, el.dist)) {
            if (el.type < pt.nearest_type) {
                pt.nearest = el;
                pt.nearest_dist = el.dist;
                pt.nearest_type = el.type;
            }
        } else if (el.dist < pt.nearest_dist) {
            pt.nearest = el;
            pt.nearest_dist = el.dist;
            pt.nearest_type = el.type;
        }
    }

    private static void _ccdPtNearestRenew(ccd_pt_t pt) {
        pt.nearest_dist = Double.MAX_VALUE;
        pt.nearest_type = 3;
        pt.nearest = null;
        for (ccd_pt_el_t ccd_pt_el_t2 : pt.vertices) {
            CCDPolyTope._ccdPtNearestUpdate(pt, ccd_pt_el_t2);
        }
        for (ccd_pt_el_t ccd_pt_el_t3 : pt.edges) {
            CCDPolyTope._ccdPtNearestUpdate(pt, ccd_pt_el_t3);
        }
        for (ccd_pt_el_t ccd_pt_el_t4 : pt.faces) {
            CCDPolyTope._ccdPtNearestUpdate(pt, ccd_pt_el_t4);
        }
    }

    public static final void ccdPtInit(ccd_pt_t pt) {
        pt.nearest = null;
        pt.nearest_dist = Double.MAX_VALUE;
        pt.nearest_type = 3;
    }

    public static final void ccdPtDestroy(ccd_pt_t pt) {
        for (ccd_pt_face_t f : pt.faces) {
            CCDPolyTope.ccdPtDelFace(pt, f);
        }
        for (ccd_pt_edge_t e : pt.edges) {
            CCDPolyTope.ccdPtDelEdge(pt, e);
        }
        for (ccd_pt_vertex_t v : pt.vertices) {
            CCDPolyTope.ccdPtDelVertex(pt, v);
        }
    }

    static final ccd_pt_vertex_t ccdPtAddVertex(ccd_pt_t pt, CCDSupport.ccd_support_t v) {
        ccd_pt_vertex_t vert = new ccd_pt_vertex_t();
        vert.type = 1;
        CCDSupport.ccdSupportCopy(vert.v, v);
        vert.dist = CCDVec3.ccdVec3Len2(vert.v.v);
        CCDVec3.ccdVec3Copy(vert.witness, vert.v.v);
        CCDList.ccdListInit(vert.edges);
        CCDList.ccdListAppend(pt.vertices, vert.list);
        CCDPolyTope._ccdPtNearestUpdate(pt, vert);
        return vert;
    }

    public static final ccd_pt_edge_t ccdPtAddEdge(ccd_pt_t pt, ccd_pt_vertex_t v1, ccd_pt_vertex_t v2) {
        ccd_pt_edge_t edge = new ccd_pt_edge_t();
        edge.type = 2;
        edge.vertex0 = v1;
        edge.vertex1 = v2;
        edge.faces1 = null;
        edge.faces0 = null;
        CCDVec3.ccd_vec3_t a = edge.vertex0.v.v;
        CCDVec3.ccd_vec3_t b = edge.vertex1.v.v;
        edge.dist = CCDVec3.ccdVec3PointSegmentDist2(CCDVec3.ccd_vec3_origin, a, b, edge.witness);
        CCDList.ccdListAppend(edge.vertex0.edges, edge.vertex_list0);
        CCDList.ccdListAppend(edge.vertex1.edges, edge.vertex_list1);
        CCDList.ccdListAppend(pt.edges, edge.list);
        CCDPolyTope._ccdPtNearestUpdate(pt, edge);
        return edge;
    }

    public static final ccd_pt_face_t ccdPtAddFace(ccd_pt_t pt, ccd_pt_edge_t e1, ccd_pt_edge_t e2, ccd_pt_edge_t e3) {
        ccd_pt_face_t face = new ccd_pt_face_t();
        face.type = 3;
        face.edge0 = e1;
        face.edge1 = e2;
        face.edge2 = e3;
        CCDVec3.ccd_vec3_t a = face.edge0.vertex0.v.v;
        CCDVec3.ccd_vec3_t b = face.edge0.vertex1.v.v;
        ccd_pt_edge_t e = face.edge1;
        CCDVec3.ccd_vec3_t c = e.vertex0 != face.edge0.vertex0 && e.vertex0 != face.edge0.vertex1 ? e.vertex0.v.v : e.vertex1.v.v;
        face.dist = CCDVec3.ccdVec3PointTriDist2(CCDVec3.ccd_vec3_origin, a, b, c, face.witness);
        int i = 0;
        while (i < 3) {
            ccd_pt_edge_t edge = face.edge(i);
            if (edge.faces0 == null) {
                edge.faces0 = face;
            } else {
                edge.faces1 = face;
            }
            ++i;
        }
        CCDList.ccdListAppend(pt.faces, face.list);
        CCDPolyTope._ccdPtNearestUpdate(pt, face);
        return face;
    }

    private static final void ccdPtRecomputeDistances(ccd_pt_t pt) {
        CCDVec3.ccd_vec3_t b;
        CCDVec3.ccd_vec3_t a;
        double dist;
        for (ccd_pt_vertex_t v : pt.vertices) {
            v.dist = dist = CCDVec3.ccdVec3Len2(v.v.v);
            CCDVec3.ccdVec3Copy(v.witness, v.v.v);
        }
        for (ccd_pt_edge_t e : pt.edges) {
            a = e.vertex0.v.v;
            b = e.vertex1.v.v;
            e.dist = dist = CCDVec3.ccdVec3PointSegmentDist2(CCDVec3.ccd_vec3_origin, a, b, e.witness);
        }
        for (ccd_pt_face_t f : pt.faces) {
            a = f.edge0.vertex0.v.v;
            b = f.edge0.vertex1.v.v;
            ccd_pt_edge_t e = f.edge1;
            CCDVec3.ccd_vec3_t c = e.vertex0 != f.edge0.vertex0 && e.vertex0 != f.edge0.vertex1 ? e.vertex0.v.v : e.vertex1.v.v;
            f.dist = dist = CCDVec3.ccdVec3PointTriDist2(CCDVec3.ccd_vec3_origin, a, b, c, f.witness);
        }
    }

    public static final ccd_pt_el_t ccdPtNearest(ccd_pt_t pt) {
        if (pt.nearest == null) {
            CCDPolyTope._ccdPtNearestRenew(pt);
        }
        return pt.nearest;
    }

    private static final void ccdPtDumpSVT(ccd_pt_t pt, String fn) {
        FILE fout = Cstdio.fopen(fn, "a");
        if (fout == null) {
            return;
        }
        CCDPolyTope.ccdPtDumpSVT2(pt, fout);
        Cstdio.fclose(fout);
    }

    private static final void ccdPtDumpSVT2(ccd_pt_t pt, FILE fout) {
        Cstdio.fprintf(fout, "-----\n", new Object[0]);
        Cstdio.fprintf(fout, "Points:\n", new Object[0]);
        int i = 0;
        for (ccd_pt_vertex_t v : pt.vertices) {
            v.id = i++;
            Cstdio.fprintf(fout, "%lf %lf %lf\n", CCDVec3.ccdVec3X(v.v.v), CCDVec3.ccdVec3Y(v.v.v), CCDVec3.ccdVec3Z(v.v.v));
        }
        Cstdio.fprintf(fout, "Edges:\n", new Object[0]);
        for (ccd_pt_edge_t e : pt.edges) {
            Cstdio.fprintf(fout, "%d %d\n", e.vertex0.id, e.vertex1.id);
        }
        Cstdio.fprintf(fout, "Faces:\n", new Object[0]);
        for (ccd_pt_face_t f : pt.faces) {
            ccd_pt_vertex_t a = f.edge0.vertex0;
            ccd_pt_vertex_t b = f.edge0.vertex1;
            ccd_pt_vertex_t c = f.edge1.vertex0;
            if (c == a || c == b) {
                c = f.edge1.vertex1;
            }
            Cstdio.fprintf(fout, "%d %d %d\n", a.id, b.id, c.id);
        }
    }

    public static final class ccd_pt_edge_t
    extends ccd_pt_el_t {
        ccd_pt_vertex_t vertex0;
        ccd_pt_face_t faces0;
        ccd_pt_vertex_t vertex1;
        ccd_pt_face_t faces1;
        final CCDList.ccd_list_t<ccd_pt_vertex_t> vertex_list0 = new CCDList.ccd_list_t<Object>(null);
        final CCDList.ccd_list_t<ccd_pt_vertex_t> vertex_list1 = new CCDList.ccd_list_t<Object>(null);
    }

    public static class ccd_pt_el_t {
        int type;
        double dist;
        final CCDVec3.ccd_vec3_t witness = new CCDVec3.ccd_vec3_t();
        final CCDList.ccd_list_t list = new CCDList.ccd_list_t<ccd_pt_el_t>(this);

        public double dist() {
            return this.dist;
        }

        public int type() {
            return this.type;
        }

        public CCDVec3.ccd_vec3_t witness() {
            return this.witness;
        }
    }

    public static final class ccd_pt_face_t
    extends ccd_pt_el_t {
        ccd_pt_edge_t edge0;
        ccd_pt_edge_t edge1;
        ccd_pt_edge_t edge2;

        ccd_pt_edge_t edge(int pos) {
            switch (pos) {
                case 0: {
                    return this.edge0;
                }
                case 1: {
                    return this.edge1;
                }
                case 2: {
                    return this.edge2;
                }
            }
            throw new IllegalArgumentException();
        }
    }

    public static final class ccd_pt_t {
        CCDList.ccd_list_t<ccd_pt_vertex_t> vertices = new CCDList.ccd_list_t<Object>(null);
        CCDList.ccd_list_t<ccd_pt_edge_t> edges = new CCDList.ccd_list_t<Object>(null);
        CCDList.ccd_list_t<ccd_pt_face_t> faces = new CCDList.ccd_list_t<Object>(null);
        ccd_pt_el_t nearest;
        double nearest_dist;
        int nearest_type;
    }

    public static final class ccd_pt_vertex_t
    extends ccd_pt_el_t
    implements Comparable<ccd_pt_vertex_t> {
        int id;
        final CCDSupport.ccd_support_t v = new CCDSupport.ccd_support_t();
        CCDList.ccd_list_t<ccd_pt_vertex_t> edges = new CCDList.ccd_list_t<Object>(null);

        public CCDSupport.ccd_support_t v() {
            return this.v;
        }

        @Override
        public int compareTo(ccd_pt_vertex_t o) {
            ccd_pt_vertex_t v1 = this;
            ccd_pt_vertex_t v2 = o;
            if (CCDVec3.ccdEq(v1.dist, v2.dist)) {
                return 0;
            }
            if (v1.dist < v2.dist) {
                return -1;
            }
            return 1;
        }
    }
}

