/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal.libccd;

import org.cpp4j.java.RefDouble;
import org.ode4j.ode.internal.libccd.CCD;
import org.ode4j.ode.internal.libccd.CCDSimplex;
import org.ode4j.ode.internal.libccd.CCDSupport;
import org.ode4j.ode.internal.libccd.CCDVec3;

public class CCDMPR {
    public static int ccdMPRIntersect(Object obj1, Object obj2, CCD.ccd_t ccd) {
        CCDSimplex.ccd_simplex_t portal = new CCDSimplex.ccd_simplex_t();
        int res = CCDMPR.discoverPortal(obj1, obj2, ccd, portal);
        if (res < 0) {
            return 0;
        }
        if (res > 0) {
            return 1;
        }
        res = CCDMPR.refinePortal(obj1, obj2, ccd, portal);
        return res == 0 ? 1 : 0;
    }

    public static int ccdMPRPenetration(Object obj1, Object obj2, CCD.ccd_t ccd, RefDouble depth, CCDVec3.ccd_vec3_t dir, CCDVec3.ccd_vec3_t pos) {
        CCDSimplex.ccd_simplex_t portal = new CCDSimplex.ccd_simplex_t();
        int res = CCDMPR.discoverPortal(obj1, obj2, ccd, portal);
        if (res < 0) {
            return -1;
        }
        if (res == 1) {
            CCDMPR.findPenetrTouch(obj1, obj2, ccd, portal, depth, dir, pos);
        } else if (res == 2) {
            CCDMPR.findPenetrSegment(obj1, obj2, ccd, portal, depth, dir, pos);
        } else if (res == 0) {
            res = CCDMPR.refinePortal(obj1, obj2, ccd, portal);
            if (res < 0) {
                return -1;
            }
            CCDMPR.findPenetr(obj1, obj2, ccd, portal, depth, dir, pos);
        }
        return 0;
    }

    private static final void findOrigin(Object obj1, Object obj2, CCD.ccd_t ccd, CCDSupport.ccd_support_t center) {
        ccd.center1.run(obj1, center.v1);
        ccd.center2.run(obj2, center.v2);
        CCDVec3.ccdVec3Sub2(center.v, center.v1, center.v2);
    }

    private static int discoverPortal(Object obj1, Object obj2, CCD.ccd_t ccd, CCDSimplex.ccd_simplex_t portal) {
        CCDVec3.ccd_vec3_t dir = new CCDVec3.ccd_vec3_t();
        CCDVec3.ccd_vec3_t va = new CCDVec3.ccd_vec3_t();
        CCDVec3.ccd_vec3_t vb = new CCDVec3.ccd_vec3_t();
        CCDMPR.findOrigin(obj1, obj2, ccd, CCDSimplex.ccdSimplexPointW0(portal));
        CCDSimplex.ccdSimplexSetSize(portal, 1);
        if (CCDVec3.ccdVec3Eq(CCDSimplex.ccdSimplexPoint0((CCDSimplex.ccd_simplex_t)portal).v, CCDVec3.ccd_vec3_origin)) {
            CCDVec3.ccdVec3Set(va, 2.220446049250313E-15, 0.0, 0.0);
            CCDVec3.ccdVec3Add(CCDSimplex.ccdSimplexPointW0((CCDSimplex.ccd_simplex_t)portal).v, va);
        }
        CCDVec3.ccdVec3Copy(dir, CCDSimplex.ccdSimplexPoint0((CCDSimplex.ccd_simplex_t)portal).v);
        CCDVec3.ccdVec3Scale(dir, -1.0);
        CCDVec3.ccdVec3Normalize(dir);
        CCDSupport.__ccdSupport(obj1, obj2, dir, ccd, CCDSimplex.ccdSimplexPointW1(portal));
        CCDSimplex.ccdSimplexSetSize(portal, 2);
        double dot = CCDVec3.ccdVec3Dot(CCDSimplex.ccdSimplexPoint1((CCDSimplex.ccd_simplex_t)portal).v, dir);
        if (CCDVec3.ccdIsZero(dot) || dot < 0.0) {
            return -1;
        }
        CCDVec3.ccdVec3Cross(dir, CCDSimplex.ccdSimplexPoint0((CCDSimplex.ccd_simplex_t)portal).v, CCDSimplex.ccdSimplexPoint1((CCDSimplex.ccd_simplex_t)portal).v);
        if (CCDVec3.ccdIsZero(CCDVec3.ccdVec3Len2(dir))) {
            if (CCDVec3.ccdVec3Eq(CCDSimplex.ccdSimplexPoint1((CCDSimplex.ccd_simplex_t)portal).v, CCDVec3.ccd_vec3_origin)) {
                return 1;
            }
            return 2;
        }
        CCDVec3.ccdVec3Normalize(dir);
        CCDSupport.__ccdSupport(obj1, obj2, dir, ccd, CCDSimplex.ccdSimplexPointW2(portal));
        dot = CCDVec3.ccdVec3Dot(CCDSimplex.ccdSimplexPoint2((CCDSimplex.ccd_simplex_t)portal).v, dir);
        if (CCDVec3.ccdIsZero(dot) || dot < 0.0) {
            return -1;
        }
        CCDSimplex.ccdSimplexSetSize(portal, 3);
        CCDVec3.ccdVec3Sub2(va, CCDSimplex.ccdSimplexPoint1((CCDSimplex.ccd_simplex_t)portal).v, CCDSimplex.ccdSimplexPoint0((CCDSimplex.ccd_simplex_t)portal).v);
        CCDVec3.ccdVec3Sub2(vb, CCDSimplex.ccdSimplexPoint2((CCDSimplex.ccd_simplex_t)portal).v, CCDSimplex.ccdSimplexPoint0((CCDSimplex.ccd_simplex_t)portal).v);
        CCDVec3.ccdVec3Cross(dir, va, vb);
        CCDVec3.ccdVec3Normalize(dir);
        dot = CCDVec3.ccdVec3Dot(dir, CCDSimplex.ccdSimplexPoint0((CCDSimplex.ccd_simplex_t)portal).v);
        if (dot > 0.0) {
            CCDSimplex.ccdSimplexSwap12(portal);
            CCDVec3.ccdVec3Scale(dir, -1.0);
        }
        while (CCDSimplex.ccdSimplexSize(portal) < 4) {
            CCDSupport.__ccdSupport(obj1, obj2, dir, ccd, CCDSimplex.ccdSimplexPointW3(portal));
            dot = CCDVec3.ccdVec3Dot(CCDSimplex.ccdSimplexPoint3((CCDSimplex.ccd_simplex_t)portal).v, dir);
            if (CCDVec3.ccdIsZero(dot) || dot < 0.0) {
                return -1;
            }
            boolean cont = false;
            CCDVec3.ccdVec3Cross(va, CCDSimplex.ccdSimplexPoint1((CCDSimplex.ccd_simplex_t)portal).v, CCDSimplex.ccdSimplexPoint3((CCDSimplex.ccd_simplex_t)portal).v);
            dot = CCDVec3.ccdVec3Dot(va, CCDSimplex.ccdSimplexPoint0((CCDSimplex.ccd_simplex_t)portal).v);
            if (dot < 0.0 && !CCDVec3.ccdIsZero(dot)) {
                CCDSimplex.ccdSimplexSet2(portal, CCDSimplex.ccdSimplexPoint3(portal));
                cont = true;
            }
            if (!cont) {
                CCDVec3.ccdVec3Cross(va, CCDSimplex.ccdSimplexPoint3((CCDSimplex.ccd_simplex_t)portal).v, CCDSimplex.ccdSimplexPoint2((CCDSimplex.ccd_simplex_t)portal).v);
                dot = CCDVec3.ccdVec3Dot(va, CCDSimplex.ccdSimplexPoint0((CCDSimplex.ccd_simplex_t)portal).v);
                if (dot < 0.0 && !CCDVec3.ccdIsZero(dot)) {
                    CCDSimplex.ccdSimplexSet1(portal, CCDSimplex.ccdSimplexPoint3(portal));
                    cont = true;
                }
            }
            if (cont) {
                CCDVec3.ccdVec3Sub2(va, CCDSimplex.ccdSimplexPoint1((CCDSimplex.ccd_simplex_t)portal).v, CCDSimplex.ccdSimplexPoint0((CCDSimplex.ccd_simplex_t)portal).v);
                CCDVec3.ccdVec3Sub2(vb, CCDSimplex.ccdSimplexPoint2((CCDSimplex.ccd_simplex_t)portal).v, CCDSimplex.ccdSimplexPoint0((CCDSimplex.ccd_simplex_t)portal).v);
                CCDVec3.ccdVec3Cross(dir, va, vb);
                CCDVec3.ccdVec3Normalize(dir);
                continue;
            }
            CCDSimplex.ccdSimplexSetSize(portal, 4);
        }
        return 0;
    }

    private static int refinePortal(Object obj1, Object obj2, CCD.ccd_t ccd, CCDSimplex.ccd_simplex_t portal) {
        CCDVec3.ccd_vec3_t dir = new CCDVec3.ccd_vec3_t();
        CCDSupport.ccd_support_t v4 = new CCDSupport.ccd_support_t();
        while (true) {
            CCDMPR.portalDir(portal, dir);
            if (CCDMPR.portalEncapsulesOrigin(portal, dir)) {
                return 0;
            }
            CCDSupport.__ccdSupport(obj1, obj2, dir, ccd, v4);
            if (!CCDMPR.portalCanEncapsuleOrigin(portal, v4, dir) || CCDMPR.portalReachTolerance(portal, v4, dir, ccd)) {
                return -1;
            }
            CCDMPR.expandPortal(portal, v4);
        }
    }

    private static void findPenetr(Object obj1, Object obj2, CCD.ccd_t ccd, CCDSimplex.ccd_simplex_t portal, RefDouble depth, CCDVec3.ccd_vec3_t pdir, CCDVec3.ccd_vec3_t pos) {
        CCDVec3.ccd_vec3_t dir = new CCDVec3.ccd_vec3_t();
        CCDSupport.ccd_support_t v4 = new CCDSupport.ccd_support_t();
        long iterations = 0L;
        while (true) {
            CCDMPR.portalDir(portal, dir);
            CCDSupport.__ccdSupport(obj1, obj2, dir, ccd, v4);
            if (CCDMPR.portalReachTolerance(portal, v4, dir, ccd) || iterations > ccd.max_iterations) {
                depth.set(CCDVec3.ccdVec3PointTriDist2(CCDVec3.ccd_vec3_origin, CCDSimplex.ccdSimplexPoint1((CCDSimplex.ccd_simplex_t)portal).v, CCDSimplex.ccdSimplexPoint2((CCDSimplex.ccd_simplex_t)portal).v, CCDSimplex.ccdSimplexPoint3((CCDSimplex.ccd_simplex_t)portal).v, pdir));
                depth.set(CCDVec3.CCD_SQRT(depth.get()));
                CCDVec3.ccdVec3Normalize(pdir);
                CCDMPR.findPos(obj1, obj2, ccd, portal, pos);
                return;
            }
            CCDMPR.expandPortal(portal, v4);
            ++iterations;
        }
    }

    private static void findPenetrTouch(Object obj1, Object obj2, CCD.ccd_t ccd, CCDSimplex.ccd_simplex_t portal, RefDouble depth, CCDVec3.ccd_vec3_t dir, CCDVec3.ccd_vec3_t pos) {
        depth.set(0.0);
        CCDVec3.ccdVec3Copy(dir, CCDVec3.ccd_vec3_origin);
        CCDVec3.ccdVec3Copy(pos, CCDSimplex.ccdSimplexPoint1((CCDSimplex.ccd_simplex_t)portal).v1);
        CCDVec3.ccdVec3Add(pos, CCDSimplex.ccdSimplexPoint1((CCDSimplex.ccd_simplex_t)portal).v2);
        CCDVec3.ccdVec3Scale(pos, 0.5);
    }

    private static void findPenetrSegment(Object obj1, Object obj2, CCD.ccd_t ccd, CCDSimplex.ccd_simplex_t portal, RefDouble depth, CCDVec3.ccd_vec3_t dir, CCDVec3.ccd_vec3_t pos) {
        CCDVec3.ccdVec3Copy(pos, CCDSimplex.ccdSimplexPoint1((CCDSimplex.ccd_simplex_t)portal).v1);
        CCDVec3.ccdVec3Add(pos, CCDSimplex.ccdSimplexPoint1((CCDSimplex.ccd_simplex_t)portal).v2);
        CCDVec3.ccdVec3Scale(pos, 0.5);
        CCDVec3.ccdVec3Copy(dir, CCDSimplex.ccdSimplexPoint1((CCDSimplex.ccd_simplex_t)portal).v);
        depth.set(CCDVec3.CCD_SQRT(CCDVec3.ccdVec3Len2(dir)));
        CCDVec3.ccdVec3Normalize(dir);
    }

    private static void findPos(Object obj1, Object obj2, CCD.ccd_t ccd, CCDSimplex.ccd_simplex_t portal, CCDVec3.ccd_vec3_t pos) {
        CCDVec3.ccd_vec3_t dir = new CCDVec3.ccd_vec3_t();
        CCDVec3.ccd_vec3_t vec = new CCDVec3.ccd_vec3_t();
        CCDVec3.ccd_vec3_t p1 = new CCDVec3.ccd_vec3_t();
        CCDVec3.ccd_vec3_t p2 = new CCDVec3.ccd_vec3_t();
        CCDMPR.portalDir(portal, dir);
        CCDVec3.ccdVec3Cross(vec, CCDSimplex.ccdSimplexPoint1((CCDSimplex.ccd_simplex_t)portal).v, CCDSimplex.ccdSimplexPoint2((CCDSimplex.ccd_simplex_t)portal).v);
        double b0 = CCDVec3.ccdVec3Dot(vec, CCDSimplex.ccdSimplexPoint3((CCDSimplex.ccd_simplex_t)portal).v);
        CCDVec3.ccdVec3Cross(vec, CCDSimplex.ccdSimplexPoint3((CCDSimplex.ccd_simplex_t)portal).v, CCDSimplex.ccdSimplexPoint2((CCDSimplex.ccd_simplex_t)portal).v);
        double b1 = CCDVec3.ccdVec3Dot(vec, CCDSimplex.ccdSimplexPoint0((CCDSimplex.ccd_simplex_t)portal).v);
        CCDVec3.ccdVec3Cross(vec, CCDSimplex.ccdSimplexPoint0((CCDSimplex.ccd_simplex_t)portal).v, CCDSimplex.ccdSimplexPoint1((CCDSimplex.ccd_simplex_t)portal).v);
        double b2 = CCDVec3.ccdVec3Dot(vec, CCDSimplex.ccdSimplexPoint3((CCDSimplex.ccd_simplex_t)portal).v);
        CCDVec3.ccdVec3Cross(vec, CCDSimplex.ccdSimplexPoint2((CCDSimplex.ccd_simplex_t)portal).v, CCDSimplex.ccdSimplexPoint1((CCDSimplex.ccd_simplex_t)portal).v);
        double b3 = CCDVec3.ccdVec3Dot(vec, CCDSimplex.ccdSimplexPoint0((CCDSimplex.ccd_simplex_t)portal).v);
        double sum = b0 + b1 + b2 + b3;
        if (CCDVec3.ccdIsZero(sum) || sum < 0.0) {
            b0 = 0.0;
            CCDVec3.ccdVec3Cross(vec, CCDSimplex.ccdSimplexPoint2((CCDSimplex.ccd_simplex_t)portal).v, CCDSimplex.ccdSimplexPoint3((CCDSimplex.ccd_simplex_t)portal).v);
            b1 = CCDVec3.ccdVec3Dot(vec, dir);
            CCDVec3.ccdVec3Cross(vec, CCDSimplex.ccdSimplexPoint3((CCDSimplex.ccd_simplex_t)portal).v, CCDSimplex.ccdSimplexPoint1((CCDSimplex.ccd_simplex_t)portal).v);
            b2 = CCDVec3.ccdVec3Dot(vec, dir);
            CCDVec3.ccdVec3Cross(vec, CCDSimplex.ccdSimplexPoint1((CCDSimplex.ccd_simplex_t)portal).v, CCDSimplex.ccdSimplexPoint2((CCDSimplex.ccd_simplex_t)portal).v);
            b3 = CCDVec3.ccdVec3Dot(vec, dir);
            sum = b1 + b2 + b3;
        }
        double inv = 1.0 / sum;
        CCDVec3.ccdVec3Copy(p1, CCDVec3.ccd_vec3_origin);
        CCDVec3.ccdVec3Copy(p2, CCDVec3.ccd_vec3_origin);
        CCDVec3.ccdVec3Copy(vec, CCDSimplex.ccdSimplexPoint0((CCDSimplex.ccd_simplex_t)portal).v1);
        CCDVec3.ccdVec3Scale(vec, b0);
        CCDVec3.ccdVec3Add(p1, vec);
        CCDVec3.ccdVec3Copy(vec, CCDSimplex.ccdSimplexPoint0((CCDSimplex.ccd_simplex_t)portal).v2);
        CCDVec3.ccdVec3Scale(vec, b0);
        CCDVec3.ccdVec3Add(p2, vec);
        CCDVec3.ccdVec3Copy(vec, CCDSimplex.ccdSimplexPoint1((CCDSimplex.ccd_simplex_t)portal).v1);
        CCDVec3.ccdVec3Scale(vec, b1);
        CCDVec3.ccdVec3Add(p1, vec);
        CCDVec3.ccdVec3Copy(vec, CCDSimplex.ccdSimplexPoint1((CCDSimplex.ccd_simplex_t)portal).v2);
        CCDVec3.ccdVec3Scale(vec, b1);
        CCDVec3.ccdVec3Add(p2, vec);
        CCDVec3.ccdVec3Copy(vec, CCDSimplex.ccdSimplexPoint2((CCDSimplex.ccd_simplex_t)portal).v1);
        CCDVec3.ccdVec3Scale(vec, b2);
        CCDVec3.ccdVec3Add(p1, vec);
        CCDVec3.ccdVec3Copy(vec, CCDSimplex.ccdSimplexPoint2((CCDSimplex.ccd_simplex_t)portal).v2);
        CCDVec3.ccdVec3Scale(vec, b2);
        CCDVec3.ccdVec3Add(p2, vec);
        CCDVec3.ccdVec3Copy(vec, CCDSimplex.ccdSimplexPoint3((CCDSimplex.ccd_simplex_t)portal).v1);
        CCDVec3.ccdVec3Scale(vec, b3);
        CCDVec3.ccdVec3Add(p1, vec);
        CCDVec3.ccdVec3Copy(vec, CCDSimplex.ccdSimplexPoint3((CCDSimplex.ccd_simplex_t)portal).v2);
        CCDVec3.ccdVec3Scale(vec, b3);
        CCDVec3.ccdVec3Add(p2, vec);
        CCDVec3.ccdVec3Scale(p1, inv);
        CCDVec3.ccdVec3Scale(p2, inv);
        CCDVec3.ccdVec3Copy(pos, p1);
        CCDVec3.ccdVec3Add(pos, p2);
        CCDVec3.ccdVec3Scale(pos, 0.5);
    }

    private static final void expandPortal(CCDSimplex.ccd_simplex_t portal, CCDSupport.ccd_support_t v4) {
        CCDVec3.ccd_vec3_t v4v0 = new CCDVec3.ccd_vec3_t();
        CCDVec3.ccdVec3Cross(v4v0, v4.v, CCDSimplex.ccdSimplexPoint0((CCDSimplex.ccd_simplex_t)portal).v);
        double dot = CCDVec3.ccdVec3Dot(CCDSimplex.ccdSimplexPoint1((CCDSimplex.ccd_simplex_t)portal).v, v4v0);
        if (dot > 0.0) {
            dot = CCDVec3.ccdVec3Dot(CCDSimplex.ccdSimplexPoint2((CCDSimplex.ccd_simplex_t)portal).v, v4v0);
            if (dot > 0.0) {
                CCDSimplex.ccdSimplexSet1(portal, v4);
            } else {
                CCDSimplex.ccdSimplexSet3(portal, v4);
            }
        } else {
            dot = CCDVec3.ccdVec3Dot(CCDSimplex.ccdSimplexPoint3((CCDSimplex.ccd_simplex_t)portal).v, v4v0);
            if (dot > 0.0) {
                CCDSimplex.ccdSimplexSet2(portal, v4);
            } else {
                CCDSimplex.ccdSimplexSet1(portal, v4);
            }
        }
    }

    private static final void portalDir(CCDSimplex.ccd_simplex_t portal, CCDVec3.ccd_vec3_t dir) {
        CCDVec3.ccd_vec3_t v2v1 = new CCDVec3.ccd_vec3_t();
        CCDVec3.ccd_vec3_t v3v1 = new CCDVec3.ccd_vec3_t();
        CCDVec3.ccdVec3Sub2(v2v1, CCDSimplex.ccdSimplexPoint2((CCDSimplex.ccd_simplex_t)portal).v, CCDSimplex.ccdSimplexPoint1((CCDSimplex.ccd_simplex_t)portal).v);
        CCDVec3.ccdVec3Sub2(v3v1, CCDSimplex.ccdSimplexPoint3((CCDSimplex.ccd_simplex_t)portal).v, CCDSimplex.ccdSimplexPoint1((CCDSimplex.ccd_simplex_t)portal).v);
        CCDVec3.ccdVec3Cross(dir, v2v1, v3v1);
        CCDVec3.ccdVec3Normalize(dir);
    }

    private static final boolean portalEncapsulesOrigin(CCDSimplex.ccd_simplex_t portal, CCDVec3.ccd_vec3_t dir) {
        double dot = CCDVec3.ccdVec3Dot(dir, CCDSimplex.ccdSimplexPoint1((CCDSimplex.ccd_simplex_t)portal).v);
        return CCDVec3.ccdIsZero(dot) || dot > 0.0;
    }

    private static final boolean portalReachTolerance(CCDSimplex.ccd_simplex_t portal, CCDSupport.ccd_support_t v4, CCDVec3.ccd_vec3_t dir, CCD.ccd_t ccd) {
        double dv1 = CCDVec3.ccdVec3Dot(CCDSimplex.ccdSimplexPoint1((CCDSimplex.ccd_simplex_t)portal).v, dir);
        double dv2 = CCDVec3.ccdVec3Dot(CCDSimplex.ccdSimplexPoint2((CCDSimplex.ccd_simplex_t)portal).v, dir);
        double dv3 = CCDVec3.ccdVec3Dot(CCDSimplex.ccdSimplexPoint3((CCDSimplex.ccd_simplex_t)portal).v, dir);
        double dv4 = CCDVec3.ccdVec3Dot(v4.v, dir);
        double dot1 = dv4 - dv1;
        double dot2 = dv4 - dv2;
        double dot3 = dv4 - dv3;
        dot1 = CCDVec3.CCD_FMIN(dot1, dot2);
        return CCDVec3.ccdEq(dot1 = CCDVec3.CCD_FMIN(dot1, dot3), ccd.mpr_tolerance) || dot1 < ccd.mpr_tolerance;
    }

    private static final boolean portalCanEncapsuleOrigin(CCDSimplex.ccd_simplex_t portal, CCDSupport.ccd_support_t v4, CCDVec3.ccd_vec3_t dir) {
        double dot = CCDVec3.ccdVec3Dot(v4.v, dir);
        return CCDVec3.ccdIsZero(dot) || dot > 0.0;
    }
}

