/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal.libccd;

import java.util.Arrays;
import org.cpp4j.java.Ref;
import org.cpp4j.java.RefDouble;
import org.ode4j.ode.internal.libccd.CCDPolyTope;
import org.ode4j.ode.internal.libccd.CCDSimplex;
import org.ode4j.ode.internal.libccd.CCDSupport;
import org.ode4j.ode.internal.libccd.CCDVec3;

public class CCD {
    public static final void CCD_INIT(ccd_t ccd) {
        ccd.first_dir = new ccd_first_dir_fn(){

            @Override
            public void run(Object obj1, Object obj2, CCDVec3.ccd_vec3_t dir) {
                CCD.ccdFirstDirDefault(obj1, obj2, dir);
            }
        };
        ccd.support1 = null;
        ccd.support2 = null;
        ccd.center1 = null;
        ccd.center2 = null;
        ccd.max_iterations = Long.MAX_VALUE;
        ccd.epa_tolerance = 1.0E-4;
        ccd.mpr_tolerance = 1.0E-4;
    }

    static void ccdFirstDirDefault(Object o1, Object o2, CCDVec3.ccd_vec3_t dir) {
        CCDVec3.ccdVec3Set(dir, 1.0, 0.0, 0.0);
    }

    public static boolean ccdGJKIntersect(Object obj1, Object obj2, ccd_t ccd) {
        CCDSimplex.ccd_simplex_t simplex = new CCDSimplex.ccd_simplex_t();
        return CCD.__ccdGJK(obj1, obj2, ccd, simplex) == 0;
    }

    public static int ccdGJKSeparate(Object obj1, Object obj2, ccd_t ccd, CCDVec3.ccd_vec3_t sep) {
        CCDPolyTope.ccd_pt_t polytope = new CCDPolyTope.ccd_pt_t();
        Ref<CCDPolyTope.ccd_pt_el_t> nearestRef = new Ref<CCDPolyTope.ccd_pt_el_t>();
        CCDPolyTope.ccdPtInit(polytope);
        int ret = CCD.__ccdGJKEPA(obj1, obj2, ccd, polytope, nearestRef);
        if (nearestRef.get() != null) {
            CCDVec3.ccdVec3Copy(sep, nearestRef.get().witness);
        }
        CCDPolyTope.ccdPtDestroy(polytope);
        return ret;
    }

    static int penEPAPosCmp(CCDPolyTope.ccd_pt_vertex_t a, CCDPolyTope.ccd_pt_vertex_t b) {
        CCDPolyTope.ccd_pt_vertex_t v1 = a;
        CCDPolyTope.ccd_pt_vertex_t v2 = b;
        if (CCDVec3.ccdEq(v1.dist, v2.dist)) {
            return 0;
        }
        if (v1.dist < v2.dist) {
            return -1;
        }
        return 1;
    }

    static void penEPAPos(CCDPolyTope.ccd_pt_t pt, CCDPolyTope.ccd_pt_el_t nearest, CCDVec3.ccd_vec3_t pos) {
        int len = 0;
        for (CCDPolyTope.ccd_pt_vertex_t v : pt.vertices) {
            ++len;
        }
        Object[] vs = new CCDPolyTope.ccd_pt_vertex_t[len];
        int i = 0;
        for (CCDPolyTope.ccd_pt_vertex_t v : pt.vertices) {
            vs[i++] = v;
        }
        Arrays.sort(vs);
        CCDVec3.ccdVec3Set(pos, 0.0, 0.0, 0.0);
        double scale = 0.0;
        if (len % 2 == 1) {
            ++len;
        }
        i = 0;
        while (i < len / 2) {
            CCDVec3.ccdVec3Add(pos, ((CCDPolyTope.ccd_pt_vertex_t)vs[i]).v.v1);
            CCDVec3.ccdVec3Add(pos, ((CCDPolyTope.ccd_pt_vertex_t)vs[i]).v.v2);
            scale += 2.0;
            ++i;
        }
        CCDVec3.ccdVec3Scale(pos, 1.0 / scale);
    }

    public static int ccdGJKPenetration(Object obj1, Object obj2, ccd_t ccd, RefDouble depth, CCDVec3.ccd_vec3_t dir, CCDVec3.ccd_vec3_t pos) {
        CCDPolyTope.ccd_pt_t polytope = new CCDPolyTope.ccd_pt_t();
        Ref<CCDPolyTope.ccd_pt_el_t> nearestRef = new Ref<CCDPolyTope.ccd_pt_el_t>();
        CCDPolyTope.ccdPtInit(polytope);
        int ret = CCD.__ccdGJKEPA(obj1, obj2, ccd, polytope, nearestRef);
        if (ret == 0 && nearestRef.get() != null) {
            depth.set(CCDVec3.CCD_SQRT(nearestRef.get().dist));
            CCDVec3.ccdVec3Copy(dir, nearestRef.get().witness);
            CCDVec3.ccdVec3Normalize(dir);
            CCD.penEPAPos(polytope, nearestRef.get(), pos);
        }
        CCDPolyTope.ccdPtDestroy(polytope);
        return ret;
    }

    private static int __ccdGJK(Object obj1, Object obj2, ccd_t ccd, CCDSimplex.ccd_simplex_t simplex) {
        CCDVec3.ccd_vec3_t dir = new CCDVec3.ccd_vec3_t();
        CCDSupport.ccd_support_t last = new CCDSupport.ccd_support_t();
        CCDSimplex.ccdSimplexInit(simplex);
        ccd.first_dir.run(obj1, obj2, dir);
        CCDSupport.__ccdSupport(obj1, obj2, dir, ccd, last);
        CCDSimplex.ccdSimplexAdd(simplex, last);
        CCDVec3.ccdVec3Copy(dir, last.v);
        CCDVec3.ccdVec3Scale(dir, -1.0);
        long iterations = 0L;
        while (iterations < ccd.max_iterations) {
            CCDSupport.__ccdSupport(obj1, obj2, dir, ccd, last);
            if (CCDVec3.ccdVec3Dot(last.v, dir) < 0.0) {
                return -1;
            }
            CCDSimplex.ccdSimplexAdd(simplex, last);
            int do_simplex_res = CCD.doSimplex(simplex, dir);
            if (do_simplex_res == 1) {
                return 0;
            }
            if (do_simplex_res == -1) {
                return -1;
            }
            if (CCDVec3.ccdIsZero(CCDVec3.ccdVec3Len2(dir))) {
                return -1;
            }
            ++iterations;
        }
        return -1;
    }

    private static int __ccdGJKEPA(Object obj1, Object obj2, ccd_t ccd, CCDPolyTope.ccd_pt_t polytope, Ref<CCDPolyTope.ccd_pt_el_t> nearest) {
        CCDSimplex.ccd_simplex_t simplex = new CCDSimplex.ccd_simplex_t();
        CCDSupport.ccd_support_t supp = new CCDSupport.ccd_support_t();
        nearest.set(null);
        int ret = CCD.__ccdGJK(obj1, obj2, ccd, simplex);
        if (ret != 0) {
            return -1;
        }
        int size = CCDSimplex.ccdSimplexSize(simplex);
        if (size == 4 ? CCD.simplexToPolytope4(obj1, obj2, ccd, simplex, polytope, nearest) != 0 : (size == 3 ? CCD.simplexToPolytope3(obj1, obj2, ccd, simplex, polytope, nearest) != 0 : CCD.simplexToPolytope2(obj1, obj2, ccd, simplex, polytope, nearest) != 0)) {
            return 0;
        }
        while (true) {
            nearest.set(CCDPolyTope.ccdPtNearest(polytope));
            if (CCD.nextSupport(obj1, obj2, ccd, nearest.get(), supp) != 0) break;
            CCD.expandPolytope(polytope, nearest.get(), supp);
        }
        return 0;
    }

    private static int doSimplex2(CCDSimplex.ccd_simplex_t simplex, CCDVec3.ccd_vec3_t dir) {
        CCDVec3.ccd_vec3_t AB = new CCDVec3.ccd_vec3_t();
        CCDVec3.ccd_vec3_t AO = new CCDVec3.ccd_vec3_t();
        CCDVec3.ccd_vec3_t tmp = new CCDVec3.ccd_vec3_t();
        CCDSupport.ccd_support_t A = CCDSimplex.ccdSimplexLast(simplex);
        CCDSupport.ccd_support_t B = CCDSimplex.ccdSimplexPoint0(simplex);
        CCDVec3.ccdVec3Sub2(AB, B.v, A.v);
        CCDVec3.ccdVec3Copy(AO, A.v);
        CCDVec3.ccdVec3Scale(AO, -1.0);
        double dot = CCDVec3.ccdVec3Dot(AB, AO);
        CCDVec3.ccdVec3Cross(tmp, AB, AO);
        if (CCDVec3.ccdIsZero(CCDVec3.ccdVec3Len2(tmp)) && dot > 0.0) {
            return 1;
        }
        if (CCDVec3.ccdIsZero(dot) || dot < 0.0) {
            CCDSimplex.ccdSimplexSet0(simplex, A);
            CCDSimplex.ccdSimplexSetSize(simplex, 1);
            CCDVec3.ccdVec3Copy(dir, AO);
        } else {
            CCD.tripleCross(AB, AO, AB, dir);
        }
        return 0;
    }

    private static int doSimplex3(CCDSimplex.ccd_simplex_t simplex, CCDVec3.ccd_vec3_t dir) {
        CCDVec3.ccd_vec3_t AO = new CCDVec3.ccd_vec3_t();
        CCDVec3.ccd_vec3_t AB = new CCDVec3.ccd_vec3_t();
        CCDVec3.ccd_vec3_t AC = new CCDVec3.ccd_vec3_t();
        CCDVec3.ccd_vec3_t ABC = new CCDVec3.ccd_vec3_t();
        CCDVec3.ccd_vec3_t tmp = new CCDVec3.ccd_vec3_t();
        CCDSupport.ccd_support_t A = CCDSimplex.ccdSimplexLast(simplex);
        CCDSupport.ccd_support_t B = CCDSimplex.ccdSimplexPoint1(simplex);
        CCDSupport.ccd_support_t C = CCDSimplex.ccdSimplexPoint0(simplex);
        double dist = CCDVec3.ccdVec3PointTriDist2(CCDVec3.ccd_vec3_origin, A.v, B.v, C.v, null);
        if (CCDVec3.ccdIsZero(dist)) {
            return 1;
        }
        if (CCDVec3.ccdVec3Eq(A.v, B.v) || CCDVec3.ccdVec3Eq(A.v, C.v)) {
            return -1;
        }
        CCDVec3.ccdVec3Copy(AO, A.v);
        CCDVec3.ccdVec3Scale(AO, -1.0);
        CCDVec3.ccdVec3Sub2(AB, B.v, A.v);
        CCDVec3.ccdVec3Sub2(AC, C.v, A.v);
        CCDVec3.ccdVec3Cross(ABC, AB, AC);
        CCDVec3.ccdVec3Cross(tmp, ABC, AC);
        double dot = CCDVec3.ccdVec3Dot(tmp, AO);
        if (CCDVec3.ccdIsZero(dot) || dot > 0.0) {
            dot = CCDVec3.ccdVec3Dot(AC, AO);
            if (CCDVec3.ccdIsZero(dot) || dot > 0.0) {
                CCDSimplex.ccdSimplexSet1(simplex, A);
                CCDSimplex.ccdSimplexSetSize(simplex, 2);
                CCD.tripleCross(AC, AO, AC, dir);
            } else {
                dot = CCDVec3.ccdVec3Dot(AB, AO);
                if (CCDVec3.ccdIsZero(dot) || dot > 0.0) {
                    CCDSimplex.ccdSimplexSet0(simplex, B);
                    CCDSimplex.ccdSimplexSet1(simplex, A);
                    CCDSimplex.ccdSimplexSetSize(simplex, 2);
                    CCD.tripleCross(AB, AO, AB, dir);
                } else {
                    CCDSimplex.ccdSimplexSet0(simplex, A);
                    CCDSimplex.ccdSimplexSetSize(simplex, 1);
                    CCDVec3.ccdVec3Copy(dir, AO);
                }
            }
        } else {
            CCDVec3.ccdVec3Cross(tmp, AB, ABC);
            dot = CCDVec3.ccdVec3Dot(tmp, AO);
            if (CCDVec3.ccdIsZero(dot) || dot > 0.0) {
                dot = CCDVec3.ccdVec3Dot(AB, AO);
                if (CCDVec3.ccdIsZero(dot) || dot > 0.0) {
                    CCDSimplex.ccdSimplexSet0(simplex, B);
                    CCDSimplex.ccdSimplexSet1(simplex, A);
                    CCDSimplex.ccdSimplexSetSize(simplex, 2);
                    CCD.tripleCross(AB, AO, AB, dir);
                } else {
                    CCDSimplex.ccdSimplexSet0(simplex, A);
                    CCDSimplex.ccdSimplexSetSize(simplex, 1);
                    CCDVec3.ccdVec3Copy(dir, AO);
                }
            } else {
                dot = CCDVec3.ccdVec3Dot(ABC, AO);
                if (CCDVec3.ccdIsZero(dot) || dot > 0.0) {
                    CCDVec3.ccdVec3Copy(dir, ABC);
                } else {
                    CCDSupport.ccd_support_t Ctmp = new CCDSupport.ccd_support_t();
                    CCDSupport.ccdSupportCopy(Ctmp, C);
                    CCDSimplex.ccdSimplexSet0(simplex, B);
                    CCDSimplex.ccdSimplexSet1(simplex, Ctmp);
                    CCDVec3.ccdVec3Copy(dir, ABC);
                    CCDVec3.ccdVec3Scale(dir, -1.0);
                }
            }
        }
        return 0;
    }

    private static int doSimplex4(CCDSimplex.ccd_simplex_t simplex, CCDVec3.ccd_vec3_t dir) {
        boolean AD_O;
        CCDVec3.ccd_vec3_t AO = new CCDVec3.ccd_vec3_t();
        CCDVec3.ccd_vec3_t AB = new CCDVec3.ccd_vec3_t();
        CCDVec3.ccd_vec3_t AC = new CCDVec3.ccd_vec3_t();
        CCDVec3.ccd_vec3_t AD = new CCDVec3.ccd_vec3_t();
        CCDVec3.ccd_vec3_t ABC = new CCDVec3.ccd_vec3_t();
        CCDVec3.ccd_vec3_t ACD = new CCDVec3.ccd_vec3_t();
        CCDVec3.ccd_vec3_t ADB = new CCDVec3.ccd_vec3_t();
        CCDSupport.ccd_support_t A = CCDSimplex.ccdSimplexLast(simplex);
        CCDSupport.ccd_support_t B = CCDSimplex.ccdSimplexPoint2(simplex);
        CCDSupport.ccd_support_t C = CCDSimplex.ccdSimplexPoint1(simplex);
        CCDSupport.ccd_support_t D = CCDSimplex.ccdSimplexPoint0(simplex);
        double dist = CCDVec3.ccdVec3PointTriDist2(A.v, B.v, C.v, D.v, null);
        if (CCDVec3.ccdIsZero(dist)) {
            return -1;
        }
        dist = CCDVec3.ccdVec3PointTriDist2(CCDVec3.ccd_vec3_origin, A.v, B.v, C.v, null);
        if (CCDVec3.ccdIsZero(dist)) {
            return 1;
        }
        dist = CCDVec3.ccdVec3PointTriDist2(CCDVec3.ccd_vec3_origin, A.v, C.v, D.v, null);
        if (CCDVec3.ccdIsZero(dist)) {
            return 1;
        }
        dist = CCDVec3.ccdVec3PointTriDist2(CCDVec3.ccd_vec3_origin, A.v, B.v, D.v, null);
        if (CCDVec3.ccdIsZero(dist)) {
            return 1;
        }
        dist = CCDVec3.ccdVec3PointTriDist2(CCDVec3.ccd_vec3_origin, B.v, C.v, D.v, null);
        if (CCDVec3.ccdIsZero(dist)) {
            return 1;
        }
        CCDVec3.ccdVec3Copy(AO, A.v);
        CCDVec3.ccdVec3Scale(AO, -1.0);
        CCDVec3.ccdVec3Sub2(AB, B.v, A.v);
        CCDVec3.ccdVec3Sub2(AC, C.v, A.v);
        CCDVec3.ccdVec3Sub2(AD, D.v, A.v);
        CCDVec3.ccdVec3Cross(ABC, AB, AC);
        CCDVec3.ccdVec3Cross(ACD, AC, AD);
        CCDVec3.ccdVec3Cross(ADB, AD, AB);
        int B_on_ACD = CCDVec3.ccdSign(CCDVec3.ccdVec3Dot(ACD, AB));
        int C_on_ADB = CCDVec3.ccdSign(CCDVec3.ccdVec3Dot(ADB, AC));
        int D_on_ABC = CCDVec3.ccdSign(CCDVec3.ccdVec3Dot(ABC, AD));
        boolean AB_O = CCDVec3.ccdSign(CCDVec3.ccdVec3Dot(ACD, AO)) == B_on_ACD;
        boolean AC_O = CCDVec3.ccdSign(CCDVec3.ccdVec3Dot(ADB, AO)) == C_on_ADB;
        boolean bl = AD_O = CCDVec3.ccdSign(CCDVec3.ccdVec3Dot(ABC, AO)) == D_on_ABC;
        if (AB_O && AC_O && AD_O) {
            return 1;
        }
        if (!AB_O) {
            CCDSimplex.ccdSimplexSet2(simplex, A);
            CCDSimplex.ccdSimplexSetSize(simplex, 3);
        } else if (!AC_O) {
            CCDSimplex.ccdSimplexSet1(simplex, D);
            CCDSimplex.ccdSimplexSet0(simplex, B);
            CCDSimplex.ccdSimplexSet2(simplex, A);
            CCDSimplex.ccdSimplexSetSize(simplex, 3);
        } else {
            CCDSimplex.ccdSimplexSet0(simplex, C);
            CCDSimplex.ccdSimplexSet1(simplex, B);
            CCDSimplex.ccdSimplexSet2(simplex, A);
            CCDSimplex.ccdSimplexSetSize(simplex, 3);
        }
        return CCD.doSimplex3(simplex, dir);
    }

    private static int doSimplex(CCDSimplex.ccd_simplex_t simplex, CCDVec3.ccd_vec3_t dir) {
        if (CCDSimplex.ccdSimplexSize(simplex) == 2) {
            return CCD.doSimplex2(simplex, dir);
        }
        if (CCDSimplex.ccdSimplexSize(simplex) == 3) {
            return CCD.doSimplex3(simplex, dir);
        }
        return CCD.doSimplex4(simplex, dir);
    }

    private static void tripleCross(CCDVec3.ccd_vec3_t a, CCDVec3.ccd_vec3_t b, CCDVec3.ccd_vec3_t c, CCDVec3.ccd_vec3_t d) {
        CCDVec3.ccd_vec3_t e = new CCDVec3.ccd_vec3_t();
        CCDVec3.ccdVec3Cross(e, a, b);
        CCDVec3.ccdVec3Cross(d, e, c);
    }

    static int simplexToPolytope4(Object obj1, Object obj2, ccd_t ccd, CCDSimplex.ccd_simplex_t simplex, CCDPolyTope.ccd_pt_t pt, Ref<CCDPolyTope.ccd_pt_el_t> nearest) {
        CCDPolyTope.ccd_pt_edge_t[] e = new CCDPolyTope.ccd_pt_edge_t[6];
        CCDSupport.ccd_support_t a = CCDSimplex.ccdSimplexPoint0(simplex);
        CCDSupport.ccd_support_t b = CCDSimplex.ccdSimplexPoint1(simplex);
        CCDSupport.ccd_support_t c = CCDSimplex.ccdSimplexPoint2(simplex);
        CCDSupport.ccd_support_t d = CCDSimplex.ccdSimplexPoint3(simplex);
        boolean use_polytope3 = false;
        double dist = CCDVec3.ccdVec3PointTriDist2(CCDVec3.ccd_vec3_origin, a.v, b.v, c.v, null);
        if (CCDVec3.ccdIsZero(dist)) {
            use_polytope3 = true;
        }
        if (CCDVec3.ccdIsZero(dist = CCDVec3.ccdVec3PointTriDist2(CCDVec3.ccd_vec3_origin, a.v, c.v, d.v, null))) {
            use_polytope3 = true;
            CCDSimplex.ccdSimplexSet1(simplex, c);
            CCDSimplex.ccdSimplexSet2(simplex, d);
        }
        if (CCDVec3.ccdIsZero(dist = CCDVec3.ccdVec3PointTriDist2(CCDVec3.ccd_vec3_origin, a.v, b.v, d.v, null))) {
            use_polytope3 = true;
            CCDSimplex.ccdSimplexSet2(simplex, d);
        }
        if (CCDVec3.ccdIsZero(dist = CCDVec3.ccdVec3PointTriDist2(CCDVec3.ccd_vec3_origin, b.v, c.v, d.v, null))) {
            use_polytope3 = true;
            CCDSimplex.ccdSimplexSet0(simplex, b);
            CCDSimplex.ccdSimplexSet1(simplex, c);
            CCDSimplex.ccdSimplexSet2(simplex, d);
        }
        if (use_polytope3) {
            CCDSimplex.ccdSimplexSetSize(simplex, 3);
            return CCD.simplexToPolytope3(obj1, obj2, ccd, simplex, pt, nearest);
        }
        CCDPolyTope.ccd_pt_vertex_t v0 = CCDPolyTope.ccdPtAddVertex(pt, CCDSimplex.ccdSimplexPoint0(simplex));
        CCDPolyTope.ccd_pt_vertex_t v1 = CCDPolyTope.ccdPtAddVertex(pt, CCDSimplex.ccdSimplexPoint1(simplex));
        CCDPolyTope.ccd_pt_vertex_t v2 = CCDPolyTope.ccdPtAddVertex(pt, CCDSimplex.ccdSimplexPoint2(simplex));
        CCDPolyTope.ccd_pt_vertex_t v3 = CCDPolyTope.ccdPtAddVertex(pt, CCDSimplex.ccdSimplexPoint3(simplex));
        e[0] = CCDPolyTope.ccdPtAddEdge(pt, v0, v1);
        e[1] = CCDPolyTope.ccdPtAddEdge(pt, v1, v2);
        e[2] = CCDPolyTope.ccdPtAddEdge(pt, v2, v0);
        e[3] = CCDPolyTope.ccdPtAddEdge(pt, v3, v0);
        e[4] = CCDPolyTope.ccdPtAddEdge(pt, v3, v1);
        e[5] = CCDPolyTope.ccdPtAddEdge(pt, v3, v2);
        CCDPolyTope.ccdPtAddFace(pt, e[0], e[1], e[2]);
        CCDPolyTope.ccdPtAddFace(pt, e[3], e[4], e[0]);
        CCDPolyTope.ccdPtAddFace(pt, e[4], e[5], e[1]);
        CCDPolyTope.ccdPtAddFace(pt, e[5], e[3], e[2]);
        return 0;
    }

    static int simplexToPolytope3(Object obj1, Object obj2, ccd_t ccd, CCDSimplex.ccd_simplex_t simplex, CCDPolyTope.ccd_pt_t pt, Ref<CCDPolyTope.ccd_pt_el_t> nearest) {
        CCDSupport.ccd_support_t d = new CCDSupport.ccd_support_t();
        CCDSupport.ccd_support_t d2 = new CCDSupport.ccd_support_t();
        CCDVec3.ccd_vec3_t ab = new CCDVec3.ccd_vec3_t();
        CCDVec3.ccd_vec3_t ac = new CCDVec3.ccd_vec3_t();
        CCDVec3.ccd_vec3_t dir = new CCDVec3.ccd_vec3_t();
        CCDPolyTope.ccd_pt_vertex_t[] v = new CCDPolyTope.ccd_pt_vertex_t[5];
        CCDPolyTope.ccd_pt_edge_t[] e = new CCDPolyTope.ccd_pt_edge_t[9];
        nearest.set(null);
        CCDSupport.ccd_support_t a = CCDSimplex.ccdSimplexPoint0(simplex);
        CCDSupport.ccd_support_t b = CCDSimplex.ccdSimplexPoint1(simplex);
        CCDSupport.ccd_support_t c = CCDSimplex.ccdSimplexPoint2(simplex);
        CCDVec3.ccdVec3Sub2(ab, b.v, a.v);
        CCDVec3.ccdVec3Sub2(ac, c.v, a.v);
        CCDVec3.ccdVec3Cross(dir, ab, ac);
        CCDSupport.__ccdSupport(obj1, obj2, dir, ccd, d);
        double dist = CCDVec3.ccdVec3PointTriDist2(d.v, a.v, b.v, c.v, null);
        CCDVec3.ccdVec3Scale(dir, -1.0);
        CCDSupport.__ccdSupport(obj1, obj2, dir, ccd, d2);
        double dist2 = CCDVec3.ccdVec3PointTriDist2(d2.v, a.v, b.v, c.v, null);
        if (CCDVec3.ccdIsZero(dist) || CCDVec3.ccdIsZero(dist2)) {
            v[0] = CCDPolyTope.ccdPtAddVertex(pt, a);
            v[1] = CCDPolyTope.ccdPtAddVertex(pt, b);
            v[2] = CCDPolyTope.ccdPtAddVertex(pt, c);
            e[0] = CCDPolyTope.ccdPtAddEdge(pt, v[0], v[1]);
            e[1] = CCDPolyTope.ccdPtAddEdge(pt, v[1], v[2]);
            e[2] = CCDPolyTope.ccdPtAddEdge(pt, v[2], v[0]);
            nearest.set(CCDPolyTope.ccdPtAddFace(pt, e[0], e[1], e[2]));
            return -1;
        }
        v[0] = CCDPolyTope.ccdPtAddVertex(pt, a);
        v[1] = CCDPolyTope.ccdPtAddVertex(pt, b);
        v[2] = CCDPolyTope.ccdPtAddVertex(pt, c);
        v[3] = CCDPolyTope.ccdPtAddVertex(pt, d);
        v[4] = CCDPolyTope.ccdPtAddVertex(pt, d2);
        e[0] = CCDPolyTope.ccdPtAddEdge(pt, v[0], v[1]);
        e[1] = CCDPolyTope.ccdPtAddEdge(pt, v[1], v[2]);
        e[2] = CCDPolyTope.ccdPtAddEdge(pt, v[2], v[0]);
        e[3] = CCDPolyTope.ccdPtAddEdge(pt, v[3], v[0]);
        e[4] = CCDPolyTope.ccdPtAddEdge(pt, v[3], v[1]);
        e[5] = CCDPolyTope.ccdPtAddEdge(pt, v[3], v[2]);
        e[6] = CCDPolyTope.ccdPtAddEdge(pt, v[4], v[0]);
        e[7] = CCDPolyTope.ccdPtAddEdge(pt, v[4], v[1]);
        e[8] = CCDPolyTope.ccdPtAddEdge(pt, v[4], v[2]);
        CCDPolyTope.ccdPtAddFace(pt, e[3], e[4], e[0]);
        CCDPolyTope.ccdPtAddFace(pt, e[4], e[5], e[1]);
        CCDPolyTope.ccdPtAddFace(pt, e[5], e[3], e[2]);
        CCDPolyTope.ccdPtAddFace(pt, e[6], e[7], e[0]);
        CCDPolyTope.ccdPtAddFace(pt, e[7], e[8], e[1]);
        CCDPolyTope.ccdPtAddFace(pt, e[8], e[6], e[2]);
        return 0;
    }

    static int simplexToPolytope2(Object obj1, Object obj2, ccd_t ccd, CCDSimplex.ccd_simplex_t simplex, CCDPolyTope.ccd_pt_t pt, Ref<CCDPolyTope.ccd_pt_el_t> nearest) {
        CCDVec3.ccd_vec3_t ab = new CCDVec3.ccd_vec3_t();
        CCDVec3.ccd_vec3_t ac = new CCDVec3.ccd_vec3_t();
        CCDVec3.ccd_vec3_t dir = new CCDVec3.ccd_vec3_t();
        CCDSupport.ccd_support_t[] supp = new CCDSupport.ccd_support_t[4];
        int i = 0;
        while (i < supp.length) {
            supp[i] = new CCDSupport.ccd_support_t();
            ++i;
        }
        CCDPolyTope.ccd_pt_vertex_t[] v = new CCDPolyTope.ccd_pt_vertex_t[6];
        CCDPolyTope.ccd_pt_edge_t[] e = new CCDPolyTope.ccd_pt_edge_t[12];
        CCDSupport.ccd_support_t a = CCDSimplex.ccdSimplexPoint0(simplex);
        CCDSupport.ccd_support_t b = CCDSimplex.ccdSimplexPoint1(simplex);
        boolean found = false;
        int i2 = 0;
        while (i2 < CCDVec3.ccd_points_on_sphere_len) {
            CCDSupport.__ccdSupport(obj1, obj2, CCDVec3.ccd_points_on_sphere[i2], ccd, supp[0]);
            if (!CCDVec3.ccdVec3Eq(a.v, supp[0].v) && !CCDVec3.ccdVec3Eq(b.v, supp[0].v)) {
                found = true;
                break;
            }
            ++i2;
        }
        boolean touching_contact = true;
        if (found) {
            CCDVec3.ccdVec3Copy(dir, supp[0].v);
            CCDVec3.ccdVec3Scale(dir, -1.0);
            CCDSupport.__ccdSupport(obj1, obj2, dir, ccd, supp[1]);
            if (!CCDVec3.ccdVec3Eq(a.v, supp[1].v) && !CCDVec3.ccdVec3Eq(b.v, supp[1].v)) {
                CCDVec3.ccdVec3Sub2(ab, supp[0].v, a.v);
                CCDVec3.ccdVec3Sub2(ac, supp[1].v, a.v);
                CCDVec3.ccdVec3Cross(dir, ab, ac);
                CCDSupport.__ccdSupport(obj1, obj2, dir, ccd, supp[2]);
                if (!CCDVec3.ccdVec3Eq(a.v, supp[2].v) && !CCDVec3.ccdVec3Eq(b.v, supp[2].v)) {
                    CCDVec3.ccdVec3Scale(dir, -1.0);
                    CCDSupport.__ccdSupport(obj1, obj2, dir, ccd, supp[3]);
                    if (!CCDVec3.ccdVec3Eq(a.v, supp[3].v) && !CCDVec3.ccdVec3Eq(b.v, supp[3].v)) {
                        touching_contact = false;
                    }
                }
            }
        }
        if (touching_contact) {
            v[0] = CCDPolyTope.ccdPtAddVertex(pt, a);
            v[1] = CCDPolyTope.ccdPtAddVertex(pt, b);
            nearest.set(CCDPolyTope.ccdPtAddEdge(pt, v[0], v[1]));
            return -1;
        }
        v[0] = CCDPolyTope.ccdPtAddVertex(pt, a);
        v[1] = CCDPolyTope.ccdPtAddVertex(pt, supp[0]);
        v[2] = CCDPolyTope.ccdPtAddVertex(pt, b);
        v[3] = CCDPolyTope.ccdPtAddVertex(pt, supp[1]);
        v[4] = CCDPolyTope.ccdPtAddVertex(pt, supp[2]);
        v[5] = CCDPolyTope.ccdPtAddVertex(pt, supp[3]);
        e[0] = CCDPolyTope.ccdPtAddEdge(pt, v[0], v[1]);
        e[1] = CCDPolyTope.ccdPtAddEdge(pt, v[1], v[2]);
        e[2] = CCDPolyTope.ccdPtAddEdge(pt, v[2], v[3]);
        e[3] = CCDPolyTope.ccdPtAddEdge(pt, v[3], v[0]);
        e[4] = CCDPolyTope.ccdPtAddEdge(pt, v[4], v[0]);
        e[5] = CCDPolyTope.ccdPtAddEdge(pt, v[4], v[1]);
        e[6] = CCDPolyTope.ccdPtAddEdge(pt, v[4], v[2]);
        e[7] = CCDPolyTope.ccdPtAddEdge(pt, v[4], v[3]);
        e[8] = CCDPolyTope.ccdPtAddEdge(pt, v[5], v[0]);
        e[9] = CCDPolyTope.ccdPtAddEdge(pt, v[5], v[1]);
        e[10] = CCDPolyTope.ccdPtAddEdge(pt, v[5], v[2]);
        e[11] = CCDPolyTope.ccdPtAddEdge(pt, v[5], v[3]);
        CCDPolyTope.ccdPtAddFace(pt, e[4], e[5], e[0]);
        CCDPolyTope.ccdPtAddFace(pt, e[5], e[6], e[1]);
        CCDPolyTope.ccdPtAddFace(pt, e[6], e[7], e[2]);
        CCDPolyTope.ccdPtAddFace(pt, e[7], e[4], e[3]);
        CCDPolyTope.ccdPtAddFace(pt, e[8], e[9], e[0]);
        CCDPolyTope.ccdPtAddFace(pt, e[9], e[10], e[1]);
        CCDPolyTope.ccdPtAddFace(pt, e[10], e[11], e[2]);
        CCDPolyTope.ccdPtAddFace(pt, e[11], e[8], e[3]);
        return 0;
    }

    static void expandPolytope(CCDPolyTope.ccd_pt_t pt, CCDPolyTope.ccd_pt_el_t el, CCDSupport.ccd_support_t newv) {
        CCDPolyTope.ccd_pt_vertex_t[] v = new CCDPolyTope.ccd_pt_vertex_t[5];
        CCDPolyTope.ccd_pt_edge_t[] e = new CCDPolyTope.ccd_pt_edge_t[8];
        CCDPolyTope.ccd_pt_face_t[] f = new CCDPolyTope.ccd_pt_face_t[2];
        if (el.type == 2) {
            CCDPolyTope.ccdPtEdgeVertices((CCDPolyTope.ccd_pt_edge_t)el, v, 0, 2);
            CCDPolyTope.ccdPtEdgeFaces((CCDPolyTope.ccd_pt_edge_t)el, f, 0, 1);
            if (f[0] != null) {
                CCDPolyTope.ccdPtFaceEdges(f[0], e, 0, 1, 2);
                if (e[0] == (CCDPolyTope.ccd_pt_edge_t)el) {
                    e[0] = e[2];
                } else if (e[1] == (CCDPolyTope.ccd_pt_edge_t)el) {
                    e[1] = e[2];
                }
                CCDPolyTope.ccdPtEdgeVertices(e[0], v, 1, 3);
                if (v[1] != v[0] && v[3] != v[0]) {
                    e[2] = e[0];
                    e[0] = e[1];
                    e[1] = e[2];
                    if (v[1] == v[2]) {
                        v[1] = v[3];
                    }
                } else if (v[1] == v[0]) {
                    v[1] = v[3];
                }
                if (f[1] != null) {
                    CCDPolyTope.ccdPtFaceEdges(f[1], e, 2, 3, 4);
                    if (e[2] == (CCDPolyTope.ccd_pt_edge_t)el) {
                        e[2] = e[4];
                    } else if (e[3] == (CCDPolyTope.ccd_pt_edge_t)el) {
                        e[3] = e[4];
                    }
                    CCDPolyTope.ccdPtEdgeVertices(e[2], v, 3, 4);
                    if (v[3] != v[2] && v[4] != v[2]) {
                        e[4] = e[2];
                        e[2] = e[3];
                        e[3] = e[4];
                        if (v[3] == v[0]) {
                            v[3] = v[4];
                        }
                    } else if (v[3] == v[2]) {
                        v[3] = v[4];
                    }
                }
                v[4] = CCDPolyTope.ccdPtAddVertex(pt, newv);
                CCDPolyTope.ccdPtDelFace(pt, f[0]);
                if (f[1] != null) {
                    CCDPolyTope.ccdPtDelFace(pt, f[1]);
                    CCDPolyTope.ccdPtDelEdge(pt, (CCDPolyTope.ccd_pt_edge_t)el);
                }
                e[4] = CCDPolyTope.ccdPtAddEdge(pt, v[4], v[2]);
                e[5] = CCDPolyTope.ccdPtAddEdge(pt, v[4], v[0]);
                e[6] = CCDPolyTope.ccdPtAddEdge(pt, v[4], v[1]);
                if (f[1] != null) {
                    e[7] = CCDPolyTope.ccdPtAddEdge(pt, v[4], v[3]);
                }
                CCDPolyTope.ccdPtAddFace(pt, e[1], e[4], e[6]);
                CCDPolyTope.ccdPtAddFace(pt, e[0], e[6], e[5]);
                if (f[1] != null) {
                    CCDPolyTope.ccdPtAddFace(pt, e[3], e[5], e[7]);
                    CCDPolyTope.ccdPtAddFace(pt, e[4], e[7], e[2]);
                } else {
                    CCDPolyTope.ccdPtAddFace(pt, e[4], e[5], (CCDPolyTope.ccd_pt_edge_t)el);
                }
            }
        } else {
            CCDPolyTope.ccdPtFaceEdges((CCDPolyTope.ccd_pt_face_t)el, e, 0, 1, 2);
            CCDPolyTope.ccdPtEdgeVertices(e[0], v, 0, 1);
            CCDPolyTope.ccdPtEdgeVertices(e[1], v, 2, 3);
            if (v[2] != v[1] && v[3] != v[1]) {
                e[3] = e[1];
                e[1] = e[2];
                e[2] = e[3];
            }
            if (v[3] != v[0] && v[3] != v[1]) {
                v[2] = v[3];
            }
            CCDPolyTope.ccdPtDelFace(pt, (CCDPolyTope.ccd_pt_face_t)el);
            v[3] = CCDPolyTope.ccdPtAddVertex(pt, newv);
            e[3] = CCDPolyTope.ccdPtAddEdge(pt, v[3], v[0]);
            e[4] = CCDPolyTope.ccdPtAddEdge(pt, v[3], v[1]);
            e[5] = CCDPolyTope.ccdPtAddEdge(pt, v[3], v[2]);
            CCDPolyTope.ccdPtAddFace(pt, e[3], e[4], e[0]);
            CCDPolyTope.ccdPtAddFace(pt, e[4], e[5], e[1]);
            CCDPolyTope.ccdPtAddFace(pt, e[5], e[3], e[2]);
        }
    }

    static int nextSupport(Object obj1, Object obj2, ccd_t ccd, CCDPolyTope.ccd_pt_el_t el, CCDSupport.ccd_support_t out) {
        double dist;
        if (el.type == 1) {
            return -1;
        }
        if (CCDVec3.ccdIsZero(el.dist)) {
            return -1;
        }
        CCDSupport.__ccdSupport(obj1, obj2, el.witness, ccd, out);
        if (el.type == 2) {
            CCDPolyTope.ccd_pt_edge_t e = (CCDPolyTope.ccd_pt_edge_t)el;
            CCDVec3.ccd_vec3_t a = e.vertex0.v.v;
            CCDVec3.ccd_vec3_t b = e.vertex1.v.v;
            dist = CCDVec3.ccdVec3PointSegmentDist2(out.v, a, b, null);
        } else {
            CCDPolyTope.ccd_pt_face_t face = (CCDPolyTope.ccd_pt_face_t)el;
            CCDVec3.ccd_vec3_t a = face.edge0.vertex0.v.v;
            CCDVec3.ccd_vec3_t b = face.edge0.vertex1.v.v;
            CCDVec3.ccd_vec3_t c = face.edge1.vertex0 != face.edge0.vertex0 && face.edge1.vertex0 != face.edge0.vertex1 ? face.edge1.vertex0.v.v : face.edge1.vertex1.v.v;
            dist = CCDVec3.ccdVec3PointTriDist2(out.v, a, b, c, null);
        }
        if (dist < ccd.epa_tolerance) {
            return -1;
        }
        return 0;
    }

    public static interface ccd_center_fn {
        public void run(Object var1, CCDVec3.ccd_vec3_t var2);
    }

    static interface ccd_first_dir_fn {
        public void run(Object var1, Object var2, CCDVec3.ccd_vec3_t var3);
    }

    public static interface ccd_support_fn {
        public void run(Object var1, CCDVec3.ccd_vec3_t var2, CCDVec3.ccd_vec3_t var3);
    }

    public static final class ccd_t {
        ccd_first_dir_fn first_dir;
        public ccd_support_fn support1;
        public ccd_support_fn support2;
        public ccd_center_fn center1;
        public ccd_center_fn center2;
        public long max_iterations;
        double epa_tolerance;
        public double mpr_tolerance;
    }
}

