/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal.joints;

import java.util.LinkedList;
import java.util.List;
import org.ode4j.ode.DBody;
import org.ode4j.ode.DContact;
import org.ode4j.ode.DJoint;
import org.ode4j.ode.DJointGroup;
import org.ode4j.ode.DWorld;
import org.ode4j.ode.OdeHelper;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DxBody;
import org.ode4j.ode.internal.DxWorld;
import org.ode4j.ode.internal.joints.DxJoint;
import org.ode4j.ode.internal.joints.DxJointAMotor;
import org.ode4j.ode.internal.joints.DxJointBall;
import org.ode4j.ode.internal.joints.DxJointContact;
import org.ode4j.ode.internal.joints.DxJointFixed;
import org.ode4j.ode.internal.joints.DxJointGroup;
import org.ode4j.ode.internal.joints.DxJointHinge;
import org.ode4j.ode.internal.joints.DxJointHinge2;
import org.ode4j.ode.internal.joints.DxJointLMotor;
import org.ode4j.ode.internal.joints.DxJointNode;
import org.ode4j.ode.internal.joints.DxJointNull;
import org.ode4j.ode.internal.joints.DxJointPR;
import org.ode4j.ode.internal.joints.DxJointPU;
import org.ode4j.ode.internal.joints.DxJointPiston;
import org.ode4j.ode.internal.joints.DxJointPlane2D;
import org.ode4j.ode.internal.joints.DxJointSlider;
import org.ode4j.ode.internal.joints.DxJointUniversal;

public class OdeJointsFactoryImpl
extends OdeHelper {
    private <T extends DxJoint> T createJoint(T j, DJointGroup group) {
        if (group != null) {
            ((DxJointGroup)group).addJoint(j);
        }
        return j;
    }

    public DxJointBall dJointCreateBall(DWorld w, DJointGroup group) {
        Common.dAASSERT(w);
        return this.createJoint(new DxJointBall((DxWorld)w), group);
    }

    public DxJointHinge dJointCreateHinge(DWorld w, DJointGroup group) {
        Common.dAASSERT(w);
        return this.createJoint(new DxJointHinge((DxWorld)w), group);
    }

    public DxJointSlider dJointCreateSlider(DWorld w, DJointGroup group) {
        Common.dAASSERT(w);
        return this.createJoint(new DxJointSlider((DxWorld)w), group);
    }

    public DxJointContact dJointCreateContact(DWorld w, DJointGroup group, DContact c) {
        Common.dAASSERT(w, c);
        DxJointContact j = this.createJoint(new DxJointContact((DxWorld)w), group);
        j.contact = c;
        return j;
    }

    public DxJointHinge2 dJointCreateHinge2(DWorld w, DJointGroup group) {
        Common.dAASSERT(w);
        return this.createJoint(new DxJointHinge2((DxWorld)w), group);
    }

    public DxJointUniversal dJointCreateUniversal(DWorld w, DJointGroup group) {
        Common.dAASSERT(w);
        return this.createJoint(new DxJointUniversal((DxWorld)w), group);
    }

    public DxJointPR dJointCreatePR(DWorld w, DJointGroup group) {
        Common.dAASSERT(w);
        return this.createJoint(new DxJointPR((DxWorld)w), group);
    }

    public DxJointPU dJointCreatePU(DWorld w, DJointGroup group) {
        Common.dAASSERT(w);
        return this.createJoint(new DxJointPU((DxWorld)w), group);
    }

    public DxJointPiston dJointCreatePiston(DWorld w, DJointGroup group) {
        Common.dAASSERT(w);
        return this.createJoint(new DxJointPiston((DxWorld)w), group);
    }

    public DxJointFixed dJointCreateFixed(DWorld id, DJointGroup group) {
        Common.dAASSERT(id);
        return this.createJoint(new DxJointFixed((DxWorld)id), group);
    }

    public DxJointNull dJointCreateNull(DWorld w, DJointGroup group) {
        Common.dAASSERT(w);
        return this.createJoint(new DxJointNull((DxWorld)w), group);
    }

    public DxJointAMotor dJointCreateAMotor(DWorld w, DJointGroup group) {
        Common.dAASSERT(w);
        return this.createJoint(new DxJointAMotor((DxWorld)w), group);
    }

    public DxJointLMotor dJointCreateLMotor(DWorld w, DJointGroup group) {
        Common.dAASSERT(w);
        return this.createJoint(new DxJointLMotor((DxWorld)w), group);
    }

    public DxJointPlane2D dJointCreatePlane2D(DWorld w, DJointGroup group) {
        Common.dAASSERT(w);
        return this.createJoint(new DxJointPlane2D((DxWorld)w), group);
    }

    protected static void dJointDestroy(DxJoint j) {
        Common.dAASSERT(j);
        if (j.isFlagsInGroup()) {
            return;
        }
        j.removeJointReferencesFromAttachedBodies();
        j.removeObjectFromList();
        --j.world.nj;
        j.DESTRUCTOR();
    }

    public void dJointAttach(DxJoint joint, DxBody body1, DxBody body2) {
        joint.dJointAttach(body1, body2);
    }

    public static DJoint dConnectingJoint(DBody in_b1, DBody in_b2) {
        DxBody b2;
        DxBody b1;
        Common.dAASSERT(in_b1 != null || in_b2 != null);
        if (in_b1 == null) {
            b1 = (DxBody)in_b2;
            b2 = (DxBody)in_b1;
        } else {
            b1 = (DxBody)in_b1;
            b2 = (DxBody)in_b2;
        }
        DxJointNode n = b1.firstjoint.get();
        while (n != null) {
            if (n.body == b2) {
                return n.joint;
            }
            n = n.next;
        }
        return null;
    }

    public static List<DJoint> dConnectingJointList(DxBody in_b1, DxBody in_b2) {
        DxBody b2;
        DxBody b1;
        Common.dAASSERT(in_b1 != null || in_b2 != null);
        LinkedList<DJoint> out_list = new LinkedList<DJoint>();
        if (in_b1 == null) {
            b1 = in_b2;
            b2 = in_b1;
        } else {
            b1 = in_b1;
            b2 = in_b2;
        }
        DxJointNode n = b1.firstjoint.get();
        while (n != null) {
            if (n.body == b2) {
                out_list.add(n.joint);
            }
            n = n.next;
        }
        return out_list;
    }

    public boolean _dAreConnected(DBody b1, DBody b2) {
        Common.dAASSERT(b1 != null);
        DxJointNode n = ((DxBody)b1).firstjoint.get();
        while (n != null) {
            if (n.body == b2) {
                return true;
            }
            n = n.next;
        }
        return false;
    }

    public boolean _dAreConnectedExcluding(DBody b1, DBody b2, Class<? extends DJoint>[] jointType) {
        Common.dAASSERT(b1 != null);
        DxJointNode n = ((DxBody)b1).firstjoint.get();
        while (n != null) {
            if (n.body == b2) {
                boolean found = false;
                Class<? extends DJoint>[] classArray = jointType;
                int n2 = jointType.length;
                int n3 = 0;
                while (n3 < n2) {
                    Class<? extends DJoint> cls = classArray[n3];
                    if (cls.isAssignableFrom(n.joint.getClass())) {
                        found = true;
                        break;
                    }
                    ++n3;
                }
                if (!found) {
                    return true;
                }
            }
            n = n.next;
        }
        return false;
    }
}

