/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal.joints;

import org.cpp4j.java.RefDouble;
import org.ode4j.math.DMatrix3;
import org.ode4j.math.DQuaternion;
import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.DJoint;
import org.ode4j.ode.DUniversalJoint;
import org.ode4j.ode.OdeMath;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DxWorld;
import org.ode4j.ode.internal.Rotation;
import org.ode4j.ode.internal.joints.DxJoint;
import org.ode4j.ode.internal.joints.DxJointLimitMotor;

public class DxJointUniversal
extends DxJoint
implements DUniversalJoint {
    DVector3 _anchor1 = new DVector3();
    DVector3 _anchor2 = new DVector3();
    DVector3 _axis1 = new DVector3(1.0, 0.0, 0.0);
    DVector3 _axis2 = new DVector3(0.0, 1.0, 0.0);
    DQuaternion qrel1 = new DQuaternion();
    DQuaternion qrel2 = new DQuaternion();
    DxJointLimitMotor limot1 = new DxJointLimitMotor();
    DxJointLimitMotor limot2;

    DxJointUniversal(DxWorld w) {
        super(w);
        this.limot1.init(this.world);
        this.limot2 = new DxJointLimitMotor();
        this.limot2.init(this.world);
    }

    void getAxes(DVector3 ax1, DVector3 ax2) {
        OdeMath.dMultiply0_331(ax1, this.node[0].body.posr().R(), (DVector3C)this._axis1);
        if (this.node[1].body != null) {
            OdeMath.dMultiply0_331(ax2, this.node[1].body.posr().R(), (DVector3C)this._axis2);
        } else {
            ax2.set(this._axis2);
        }
    }

    void getAngles(RefDouble angle1, RefDouble angle2) {
        if (this.node[0].body != null) {
            DVector3 ax1 = new DVector3();
            DVector3 ax2 = new DVector3();
            DMatrix3 R = new DMatrix3();
            DQuaternion qcross = new DQuaternion();
            DQuaternion qq = new DQuaternion();
            DQuaternion qrel = new DQuaternion();
            this.getAxes(ax1, ax2);
            Rotation.dRFrom2Axes(R, ax1, ax2);
            Rotation.dQfromR(qcross, R);
            Rotation.dQMultiply1(qq, this.node[0].body._q, qcross);
            Rotation.dQMultiply2(qrel, qq, this.qrel1);
            angle1.set(this.getHingeAngleFromRelativeQuat(qrel, this._axis1));
            DQuaternion qcross2 = new DQuaternion();
            qrel.set0(0.0);
            qrel.set1(ax1.get0() + ax2.get0());
            qrel.set2(ax1.get1() + ax2.get1());
            qrel.set3(ax1.get2() + ax2.get2());
            double l = Common.dRecip(Math.sqrt(qrel.get1() * qrel.get1() + qrel.get2() * qrel.get2() + qrel.get3() * qrel.get3()));
            qrel.scale(1, l);
            qrel.scale(2, l);
            qrel.scale(3, l);
            Rotation.dQMultiply0(qcross2, qrel, qcross);
            if (this.node[1].body != null) {
                Rotation.dQMultiply1(qq, this.node[1].body._q, qcross2);
                Rotation.dQMultiply2(qrel, qq, this.qrel2);
            } else {
                Rotation.dQMultiply2(qrel, qcross2, this.qrel2);
            }
            angle2.set(-this.getHingeAngleFromRelativeQuat(qrel, this._axis2));
        } else {
            angle1.set(0.0);
            angle2.set(0.0);
        }
    }

    protected double getAngle1Internal() {
        if (this.node[0].body != null) {
            DVector3 ax1 = new DVector3();
            DVector3 ax2 = new DVector3();
            DMatrix3 R = new DMatrix3();
            DQuaternion qcross = new DQuaternion();
            DQuaternion qq = new DQuaternion();
            DQuaternion qrel = new DQuaternion();
            this.getAxes(ax1, ax2);
            Rotation.dRFrom2Axes(R, ax1, ax2);
            Rotation.dQfromR(qcross, R);
            Rotation.dQMultiply1(qq, this.node[0].body._q, qcross);
            Rotation.dQMultiply2(qrel, qq, this.qrel1);
            return this.getHingeAngleFromRelativeQuat(qrel, this._axis1);
        }
        return 0.0;
    }

    protected double getAngle2Internal() {
        if (this.node[0].body != null) {
            DVector3 ax1 = new DVector3();
            DVector3 ax2 = new DVector3();
            DMatrix3 R = new DMatrix3();
            DQuaternion qcross = new DQuaternion();
            DQuaternion qq = new DQuaternion();
            DQuaternion qrel = new DQuaternion();
            this.getAxes(ax1, ax2);
            Rotation.dRFrom2Axes(R, ax2, ax1);
            Rotation.dQfromR(qcross, R);
            if (this.node[1].body != null) {
                Rotation.dQMultiply1(qq, this.node[1].body._q, qcross);
                Rotation.dQMultiply2(qrel, qq, this.qrel2);
            } else {
                Rotation.dQMultiply2(qrel, qcross, this.qrel2);
            }
            return -this.getHingeAngleFromRelativeQuat(qrel, this._axis2);
        }
        return 0.0;
    }

    @Override
    void getSureMaxInfo(DxJoint.SureMaxInfo info) {
        info.max_m = 6;
    }

    @Override
    public void getInfo1(DxJoint.Info1 info) {
        info.setNub(4);
        info.setM(4);
        boolean limiting1 = (this.limot1.lostop >= -Math.PI || this.limot1.histop <= Math.PI) && this.limot1.lostop <= this.limot1.histop;
        boolean limiting2 = (this.limot2.lostop >= -Math.PI || this.limot2.histop <= Math.PI) && this.limot2.lostop <= this.limot2.histop;
        this.limot1.limit = 0;
        this.limot2.limit = 0;
        if (limiting1 || limiting2) {
            RefDouble angle1 = new RefDouble();
            RefDouble angle2 = new RefDouble();
            this.getAngles(angle1, angle2);
            if (limiting1) {
                this.limot1.testRotationalLimit(angle1.get());
            }
            if (limiting2) {
                this.limot2.testRotationalLimit(angle2.get());
            }
        }
        if (this.limot1.limit != 0 || this.limot1.fmax > 0.0) {
            info.incM();
        }
        if (this.limot2.limit != 0 || this.limot2.fmax > 0.0) {
            info.incM();
        }
    }

    @Override
    public void getInfo2(DxJoint.Info2 info) {
        this.setBall(this, info, this._anchor1, this._anchor2);
        DVector3 ax1 = new DVector3();
        DVector3 ax2 = new DVector3();
        DVector3 ax2_temp = new DVector3();
        DVector3 p = new DVector3();
        this.getAxes(ax1, ax2);
        double k = ax1.dot(ax2);
        ax2_temp.eqSum((DVector3C)ax2, ax1, -k);
        OdeMath.dCalcVectorCross3(p, ax1, ax2_temp);
        OdeMath.dNormalize3(p);
        int s3 = 3 * info.rowskip();
        info._J[info.J1ap + s3 + 0] = p.get0();
        info._J[info.J1ap + s3 + 1] = p.get1();
        info._J[info.J1ap + s3 + 2] = p.get2();
        if (this.node[1].body != null) {
            info._J[info.J2ap + s3 + 0] = -p.get0();
            info._J[info.J2ap + s3 + 1] = -p.get1();
            info._J[info.J2ap + s3 + 2] = -p.get2();
        }
        info.setC(3, info.fps * info.erp * -k);
        int row = 4 + this.limot1.addLimot(this, info, 4, ax1, true);
        this.limot2.addLimot(this, info, row, ax2, true);
    }

    void computeInitialRelativeRotations() {
        if (this.node[0].body != null) {
            DVector3 ax1 = new DVector3();
            DVector3 ax2 = new DVector3();
            DMatrix3 R = new DMatrix3();
            DQuaternion qcross = new DQuaternion();
            this.getAxes(ax1, ax2);
            Rotation.dRFrom2Axes(R, ax1, ax2);
            Rotation.dQfromR(qcross, R);
            Rotation.dQMultiply1(this.qrel1, this.node[0].body._q, qcross);
            Rotation.dRFrom2Axes(R, ax2, ax1);
            Rotation.dQfromR(qcross, R);
            if (this.node[1].body != null) {
                Rotation.dQMultiply1(this.qrel2, this.node[1].body._q, qcross);
            } else {
                this.qrel2.set(qcross);
            }
        }
    }

    public void dJointSetUniversalAnchor(double x, double y, double z) {
        this.dJointSetUniversalAnchor(new DVector3(x, y, z));
    }

    public void dJointSetUniversalAnchor(DVector3C xyz) {
        this.setAnchors(xyz, this._anchor1, this._anchor2);
        this.computeInitialRelativeRotations();
    }

    public void dJointSetUniversalAxis1(double x, double y, double z) {
        if (this.isFlagsReverse()) {
            this.setAxes(x, y, z, null, this._axis2);
        } else {
            this.setAxes(x, y, z, this._axis1, null);
        }
        this.computeInitialRelativeRotations();
    }

    void dJointSetUniversalAxis1Offset(double x, double y, double z, double offset1, double offset2) {
        DVector3 xyz = new DVector3(x, y, z);
        if (this.isFlagsReverse()) {
            this.setAxes(xyz, null, this._axis2);
            offset1 = -offset1;
            offset2 = -offset2;
        } else {
            this.setAxes(xyz, this._axis1, null);
        }
        this.computeInitialRelativeRotations();
        DVector3 ax2 = new DVector3();
        this.getAxis2(ax2, this._axis2);
        DVector3 ax1 = new DVector3();
        this.getAxes(ax1, ax2);
        DQuaternion qAngle = new DQuaternion();
        Rotation.dQFromAxisAndAngle(qAngle, xyz, offset1);
        DMatrix3 R = new DMatrix3();
        Rotation.dRFrom2Axes(R, xyz, ax2);
        DQuaternion qcross = new DQuaternion();
        Rotation.dQfromR(qcross, R);
        DQuaternion qOffset = new DQuaternion();
        Rotation.dQMultiply0(qOffset, qAngle, qcross);
        Rotation.dQMultiply1(this.qrel1, this.node[0].body._q, qOffset);
        Rotation.dQFromAxisAndAngle(qAngle, ax2, offset2);
        Rotation.dRFrom2Axes(R, ax2, xyz);
        Rotation.dQfromR(qcross, R);
        Rotation.dQMultiply1(qOffset, qAngle, qcross);
        if (this.node[1].body != null) {
            Rotation.dQMultiply1(this.qrel2, this.node[1].body._q, qOffset);
        } else {
            this.qrel2.set(qcross);
        }
    }

    public void dJointSetUniversalAxis2(double x, double y, double z) {
        if (this.isFlagsReverse()) {
            this.setAxes(x, y, z, this._axis1, null);
        } else {
            this.setAxes(x, y, z, null, this._axis2);
        }
        this.computeInitialRelativeRotations();
    }

    void dJointSetUniversalAxis2Offset(double x, double y, double z, double offset1, double offset2) {
        DVector3 xyz = new DVector3(x, y, z);
        if (this.isFlagsReverse()) {
            this.setAxes(xyz, this._axis1, null);
            offset1 = -offset2;
            offset2 = -offset1;
        } else {
            this.setAxes(xyz, null, this._axis2);
        }
        this.computeInitialRelativeRotations();
        DVector3 ax1 = new DVector3();
        DVector3 ax2 = new DVector3();
        this.getAxes(ax1, ax2);
        DQuaternion qAngle = new DQuaternion();
        Rotation.dQFromAxisAndAngle(qAngle, ax1, offset1);
        DMatrix3 R = new DMatrix3();
        Rotation.dRFrom2Axes(R, ax1, ax2);
        DQuaternion qcross = new DQuaternion();
        Rotation.dQfromR(qcross, R);
        DQuaternion qOffset = new DQuaternion();
        Rotation.dQMultiply0(qOffset, qAngle, qcross);
        Rotation.dQMultiply1(this.qrel1, this.node[0].body._q, qOffset);
        Rotation.dQFromAxisAndAngle(qAngle, ax2, offset2);
        Rotation.dRFrom2Axes(R, ax2, ax1);
        Rotation.dQfromR(qcross, R);
        Rotation.dQMultiply1(qOffset, qAngle, qcross);
        if (this.node[1].body != null) {
            Rotation.dQMultiply1(this.qrel2, this.node[1].body._q, qOffset);
        } else {
            this.qrel2.set(qcross);
        }
    }

    public void dJointGetUniversalAnchor(DVector3 result) {
        if (this.isFlagsReverse()) {
            this.getAnchor2(result, this._anchor2);
        } else {
            this.getAnchor(result, this._anchor1);
        }
    }

    private void dJointGetUniversalAnchor2(DVector3 result) {
        if (this.isFlagsReverse()) {
            this.getAnchor(result, this._anchor1);
        } else {
            this.getAnchor2(result, this._anchor2);
        }
    }

    public void dJointGetUniversalAxis1(DVector3 result) {
        if (this.isFlagsReverse()) {
            this.getAxis2(result, this._axis2);
        } else {
            this.getAxis(result, this._axis1);
        }
    }

    public void dJointGetUniversalAxis2(DVector3 result) {
        if (this.isFlagsReverse()) {
            this.getAxis(result, this._axis1);
        } else {
            this.getAxis2(result, this._axis2);
        }
    }

    public void dJointSetUniversalParam(DJoint.PARAM_N parameter, double value) {
        if (parameter.isGroup2()) {
            this.limot2.set(parameter.toSUB(), value);
        } else {
            this.limot1.set(parameter.toSUB(), value);
        }
    }

    private double dJointGetUniversalParam(DJoint.PARAM_N parameter) {
        if (parameter.isGroup2()) {
            return this.limot2.get(parameter.toSUB());
        }
        return this.limot1.get(parameter.toSUB());
    }

    public double dJointGetUniversalAngle1() {
        if (this.isFlagsReverse()) {
            return this.getAngle2Internal();
        }
        return this.getAngle1Internal();
    }

    public double dJointGetUniversalAngle2() {
        if (this.isFlagsReverse()) {
            return -this.getAngle1Internal();
        }
        return this.getAngle2Internal();
    }

    public double dJointGetUniversalAngle1Rate() {
        if (this.node[0].body != null) {
            DVector3 axis = new DVector3();
            if (this.isFlagsReverse()) {
                this.getAxis2(axis, this._axis2);
            } else {
                this.getAxis(axis, this._axis1);
            }
            double rate = OdeMath.dCalcVectorDot3(axis, this.node[0].body.avel);
            if (this.node[1].body != null) {
                rate -= OdeMath.dCalcVectorDot3(axis, this.node[1].body.avel);
            }
            return rate;
        }
        return 0.0;
    }

    public double dJointGetUniversalAngle2Rate() {
        if (this.node[0].body != null) {
            DVector3 axis = new DVector3();
            if (this.isFlagsReverse()) {
                this.getAxis(axis, this._axis1);
            } else {
                this.getAxis2(axis, this._axis2);
            }
            double rate = OdeMath.dCalcVectorDot3(axis, this.node[0].body.avel);
            if (this.node[1].body != null) {
                rate -= OdeMath.dCalcVectorDot3(axis, this.node[1].body.avel);
            }
            return rate;
        }
        return 0.0;
    }

    private void dJointAddUniversalTorques(double torque1, double torque2) {
        DVector3 axis1 = new DVector3();
        DVector3 axis2 = new DVector3();
        if (this.isFlagsReverse()) {
            double temp = torque1;
            torque1 = -torque2;
            torque2 = -temp;
        }
        this.getAxis(axis1, this._axis1);
        this.getAxis2(axis2, this._axis2);
        axis1.eqSum(axis1, torque1, (DVector3C)axis2, torque2);
        if (this.node[0].body != null) {
            this.node[0].body.dBodyAddTorque(axis1);
        }
        if (this.node[1].body != null) {
            this.node[1].body.dBodyAddTorque(axis1.scale(-1.0));
        }
    }

    @Override
    void setRelativeValues() {
        DVector3 anchor = new DVector3();
        this.dJointGetUniversalAnchor(anchor);
        this.setAnchors(anchor, this._anchor1, this._anchor2);
        DVector3 ax1 = new DVector3();
        DVector3 ax2 = new DVector3();
        this.dJointGetUniversalAxis1(ax1);
        this.dJointGetUniversalAxis2(ax2);
        if (this.isFlagsReverse()) {
            this.setAxes(ax1, null, this._axis2);
            this.setAxes(ax2, this._axis1, null);
        } else {
            this.setAxes(ax1, this._axis1, null);
            this.setAxes(ax2, null, this._axis2);
        }
        this.computeInitialRelativeRotations();
    }

    public DxJointLimitMotor getLimot1() {
        return this.limot1;
    }

    public DxJointLimitMotor getLimot2() {
        return this.limot2;
    }

    @Override
    public void setAnchor(double x, double y, double z) {
        this.dJointSetUniversalAnchor(x, y, z);
    }

    @Override
    public void setAnchor(DVector3C a) {
        this.dJointSetUniversalAnchor(a);
    }

    @Override
    public void setAxis1(double x, double y, double z) {
        this.dJointSetUniversalAxis1(x, y, z);
    }

    @Override
    public void setAxis1(DVector3C a) {
        this.setAxis1(a.get0(), a.get1(), a.get2());
    }

    @Override
    public void setAxis2(double x, double y, double z) {
        this.dJointSetUniversalAxis2(x, y, z);
    }

    @Override
    public void setAxis2(DVector3C a) {
        this.setAxis2(a.get0(), a.get1(), a.get2());
    }

    @Override
    public void getAnchor(DVector3 result) {
        this.dJointGetUniversalAnchor(result);
    }

    @Override
    public void getAnchor2(DVector3 result) {
        this.dJointGetUniversalAnchor2(result);
    }

    @Override
    public void getAxis1(DVector3 result) {
        this.dJointGetUniversalAxis1(result);
    }

    @Override
    public void getAxis2(DVector3 result) {
        this.dJointGetUniversalAxis2(result);
    }

    @Override
    public void setParam(DJoint.PARAM_N parameter, double value) {
        this.dJointSetUniversalParam(parameter, value);
    }

    @Override
    public double getParam(DJoint.PARAM_N parameter) {
        return this.dJointGetUniversalParam(parameter);
    }

    @Override
    public double getAngle1() {
        return this.dJointGetUniversalAngle1();
    }

    @Override
    public double getAngle1Rate() {
        return this.dJointGetUniversalAngle1Rate();
    }

    @Override
    public double getAngle2() {
        return this.dJointGetUniversalAngle2();
    }

    @Override
    public double getAngle2Rate() {
        return this.dJointGetUniversalAngle2Rate();
    }

    @Override
    public void addTorques(double torque1, double torque2) {
        this.dJointAddUniversalTorques(torque1, torque2);
    }

    @Override
    public void setAxis1Offset(double x, double y, double z, double offset1, double offset2) {
        this.dJointSetUniversalAxis1Offset(x, y, z, offset1, offset2);
    }

    @Override
    public void setAxis2Offset(double x, double y, double z, double offset1, double offset2) {
        this.dJointSetUniversalAxis2Offset(x, y, z, offset1, offset2);
    }
}

