/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal.joints;

import org.ode4j.math.DMatrix3C;
import org.ode4j.math.DQuaternion;
import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.DJoint;
import org.ode4j.ode.DSliderJoint;
import org.ode4j.ode.OdeMath;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DxWorld;
import org.ode4j.ode.internal.Rotation;
import org.ode4j.ode.internal.joints.DxJoint;
import org.ode4j.ode.internal.joints.DxJointLimitMotor;

public class DxJointSlider
extends DxJoint
implements DSliderJoint {
    DVector3 axis1 = new DVector3(1.0, 0.0, 0.0);
    public DQuaternion qrel = new DQuaternion();
    DVector3 offset = new DVector3();
    DxJointLimitMotor limot = new DxJointLimitMotor();

    DxJointSlider(DxWorld w) {
        super(w);
        this.limot.init(this.world);
    }

    public double dJointGetSliderPosition() {
        DVector3 ax1 = new DVector3();
        DVector3 q = new DVector3();
        OdeMath.dMultiply0_331(ax1, this.node[0].body.posr().R(), (DVector3C)this.axis1);
        if (this.node[1].body != null) {
            OdeMath.dMultiply0_331(q, this.node[1].body.posr().R(), (DVector3C)this.offset);
            q.eqDiff(this.node[0].body.posr().pos(), q);
            q.sub(this.node[1].body.posr().pos());
        } else {
            q.eqDiff(this.node[0].body.posr().pos(), this.offset);
            if (this.isFlagsReverse()) {
                ax1.scale(-1.0);
            }
        }
        return OdeMath.dCalcVectorDot3(ax1, q);
    }

    public double dJointGetSliderPositionRate() {
        DVector3 ax1 = new DVector3();
        OdeMath.dMultiply0_331(ax1, this.node[0].body.posr().R(), (DVector3C)this.axis1);
        if (this.node[1].body != null) {
            return OdeMath.dCalcVectorDot3(ax1, this.node[0].body.lvel) - OdeMath.dCalcVectorDot3(ax1, this.node[1].body.lvel);
        }
        double rate = OdeMath.dCalcVectorDot3(ax1, this.node[0].body.lvel);
        if (this.isFlagsReverse()) {
            rate = -rate;
        }
        return rate;
    }

    @Override
    void getSureMaxInfo(DxJoint.SureMaxInfo info) {
        info.max_m = 6;
    }

    @Override
    public void getInfo1(DxJoint.Info1 info) {
        info.setNub(5);
        if (this.limot.fmax > 0.0) {
            info.setM(6);
        } else {
            info.setM(5);
        }
        this.limot.limit = 0;
        if ((this.limot.lostop > Double.NEGATIVE_INFINITY || this.limot.histop < Double.POSITIVE_INFINITY) && this.limot.lostop <= this.limot.histop) {
            double pos = this.dJointGetSliderPosition();
            if (pos <= this.limot.lostop) {
                this.limot.limit = 1;
                this.limot.limit_err = pos - this.limot.lostop;
                info.setM(6);
            } else if (pos >= this.limot.histop) {
                this.limot.limit = 2;
                this.limot.limit_err = pos - this.limot.histop;
                info.setM(6);
            }
        }
    }

    @Override
    public void getInfo2(DxJoint.Info2 info) {
        int i;
        DMatrix3C R2;
        DVector3C pos2;
        int s = info.rowskip();
        int s3 = 3 * s;
        int s4 = 4 * s;
        DVector3 c = new DVector3();
        DVector3C pos1 = this.node[0].body.posr().pos();
        DMatrix3C R1 = this.node[0].body.posr().R();
        if (this.node[1].body != null) {
            pos2 = this.node[1].body.posr().pos();
            R2 = this.node[1].body.posr().R();
            c.eqDiff(pos2, pos1);
        } else {
            pos2 = null;
            R2 = null;
        }
        this.setFixedOrientation(this, info, this.qrel, 0);
        DVector3 ax1 = new DVector3();
        DVector3 p = new DVector3();
        DVector3 q = new DVector3();
        OdeMath.dMultiply0_331(ax1, R1, (DVector3C)this.axis1);
        OdeMath.dPlaneSpace(ax1, p, q);
        if (this.node[1].body != null) {
            DVector3 tmp = new DVector3();
            OdeMath.dCalcVectorCross3(tmp, c, p);
            tmp.scale(0.5);
            i = 0;
            while (i < 3) {
                info._J[info.J1ap + s3 + i] = tmp.get(i);
                ++i;
            }
            i = 0;
            while (i < 3) {
                info._J[info.J2ap + s3 + i] = tmp.get(i);
                ++i;
            }
            OdeMath.dCalcVectorCross3(tmp, c, p);
            tmp.scale(0.5);
            i = 0;
            while (i < 3) {
                info._J[info.J1ap + s4 + i] = tmp.get(i);
                ++i;
            }
            i = 0;
            while (i < 3) {
                info._J[info.J2ap + s4 + i] = tmp.get(i);
                ++i;
            }
            i = 0;
            while (i < 3) {
                info._J[info.J2lp + s3 + i] = -p.get(i);
                ++i;
            }
            i = 0;
            while (i < 3) {
                info._J[info.J2lp + s4 + i] = -q.get(i);
                ++i;
            }
        }
        i = 0;
        while (i < 3) {
            info._J[info.J1lp + s3 + i] = p.get(i);
            ++i;
        }
        i = 0;
        while (i < 3) {
            info._J[info.J1lp + s4 + i] = q.get(i);
            ++i;
        }
        double k = info.fps * info.erp;
        if (this.node[1].body != null) {
            DVector3 ofs = new DVector3();
            OdeMath.dMultiply0_331(ofs, R2, (DVector3C)this.offset);
            c.add(ofs);
            info.setC(3, k * OdeMath.dCalcVectorDot3(p, c));
            info.setC(4, k * OdeMath.dCalcVectorDot3(q, c));
        } else {
            DVector3 ofs = new DVector3();
            ofs.eqDiff(this.offset, pos1);
            info.setC(3, k * OdeMath.dCalcVectorDot3(p, ofs));
            info.setC(4, k * OdeMath.dCalcVectorDot3(q, ofs));
            if (this.isFlagsReverse()) {
                ax1.scale(-1.0);
            }
        }
        this.limot.addLimot(this, info, 5, ax1, false);
    }

    public void dJointSetSliderAxis(double x, double y, double z) {
        this.setAxes(x, y, z, this.axis1, null);
        this.computeOffset();
        this.computeInitialRelativeRotation();
    }

    void dJointSetSliderAxisDelta(double x, double y, double z, double dx, double dy, double dz) {
        this.setAxes(x, y, z, this.axis1, null);
        this.computeOffset();
        if (this.node[1].body == null) {
            this.offset.add(dx, dy, dz);
        }
        this.computeInitialRelativeRotation();
    }

    void dJointGetSliderAxis(DVector3 result) {
        Common.dUASSERT(result, "bad result argument");
        this.getAxis(result, this.axis1);
    }

    public void dJointSetSliderParam(DJoint.PARAM_N parameter, double value) {
        this.limot.set(parameter.toSUB(), value);
    }

    double dJointGetSliderParam(DJoint.PARAM_N parameter) {
        return this.limot.get(parameter.toSUB());
    }

    public void dJointAddSliderForce(double force) {
        DVector3 axis = new DVector3();
        if (this.isFlagsReverse()) {
            force -= force;
        }
        this.getAxis(axis, this.axis1);
        axis.scale(force);
        if (this.node[0].body != null) {
            this.node[0].body.dBodyAddForce(axis.get0(), axis.get1(), axis.get2());
        }
        if (this.node[1].body != null) {
            this.node[1].body.dBodyAddForce(-axis.get0(), -axis.get1(), -axis.get2());
        }
        if (this.node[0].body != null && this.node[1].body != null) {
            DVector3 ltd = new DVector3();
            DVector3 c = new DVector3();
            c.eqDiff(this.node[1].body.posr().pos(), this.node[0].body.posr().pos()).scale(0.5);
            OdeMath.dCalcVectorCross3(ltd, c, axis);
            this.node[0].body.dBodyAddTorque(ltd.get0(), ltd.get1(), ltd.get2());
            this.node[1].body.dBodyAddTorque(ltd.get0(), ltd.get1(), ltd.get2());
        }
    }

    @Override
    void setRelativeValues() {
        this.computeOffset();
        this.computeInitialRelativeRotation();
    }

    void computeInitialRelativeRotation() {
        if (this.node[0].body != null) {
            if (this.node[1].body != null) {
                Rotation.dQMultiply1(this.qrel, this.node[0].body._q, this.node[1].body._q);
            } else {
                this.qrel.set(this.node[0].body._q).scale(-1.0);
            }
        }
    }

    private void computeOffset() {
        if (this.node[1].body != null) {
            DVector3 c = new DVector3();
            c.eqDiff(this.node[0].body.posr().pos(), this.node[1].body.posr().pos());
            OdeMath.dMultiply1_331(this.offset, this.node[1].body.posr().R(), c);
        } else if (this.node[0].body != null) {
            this.offset.set(this.node[0].body.posr().pos());
        }
    }

    @Override
    public void setAxis(double x, double y, double z) {
        this.dJointSetSliderAxis(x, y, z);
    }

    @Override
    public void setAxis(DVector3C a) {
        this.dJointSetSliderAxis(a.get0(), a.get1(), a.get2());
    }

    @Override
    public void getAxis(DVector3 result) {
        this.dJointGetSliderAxis(result);
    }

    @Override
    public double getPosition() {
        return this.dJointGetSliderPosition();
    }

    @Override
    public double getPositionRate() {
        return this.dJointGetSliderPositionRate();
    }

    @Override
    public void setParam(DJoint.PARAM_N parameter, double value) {
        this.dJointSetSliderParam(parameter, value);
    }

    @Override
    public double getParam(DJoint.PARAM_N parameter) {
        return this.dJointGetSliderParam(parameter);
    }

    @Override
    public void addForce(double force) {
        this.dJointAddSliderForce(force);
    }

    @Override
    public void setParamFMax(double d) {
        this.dJointSetSliderParam(DJoint.PARAM_N.dParamFMax1, d);
    }

    @Override
    public void setParamHiStop(double d) {
        this.dJointSetSliderParam(DJoint.PARAM_N.dParamHiStop1, d);
    }

    @Override
    public void setParamLoStop(double d) {
        this.dJointSetSliderParam(DJoint.PARAM_N.dParamLoStop1, d);
    }

    @Override
    public void setParamVel(double d) {
        this.dJointSetSliderParam(DJoint.PARAM_N.dParamVel1, d);
    }

    @Override
    public void setParamBounce(double d) {
        this.dJointSetSliderParam(DJoint.PARAM_N.dParamBounce1, d);
    }

    @Override
    public void setAxisDelta(double x, double y, double z, double dx, double dy, double dz) {
        this.dJointSetSliderAxisDelta(x, y, z, dx, dy, dz);
    }
}

