/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal.joints;

import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.DJoint;
import org.ode4j.ode.DPlane2DJoint;
import org.ode4j.ode.internal.DxWorld;
import org.ode4j.ode.internal.joints.DxJoint;
import org.ode4j.ode.internal.joints.DxJointLimitMotor;

public class DxJointPlane2D
extends DxJoint
implements DPlane2DJoint {
    int row_motor_x;
    int row_motor_y;
    int row_motor_angle;
    DxJointLimitMotor motor_x = new DxJointLimitMotor();
    DxJointLimitMotor motor_y = new DxJointLimitMotor();
    DxJointLimitMotor motor_angle = new DxJointLimitMotor();
    private static final DVector3C Midentity0 = new DVector3(1.0, 0.0, 0.0);
    private static final DVector3C Midentity1 = new DVector3(0.0, 1.0, 0.0);
    private static final DVector3C Midentity2 = new DVector3(0.0, 0.0, 1.0);

    DxJointPlane2D(DxWorld w) {
        super(w);
        this.motor_x.init(this.world);
        this.motor_y.init(this.world);
        this.motor_angle.init(this.world);
    }

    @Override
    void getSureMaxInfo(DxJoint.SureMaxInfo info) {
        info.max_m = 6;
    }

    @Override
    public void getInfo1(DxJoint.Info1 info) {
        info.setM(3);
        info.setNub(3);
        if (this.motor_x.fmax > 0.0) {
            this.row_motor_x = info.m++;
        }
        if (this.motor_y.fmax > 0.0) {
            this.row_motor_y = info.m++;
        }
        if (this.motor_angle.fmax > 0.0) {
            this.row_motor_angle = info.m++;
        }
    }

    @Override
    public void getInfo2(DxJoint.Info2 info) {
        int r0 = 0;
        int r1 = info.rowskip();
        int r2 = 2 * r1;
        double eps = info.fps * info.erp;
        int rx = info.J1lp + r0;
        info._J[rx] = 0.0;
        info._J[rx + 1] = 0.0;
        info._J[rx + 2] = 1.0;
        rx = info.J1lp + r1;
        info._J[rx] = 0.0;
        info._J[rx + 1] = 0.0;
        info._J[rx + 2] = 0.0;
        rx = info.J1lp + r2;
        info._J[rx] = 0.0;
        info._J[rx + 1] = 0.0;
        info._J[rx + 2] = 0.0;
        rx = info.J1ap + r0;
        info._J[rx] = 0.0;
        info._J[rx + 1] = 0.0;
        info._J[rx + 2] = 0.0;
        rx = info.J1ap + r1;
        info._J[rx] = 1.0;
        info._J[rx + 1] = 0.0;
        info._J[rx + 2] = 0.0;
        rx = info.J1ap + r2;
        info._J[rx] = 0.0;
        info._J[rx + 1] = 1.0;
        info._J[rx + 2] = 0.0;
        info.setC(0, eps * -this.node[0].body.posr().pos().get2());
        if (this.row_motor_x > 0) {
            this.motor_x.addLimot(this, info, this.row_motor_x, Midentity0, false);
        }
        if (this.row_motor_y > 0) {
            this.motor_y.addLimot(this, info, this.row_motor_y, Midentity1, false);
        }
        if (this.row_motor_angle > 0) {
            this.motor_angle.addLimot(this, info, this.row_motor_angle, Midentity2, true);
        }
    }

    public void dJointSetPlane2DXParam(DJoint.PARAM_N parameter, double value) {
        this.motor_x.set(parameter.toSUB(), value);
    }

    public void dJointSetPlane2DYParam(DJoint.PARAM_N parameter, double value) {
        this.motor_y.set(parameter.toSUB(), value);
    }

    void dJointSetPlane2DAngleParam(DJoint.PARAM_N parameter, double value) {
        this.motor_angle.set(parameter.toSUB(), value);
    }

    @Override
    public double getParam(DJoint.PARAM_N parameter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setParam(DJoint.PARAM_N parameter, double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getXParamFMax() {
        return this.motor_x.get(DJoint.PARAM.dParamFMax);
    }

    @Override
    public double getYParamFMax() {
        return this.motor_y.get(DJoint.PARAM.dParamFMax);
    }

    @Override
    public void setXParamFMax(double d) {
        this.dJointSetPlane2DXParam(DJoint.PARAM_N.dParamFMax1, d);
    }

    @Override
    public void setYParamFMax(double d) {
        this.dJointSetPlane2DYParam(DJoint.PARAM_N.dParamFMax1, d);
    }

    @Override
    public double getXParamVel() {
        return this.motor_x.get(DJoint.PARAM.dParamVel);
    }

    @Override
    public double getYParamVel() {
        return this.motor_y.get(DJoint.PARAM.dParamVel);
    }

    @Override
    public void setXParamVel(double d) {
        this.dJointSetPlane2DXParam(DJoint.PARAM_N.dParamVel1, d);
    }

    @Override
    public void setYParamVel(double d) {
        this.dJointSetPlane2DYParam(DJoint.PARAM_N.dParamVel1, d);
    }

    @Override
    public void setXParam(DJoint.PARAM parameter, double value) {
        this.motor_x.set(parameter, value);
    }

    @Override
    public void setYParam(DJoint.PARAM parameter, double value) {
        this.motor_y.set(parameter, value);
    }

    @Override
    public void setAngleParam(DJoint.PARAM parameter, double value) {
        this.motor_angle.set(parameter, value);
    }
}

