/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal.joints;

import org.ode4j.math.DMatrix3C;
import org.ode4j.math.DQuaternion;
import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.DJoint;
import org.ode4j.ode.DPistonJoint;
import org.ode4j.ode.OdeMath;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DxWorld;
import org.ode4j.ode.internal.Rotation;
import org.ode4j.ode.internal.joints.DxJoint;
import org.ode4j.ode.internal.joints.DxJointLimitMotor;

public class DxJointPiston
extends DxJoint
implements DPistonJoint {
    DVector3 axis1 = new DVector3();
    DVector3 axis2 = new DVector3();
    DQuaternion qrel = new DQuaternion();
    DVector3 anchor1 = new DVector3();
    DVector3 anchor2 = new DVector3();
    public DxJointLimitMotor limotP = new DxJointLimitMotor();
    public DxJointLimitMotor limotR = new DxJointLimitMotor();

    DxJointPiston(DxWorld w) {
        super(w);
        this.axis1.set0(1.0);
        this.axis2.set0(1.0);
        this.limotP.init(this.world);
        this.limotR.init(this.world);
    }

    double dJointGetPistonPosition() {
        if (this.node[0].body != null) {
            DVector3 q = new DVector3();
            OdeMath.dMultiply0_331(q, this.node[0].body.posr().R(), (DVector3C)this.anchor1);
            if (this.node[1].body != null) {
                DVector3 anchor2 = new DVector3();
                OdeMath.dMultiply0_331(anchor2, this.node[1].body.posr().R(), (DVector3C)this.anchor2);
                q.eqSum(this.node[0].body.posr().pos(), q);
                q.sub(this.node[1].body.posr().pos());
                q.sub(anchor2);
            } else {
                q.eqSum(this.node[0].body.posr().pos(), q).sub(this.anchor2);
                if (this.isFlagsReverse()) {
                    q.scale(-1.0);
                }
            }
            DVector3 ax = new DVector3();
            OdeMath.dMultiply0_331(ax, this.node[0].body.posr().R(), (DVector3C)this.axis1);
            return OdeMath.dCalcVectorDot3(ax, q);
        }
        Common.dDEBUGMSG("The function always return 0 since no body are attached");
        return 0.0;
    }

    public double dJointGetPistonPositionRate() {
        DVector3 ax = new DVector3();
        OdeMath.dMultiply0_331(ax, this.node[0].body.posr().R(), (DVector3C)this.axis1);
        if (this.node[1].body != null) {
            return OdeMath.dCalcVectorDot3(ax, this.node[0].body.lvel) - OdeMath.dCalcVectorDot3(ax, this.node[1].body.lvel);
        }
        double rate = OdeMath.dCalcVectorDot3(ax, this.node[0].body.lvel);
        return this.isFlagsReverse() ? -rate : rate;
    }

    double dJointGetPistonAngle() {
        if (this.node[0].body != null) {
            double ang = this.getHingeAngle(this.node[0].body, this.node[1].body, this.axis1, this.qrel);
            if (this.isFlagsReverse()) {
                return -ang;
            }
            return ang;
        }
        return 0.0;
    }

    double dJointGetPistonAngleRate() {
        if (this.node[0].body != null) {
            DVector3 axis = new DVector3();
            OdeMath.dMultiply0_331(axis, this.node[0].body.posr().R(), (DVector3C)this.axis1);
            double rate = OdeMath.dCalcVectorDot3(axis, this.node[0].body.avel);
            if (this.node[1].body != null) {
                rate -= OdeMath.dCalcVectorDot3(axis, this.node[1].body.avel);
            }
            if (this.isFlagsReverse()) {
                rate = -rate;
            }
            return rate;
        }
        return 0.0;
    }

    @Override
    void getSureMaxInfo(DxJoint.SureMaxInfo info) {
        info.max_m = 6;
    }

    @Override
    public void getInfo1(DxJoint.Info1 info) {
        info.setNub(4);
        info.setM(4);
        this.limotP.limit = 0;
        if ((this.limotP.lostop > Double.NEGATIVE_INFINITY || this.limotP.histop < Double.POSITIVE_INFINITY) && this.limotP.lostop <= this.limotP.histop) {
            double pos = this.dJointGetPistonPosition();
            this.limotP.testRotationalLimit(pos);
        }
        if (this.limotP.limit != 0 || this.limotP.fmax > 0.0) {
            info.incM();
        }
        this.limotR.limit = 0;
        if ((this.limotR.lostop > Double.NEGATIVE_INFINITY || this.limotR.histop < Double.POSITIVE_INFINITY) && this.limotR.lostop <= this.limotR.histop) {
            double angle = this.getHingeAngle(this.node[0].body, this.node[1].body, this.axis1, this.qrel);
            this.limotR.testRotationalLimit(angle);
        }
        if (this.limotR.limit != 0 || this.limotR.fmax > 0.0) {
            info.incM();
        }
    }

    @Override
    public void getInfo2(DxJoint.Info2 info) {
        boolean s0 = false;
        int s1 = info.rowskip();
        int s2 = 2 * s1;
        int s3 = 3 * s1;
        double k = info.fps * info.erp;
        DMatrix3C R1 = null;
        DMatrix3C R2 = null;
        DVector3 dist = new DVector3();
        DVector3 lanchor2 = new DVector3(0.0, 0.0, 0.0);
        DVector3C pos1 = this.node[0].body.posr().pos();
        R1 = this.node[0].body.posr().R();
        if (this.node[1].body != null) {
            DVector3C pos2 = this.node[1].body.posr().pos();
            R2 = this.node[1].body.posr().R();
            OdeMath.dMultiply0_331(lanchor2, R2, (DVector3C)this.anchor2);
            dist.eqSum(lanchor2, pos2).sub(pos1);
        } else if (this.isFlagsReverse()) {
            dist.eqDiff(pos1, this.anchor2);
        } else {
            dist.eqDiff(this.anchor2, pos1);
        }
        DVector3 ax1 = new DVector3();
        DVector3 p = new DVector3();
        DVector3 q = new DVector3();
        OdeMath.dMultiply0_331(ax1, this.node[0].body.posr().R(), (DVector3C)this.axis1);
        OdeMath.dPlaneSpace(ax1, p, q);
        OdeMath.dCopyVector3(info._J, info.J1ap + 0, (DVector3C)p);
        OdeMath.dCopyVector3(info._J, info.J1ap + s1, (DVector3C)q);
        DVector3 b = new DVector3();
        if (this.node[1].body != null) {
            OdeMath.dCopyNegatedVector3(info._J, info.J2ap + 0, p);
            OdeMath.dCopyNegatedVector3(info._J, info.J2ap + s1, q);
            DVector3 ax2 = new DVector3();
            OdeMath.dMultiply0_331(ax2, R2, (DVector3C)this.axis2);
            OdeMath.dCalcVectorCross3(b, ax1, ax2);
        } else {
            OdeMath.dCalcVectorCross3(b, ax1, this.axis2);
        }
        info.setC(0, k * OdeMath.dCalcVectorDot3(p, b));
        info.setC(1, k * OdeMath.dCalcVectorDot3(q, b));
        OdeMath.dCalcVectorCross3(info._J, info.J1ap + s2, dist, p);
        OdeMath.dCalcVectorCross3(info._J, info.J1ap + s3, dist, q);
        OdeMath.dCopyVector3(info._J, info.J1lp + s2, (DVector3C)p);
        OdeMath.dCopyVector3(info._J, info.J1lp + s3, (DVector3C)q);
        if (this.node[1].body != null) {
            OdeMath.dCalcVectorCross3(info._J, info.J2ap + s2, p, lanchor2);
            OdeMath.dCalcVectorCross3(info._J, info.J2ap + s3, q, lanchor2);
            OdeMath.dCopyNegatedVector3(info._J, info.J2lp + s2, p);
            OdeMath.dCopyNegatedVector3(info._J, info.J2lp + s3, q);
        }
        DVector3 err = new DVector3();
        OdeMath.dMultiply0_331(err, R1, (DVector3C)this.anchor1);
        err.eqDiff(dist, err);
        info.setC(2, k * OdeMath.dCalcVectorDot3(p, err));
        info.setC(3, k * OdeMath.dCalcVectorDot3(q, err));
        int row = 4;
        if (this.node[1].body != null) {
            row += this.limotP.addLimot(this, info, 4, ax1, false);
        } else if (this.isFlagsReverse()) {
            DVector3 rAx1 = new DVector3();
            rAx1.sub(ax1);
            row += this.limotP.addLimot(this, info, 4, rAx1, false);
        } else {
            row += this.limotP.addLimot(this, info, 4, ax1, false);
        }
        this.limotR.addLimot(this, info, row, ax1, true);
    }

    public void dJointSetPistonAnchor(DVector3C xyz) {
        this.setAnchors(xyz, this.anchor1, this.anchor2);
        this.computeInitialRelativeRotation();
    }

    void dJointSetPistonAnchorOffset(DVector3C xyz, double dx, double dy, double dz) {
        if (this.isFlagsReverse()) {
            dx = -dx;
            dy = -dy;
            dz = -dz;
        }
        if (this.node[0].body != null) {
            this.node[0].body._posr.pos.sub(dx, dy, dz);
        }
        this.setAnchors(xyz, this.anchor1, this.anchor2);
        if (this.node[0].body != null) {
            this.node[0].body._posr.pos.add(dx, dy, dz);
        }
        this.computeInitialRelativeRotation();
    }

    public void dJointGetPistonAnchor(DVector3 result) {
        if (this.isFlagsReverse()) {
            this.getAnchor2(result, this.anchor2);
        } else {
            this.getAnchor(result, this.anchor1);
        }
    }

    void dJointGetPistonAnchor2(DVector3 result) {
        if (this.isFlagsReverse()) {
            this.getAnchor(result, this.anchor1);
        } else {
            this.getAnchor2(result, this.anchor2);
        }
    }

    void dJointSetPistonAxis(double x, double y, double z) {
        this.setAxes(x, y, z, this.axis1, this.axis2);
        this.computeInitialRelativeRotation();
    }

    void dJointSetPistonAxisDelta(double x, double y, double z, double dx, double dy, double dz) {
        this.setAxes(x, y, z, this.axis1, this.axis2);
        this.computeInitialRelativeRotation();
        DVector3 c = new DVector3(0.0, 0.0, 0.0);
        if (this.node[1].body != null) {
            c.eqDiff(this.node[0].body.posr().pos(), this.node[1].body.posr().pos()).sub(dx, dy, dz);
        } else if (this.node[0].body != null) {
            c.set(this.node[0].body.posr().pos()).sub(dx, dy, dz);
        }
        OdeMath.dMultiply1_331(this.anchor1, this.node[0].body.posr().R(), c);
    }

    void dJointGetPistonAxis(DVector3 result) {
        this.getAxis(result, this.axis1);
    }

    public void dJointSetPistonParam(DJoint.PARAM_N parameter, double value) {
        if (parameter.isGroup2()) {
            this.limotR.set(parameter.toSUB(), value);
        } else {
            this.limotP.set(parameter.toSUB(), value);
        }
    }

    public double dJointGetPistonParam(DJoint.PARAM_N parameter) {
        if (parameter.isGroup2()) {
            return this.limotR.get(parameter.toSUB());
        }
        return this.limotP.get(parameter.toSUB());
    }

    public void dJointAddPistonForce(double force) {
        if (this.isFlagsReverse()) {
            force -= force;
        }
        DVector3 axis = new DVector3();
        this.getAxis(axis, this.axis1);
        axis.scale(force);
        if (this.node[0].body != null) {
            this.node[0].body.dBodyAddForce(axis.get0(), axis.get1(), axis.get2());
        }
        if (this.node[1].body != null) {
            this.node[1].body.dBodyAddForce(-axis.get0(), -axis.get1(), -axis.get2());
        }
        if (this.node[0].body != null && this.node[1].body != null) {
            DVector3 ltd = new DVector3();
            DVector3 c = new DVector3();
            OdeMath.dMultiply0_331(c, this.node[0].body.posr().R(), (DVector3C)this.anchor1);
            OdeMath.dCalcVectorCross3(ltd, c, axis);
            this.node[0].body.dBodyAddTorque(ltd);
            OdeMath.dMultiply0_331(c, this.node[1].body.posr().R(), (DVector3C)this.anchor2);
            OdeMath.dCalcVectorCross3(ltd, c, axis);
            this.node[1].body.dBodyAddTorque(ltd);
        }
    }

    @Override
    void setRelativeValues() {
        DVector3 vec = new DVector3();
        this.dJointGetPistonAnchor(vec);
        this.setAnchors(vec, this.anchor1, this.anchor2);
        this.dJointGetPistonAxis(vec);
        this.setAxes(vec, this.axis1, this.axis2);
        this.computeInitialRelativeRotation();
    }

    private void computeInitialRelativeRotation() {
        if (this.node[0].body != null) {
            if (this.node[1].body != null) {
                Rotation.dQMultiply1(this.qrel, this.node[0].body._q, this.node[1].body._q);
            } else {
                this.qrel.set0(this.node[0].body._q.get0());
                int i = 1;
                while (i < 4) {
                    this.qrel.set(i, -this.node[0].body._q.get(i));
                    ++i;
                }
            }
        }
    }

    @Override
    public void setAnchor(double x, double y, double z) {
        this.dJointSetPistonAnchor(new DVector3(x, y, z));
    }

    @Override
    public void setAnchor(DVector3C a) {
        this.dJointSetPistonAnchor(a);
    }

    @Override
    public void getAnchor(DVector3 result) {
        this.dJointGetPistonAnchor(result);
    }

    @Override
    public void getAnchor2(DVector3 result) {
        this.dJointGetPistonAnchor2(result);
    }

    @Override
    public void setAxis(double x, double y, double z) {
        this.dJointSetPistonAxis(x, y, z);
    }

    @Override
    public void setAxis(DVector3C a) {
        this.dJointSetPistonAxis(a.get0(), a.get1(), a.get2());
    }

    @Override
    public void getAxis(DVector3 result) {
        this.dJointGetPistonAxis(result);
    }

    @Override
    public double getPosition() {
        return this.dJointGetPistonPosition();
    }

    @Override
    public double getPositionRate() {
        return this.dJointGetPistonPositionRate();
    }

    @Override
    public void setParam(DJoint.PARAM_N parameter, double value) {
        this.dJointSetPistonParam(parameter, value);
    }

    @Override
    public double getParam(DJoint.PARAM_N parameter) {
        return this.dJointGetPistonParam(parameter);
    }

    @Override
    public void addForce(double force) {
        this.dJointAddPistonForce(force);
    }

    @Override
    public double getParamHiStop2() {
        return this.dJointGetPistonParam(DJoint.PARAM_N.dParamHiStop2);
    }

    @Override
    public double getParamLoStop2() {
        return this.dJointGetPistonParam(DJoint.PARAM_N.dParamLoStop2);
    }

    @Override
    public void setParamHiStop2(double d) {
        this.dJointSetPistonParam(DJoint.PARAM_N.dParamHiStop2, d);
    }

    @Override
    public void setParamLoStop2(double d) {
        this.dJointSetPistonParam(DJoint.PARAM_N.dParamLoStop2, d);
    }

    @Override
    public double getAngle() {
        return this.dJointGetPistonAngle();
    }

    @Override
    public double getAngleRate() {
        return this.dJointGetPistonAngleRate();
    }

    @Override
    public void setAnchorOffset(DVector3C xyz, double dx, double dy, double dz) {
        this.dJointSetPistonAnchorOffset(xyz, dx, dy, dz);
    }
}

