/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal.joints;

import org.cpp4j.java.RefDouble;
import org.ode4j.math.DMatrix3C;
import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.DJoint;
import org.ode4j.ode.DPUJoint;
import org.ode4j.ode.OdeMath;
import org.ode4j.ode.internal.DxWorld;
import org.ode4j.ode.internal.joints.DxJoint;
import org.ode4j.ode.internal.joints.DxJointLimitMotor;
import org.ode4j.ode.internal.joints.DxJointUniversal;

public class DxJointPU
extends DxJointUniversal
implements DPUJoint {
    DVector3 axisP1 = new DVector3();
    public DxJointLimitMotor limotP = new DxJointLimitMotor();

    DxJointPU(DxWorld w) {
        super(w);
        this._axis1.set(0.0, 1.0, 0.0);
        this._anchor2.setZero();
        this._axis2.set(0.0, 0.0, 1.0);
        this.axisP1.set(1.0, 0.0, 0.0);
        this.qrel1.setZero();
        this.qrel2.setZero();
        this.limotP.init(this.world);
        this.limot1.init(this.world);
        this.limot2.init(this.world);
    }

    double dJointGetPUPosition() {
        DVector3 q = new DVector3();
        OdeMath.dMultiply0_331(q, this.node[0].body.posr().R(), (DVector3C)this._anchor1);
        if (this.node[1].body != null) {
            DVector3 anchor2 = new DVector3();
            OdeMath.dMultiply0_331(anchor2, this.node[1].body.posr().R(), (DVector3C)this._anchor2);
            q.add(this.node[0].body.posr().pos());
            q.sub(this.node[1].body.posr().pos());
            q.sub(anchor2);
        } else {
            q.add(this.node[0].body.posr().pos());
            q.sub(this._anchor2);
            if (this.isFlagsReverse()) {
                q.scale(-1.0);
            }
        }
        DVector3 axP = new DVector3();
        OdeMath.dMultiply0_331(axP, this.node[0].body.posr().R(), (DVector3C)this.axisP1);
        return OdeMath.dCalcVectorDot3(axP, q);
    }

    public double dJointGetPUPositionRate() {
        if (this.node[0].body != null) {
            DVector3 r = new DVector3();
            DVector3 anchor2 = new DVector3(0.0, 0.0, 0.0);
            if (this.node[1].body != null) {
                OdeMath.dMultiply0_331(anchor2, this.node[1].body.posr().R(), (DVector3C)this._anchor2);
                r.eqDiff(this.node[0].body.posr().pos(), this.node[1].body.posr().pos()).sub(anchor2);
            } else {
                r.eqDiff(this.node[0].body.posr().pos(), this._anchor2);
            }
            DVector3 lvel1 = new DVector3();
            OdeMath.dCalcVectorCross3(lvel1, r, this.node[0].body.avel);
            lvel1.add(this.node[0].body.lvel);
            DVector3 axP1 = new DVector3();
            OdeMath.dMultiply0_331(axP1, this.node[0].body.posr().R(), (DVector3C)this.axisP1);
            if (this.node[1].body != null) {
                DVector3 lvel2 = new DVector3();
                OdeMath.dCalcVectorCross3(lvel2, anchor2, this.node[1].body.avel);
                lvel1.sub(lvel2);
                lvel1.sub(this.node[1].body.lvel);
                return OdeMath.dCalcVectorDot3(axP1, lvel1);
            }
            double rate = axP1.dot(lvel1);
            return this.isFlagsReverse() ? -rate : rate;
        }
        return 0.0;
    }

    @Override
    void getSureMaxInfo(DxJoint.SureMaxInfo info) {
        info.max_m = 6;
    }

    @Override
    public void getInfo1(DxJoint.Info1 info) {
        info.setM(3);
        info.setNub(3);
        this.limotP.limit = 0;
        if ((this.limotP.lostop > Double.NEGATIVE_INFINITY || this.limotP.histop < Double.POSITIVE_INFINITY) && this.limotP.lostop <= this.limotP.histop) {
            double pos = this.dJointGetPUPosition();
            this.limotP.testRotationalLimit(pos);
        }
        if (this.limotP.limit != 0 || this.limotP.fmax > 0.0) {
            info.incM();
        }
        boolean limiting1 = (this.limot1.lostop >= -Math.PI || this.limot1.histop <= Math.PI) && this.limot1.lostop <= this.limot1.histop;
        boolean limiting2 = (this.limot2.lostop >= -Math.PI || this.limot2.histop <= Math.PI) && this.limot2.lostop <= this.limot2.histop;
        this.limot1.limit = 0;
        this.limot2.limit = 0;
        if (limiting1 || limiting2) {
            RefDouble angle1 = new RefDouble(0.0);
            RefDouble angle2 = new RefDouble(0.0);
            this.getAngles(angle1, angle2);
            if (limiting1) {
                this.limot1.testRotationalLimit(angle1.get());
            }
            if (limiting2) {
                this.limot2.testRotationalLimit(angle2.get());
            }
        }
        if (this.limot1.limit != 0 || this.limot1.fmax > 0.0) {
            info.incM();
        }
        if (this.limot2.limit != 0 || this.limot2.fmax > 0.0) {
            info.incM();
        }
    }

    @Override
    public void getInfo2(DxJoint.Info2 info) {
        boolean s0 = false;
        int s1 = info.rowskip();
        int s2 = 2 * s1;
        double k = info.fps * info.erp;
        DVector3C pos2 = null;
        DMatrix3C R2 = null;
        DVector3C pos1 = this.node[0].body.posr().pos();
        DMatrix3C R1 = this.node[0].body.posr().R();
        if (this.node[1].body != null) {
            pos2 = this.node[1].body.posr().pos();
            R2 = this.node[1].body.posr().R();
        }
        DVector3 axP = new DVector3();
        OdeMath.dMultiply0_331(axP, R1, (DVector3C)this.axisP1);
        DVector3 dist = new DVector3();
        DVector3 wanchor2 = new DVector3(0.0, 0.0, 0.0);
        if (this.node[1].body != null) {
            OdeMath.dMultiply0_331(wanchor2, R2, (DVector3C)this._anchor2);
            dist.eqSum(wanchor2, pos2).sub(pos1);
        } else if (this.isFlagsReverse()) {
            dist.eqDiff(pos1, this._anchor2);
        } else {
            dist.eqDiff(this._anchor2, pos1);
        }
        DVector3 q = new DVector3();
        DVector3 ax1 = new DVector3();
        DVector3 ax2 = new DVector3();
        this.getAxes(ax1, ax2);
        double val = OdeMath.dCalcVectorDot3(ax1, ax2);
        q.eqSum((DVector3C)ax2, ax1, -val);
        DVector3 p = new DVector3();
        OdeMath.dCalcVectorCross3(p, ax1, q);
        OdeMath.dNormalize3(p);
        OdeMath.dCopyVector3(info._J, info.J1ap + 0, (DVector3C)p);
        if (this.node[1].body != null) {
            OdeMath.dCopyNegatedVector3(info._J, info.J2ap + 0, p);
        }
        info.setC(0, k * -val);
        OdeMath.dCalcVectorCross3(q, ax1, axP);
        OdeMath.dMultiply0_331(axP, R1, (DVector3C)this.axisP1);
        OdeMath.dCalcVectorCross3(info._J, info.J1ap + s1, dist, ax1);
        OdeMath.dCalcVectorCross3(info._J, info.J1ap + s2, dist, q);
        OdeMath.dCopyVector3(info._J, info.J1lp + s1, (DVector3C)ax1);
        OdeMath.dCopyVector3(info._J, info.J1lp + s2, (DVector3C)q);
        if (this.node[1].body != null) {
            OdeMath.dCalcVectorCross3(info._J, info.J2ap + s1, ax1, wanchor2);
            OdeMath.dCalcVectorCross3(info._J, info.J2ap + s2, q, wanchor2);
            OdeMath.dCopyNegatedVector3(info._J, info.J2lp + s1, ax1);
            OdeMath.dCopyNegatedVector3(info._J, info.J2lp + s2, q);
        }
        DVector3 err = new DVector3();
        OdeMath.dMultiply0_331(err, R1, (DVector3C)this._anchor1);
        err.eqDiff(dist, err);
        info.setC(1, k * OdeMath.dCalcVectorDot3(ax1, err));
        info.setC(2, k * OdeMath.dCalcVectorDot3(q, err));
        int row = 3 + this.limot1.addLimot(this, info, 3, ax1, true);
        row += this.limot2.addLimot(this, info, row, ax2, true);
        if (this.node[1].body != null || !this.isFlagsReverse()) {
            this.limotP.addLimot(this, info, row, axP, false);
        } else {
            axP.scale(-1.0);
            this.limotP.addLimot(this, info, row, axP, false);
        }
    }

    public void dJointSetPUAnchor(double x, double y, double z) {
        this.dJointSetPUAnchor(new DVector3(x, y, z));
    }

    public void dJointSetPUAnchor(DVector3C xyz) {
        this.setAnchors(xyz, this._anchor1, this._anchor2);
        this.computeInitialRelativeRotations();
    }

    void dJointSetPUAnchorDelta(double x, double y, double z, double dx, double dy, double dz) {
        if (this.node[0].body != null) {
            this.node[0].body._posr.pos.add(dx, dy, dz);
        }
        this.setAnchors(new DVector3(x, y, z), this._anchor1, this._anchor2);
        if (this.node[0].body != null) {
            this.node[0].body._posr.pos.sub(dx, dy, dz);
        }
        this.computeInitialRelativeRotations();
    }

    void dJointSetPUAnchorOffset(double x, double y, double z, double dx, double dy, double dz) {
        DVector3 dxyz = new DVector3(dx, dy, dz);
        if (this.isFlagsReverse()) {
            dxyz.scale(-1.0);
        }
        if (this.node[0].body != null) {
            this.node[0].body._posr.pos.sub(dxyz);
        }
        this.setAnchors(dxyz, this._anchor1, this._anchor2);
        if (this.node[0].body != null) {
            this.node[0].body._posr.pos.add(dxyz);
        }
        this.computeInitialRelativeRotations();
    }

    public void dJointSetPUAxis1(double x, double y, double z) {
        if (this.isFlagsReverse()) {
            this.setAxes(x, y, z, null, this._axis2);
        } else {
            this.setAxes(x, y, z, this._axis1, null);
        }
        this.computeInitialRelativeRotations();
    }

    public void dJointSetPUAxis2(double x, double y, double z) {
        if (this.isFlagsReverse()) {
            this.setAxes(x, y, z, this._axis1, null);
        } else {
            this.setAxes(x, y, z, null, this._axis2);
        }
        this.computeInitialRelativeRotations();
    }

    public void dJointSetPUAxisP(double x, double y, double z) {
        this.dJointSetPUAxis3(x, y, z);
    }

    public void dJointSetPUAxis3(double x, double y, double z) {
        this.setAxes(x, y, z, this.axisP1, null);
        this.computeInitialRelativeRotations();
    }

    void dJointGetPUAngles(RefDouble angle1, RefDouble angle2) {
        if (this.isFlagsReverse()) {
            this.getAngles(angle2, angle1);
        } else {
            this.getAngles(angle1, angle2);
        }
    }

    double dJointGetPUAngle1() {
        if (this.isFlagsReverse()) {
            return this.getAngle2Internal();
        }
        return this.getAngle1Internal();
    }

    double dJointGetPUAngle2() {
        if (this.isFlagsReverse()) {
            return this.getAngle1Internal();
        }
        return this.getAngle2Internal();
    }

    double dJointGetPUAngle1Rate() {
        if (this.node[0].body != null) {
            DVector3 axis = new DVector3();
            if (this.isFlagsReverse()) {
                this.getAxis2(axis, this._axis2);
            } else {
                this.getAxis(axis, this._axis1);
            }
            double rate = OdeMath.dCalcVectorDot3(axis, this.node[0].body.avel);
            if (this.node[1].body != null) {
                rate -= OdeMath.dCalcVectorDot3(axis, this.node[1].body.avel);
            }
            return rate;
        }
        return 0.0;
    }

    double dJointGetPUAngle2Rate() {
        if (this.node[0].body != null) {
            DVector3 axis = new DVector3();
            if (this.isFlagsReverse()) {
                this.getAxis(axis, this._axis1);
            } else {
                this.getAxis2(axis, this._axis2);
            }
            double rate = OdeMath.dCalcVectorDot3(axis, this.node[0].body.avel);
            if (this.node[1].body != null) {
                rate -= OdeMath.dCalcVectorDot3(axis, this.node[1].body.avel);
            }
            return rate;
        }
        return 0.0;
    }

    public void dJointSetPUParam(DJoint.PARAM_N parameter, double value) {
        switch (parameter.toGROUP()) {
            case dParamGroup1: {
                this.limot1.set(parameter.toSUB(), value);
                break;
            }
            case dParamGroup2: {
                this.limot2.set(parameter.toSUB(), value);
                break;
            }
            case dParamGroup3: {
                this.limotP.set(parameter.toSUB(), value);
                break;
            }
            default: {
                throw new IllegalArgumentException(parameter.name());
            }
        }
    }

    public void dJointGetPUAnchor(DVector3 result) {
        if (this.node[1].body != null) {
            this.getAnchor2(result, this._anchor2);
        } else {
            result.set(this._anchor2);
        }
    }

    void dJointGetPUAxis1(DVector3 result) {
        if (this.isFlagsReverse()) {
            this.getAxis2(result, this._axis2);
        } else {
            this.getAxis(result, this._axis1);
        }
    }

    void dJointGetPUAxis2(DVector3 result) {
        if (this.isFlagsReverse()) {
            this.getAxis(result, this._axis1);
        } else {
            this.getAxis2(result, this._axis2);
        }
    }

    void dJointGetPUAxisP(DVector3 result) {
        this.dJointGetPUAxis3(result);
    }

    void dJointGetPUAxis3(DVector3 result) {
        this.getAxis(result, this.axisP1);
    }

    public double dJointGetPUParam(DJoint.PARAM_N parameter) {
        switch (parameter.toGROUP()) {
            case dParamGroup1: {
                return this.limot1.get(parameter.toSUB());
            }
            case dParamGroup2: {
                return this.limot2.get(parameter.toSUB());
            }
            case dParamGroup3: {
                return this.limotP.get(parameter.toSUB());
            }
        }
        throw new IllegalArgumentException(parameter.name());
    }

    @Override
    void setRelativeValues() {
        DVector3 anchor = new DVector3();
        this.dJointGetPUAnchor(anchor);
        this.setAnchors(anchor, this._anchor1, this._anchor2);
        DVector3 ax1 = new DVector3();
        DVector3 ax2 = new DVector3();
        DVector3 ax3 = new DVector3();
        this.dJointGetPUAxis1(ax1);
        this.dJointGetPUAxis2(ax2);
        this.dJointGetPUAxis3(ax3);
        if (this.isFlagsReverse()) {
            this.setAxes(ax1, null, this._axis2);
            this.setAxes(ax2, this._axis1, null);
        } else {
            this.setAxes(ax1, this._axis1, null);
            this.setAxes(ax2, null, this._axis2);
        }
        this.setAxes(ax3, null, this.axisP1);
        this.computeInitialRelativeRotations();
    }

    @Override
    public final void setAnchor(double x, double y, double z) {
        this.dJointSetPUAnchor(x, y, z);
    }

    @Override
    public final void setAnchor(DVector3C a) {
        this.dJointSetPUAnchor(a);
    }

    @Override
    public final void setAxis1(double x, double y, double z) {
        this.dJointSetPUAxis1(x, y, z);
    }

    @Override
    public final void setAxis1(DVector3C a) {
        this.setAxis1(a.get0(), a.get1(), a.get2());
    }

    @Override
    public final void setAxis2(double x, double y, double z) {
        this.dJointSetPUAxis2(x, y, z);
    }

    @Override
    public final void setAxis3(double x, double y, double z) {
        this.dJointSetPUAxis3(x, y, z);
    }

    @Override
    public final void setAxis3(DVector3C a) {
        this.setAxis3(a.get0(), a.get1(), a.get2());
    }

    @Override
    public final void setAxisP(double x, double y, double z) {
        this.dJointSetPUAxis3(x, y, z);
    }

    @Override
    public final void setAxisP(DVector3C a) {
        this.setAxisP(a.get0(), a.get1(), a.get2());
    }

    @Override
    public void getAnchor(DVector3 result) {
        this.dJointGetPUAnchor(result);
    }

    @Override
    public final void getAxis1(DVector3 result) {
        this.dJointGetPUAxis1(result);
    }

    @Override
    public final void getAxis2(DVector3 result) {
        this.dJointGetPUAxis2(result);
    }

    @Override
    public final void getAxis3(DVector3 result) {
        this.dJointGetPUAxis3(result);
    }

    @Override
    public final void getAxisP(DVector3 result) {
        this.dJointGetPUAxis3(result);
    }

    @Override
    public final double getAngle1() {
        return this.dJointGetPUAngle1();
    }

    @Override
    public final double getAngle1Rate() {
        return this.dJointGetPUAngle1Rate();
    }

    @Override
    public final double getAngle2() {
        return this.dJointGetPUAngle2();
    }

    @Override
    public final double getAngle2Rate() {
        return this.dJointGetPUAngle2Rate();
    }

    @Override
    public final double getPosition() {
        return this.dJointGetPUPosition();
    }

    @Override
    public final double getPositionRate() {
        return this.dJointGetPUPositionRate();
    }

    @Override
    public final void setParam(DJoint.PARAM_N parameter, double value) {
        this.dJointSetPUParam(parameter, value);
    }

    @Override
    public final double getParam(DJoint.PARAM_N parameter) {
        return this.dJointGetPUParam(parameter);
    }

    @Override
    public void setAnchorOffset(double x, double y, double z, double dx, double dy, double dz) {
        this.dJointSetPUAnchorOffset(x, y, z, dx, dy, dz);
    }
}

