/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal.joints;

import org.ode4j.math.DMatrix3;
import org.ode4j.math.DMatrix3C;
import org.ode4j.math.DQuaternion;
import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.DJoint;
import org.ode4j.ode.DPRJoint;
import org.ode4j.ode.OdeMath;
import org.ode4j.ode.internal.DxWorld;
import org.ode4j.ode.internal.Rotation;
import org.ode4j.ode.internal.joints.DxJoint;
import org.ode4j.ode.internal.joints.DxJointLimitMotor;

public class DxJointPR
extends DxJoint
implements DPRJoint {
    DVector3 _anchor2 = new DVector3();
    DVector3 axisR1 = new DVector3(1.0, 0.0, 0.0);
    DVector3 axisR2 = new DVector3(1.0, 0.0, 0.0);
    DVector3 axisP1 = new DVector3(0.0, 1.0, 0.0);
    DQuaternion qrel = new DQuaternion();
    DVector3 offset = new DVector3();
    public DxJointLimitMotor limotR = new DxJointLimitMotor();
    public DxJointLimitMotor limotP;

    DxJointPR(DxWorld w) {
        super(w);
        this.limotR.init(this.world);
        this.limotP = new DxJointLimitMotor();
        this.limotP.init(this.world);
    }

    double dJointGetPRPosition() {
        DVector3 q = new DVector3();
        OdeMath.dMultiply0_331(q, this.node[0].body.posr().R(), (DVector3C)this.offset);
        if (this.node[1].body != null) {
            DVector3 anchor2 = new DVector3();
            OdeMath.dMultiply0_331(anchor2, this.node[1].body.posr().R(), (DVector3C)this._anchor2);
            q.eqSum(this.node[0].body.posr().pos(), q).sub(this.node[1].body.posr().pos()).sub(anchor2);
        } else {
            q.eqSum(this.node[0].body.posr().pos(), q).sub(this._anchor2);
            if (this.isFlagsReverse()) {
                q.scale(-1.0);
            }
        }
        DVector3 axP = new DVector3();
        OdeMath.dMultiply0_331(axP, this.node[0].body.posr().R(), (DVector3C)this.axisP1);
        return OdeMath.dCalcVectorDot3(axP, q);
    }

    public double dJointGetPRPositionRate() {
        DVector3 ax1 = new DVector3();
        OdeMath.dMultiply0_331(ax1, this.node[0].body.posr().R(), (DVector3C)this.axisP1);
        if (this.node[1].body != null) {
            DVector3 lv2 = new DVector3();
            this.node[1].body.dBodyGetRelPointVel(this._anchor2, lv2);
            return OdeMath.dCalcVectorDot3(ax1, this.node[0].body.lvel) - OdeMath.dCalcVectorDot3(ax1, lv2);
        }
        double rate = ax1.dot(this.node[0].body.lvel);
        return this.isFlagsReverse() ? -rate : rate;
    }

    double dJointGetPRAngle() {
        if (this.node[0].body != null) {
            double ang = this.getHingeAngle(this.node[0].body, this.node[1].body, this.axisR1, this.qrel);
            if (this.isFlagsReverse()) {
                return -ang;
            }
            return ang;
        }
        return 0.0;
    }

    double dJointGetPRAngleRate() {
        if (this.node[0].body != null) {
            DVector3 axis = new DVector3();
            OdeMath.dMultiply0_331(axis, this.node[0].body.posr().R(), (DVector3C)this.axisR1);
            double rate = OdeMath.dCalcVectorDot3(axis, this.node[0].body.avel);
            if (this.node[1].body != null) {
                rate -= OdeMath.dCalcVectorDot3(axis, this.node[1].body.avel);
            }
            if (this.isFlagsReverse()) {
                rate = -rate;
            }
            return rate;
        }
        return 0.0;
    }

    @Override
    void getSureMaxInfo(DxJoint.SureMaxInfo info) {
        info.max_m = 6;
    }

    @Override
    public void getInfo1(DxJoint.Info1 info) {
        info.setNub(4);
        info.setM(4);
        this.limotP.limit = 0;
        if ((this.limotP.lostop > Double.NEGATIVE_INFINITY || this.limotP.histop < Double.POSITIVE_INFINITY) && this.limotP.lostop <= this.limotP.histop) {
            double pos = this.dJointGetPRPosition();
            this.limotP.testRotationalLimit(pos);
        }
        if (this.limotP.limit != 0 || this.limotP.fmax > 0.0) {
            info.incM();
        }
        this.limotR.limit = 0;
        if ((this.limotR.lostop >= -Math.PI || this.limotR.histop <= Math.PI) && this.limotR.lostop <= this.limotR.histop) {
            double angle = this.getHingeAngle(this.node[0].body, this.node[1].body, this.axisR1, this.qrel);
            this.limotR.testRotationalLimit(angle);
        }
        if (this.limotR.limit != 0 || this.limotR.fmax > 0.0) {
            info.incM();
        }
    }

    @Override
    public void getInfo2(DxJoint.Info2 info) {
        int s = info.rowskip();
        int s2 = 2 * s;
        int s3 = 3 * s;
        double k = info.fps * info.erp;
        DVector3 q = new DVector3();
        DVector3C pos2 = null;
        DMatrix3C R1 = new DMatrix3();
        DMatrix3C R2 = null;
        DVector3C pos1 = this.node[0].body.posr().pos();
        R1 = this.node[0].body.posr().R();
        if (this.node[1].body != null) {
            pos2 = this.node[1].body.posr().pos();
            R2 = this.node[1].body.posr().R();
        }
        DVector3 axP = new DVector3();
        OdeMath.dMultiply0_331(axP, R1, (DVector3C)this.axisP1);
        DVector3 wanchor2 = new DVector3(0.0, 0.0, 0.0);
        DVector3 dist = new DVector3();
        if (this.node[1].body != null) {
            OdeMath.dMultiply0_331(wanchor2, R2, (DVector3C)this._anchor2);
            dist.eqSum(wanchor2, pos2).sub(pos1);
        } else if (this.isFlagsReverse()) {
            dist.eqDiff(pos1, this._anchor2);
        } else {
            dist.eqDiff(this._anchor2, pos1);
        }
        DVector3 ax1 = new DVector3();
        OdeMath.dMultiply0_331(ax1, this.node[0].body.posr().R(), (DVector3C)this.axisR1);
        OdeMath.dCalcVectorCross3(q, ax1, axP);
        info._J[info.J1ap + 0] = axP.get0();
        info._J[info.J1ap + 1] = axP.get1();
        info._J[info.J1ap + 2] = axP.get2();
        info._J[info.J1ap + s + 0] = q.get0();
        info._J[info.J1ap + s + 1] = q.get1();
        info._J[info.J1ap + s + 2] = q.get2();
        if (this.node[1].body != null) {
            info._J[info.J2ap + 0] = -axP.get0();
            info._J[info.J2ap + 1] = -axP.get1();
            info._J[info.J2ap + 2] = -axP.get2();
            info._J[info.J2ap + s + 0] = -q.get0();
            info._J[info.J2ap + s + 1] = -q.get1();
            info._J[info.J2ap + s + 2] = -q.get2();
        }
        DVector3 ax2 = new DVector3();
        if (this.node[1].body != null) {
            OdeMath.dMultiply0_331(ax2, R2, (DVector3C)this.axisR2);
        } else {
            ax2.set(this.axisR2);
        }
        DVector3 b = new DVector3();
        OdeMath.dCalcVectorCross3(b, ax1, ax2);
        info.setC(0, k * OdeMath.dCalcVectorDot3(b, axP));
        info.setC(1, k * OdeMath.dCalcVectorDot3(b, q));
        OdeMath.dCalcVectorCross3(info._J, info.J1ap + s2, dist, ax1);
        OdeMath.dCalcVectorCross3(info._J, info.J1ap + s3, dist, q);
        info._J[info.J1lp + s2 + 0] = ax1.get0();
        info._J[info.J1lp + s2 + 1] = ax1.get1();
        info._J[info.J1lp + s2 + 2] = ax1.get2();
        info._J[info.J1lp + s3 + 0] = q.get0();
        info._J[info.J1lp + s3 + 1] = q.get1();
        info._J[info.J1lp + s3 + 2] = q.get2();
        if (this.node[1].body != null) {
            OdeMath.dCalcVectorCross3(info._J, info.J2ap + s2, ax2, wanchor2);
            OdeMath.dCalcVectorCross3(info._J, info.J2ap + s3, q, wanchor2);
            info._J[info.J2lp + s2 + 0] = -ax1.get0();
            info._J[info.J2lp + s2 + 1] = -ax1.get1();
            info._J[info.J2lp + s2 + 2] = -ax1.get2();
            info._J[info.J2lp + s3 + 0] = -q.get0();
            info._J[info.J2lp + s3 + 1] = -q.get1();
            info._J[info.J2lp + s3 + 2] = -q.get2();
        }
        DVector3 err = new DVector3();
        OdeMath.dMultiply0_331(err, R1, (DVector3C)this.offset);
        err.eqDiff(dist, err);
        info.setC(2, k * OdeMath.dCalcVectorDot3(ax1, err));
        info.setC(3, k * OdeMath.dCalcVectorDot3(q, err));
        int row = 4;
        if (this.node[1].body != null || !this.isFlagsReverse()) {
            row += this.limotP.addLimot(this, info, 4, axP, false);
        } else {
            DVector3 rAxP = new DVector3();
            rAxP.sub(axP);
            row += this.limotP.addLimot(this, info, 4, rAxP, false);
        }
        this.limotR.addLimot(this, info, row, ax1, true);
    }

    void computeInitialRelativeRotation() {
        if (this.node[0].body != null) {
            if (this.node[1].body != null) {
                Rotation.dQMultiply1(this.qrel, this.node[0].body._q, this.node[1].body._q);
            } else {
                this.qrel.set(0, this.node[0].body._q.get(0));
                int i = 1;
                while (i < 4) {
                    this.qrel.set(i, -this.node[0].body._q.get(i));
                    ++i;
                }
            }
        }
    }

    public void dJointSetPRAnchor(double x, double y, double z) {
        this.dJointSetPRAnchor(new DVector3(x, y, z));
    }

    public void dJointSetPRAnchor(DVector3C xyz) {
        this.setAnchors(xyz, this.offset, this._anchor2);
    }

    public void dJointSetPRAxis1(double x, double y, double z) {
        this.setAxes(x, y, z, this.axisP1, null);
        this.computeInitialRelativeRotation();
    }

    public void dJointSetPRAxis2(double x, double y, double z) {
        this.setAxes(x, y, z, this.axisR1, this.axisR2);
        this.computeInitialRelativeRotation();
    }

    public void dJointSetPRParam(DJoint.PARAM_N parameter, double value) {
        if (parameter.isGroup2()) {
            this.limotR.set(parameter.toSUB(), value);
        } else {
            this.limotP.set(parameter.toSUB(), value);
        }
    }

    public void dJointGetPRAnchor(DVector3 result) {
        if (this.node[1].body != null) {
            this.getAnchor2(result, this._anchor2);
        } else {
            result.set(this._anchor2);
        }
    }

    void dJointGetPRAxis1(DVector3 result) {
        this.getAxis(result, this.axisP1);
    }

    void dJointGetPRAxis2(DVector3 result) {
        this.getAxis(result, this.axisR1);
    }

    public double dJointGetPRParam(DJoint.PARAM_N parameter) {
        if (parameter.isGroup2()) {
            return this.limotR.get(parameter.toSUB());
        }
        return this.limotP.get(parameter.toSUB());
    }

    void dJointAddPRTorque(double torque) {
        DVector3 axis = new DVector3();
        if (this.isFlagsReverse()) {
            torque = -torque;
        }
        this.getAxis(axis, this.axisR1);
        axis.scale(torque);
        if (this.node[0].body != null) {
            this.node[0].body.dBodyAddTorque(axis.get0(), axis.get1(), axis.get2());
        }
        if (this.node[1].body != null) {
            this.node[1].body.dBodyAddTorque(-axis.get0(), -axis.get1(), -axis.get2());
        }
    }

    @Override
    void setRelativeValues() {
        DVector3 anchor = new DVector3();
        this.dJointGetPRAnchor(anchor);
        this.setAnchors(anchor, this.offset, this._anchor2);
        DVector3 axis = new DVector3();
        this.dJointGetPRAxis1(axis);
        this.setAxes(axis, this.axisP1, null);
        this.dJointGetPRAxis2(axis);
        this.setAxes(axis, this.axisR1, this.axisR2);
        this.computeInitialRelativeRotation();
    }

    @Override
    public void setAnchor(double x, double y, double z) {
        this.dJointSetPRAnchor(x, y, z);
    }

    @Override
    public void setAnchor(DVector3C a) {
        this.dJointSetPRAnchor(a);
    }

    @Override
    public void setAxis1(double x, double y, double z) {
        this.dJointSetPRAxis1(x, y, z);
    }

    @Override
    public void setAxis1(DVector3C a) {
        this.setAxis1(a.get0(), a.get1(), a.get2());
    }

    @Override
    public void setAxis2(double x, double y, double z) {
        this.dJointSetPRAxis2(x, y, z);
    }

    @Override
    public void setAxis2(DVector3C a) {
        this.setAxis2(a.get0(), a.get1(), a.get2());
    }

    @Override
    public void getAnchor(DVector3 result) {
        this.dJointGetPRAnchor(result);
    }

    @Override
    public void getAxis1(DVector3 result) {
        this.dJointGetPRAxis1(result);
    }

    @Override
    public void getAxis2(DVector3 result) {
        this.dJointGetPRAxis2(result);
    }

    @Override
    public double getAngle() {
        return this.dJointGetPRAngle();
    }

    @Override
    public double getAngleRate() {
        return this.dJointGetPRAngleRate();
    }

    @Override
    public double getPosition() {
        return this.dJointGetPRPosition();
    }

    @Override
    public double getPositionRate() {
        return this.dJointGetPRPositionRate();
    }

    @Override
    public void setParam(DJoint.PARAM_N parameter, double value) {
        this.dJointSetPRParam(parameter, value);
    }

    @Override
    public double getParam(DJoint.PARAM_N parameter) {
        return this.dJointGetPRParam(parameter);
    }

    @Override
    public void setParamHiStop(double d) {
        this.dJointSetPRParam(DJoint.PARAM_N.dParamHiStop1, d);
    }

    @Override
    public void setParamLoStop(double d) {
        this.dJointSetPRParam(DJoint.PARAM_N.dParamLoStop1, d);
    }

    @Override
    public void setParamHiStop2(double d) {
        this.dJointSetPRParam(DJoint.PARAM_N.dParamHiStop2, d);
    }

    @Override
    public void setParamLoStop2(double d) {
        this.dJointSetPRParam(DJoint.PARAM_N.dParamLoStop2, d);
    }

    @Override
    public void setParamFMax2(double d) {
        this.dJointSetPRParam(DJoint.PARAM_N.dParamFMax2, d);
    }

    @Override
    public void setParamVel2(double d) {
        this.dJointSetPRParam(DJoint.PARAM_N.dParamVel2, d);
    }

    @Override
    public void addTorque(double torque) {
        this.dJointAddPRTorque(torque);
    }
}

