/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal.joints;

import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.DJoint;
import org.ode4j.ode.OdeMath;
import org.ode4j.ode.internal.DxWorld;
import org.ode4j.ode.internal.joints.DxJoint;

public class DxJointLimitMotor {
    public double vel;
    public double fmax;
    public double lostop;
    public double histop;
    public double fudge_factor;
    public double normal_cfm;
    public double stop_erp;
    double stop_cfm;
    public double bounce;
    public int limit;
    double limit_err;

    public void init(DxWorld world) {
        this.vel = 0.0;
        this.fmax = 0.0;
        this.lostop = Double.NEGATIVE_INFINITY;
        this.histop = Double.POSITIVE_INFINITY;
        this.fudge_factor = 1.0;
        this.normal_cfm = world.getCFM();
        this.stop_erp = world.getERP();
        this.stop_cfm = world.getCFM();
        this.bounce = 0.0;
        this.limit = 0;
        this.limit_err = 0.0;
    }

    public void set(DJoint.PARAM num, double value) {
        switch (num) {
            case dParamLoStop: {
                this.lostop = value;
                break;
            }
            case dParamHiStop: {
                this.histop = value;
                break;
            }
            case dParamVel: {
                this.vel = value;
                break;
            }
            case dParamFMax: {
                if (!(value >= 0.0)) break;
                this.fmax = value;
                break;
            }
            case dParamFudgeFactor: {
                if (!(value >= 0.0) || !(value <= 1.0)) break;
                this.fudge_factor = value;
                break;
            }
            case dParamBounce: {
                this.bounce = value;
                break;
            }
            case dParamCFM: {
                this.normal_cfm = value;
                break;
            }
            case dParamStopERP: {
                this.stop_erp = value;
                break;
            }
            case dParamStopCFM: {
                this.stop_cfm = value;
                break;
            }
            default: {
                throw new IllegalArgumentException(num.name());
            }
        }
    }

    public double get(DJoint.PARAM num) {
        switch (num) {
            case dParamLoStop: {
                return this.lostop;
            }
            case dParamHiStop: {
                return this.histop;
            }
            case dParamVel: {
                return this.vel;
            }
            case dParamFMax: {
                return this.fmax;
            }
            case dParamFudgeFactor: {
                return this.fudge_factor;
            }
            case dParamBounce: {
                return this.bounce;
            }
            case dParamCFM: {
                return this.normal_cfm;
            }
            case dParamStopERP: {
                return this.stop_erp;
            }
            case dParamStopCFM: {
                return this.stop_cfm;
            }
        }
        throw new IllegalArgumentException(num.name());
    }

    public boolean testRotationalLimit(double angle) {
        if (angle <= this.lostop) {
            this.limit = 1;
            this.limit_err = angle - this.lostop;
            return true;
        }
        if (angle >= this.histop) {
            this.limit = 2;
            this.limit_err = angle - this.histop;
            return true;
        }
        this.limit = 0;
        return false;
    }

    public int addLimot(DxJoint joint, DxJoint.Info2 info, int row, DVector3C ax1, boolean rotational) {
        boolean powered;
        int srow = row * info.rowskip();
        boolean bl = powered = this.fmax > 0.0;
        if (powered || this.limit != 0) {
            if (rotational) {
                info._J[info.J1ap + srow + 0] = ax1.get0();
                info._J[info.J1ap + srow + 1] = ax1.get1();
                info._J[info.J1ap + srow + 2] = ax1.get2();
                if (joint.node[1].body != null) {
                    info._J[info.J2ap + srow + 0] = -ax1.get0();
                    info._J[info.J2ap + srow + 1] = -ax1.get1();
                    info._J[info.J2ap + srow + 2] = -ax1.get2();
                }
            } else {
                info._J[info.J1lp + srow + 0] = ax1.get0();
                info._J[info.J1lp + srow + 1] = ax1.get1();
                info._J[info.J1lp + srow + 2] = ax1.get2();
                if (joint.node[1].body != null) {
                    info._J[info.J2lp + srow + 0] = -ax1.get0();
                    info._J[info.J2lp + srow + 1] = -ax1.get1();
                    info._J[info.J2lp + srow + 2] = -ax1.get2();
                }
            }
            DVector3 ltd = new DVector3(0.0, 0.0, 0.0);
            if (!rotational && joint.node[1].body != null) {
                DVector3 c = new DVector3();
                c.eqDiff(joint.node[1].body.posr().pos(), joint.node[0].body.posr().pos()).scale(0.5);
                OdeMath.dCalcVectorCross3(ltd, c, ax1);
                info._J[info.J1ap + srow + 0] = ltd.get0();
                info._J[info.J1ap + srow + 1] = ltd.get1();
                info._J[info.J1ap + srow + 2] = ltd.get2();
                info._J[info.J2ap + srow + 0] = ltd.get0();
                info._J[info.J2ap + srow + 1] = ltd.get1();
                info._J[info.J2ap + srow + 2] = ltd.get2();
            }
            if (this.limit != 0 && this.lostop == this.histop) {
                powered = false;
            }
            if (powered) {
                info.setCfm(row, this.normal_cfm);
                if (this.limit == 0) {
                    info.setC(row, this.vel);
                    info.setLo(row, -this.fmax);
                    info.setHi(row, this.fmax);
                } else {
                    double fm = this.fmax;
                    if (this.vel > 0.0 || this.vel == 0.0 && this.limit == 2) {
                        fm = -fm;
                    }
                    if (this.limit == 1 && this.vel > 0.0 || this.limit == 2 && this.vel < 0.0) {
                        fm *= this.fudge_factor;
                    }
                    if (rotational) {
                        joint.node[0].body.dBodyAddTorque(-fm * ax1.get0(), -fm * ax1.get1(), -fm * ax1.get2());
                        if (joint.node[1].body != null) {
                            joint.node[1].body.dBodyAddTorque(fm * ax1.get0(), fm * ax1.get1(), fm * ax1.get2());
                        }
                    } else {
                        joint.node[0].body.dBodyAddForce(-fm * ax1.get0(), -fm * ax1.get1(), -fm * ax1.get2());
                        if (joint.node[1].body != null) {
                            joint.node[1].body.dBodyAddForce(fm * ax1.get0(), fm * ax1.get1(), fm * ax1.get2());
                            joint.node[0].body.dBodyAddTorque(-fm * ltd.get0(), -fm * ltd.get1(), -fm * ltd.get2());
                            joint.node[1].body.dBodyAddTorque(-fm * ltd.get0(), -fm * ltd.get1(), -fm * ltd.get2());
                        }
                    }
                }
            }
            if (this.limit != 0) {
                double k = info.fps * this.stop_erp;
                info.setC(row, -k * this.limit_err);
                info.setCfm(row, this.stop_cfm);
                if (this.lostop == this.histop) {
                    info.setLo(row, Double.NEGATIVE_INFINITY);
                    info.setHi(row, Double.POSITIVE_INFINITY);
                } else {
                    if (this.limit == 1) {
                        info.setLo(row, 0.0);
                        info.setHi(row, Double.POSITIVE_INFINITY);
                    } else {
                        info.setLo(row, Double.NEGATIVE_INFINITY);
                        info.setHi(row, 0.0);
                    }
                    if (this.bounce > 0.0) {
                        double newc;
                        double vel;
                        if (rotational) {
                            vel = joint.node[0].body.avel.dot(ax1);
                            if (joint.node[1].body != null) {
                                vel -= joint.node[1].body.avel.dot(ax1);
                            }
                        } else {
                            vel = joint.node[0].body.lvel.dot(ax1);
                            if (joint.node[1].body != null) {
                                vel -= joint.node[1].body.lvel.dot(ax1);
                            }
                        }
                        if (this.limit == 1) {
                            double newc2;
                            if (vel < 0.0 && (newc2 = -this.bounce * vel) > info.getC(row)) {
                                info.setC(row, newc2);
                            }
                        } else if (vel > 0.0 && (newc = -this.bounce * vel) < info.getC(row)) {
                            info.setC(row, newc);
                        }
                    }
                }
            }
            return 1;
        }
        return 0;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int i) {
        this.limit = i;
    }

    public double getLostop() {
        return this.lostop;
    }
}

