/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal.joints;

import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.DJoint;
import org.ode4j.ode.DLMotorJoint;
import org.ode4j.ode.OdeMath;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DxWorld;
import org.ode4j.ode.internal.joints.DxJoint;
import org.ode4j.ode.internal.joints.DxJointLimitMotor;

public class DxJointLMotor
extends DxJoint
implements DLMotorJoint {
    private int num = 0;
    private final int[] _rel = new int[3];
    private final DVector3[] axis = new DVector3[3];
    private final DxJointLimitMotor[] limot = new DxJointLimitMotor[3];

    DxJointLMotor(DxWorld w) {
        super(w);
        int i = 0;
        while (i < 3) {
            this.axis[i] = new DVector3();
            this.limot[i] = new DxJointLimitMotor();
            this.limot[i].init(this.world);
            ++i;
        }
    }

    void computeGlobalAxes(DVector3[] ax) {
        int i = 0;
        while (i < this.num) {
            if (this._rel[i] == 1) {
                OdeMath.dMultiply0_331(ax[i], this.node[0].body.posr().R(), (DVector3C)this.axis[i]);
            } else if (this._rel[i] == 2) {
                if (this.node[1].body != null) {
                    OdeMath.dMultiply0_331(ax[i], this.node[1].body.posr().R(), (DVector3C)this.axis[i]);
                }
            } else {
                ax[i].set(this.axis[i]);
            }
            ++i;
        }
    }

    @Override
    void getSureMaxInfo(DxJoint.SureMaxInfo info) {
        info.max_m = this.num;
    }

    @Override
    public void getInfo1(DxJoint.Info1 info) {
        info.setM(0);
        info.setNub(0);
        int i = 0;
        while (i < this.num) {
            if (this.limot[i].fmax > 0.0) {
                info.incM();
            }
            ++i;
        }
    }

    @Override
    public void getInfo2(DxJoint.Info2 info) {
        int row = 0;
        DVector3[] ax = new DVector3[3];
        int i = 0;
        while (i < 3) {
            ax[i] = new DVector3();
            ++i;
        }
        this.computeGlobalAxes(ax);
        i = 0;
        while (i < this.num) {
            row += this.limot[i].addLimot(this, info, row, ax[i], false);
            ++i;
        }
    }

    public void dJointSetLMotorAxis(int anum, int rel, double x, double y, double z) {
        this.dJointSetLMotorAxis(anum, rel, new DVector3(x, y, z));
    }

    public void dJointSetLMotorAxis(int anum, int rel, DVector3C r) {
        Common.dAASSERT(anum >= 0 && anum <= 2 && rel >= 0 && rel <= 2);
        if (anum < 0) {
            anum = 0;
        }
        if (anum > 2) {
            anum = 2;
        }
        if (this.node[1].body == null && rel == 2) {
            rel = 1;
        }
        this._rel[anum] = rel;
        if (rel > 0) {
            if (rel == 1) {
                OdeMath.dMultiply1_331(this.axis[anum], this.node[0].body.posr().R(), r);
            } else {
                OdeMath.dMultiply1_331(this.axis[anum], this.node[1].body.posr().R(), r);
            }
        } else {
            this.axis[anum].set(r);
        }
        OdeMath.dNormalize3(this.axis[anum]);
    }

    public void dJointSetLMotorNumAxes(int num) {
        if (num < 0) {
            num = 0;
        }
        if (num > 3) {
            num = 3;
        }
        this.num = num;
    }

    public void dJointSetLMotorParam(DJoint.PARAM_N parameter, double value) {
        int anum = parameter.toGROUP().getIndex();
        if (anum < 0) {
            anum = 0;
        }
        if (anum > 2) {
            anum = 2;
        }
        this.limot[anum].set(parameter.toSUB(), value);
    }

    int dJointGetLMotorNumAxes() {
        return this.num;
    }

    void dJointGetLMotorAxis(int anum, DVector3 result) {
        Common.dAASSERT(anum >= 0 && anum < 3);
        if (anum < 0) {
            anum = 0;
        }
        if (anum > 2) {
            anum = 2;
        }
        result.set(this.axis[anum]);
    }

    public double dJointGetLMotorParam(DJoint.PARAM_N parameter) {
        int anum = parameter.toGROUP().getIndex();
        if (anum < 0) {
            anum = 0;
        }
        if (anum > 2) {
            anum = 2;
        }
        return this.limot[anum].get(parameter.toSUB());
    }

    @Override
    public void setNumAxes(int num) {
        this.dJointSetLMotorNumAxes(num);
    }

    @Override
    public int getNumAxes() {
        return this.dJointGetLMotorNumAxes();
    }

    @Override
    public void setAxis(int anum, int rel, double x, double y, double z) {
        this.dJointSetLMotorAxis(anum, rel, x, y, z);
    }

    @Override
    public void setAxis(int anum, int rel, DVector3C a) {
        this.dJointSetLMotorAxis(anum, rel, a);
    }

    @Override
    public void getAxis(int anum, DVector3 result) {
        this.dJointGetLMotorAxis(anum, result);
    }

    @Override
    public void setParam(DJoint.PARAM_N parameter, double value) {
        this.dJointSetLMotorParam(parameter, value);
    }

    @Override
    public double getParam(DJoint.PARAM_N parameter) {
        return this.dJointGetLMotorParam(parameter);
    }

    @Override
    public void setParamFMax(double d) {
        this.dJointSetLMotorParam(DJoint.PARAM_N.dParamFMax1, d);
    }

    @Override
    public void setParamFMax2(double d) {
        this.dJointSetLMotorParam(DJoint.PARAM_N.dParamFMax2, d);
    }

    @Override
    public void setParamFMax3(double d) {
        this.dJointSetLMotorParam(DJoint.PARAM_N.dParamFMax3, d);
    }

    @Override
    public void setParamVel(double d) {
        this.dJointSetLMotorParam(DJoint.PARAM_N.dParamVel1, d);
    }

    @Override
    public void setParamVel2(double d) {
        this.dJointSetLMotorParam(DJoint.PARAM_N.dParamVel2, d);
    }

    @Override
    public void setParamVel3(double d) {
        this.dJointSetLMotorParam(DJoint.PARAM_N.dParamVel3, d);
    }

    @Override
    public double getParamFMax() {
        return this.dJointGetLMotorParam(DJoint.PARAM_N.dParamFMax1);
    }

    @Override
    public double getParamFMax2() {
        return this.dJointGetLMotorParam(DJoint.PARAM_N.dParamFMax2);
    }

    @Override
    public double getParamFMax3() {
        return this.dJointGetLMotorParam(DJoint.PARAM_N.dParamFMax3);
    }

    @Override
    public double getParamVel() {
        return this.dJointGetLMotorParam(DJoint.PARAM_N.dParamVel1);
    }

    @Override
    public double getParamVel2() {
        return this.dJointGetLMotorParam(DJoint.PARAM_N.dParamVel2);
    }

    @Override
    public double getParamVel3() {
        return this.dJointGetLMotorParam(DJoint.PARAM_N.dParamVel3);
    }
}

