/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal.joints;

import org.cpp4j.java.RefDouble;
import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.DHinge2Joint;
import org.ode4j.ode.DJoint;
import org.ode4j.ode.OdeMath;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DxWorld;
import org.ode4j.ode.internal.joints.DxJoint;
import org.ode4j.ode.internal.joints.DxJointLimitMotor;

public class DxJointHinge2
extends DxJoint
implements DHinge2Joint {
    DVector3 anchor1 = new DVector3();
    DVector3 anchor2 = new DVector3();
    DVector3 _axis1 = new DVector3(1.0, 0.0, 0.0);
    DVector3 _axis2 = new DVector3(0.0, 1.0, 0.0);
    double c0 = 0.0;
    double s0 = 0.0;
    DVector3 v1 = new DVector3(1.0, 0.0, 0.0);
    DVector3 v2 = new DVector3(0.0, 1.0, 0.0);
    DxJointLimitMotor limot1 = new DxJointLimitMotor();
    DxJointLimitMotor limot2;
    double susp_erp;
    double susp_cfm;

    double measureAngle() {
        DVector3 a1 = new DVector3();
        DVector3 a2 = new DVector3();
        OdeMath.dMultiply0_331(a1, this.node[1].body.posr().R(), (DVector3C)this._axis2);
        OdeMath.dMultiply1_331(a2, this.node[0].body.posr().R(), a1);
        double x = this.v1.dot(a2);
        double y = this.v2.dot(a2);
        return -Common.dAtan2(y, x);
    }

    DxJointHinge2(DxWorld w) {
        super(w);
        this.limot1.init(this.world);
        this.limot2 = new DxJointLimitMotor();
        this.limot2.init(this.world);
        this.susp_erp = this.world.getERP();
        this.susp_cfm = this.world.getCFM();
        this.setFlagsTwoBodies();
    }

    @Override
    void getSureMaxInfo(DxJoint.SureMaxInfo info) {
        info.max_m = 6;
    }

    @Override
    public void getInfo1(DxJoint.Info1 info) {
        info.setM(4);
        info.setNub(4);
        this.limot1.setLimit(0);
        if ((this.limot1.getLostop() >= -Math.PI || this.limot1.histop <= Math.PI) && this.limot1.getLostop() <= this.limot1.histop) {
            double angle = this.measureAngle();
            this.limot1.testRotationalLimit(angle);
        }
        if (this.limot1.getLimit() != 0 || this.limot1.fmax > 0.0) {
            info.incM();
        }
        this.limot2.setLimit(0);
        if (this.limot2.fmax > 0.0) {
            info.incM();
        }
    }

    private void getAxisInfo(DVector3 ax1, DVector3 ax2, DVector3 axCross, RefDouble sin_angle, RefDouble cos_angle) {
        OdeMath.dMultiply0_331(ax1, this.node[0].body.posr().R(), (DVector3C)this._axis1);
        OdeMath.dMultiply0_331(ax2, this.node[1].body.posr().R(), (DVector3C)this._axis2);
        OdeMath.dCalcVectorCross3(axCross, ax1, ax2);
        sin_angle.d = axCross.length();
        cos_angle.d = ax1.dot(ax2);
    }

    @Override
    public void getInfo2(DxJoint.Info2 info) {
        DVector3 q = new DVector3();
        DxJointHinge2 joint = this;
        DVector3 ax1 = new DVector3();
        DVector3 ax2 = new DVector3();
        RefDouble s = new RefDouble(0.0);
        RefDouble c = new RefDouble(0.0);
        this.getAxisInfo(ax1, ax2, q, s, c);
        OdeMath.dNormalize3(q);
        this.setBall2(this, info, this.anchor1, this.anchor2, ax1, this.susp_erp);
        int s3 = 3 * info.rowskip();
        q.wrapSet(info._J, info.J1ap + s3);
        if (joint.node[1].body != null) {
            q.wrapSub(info._J, info.J2ap + s3);
        }
        double k = info.fps * info.erp;
        info.setC(3, k * (this.c0 * s.get() - joint.s0 * c.get()));
        int row = 4 + this.limot1.addLimot(this, info, 4, ax1, true);
        this.limot2.addLimot(this, info, row, ax2, true);
        info.setCfm(0, this.susp_cfm);
    }

    void makeV1andV2() {
        if (this.node[0].body != null) {
            DVector3 ax1 = new DVector3();
            DVector3 ax2 = new DVector3();
            DVector3 v = new DVector3();
            OdeMath.dMultiply0_331(ax1, this.node[0].body.posr().R(), (DVector3C)this._axis1);
            OdeMath.dMultiply0_331(ax2, this.node[1].body.posr().R(), (DVector3C)this._axis2);
            if (ax1.get0() == 0.0 && ax1.get1() == 0.0 && ax1.get2() == 0.0 || ax2.get0() == 0.0 && ax2.get1() == 0.0 && ax2.get2() == 0.0 || ax1.get0() == ax2.get0() && ax1.get1() == ax2.get1() && ax1.get2() == ax2.get2()) {
                return;
            }
            double k = ax1.dot(ax2);
            ax2.eqSum((DVector3C)ax2, ax1, -k);
            OdeMath.dNormalize3(ax2);
            OdeMath.dCalcVectorCross3(v, ax1, ax2);
            OdeMath.dMultiply1_331(this.v1, this.node[0].body.posr().R(), ax2);
            OdeMath.dMultiply1_331(this.v2, this.node[0].body.posr().R(), v);
        }
    }

    public void dJointSetHinge2Anchor(double x, double y, double z) {
        this.dJointSetHinge2Anchor(new DVector3(x, y, z));
    }

    public void dJointSetHinge2Anchor(DVector3C xyz) {
        this.setAnchors(xyz, this.anchor1, this.anchor2);
        this.makeV1andV2();
    }

    public void dJointSetHinge2Axis1(double x, double y, double z) {
        if (this.node[0].body != null) {
            this.setAxes(x, y, z, this._axis1, null);
            DVector3 ax1 = new DVector3();
            DVector3 ax2 = new DVector3();
            DVector3 ax = new DVector3();
            RefDouble s0MD = new RefDouble(this.s0);
            RefDouble c0MD = new RefDouble(this.c0);
            this.getAxisInfo(ax1, ax2, ax, s0MD, c0MD);
            this.c0 = c0MD.get();
            this.s0 = s0MD.get();
        }
        this.makeV1andV2();
    }

    public void dJointSetHinge2Axis2(double x, double y, double z) {
        if (this.node[1].body != null) {
            this.setAxes(x, y, z, null, this._axis2);
            DVector3 ax1 = new DVector3();
            DVector3 ax2 = new DVector3();
            DVector3 ax = new DVector3();
            RefDouble s0MD = new RefDouble(this.s0);
            RefDouble c0MD = new RefDouble(this.c0);
            this.getAxisInfo(ax1, ax2, ax, s0MD, c0MD);
            this.c0 = c0MD.get();
            this.s0 = s0MD.get();
        }
        this.makeV1andV2();
    }

    public void dJointSetHinge2Param(DJoint.PARAM_N parameter, double value) {
        if (parameter.isGroup2()) {
            this.limot2.set(parameter.toSUB(), value);
        } else if (parameter.toSUB() == DJoint.PARAM.dParamSuspensionERP) {
            this.susp_erp = value;
        } else if (parameter.toSUB() == DJoint.PARAM.dParamSuspensionCFM) {
            this.susp_cfm = value;
        } else {
            this.limot1.set(parameter.toSUB(), value);
        }
    }

    private void dJointGetHinge2Anchor(DVector3 result) {
        if (this.isFlagsReverse()) {
            this.getAnchor2(result, this.anchor2);
        } else {
            this.getAnchor(result, this.anchor1);
        }
    }

    private void dJointGetHinge2Anchor2(DVector3 result) {
        if (this.isFlagsReverse()) {
            this.getAnchor(result, this.anchor1);
        } else {
            this.getAnchor2(result, this.anchor2);
        }
    }

    private void dJointGetHinge2Axis1(DVector3 result) {
        if (this.node[0].body != null) {
            OdeMath.dMultiply0_331(result, this.node[0].body.posr().R(), (DVector3C)this._axis1);
        }
    }

    private void dJointGetHinge2Axis2(DVector3 result) {
        if (this.node[1].body != null) {
            OdeMath.dMultiply0_331(result, this.node[1].body.posr().R(), (DVector3C)this._axis2);
        }
    }

    private double dJointGetHinge2Param(DJoint.PARAM_N parameter) {
        if (parameter.isGroup2()) {
            return this.limot2.get(parameter.toSUB());
        }
        if (parameter.toSUB() == DJoint.PARAM.dParamSuspensionERP) {
            return this.susp_erp;
        }
        if (parameter.toSUB() == DJoint.PARAM.dParamSuspensionCFM) {
            return this.susp_cfm;
        }
        return this.limot1.get(parameter.toSUB());
    }

    public double dJointGetHinge2Angle1() {
        if (this.node[0].body != null) {
            return this.measureAngle();
        }
        return 0.0;
    }

    public double dJointGetHinge2Angle1Rate() {
        if (this.node[0].body != null) {
            DVector3 axis = new DVector3();
            OdeMath.dMultiply0_331(axis, this.node[0].body.posr().R(), (DVector3C)this._axis1);
            double rate = OdeMath.dCalcVectorDot3(axis, this.node[0].body.avel);
            if (this.node[1].body != null) {
                rate -= OdeMath.dCalcVectorDot3(axis, this.node[1].body.avel);
            }
            return rate;
        }
        return 0.0;
    }

    public double dJointGetHinge2Angle2Rate() {
        if (this.node[0].body != null && this.node[1].body != null) {
            DVector3 axis = new DVector3();
            OdeMath.dMultiply0_331(axis, this.node[1].body.posr().R(), (DVector3C)this._axis2);
            double rate = OdeMath.dCalcVectorDot3(axis, this.node[0].body.avel);
            if (this.node[1].body != null) {
                rate -= OdeMath.dCalcVectorDot3(axis, this.node[1].body.avel);
            }
            return rate;
        }
        return 0.0;
    }

    private void dJointAddHinge2Torques(double torque1, double torque2) {
        if (this.node[0].body != null && this.node[1].body != null) {
            DVector3 axis1 = new DVector3();
            DVector3 axis2 = new DVector3();
            OdeMath.dMultiply0_331(axis1, this.node[0].body.posr().R(), (DVector3C)this._axis1);
            OdeMath.dMultiply0_331(axis2, this.node[1].body.posr().R(), (DVector3C)this._axis2);
            axis1.eqSum(axis1, torque1, (DVector3C)axis2, torque2);
            this.node[0].body.dBodyAddTorque(axis1);
            this.node[1].body.dBodyAddTorque(axis1.reScale(-1.0));
        }
    }

    @Override
    void setRelativeValues() {
        DVector3 anchor = new DVector3();
        this.dJointGetHinge2Anchor(anchor);
        this.setAnchors(anchor, this.anchor1, this.anchor2);
        DVector3 axis = new DVector3();
        if (this.node[0].body != null) {
            this.dJointGetHinge2Axis1(axis);
            this.setAxes(axis, this._axis1, null);
        }
        if (this.node[0].body != null) {
            this.dJointGetHinge2Axis2(axis);
            this.setAxes(axis, null, this._axis2);
        }
        DVector3 ax1 = new DVector3();
        DVector3 ax2 = new DVector3();
        RefDouble s0R = new RefDouble(this.s0);
        RefDouble c0R = new RefDouble(this.c0);
        this.getAxisInfo(ax1, ax2, axis, s0R, c0R);
        this.s0 = s0R.d;
        this.c0 = c0R.d;
        this.makeV1andV2();
    }

    public DxJointLimitMotor getLimot1() {
        return this.limot1;
    }

    public DxJointLimitMotor getLimot2() {
        return this.limot2;
    }

    @Override
    public void setAnchor(double x, double y, double z) {
        this.dJointSetHinge2Anchor(x, y, z);
    }

    @Override
    public void setAnchor(DVector3C a) {
        this.dJointSetHinge2Anchor(a);
    }

    @Override
    public void setAxis1(double x, double y, double z) {
        this.dJointSetHinge2Axis1(x, y, z);
    }

    @Override
    public void setAxis1(DVector3C a) {
        this.setAxis1(a.get0(), a.get1(), a.get2());
    }

    @Override
    public void setAxis2(double x, double y, double z) {
        this.dJointSetHinge2Axis2(x, y, z);
    }

    @Override
    public void setAxis2(DVector3C a) {
        this.setAxis2(a.get0(), a.get1(), a.get2());
    }

    @Override
    public void getAnchor(DVector3 result) {
        this.dJointGetHinge2Anchor(result);
    }

    @Override
    public void getAnchor2(DVector3 result) {
        this.dJointGetHinge2Anchor2(result);
    }

    @Override
    public void getAxis1(DVector3 result) {
        this.dJointGetHinge2Axis1(result);
    }

    @Override
    public void getAxis2(DVector3 result) {
        this.dJointGetHinge2Axis2(result);
    }

    @Override
    public double getAngle1() {
        return this.dJointGetHinge2Angle1();
    }

    @Override
    public double getAngle1Rate() {
        return this.dJointGetHinge2Angle1Rate();
    }

    @Override
    public double getAngle2Rate() {
        return this.dJointGetHinge2Angle2Rate();
    }

    @Override
    public void setParam(DJoint.PARAM_N parameter, double value) {
        this.dJointSetHinge2Param(parameter, value);
    }

    @Override
    public double getParam(DJoint.PARAM_N parameter) {
        return this.dJointGetHinge2Param(parameter);
    }

    @Override
    public void addTorques(double torque1, double torque2) {
        this.dJointAddHinge2Torques(torque1, torque2);
    }

    @Override
    public void setParamFMax2(double d) {
        this.dJointSetHinge2Param(DJoint.PARAM_N.dParamFMax2, d);
    }

    @Override
    public void setParamFudgeFactor(double d) {
        this.dJointSetHinge2Param(DJoint.PARAM_N.dParamFudgeFactor1, d);
    }

    @Override
    public void setParamHiStop(double d) {
        this.dJointSetHinge2Param(DJoint.PARAM_N.dParamHiStop1, d);
    }

    @Override
    public void setParamLoStop(double d) {
        this.dJointSetHinge2Param(DJoint.PARAM_N.dParamLoStop1, d);
    }

    @Override
    public void setParamFMax(double d) {
        this.dJointSetHinge2Param(DJoint.PARAM_N.dParamFMax1, d);
    }

    @Override
    public void setParamSuspensionCFM(double d) {
        this.dJointSetHinge2Param(DJoint.PARAM_N.dParamSuspensionCFM1, d);
    }

    @Override
    public void setParamSuspensionERP(double d) {
        this.dJointSetHinge2Param(DJoint.PARAM_N.dParamSuspensionERP1, d);
    }

    @Override
    public void setParamVel(double d) {
        this.dJointSetHinge2Param(DJoint.PARAM_N.dParamVel1, d);
    }

    @Override
    public void setParamVel2(double d) {
        this.dJointSetHinge2Param(DJoint.PARAM_N.dParamVel2, d);
    }
}

