/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal.joints;

import org.ode4j.math.DQuaternion;
import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.DHingeJoint;
import org.ode4j.ode.DJoint;
import org.ode4j.ode.OdeMath;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DxWorld;
import org.ode4j.ode.internal.Rotation;
import org.ode4j.ode.internal.joints.DxJoint;
import org.ode4j.ode.internal.joints.DxJointLimitMotor;

public class DxJointHinge
extends DxJoint
implements DHingeJoint {
    private DVector3 anchor1 = new DVector3();
    private DVector3 anchor2 = new DVector3();
    private DVector3 _axis1 = new DVector3();
    private DVector3 _axis2 = new DVector3();
    private DQuaternion qrel = new DQuaternion();
    private DxJointLimitMotor limot = new DxJointLimitMotor();

    DxJointHinge(DxWorld w) {
        super(w);
        this._axis1.set0(1.0);
        this._axis2.set0(1.0);
        this.limot.init(this.world);
    }

    @Override
    void getSureMaxInfo(DxJoint.SureMaxInfo info) {
        info.max_m = 6;
    }

    @Override
    public void getInfo1(DxJoint.Info1 info) {
        double angle;
        info.setNub(5);
        if (this.limot.fmax > 0.0) {
            info.setM(6);
        } else {
            info.setM(5);
        }
        if ((this.limot.lostop >= -Math.PI || this.limot.histop <= Math.PI) && this.limot.lostop <= this.limot.histop && this.limot.testRotationalLimit(angle = this.getHingeAngle(this.node[0].body, this.node[1].body, this._axis1, this.qrel))) {
            info.setM(6);
        }
    }

    @Override
    public void getInfo2(DxJoint.Info2 info) {
        this.setBall(this, info, this.anchor1, this.anchor2);
        DVector3 ax1 = new DVector3();
        DVector3 p = new DVector3();
        DVector3 q = new DVector3();
        OdeMath.dMultiply0_331(ax1, this.node[0].body.posr().R(), (DVector3C)this._axis1);
        OdeMath.dPlaneSpace(ax1, p, q);
        int s3 = 3 * info.rowskip();
        int s4 = 4 * info.rowskip();
        p.wrapSet(info._J, info.J1ap + s3);
        q.wrapSet(info._J, info.J1ap + s4);
        if (this.node[1].body != null) {
            p.wrapSub(info._J, info.J2ap + s3);
            q.wrapSub(info._J, info.J2ap + s4);
        }
        DVector3 ax2 = new DVector3();
        DVector3 b = new DVector3();
        if (this.node[1].body != null) {
            OdeMath.dMultiply0_331(ax2, this.node[1].body.posr().R(), (DVector3C)this._axis2);
        } else {
            ax2.set(this._axis2);
        }
        OdeMath.dCalcVectorCross3(b, ax1, ax2);
        double k = info.fps * info.erp;
        info.setC(3, k * b.dot(p));
        info.setC(4, k * b.dot(q));
        this.limot.addLimot(this, info, 5, ax1, true);
    }

    public void dJointSetHingeAnchor(double x, double y, double z) {
        this.dJointSetHingeAnchor(new DVector3(x, y, z));
    }

    public void dJointSetHingeAnchor(DVector3C xyz) {
        this.setAnchors(xyz, this.anchor1, this.anchor2);
        this.computeInitialRelativeRotation();
    }

    void dJointSetHingeAnchorDelta(DxJointHinge joint, double x, double y, double z, double dx, double dy, double dz) {
        Common.dUASSERT(joint, "bad joint argument");
        if (joint.node[0].body != null) {
            DVector3 q = new DVector3();
            OdeMath.dMultiply1_331(joint.anchor1, joint.node[0].body.posr().R(), q);
            if (joint.node[1].body != null) {
                q.set(x, y, z).sub(joint.node[1].body.posr().pos());
                OdeMath.dMultiply1_331(joint.anchor2, joint.node[1].body.posr().R(), q);
            } else {
                joint.anchor2.set(x, y, z).add(dx, dy, dz);
            }
        }
        joint.computeInitialRelativeRotation();
    }

    public void dJointSetHingeAxis(double x, double y, double z) {
        this.setAxes(x, y, z, this._axis1, this._axis2);
        this.computeInitialRelativeRotation();
    }

    public void dJointSetHingeAxisOffset(double x, double y, double z, double dangle) {
        this.setAxes(x, y, z, this._axis1, this._axis2);
        this.computeInitialRelativeRotation();
        if (this.isFlagsReverse()) {
            dangle = -dangle;
        }
        DQuaternion qAngle = new DQuaternion();
        DQuaternion qOffset = new DQuaternion();
        Rotation.dQFromAxisAndAngle(qAngle, x, y, z, dangle);
        Rotation.dQMultiply3(qOffset, qAngle, this.qrel);
        this.qrel.set(qOffset);
    }

    void dJointGetHingeAnchor(DVector3 result) {
        if (this.isFlagsReverse()) {
            this.getAnchor2(result, this.anchor2);
        } else {
            this.getAnchor(result, this.anchor1);
        }
    }

    void dJointGetHingeAnchor2(DVector3 result) {
        if (this.isFlagsReverse()) {
            this.getAnchor(result, this.anchor1);
        } else {
            this.getAnchor2(result, this.anchor2);
        }
    }

    void dJointGetHingeAxis(DVector3 result) {
        this.getAxis(result, this._axis1);
    }

    public void dJointSetHingeParam(DJoint.PARAM_N parameter, double value) {
        this.limot.set(parameter.toSUB(), value);
    }

    double dJointGetHingeParam(DJoint.PARAM_N parameter) {
        return this.limot.get(parameter.toSUB());
    }

    public double dJointGetHingeAngle() {
        if (this.node[0].body != null) {
            double ang = this.getHingeAngle(this.node[0].body, this.node[1].body, this._axis1, this.qrel);
            if (this.isFlagsReverse()) {
                return -ang;
            }
            return ang;
        }
        return 0.0;
    }

    public double dJointGetHingeAngleRate() {
        if (this.node[0].body != null) {
            DVector3 axis = new DVector3();
            OdeMath.dMultiply0_331(axis, this.node[0].body.posr().R(), (DVector3C)this._axis1);
            double rate = OdeMath.dCalcVectorDot3(axis, this.node[0].body.avel);
            if (this.node[1].body != null) {
                rate -= OdeMath.dCalcVectorDot3(axis, this.node[1].body.avel);
            }
            if (this.isFlagsReverse()) {
                rate = -rate;
            }
            return rate;
        }
        return 0.0;
    }

    void dJointAddHingeTorque(double torque) {
        DVector3 axis = new DVector3();
        if (this.isFlagsReverse()) {
            torque = -torque;
        }
        this.getAxis(axis, this._axis1);
        axis.scale(torque);
        if (this.node[0].body != null) {
            this.node[0].body.dBodyAddTorque(axis);
        }
        if (this.node[1].body != null) {
            this.node[1].body.dBodyAddTorque(axis.reScale(-1.0));
        }
    }

    @Override
    void setRelativeValues() {
        DVector3 vec = new DVector3();
        this.dJointGetHingeAnchor(vec);
        this.setAnchors(vec, this.anchor1, this.anchor2);
        this.dJointGetHingeAxis(vec);
        this.setAxes(vec.get0(), vec.get1(), vec.get2(), this._axis1, this._axis2);
        this.computeInitialRelativeRotation();
    }

    void computeInitialRelativeRotation() {
        if (this.node[0].body != null) {
            if (this.node[1].body != null) {
                Rotation.dQMultiply1(this.qrel, this.node[0].body._q, this.node[1].body._q);
            } else {
                this.qrel.set(this.node[0].body._q.get0(), -this.node[0].body._q.get1(), -this.node[0].body._q.get2(), -this.node[0].body._q.get3());
            }
        }
    }

    @Override
    public void setAnchor(double x, double y, double z) {
        this.dJointSetHingeAnchor(x, y, z);
    }

    @Override
    public void setAnchor(DVector3C a) {
        this.dJointSetHingeAnchor(a);
    }

    @Override
    public void getAnchor(DVector3 result) {
        this.dJointGetHingeAnchor(result);
    }

    @Override
    public void getAnchor2(DVector3 result) {
        this.dJointGetHingeAnchor2(result);
    }

    @Override
    public void setAxis(double x, double y, double z) {
        this.dJointSetHingeAxis(x, y, z);
    }

    @Override
    public void setAxis(DVector3C a) {
        this.setAxis(a.get0(), a.get1(), a.get2());
    }

    @Override
    public void getAxis(DVector3 result) {
        this.dJointGetHingeAxis(result);
    }

    @Override
    public void setAxisOffset(double x, double y, double z, double angle) {
        this.dJointSetHingeAxisOffset(x, y, z, angle);
    }

    @Override
    public double getAngle() {
        return this.dJointGetHingeAngle();
    }

    @Override
    public double getAngleRate() {
        return this.dJointGetHingeAngleRate();
    }

    @Override
    public void setParam(DJoint.PARAM_N parameter, double value) {
        this.dJointSetHingeParam(parameter, value);
    }

    @Override
    public double getParam(DJoint.PARAM_N parameter) {
        return this.dJointGetHingeParam(parameter);
    }

    @Override
    public void addTorque(double torque) {
        this.dJointAddHingeTorque(torque);
    }

    @Override
    public void setParamFMax(double d) {
        this.dJointSetHingeParam(DJoint.PARAM_N.dParamFMax1, d);
    }

    @Override
    public void setParamVel(double d) {
        this.dJointSetHingeParam(DJoint.PARAM_N.dParamVel1, d);
    }

    @Override
    public void setParamHiStop(double d) {
        this.dJointSetHingeParam(DJoint.PARAM_N.dParamHiStop1, d);
    }

    @Override
    public void setParamLoStop(double d) {
        this.dJointSetHingeParam(DJoint.PARAM_N.dParamLoStop1, d);
    }

    @Override
    public void setParamBounce(double d) {
        this.dJointSetHingeParam(DJoint.PARAM_N.dParamBounce1, d);
    }
}

