/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal.joints;

import org.ode4j.math.DQuaternion;
import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.DFixedJoint;
import org.ode4j.ode.DJoint;
import org.ode4j.ode.DRotation;
import org.ode4j.ode.OdeMath;
import org.ode4j.ode.internal.DxWorld;
import org.ode4j.ode.internal.joints.DxJoint;

public class DxJointFixed
extends DxJoint
implements DFixedJoint {
    public DQuaternion qrel;
    DVector3 offset = new DVector3();
    double erp;
    double cfm;

    DxJointFixed(DxWorld w) {
        super(w);
        this.qrel = new DQuaternion();
        this.erp = this.world.getERP();
        this.cfm = this.world.getCFM();
    }

    @Override
    void getSureMaxInfo(DxJoint.SureMaxInfo info) {
        info.max_m = 6;
    }

    @Override
    public void getInfo1(DxJoint.Info1 info) {
        info.setM(6);
        info.setNub(6);
    }

    @Override
    public void getInfo2(DxJoint.Info2 info) {
        int s = info.rowskip();
        this.setFixedOrientation(this, info, this.qrel, 3);
        info._J[info.J1lp + 0] = 1.0;
        info._J[info.J1lp + s + 1] = 1.0;
        info._J[info.J1lp + 2 * s + 2] = 1.0;
        info.erp = this.erp;
        info.setCfm(0, this.cfm);
        info.setCfm(1, this.cfm);
        info.setCfm(2, this.cfm);
        DVector3 ofs = new DVector3();
        OdeMath.dMultiply0_331(ofs, this.node[0].body.posr().R(), (DVector3C)this.offset);
        if (this.node[1].body != null) {
            OdeMath.dSetCrossMatrixPlus(info._J, info.J1ap, ofs, s);
            info._J[info.J2lp + 0] = -1.0;
            info._J[info.J2lp + s + 1] = -1.0;
            info._J[info.J2lp + 2 * s + 2] = -1.0;
        }
        double k = info.fps * info.erp;
        if (this.node[1].body != null) {
            int j = 0;
            while (j < 3) {
                info.setC(j, k * (this.node[1].body.posr().pos().get(j) - this.node[0].body.posr().pos().get(j) + ofs.get(j)));
                ++j;
            }
        } else {
            int j = 0;
            while (j < 3) {
                info.setC(j, k * (this.offset.get(j) - this.node[0].body.posr().pos().get(j)));
                ++j;
            }
        }
    }

    public void dJointSetFixed() {
        if (this.node[0].body != null) {
            if (this.node[1].body != null) {
                DVector3 ofs = new DVector3();
                ofs.eqDiff(this.node[0].body.posr().pos(), this.node[1].body.posr().pos());
                OdeMath.dMultiply1_331(this.offset, this.node[0].body.posr().R(), ofs);
            } else {
                this.offset.set(this.node[0].body.posr().pos());
            }
        }
        this.computeInitialRelativeRotation();
    }

    void set(DJoint.PARAM num, double value) {
        switch (num) {
            case dParamCFM: {
                this.cfm = value;
                break;
            }
            case dParamERP: {
                this.erp = value;
            }
        }
    }

    double get(DJoint.PARAM num) {
        switch (num) {
            case dParamCFM: {
                return this.cfm;
            }
            case dParamERP: {
                return this.erp;
            }
        }
        return 0.0;
    }

    public void dJointSetFixedParam(DJoint.PARAM_N parameter, double value) {
        this.set(parameter.toSUB(), value);
    }

    private double dJointGetFixedParam(DJoint.PARAM_N parameter) {
        return this.get(parameter.toSUB());
    }

    void computeInitialRelativeRotation() {
        if (this.node[0].body != null) {
            if (this.node[1].body != null) {
                DRotation.dQMultiply1(this.qrel, this.node[0].body._q, this.node[1].body._q);
            } else {
                this.qrel.set0(this.node[0].body._q.get0());
                this.qrel.set1(-this.node[0].body._q.get1());
                this.qrel.set2(-this.node[0].body._q.get2());
                this.qrel.set3(-this.node[0].body._q.get3());
            }
        }
    }

    @Override
    public void set() {
        this.dJointSetFixed();
    }

    @Override
    public void setParam(DJoint.PARAM_N parameter, double value) {
        this.dJointSetFixedParam(parameter, value);
    }

    @Override
    public double getParam(DJoint.PARAM_N parameter) {
        return this.dJointGetFixedParam(parameter);
    }

    @Override
    public void setFixed() {
        this.dJointSetFixed();
    }
}

