/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal.joints;

import org.ode4j.math.DVector3;
import org.ode4j.ode.DContact;
import org.ode4j.ode.DContactJoint;
import org.ode4j.ode.DJoint;
import org.ode4j.ode.OdeMath;
import org.ode4j.ode.internal.DxWorld;
import org.ode4j.ode.internal.joints.DxJoint;

public class DxJointContact
extends DxJoint
implements DContactJoint {
    int the_m;
    public DContact contact;

    DxJointContact(DxWorld w) {
        super(w);
    }

    @Override
    void getSureMaxInfo(DxJoint.SureMaxInfo info) {
        info.max_m = 3;
    }

    @Override
    public void getInfo1(DxJoint.Info1 info) {
        int m = 1;
        int nub = 0;
        if (this.contact.surface.mu < 0.0) {
            this.contact.surface.mu = 0.0;
        }
        if ((this.contact.surface.mode & 1) != 0) {
            if (this.contact.surface.mu > 0.0) {
                ++m;
            }
            if (this.contact.surface.mu2 < 0.0) {
                this.contact.surface.mu2 = 0.0;
            }
            if (this.contact.surface.mu2 > 0.0) {
                ++m;
            }
            if (this.contact.surface.mu == Double.POSITIVE_INFINITY) {
                ++nub;
            }
            if (this.contact.surface.mu2 == Double.POSITIVE_INFINITY) {
                ++nub;
            }
        } else {
            if (this.contact.surface.mu > 0.0) {
                m += 2;
            }
            if (this.contact.surface.mu == Double.POSITIVE_INFINITY) {
                nub += 2;
            }
        }
        this.the_m = m;
        info.setM(m);
        info.setNub(nub);
    }

    @Override
    public void getInfo2(DxJoint.Info2 info) {
        int s = info.rowskip();
        int s2 = 2 * s;
        DVector3 normal = new DVector3();
        if (this.isFlagsReverse()) {
            normal.set(this.contact.geom.normal).scale(-1.0);
        } else {
            normal.set(this.contact.geom.normal);
        }
        DVector3 c1 = new DVector3();
        DVector3 c2 = new DVector3();
        c1.eqDiff(this.contact.geom.pos, this.node[0].body.posr().pos());
        info._J[info.J1lp + 0] = normal.get0();
        info._J[info.J1lp + 1] = normal.get1();
        info._J[info.J1lp + 2] = normal.get2();
        OdeMath.dCalcVectorCross3(info._J, info.J1ap, c1, normal);
        if (this.node[1].body != null) {
            c2.eqDiff(this.contact.geom.pos, this.node[1].body.posr().pos());
            info._J[info.J2lp + 0] = -normal.get0();
            info._J[info.J2lp + 1] = -normal.get1();
            info._J[info.J2lp + 2] = -normal.get2();
            OdeMath.dCalcVectorCross3(info._J, info.J2ap, c2, normal);
            OdeMath.dNegateVector3(info._J, info.J2ap);
        }
        double erp = info.erp;
        if ((this.contact.surface.mode & 8) != 0) {
            erp = this.contact.surface.soft_erp;
        }
        double k = info.fps * erp;
        double depth = this.contact.geom.depth - this.world.contactp.min_depth;
        if (depth < 0.0) {
            depth = 0.0;
        }
        if ((this.contact.surface.mode & 0x10) != 0) {
            info.setCfm(0, this.contact.surface.soft_cfm);
        }
        double motionN = 0.0;
        if ((this.contact.surface.mode & 0x80) != 0) {
            motionN = this.contact.surface.motionN;
        }
        double pushout = k * depth + motionN;
        info.setC(0, pushout);
        double maxvel = this.world.contactp.max_vel;
        if (info.getC(0) > maxvel) {
            info.setC(0, maxvel);
        }
        if ((this.contact.surface.mode & 4) != 0) {
            double newc;
            double outgoing = OdeMath.dCalcVectorDot3(info._J, info.J1lp, this.node[0].body.lvel) + OdeMath.dCalcVectorDot3(info._J, info.J1ap, this.node[0].body.avel);
            if (this.node[1].body != null) {
                outgoing += OdeMath.dCalcVectorDot3(info._J, info.J2lp, this.node[1].body.lvel) + OdeMath.dCalcVectorDot3(info._J, info.J2ap, this.node[1].body.avel);
            }
            outgoing -= motionN;
            if (this.contact.surface.bounce_vel >= 0.0 && -outgoing > this.contact.surface.bounce_vel && (newc = -this.contact.surface.bounce * outgoing + motionN) > info.getC(0)) {
                info.setC(0, newc);
            }
        }
        info.setLo(0, 0.0);
        info.setHi(0, Double.POSITIVE_INFINITY);
        DVector3 t1 = new DVector3();
        DVector3 t2 = new DVector3();
        if (this.the_m >= 2) {
            if ((this.contact.surface.mode & 2) != 0) {
                t1.set(this.contact.fdir1);
                OdeMath.dCalcVectorCross3(t2, normal, t1);
            } else {
                OdeMath.dPlaneSpace(normal, t1, t2);
            }
            info._J[info.J1lp + s + 0] = t1.get0();
            info._J[info.J1lp + s + 1] = t1.get1();
            info._J[info.J1lp + s + 2] = t1.get2();
            OdeMath.dCalcVectorCross3(info._J, info.J1ap + s, c1, t1);
            if (this.node[1].body != null) {
                info._J[info.J2lp + s + 0] = -t1.get0();
                info._J[info.J2lp + s + 1] = -t1.get1();
                info._J[info.J2lp + s + 2] = -t1.get2();
                OdeMath.dCalcVectorCross3(info._J, info.J2ap + s, c2, t1);
                OdeMath.dNegateVector3(info._J, info.J2ap + s);
            }
            if ((this.contact.surface.mode & 0x20) != 0) {
                info.setC(1, this.contact.surface.motion1);
            }
            info.setLo(1, -this.contact.surface.mu);
            info.setHi(1, this.contact.surface.mu);
            if ((this.contact.surface.mode & 0x1000) != 0) {
                info.setFindex(1, 0);
            }
            if ((this.contact.surface.mode & 0x100) != 0) {
                info.setCfm(1, this.contact.surface.slip1);
            }
        }
        if (this.the_m >= 3) {
            info._J[info.J1lp + s2 + 0] = t2.get0();
            info._J[info.J1lp + s2 + 1] = t2.get1();
            info._J[info.J1lp + s2 + 2] = t2.get2();
            OdeMath.dCalcVectorCross3(info._J, info.J1ap + s2, c1, t2);
            if (this.node[1].body != null) {
                info._J[info.J2lp + s2 + 0] = -t2.get0();
                info._J[info.J2lp + s2 + 1] = -t2.get1();
                info._J[info.J2lp + s2 + 2] = -t2.get2();
                OdeMath.dCalcVectorCross3(info._J, info.J2ap + s2, c2, t2);
                OdeMath.dNegateVector3(info._J, info.J2ap + s2);
            }
            if ((this.contact.surface.mode & 0x40) != 0) {
                info.setC(2, this.contact.surface.motion2);
            }
            if ((this.contact.surface.mode & 1) != 0) {
                info.setLo(2, -this.contact.surface.mu2);
                info.setHi(2, this.contact.surface.mu2);
            } else {
                info.setLo(2, -this.contact.surface.mu);
                info.setHi(2, this.contact.surface.mu);
            }
            if ((this.contact.surface.mode & 0x2000) != 0) {
                info.setFindex(2, 0);
            }
            if ((this.contact.surface.mode & 0x200) != 0) {
                info.setCfm(2, this.contact.surface.slip2);
            }
        }
    }

    @Override
    public double getParam(DJoint.PARAM_N parameter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setParam(DJoint.PARAM_N parameter, double value) {
        throw new UnsupportedOperationException();
    }
}

