/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal.joints;

import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.DBallJoint;
import org.ode4j.ode.DJoint;
import org.ode4j.ode.internal.DxWorld;
import org.ode4j.ode.internal.joints.DxJoint;

public class DxJointBall
extends DxJoint
implements DBallJoint {
    DVector3 anchor1 = new DVector3();
    DVector3 anchor2 = new DVector3();
    double erp = this.world.getERP();
    double cfm = this.world.getCFM();

    DxJointBall(DxWorld w) {
        super(w);
    }

    @Override
    void getSureMaxInfo(DxJoint.SureMaxInfo info) {
        info.max_m = 3;
    }

    @Override
    public void getInfo1(DxJoint.Info1 info) {
        info.setM(3);
        info.setNub(3);
    }

    @Override
    public void getInfo2(DxJoint.Info2 info) {
        info.erp = this.erp;
        info.setCfm(0, this.cfm);
        info.setCfm(1, this.cfm);
        info.setCfm(2, this.cfm);
        this.setBall(this, info, this.anchor1, this.anchor2);
    }

    public void dJointSetBallAnchor(DVector3C xyz) {
        this.setAnchors(xyz, this.anchor1, this.anchor2);
    }

    void dJointSetBallAnchor2(DVector3C xyz) {
        this.anchor2.set(xyz);
    }

    void dJointGetBallAnchor(DVector3 result) {
        if (this.isFlagsReverse()) {
            this.getAnchor2(result, this.anchor2);
        } else {
            this.getAnchor(result, this.anchor1);
        }
    }

    void dJointGetBallAnchor2(DVector3 result) {
        if (this.isFlagsReverse()) {
            this.getAnchor(result, this.anchor1);
        } else {
            this.getAnchor2(result, this.anchor2);
        }
    }

    void set(DJoint.PARAM num, double value) {
        switch (num) {
            case dParamCFM: {
                this.cfm = value;
                break;
            }
            case dParamERP: {
                this.erp = value;
            }
        }
    }

    double get(DJoint.PARAM num) {
        switch (num) {
            case dParamCFM: {
                return this.cfm;
            }
            case dParamERP: {
                return this.erp;
            }
        }
        return 0.0;
    }

    void dJointSetBallParam(DJoint.PARAM parameter, double value) {
        this.set(parameter, value);
    }

    double dJointGetBallParam(DJoint.PARAM parameter) {
        return this.get(parameter);
    }

    @Override
    void setRelativeValues() {
        DVector3 anchor = new DVector3();
        this.dJointGetBallAnchor(anchor);
        this.setAnchors(anchor, this.anchor1, this.anchor2);
    }

    @Override
    public final void setAnchor(double x, double y, double z) {
        this.dJointSetBallAnchor(new DVector3(x, y, z));
    }

    @Override
    public final void setAnchor(DVector3C a) {
        this.dJointSetBallAnchor(a);
    }

    @Override
    public final void setAnchor2(double x, double y, double z) {
        this.dJointSetBallAnchor2(new DVector3(x, y, z));
    }

    @Override
    public final void setAnchor2(DVector3C a) {
        this.dJointSetBallAnchor2(a);
    }

    @Override
    public final void getAnchor(DVector3 result) {
        this.dJointGetBallAnchor(result);
    }

    @Override
    public final void getAnchor2(DVector3 result) {
        this.dJointGetBallAnchor2(result);
    }

    @Override
    public final void setParam(DJoint.PARAM_N parameter, double value) {
        if (!parameter.isGroup1()) {
            throw new IllegalArgumentException("Only Group #1 allowed, but got: " + parameter.name());
        }
        this.dJointSetBallParam(parameter.toSUB(), value);
    }

    @Override
    public final double getParam(DJoint.PARAM_N parameter) {
        if (!parameter.isGroup1()) {
            throw new IllegalArgumentException("Only Group #1 allowed, but got: " + parameter.name());
        }
        return this.dJointGetBallParam(parameter.toSUB());
    }
}

