/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal.joints;

import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.DAMotorJoint;
import org.ode4j.ode.DJoint;
import org.ode4j.ode.OdeMath;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DxWorld;
import org.ode4j.ode.internal.ErrorHandler;
import org.ode4j.ode.internal.joints.DxJoint;
import org.ode4j.ode.internal.joints.DxJointLimitMotor;

public class DxJointAMotor
extends DxJoint
implements DAMotorJoint {
    private int _num = 0;
    private DAMotorJoint.AMotorMode _mode;
    private int[] _rel = new int[3];
    private DVector3[] axis = new DVector3[3];
    private DxJointLimitMotor[] limot = new DxJointLimitMotor[3];
    private double[] angle = new double[3];
    private DVector3 reference1 = new DVector3();
    private DVector3 reference2 = new DVector3();

    DxJointAMotor(DxWorld w) {
        super(w);
        this._mode = DAMotorJoint.AMotorMode.dAMotorUser;
        int i = 0;
        while (i < 3) {
            this._rel[i] = 0;
            this.axis[i] = new DVector3();
            this.limot[i] = new DxJointLimitMotor();
            this.limot[i].init(this.world);
            this.angle[i] = 0.0;
            ++i;
        }
    }

    void computeGlobalAxes(DVector3[] ax) {
        if (this._mode == DAMotorJoint.AMotorMode.dAMotorEuler) {
            OdeMath.dMultiply0_331(ax[0], this.node[0].body.posr().R(), (DVector3C)this.axis[0]);
            if (this.node[1].body != null) {
                OdeMath.dMultiply0_331(ax[2], this.node[1].body.posr().R(), (DVector3C)this.axis[2]);
            } else {
                ax[2].set(this.axis[2]);
            }
            OdeMath.dCalcVectorCross3(ax[1], ax[2], ax[0]);
            OdeMath.dNormalize3(ax[1]);
        } else {
            int i = 0;
            while (i < this._num) {
                if (this._rel[i] == 1) {
                    OdeMath.dMultiply0_331(ax[i], this.node[0].body.posr().R(), (DVector3C)this.axis[i]);
                } else if (this._rel[i] == 2) {
                    if (this.node[1].body != null) {
                        OdeMath.dMultiply0_331(ax[i], this.node[1].body.posr().R(), (DVector3C)this.axis[i]);
                    }
                } else {
                    ax[i].set(this.axis[i]);
                }
                ++i;
            }
        }
    }

    void computeEulerAngles(DVector3[] ax) {
        DVector3 ref1 = new DVector3();
        DVector3 ref2 = new DVector3();
        OdeMath.dMultiply0_331(ref1, this.node[0].body.posr().R(), (DVector3C)this.reference1);
        if (this.node[1].body != null) {
            OdeMath.dMultiply0_331(ref2, this.node[1].body.posr().R(), (DVector3C)this.reference2);
        } else {
            ref2.set(this.reference2);
        }
        DVector3 q = new DVector3();
        OdeMath.dCalcVectorCross3(q, ax[0], ref1);
        this.angle[0] = -Common.dAtan2(OdeMath.dCalcVectorDot3(ax[2], q), OdeMath.dCalcVectorDot3(ax[2], ref1));
        OdeMath.dCalcVectorCross3(q, ax[0], ax[1]);
        this.angle[1] = -Common.dAtan2(OdeMath.dCalcVectorDot3(ax[2], ax[0]), OdeMath.dCalcVectorDot3(ax[2], q));
        OdeMath.dCalcVectorCross3(q, ax[1], ax[2]);
        this.angle[2] = -Common.dAtan2(OdeMath.dCalcVectorDot3(ref2, ax[1]), OdeMath.dCalcVectorDot3(ref2, q));
    }

    void setEulerReferenceVectors() {
        if (this.node[0].body != null && this.node[1].body != null) {
            DVector3 r = new DVector3();
            OdeMath.dMultiply0_331(r, this.node[1].body.posr().R(), (DVector3C)this.axis[2]);
            OdeMath.dMultiply1_331(this.reference1, this.node[0].body.posr().R(), r);
            OdeMath.dMultiply0_331(r, this.node[0].body.posr().R(), (DVector3C)this.axis[0]);
            OdeMath.dMultiply1_331(this.reference2, this.node[1].body.posr().R(), r);
        } else {
            DVector3 r = new DVector3();
            r.set(this.axis[2]);
            OdeMath.dMultiply1_331(this.reference1, this.node[0].body.posr().R(), r);
            OdeMath.dMultiply0_331(r, this.node[0].body.posr().R(), (DVector3C)this.axis[0]);
            this.reference2.add(r);
        }
    }

    @Override
    void getSureMaxInfo(DxJoint.SureMaxInfo info) {
        info.max_m = this._num;
    }

    @Override
    public void getInfo1(DxJoint.Info1 info) {
        info.setM(0);
        info.setNub(0);
        if (this._mode == DAMotorJoint.AMotorMode.dAMotorEuler) {
            DVector3[] ax = new DVector3[]{new DVector3(), new DVector3(), new DVector3()};
            this.computeGlobalAxes(ax);
            this.computeEulerAngles(ax);
        }
        int i = 0;
        while (i < this._num) {
            if (this.limot[i].testRotationalLimit(this.angle[i]) || this.limot[i].fmax > 0.0) {
                info.incM();
            }
            ++i;
        }
    }

    @Override
    public void getInfo2(DxJoint.Info2 info) {
        DVector3[] ax = new DVector3[]{new DVector3(), new DVector3(), new DVector3()};
        this.computeGlobalAxes(ax);
        DVector3[] axptr = new DVector3[]{ax[0], ax[1], ax[2]};
        DVector3 ax0_cross_ax1 = new DVector3();
        DVector3 ax1_cross_ax2 = new DVector3();
        if (this._mode == DAMotorJoint.AMotorMode.dAMotorEuler) {
            OdeMath.dCalcVectorCross3(ax0_cross_ax1, ax[0], ax[1]);
            axptr[2] = ax0_cross_ax1;
            OdeMath.dCalcVectorCross3(ax1_cross_ax2, ax[1], ax[2]);
            axptr[0] = ax1_cross_ax2;
        }
        int row = 0;
        int i = 0;
        while (i < this._num) {
            row += this.limot[i].addLimot(this, info, row, axptr[i], true);
            ++i;
        }
    }

    public void dJointSetAMotorNumAxes(int num) {
        Common.dAASSERT(num >= 0 && num <= 3);
        if (this._mode == DAMotorJoint.AMotorMode.dAMotorEuler) {
            this._num = 3;
        } else {
            if (num < 0) {
                num = 0;
            }
            if (num > 3) {
                num = 3;
            }
            this._num = num;
        }
    }

    public void dJointSetAMotorAxis(int anum, int rel, double x, double y, double z) {
        this.dJointSetAMotorAxis(anum, rel, new DVector3(x, y, z));
    }

    public void dJointSetAMotorAxis(int anum, int rel, DVector3C r) {
        Common.dAASSERT(anum >= 0 && anum <= 2 && rel >= 0 && rel <= 2);
        Common.dUASSERT(this.node[1].body != null || !this.isFlagsReverse() || rel != 1, "no first body, can't set axis rel=1");
        Common.dUASSERT(this.node[1].body != null || this.isFlagsReverse() || rel != 2, "no second body, can't set axis rel=2");
        if (anum < 0) {
            anum = 0;
        }
        if (anum > 2) {
            anum = 2;
        }
        if (this.node[1].body == null && rel == 2) {
            rel = 1;
        }
        this._rel[anum] = rel;
        if (rel > 0) {
            if (rel == 1) {
                OdeMath.dMultiply1_331(this.axis[anum], this.node[0].body.posr().R(), r);
            } else if (this.node[1].body != null) {
                OdeMath.dMultiply1_331(this.axis[anum], this.node[1].body.posr().R(), r);
            } else {
                this.axis[anum].set(r);
            }
        } else {
            this.axis[anum].set(r);
        }
        OdeMath.dNormalize3(this.axis[anum]);
        if (this._mode == DAMotorJoint.AMotorMode.dAMotorEuler) {
            this.setEulerReferenceVectors();
        }
    }

    void dJointSetAMotorAngle(int anum, double angle) {
        Common.dAASSERT(anum >= 0 && anum < 3);
        if (this._mode == DAMotorJoint.AMotorMode.dAMotorUser) {
            if (anum < 0) {
                anum = 0;
            }
            if (anum > 3) {
                anum = 3;
            }
            this.angle[anum] = angle;
        }
    }

    public void dJointSetAMotorParam(DJoint.PARAM_N parameter, double value) {
        int anum = parameter.toGROUP().getIndex();
        this.limot[anum].set(parameter.toSUB(), value);
    }

    public void dJointSetAMotorMode(DAMotorJoint.AMotorMode mode) {
        this._mode = mode;
        if (this._mode == DAMotorJoint.AMotorMode.dAMotorEuler) {
            this._num = 3;
            this.setEulerReferenceVectors();
        }
    }

    int dJointGetAMotorNumAxes() {
        return this._num;
    }

    void dJointGetAMotorAxis(int anum, DVector3 result) {
        Common.dAASSERT(anum >= 0 && anum < 3);
        if (anum < 0) {
            anum = 0;
        }
        if (anum > 2) {
            anum = 2;
        }
        if (this._rel[anum] > 0) {
            if (this._rel[anum] == 1) {
                OdeMath.dMultiply0_331(result, this.node[0].body.posr().R(), (DVector3C)this.axis[anum]);
            } else if (this.node[1].body != null) {
                OdeMath.dMultiply0_331(result, this.node[1].body.posr().R(), (DVector3C)this.axis[anum]);
            } else {
                result.set(this.axis[anum]);
            }
        } else {
            result.set(this.axis[anum]);
        }
    }

    int dJointGetAMotorAxisRel(int anum) {
        Common.dAASSERT(anum >= 0 && anum < 3);
        if (anum < 0) {
            anum = 0;
        }
        if (anum > 2) {
            anum = 2;
        }
        return this._rel[anum];
    }

    public double dJointGetAMotorAngle(int anum) {
        Common.dAASSERT(anum >= 0 && anum < 3);
        if (anum < 0) {
            anum = 0;
        }
        if (anum > 3) {
            anum = 3;
        }
        return this.angle[anum];
    }

    double dJointGetAMotorAngleRate(int anum) {
        ErrorHandler.dDebug(0, "not yet implemented", new Object[0]);
        return 0.0;
    }

    double dJointGetAMotorParam(DJoint.PARAM_N parameter) {
        int anum = parameter.toGROUP().getIndex();
        return this.limot[anum].get(parameter.toSUB());
    }

    DAMotorJoint.AMotorMode dJointGetAMotorMode() {
        return this._mode;
    }

    void dJointAddAMotorTorques(double torque1, double torque2, double torque3) {
        DVector3[] axes = new DVector3[3];
        if (this._num == 0) {
            return;
        }
        Common.dUASSERT(!this.isFlagsReverse(), "dJointAddAMotorTorques not yet implemented for reverse AMotor joints");
        this.computeGlobalAxes(axes);
        axes[0].scale(torque1);
        if (this._num >= 2) {
            axes[0].eqSum((DVector3C)axes[0], axes[1], torque2);
            if (this._num >= 3) {
                axes[0].eqSum((DVector3C)axes[0], axes[2], torque3);
            }
        }
        if (this.node[0].body != null) {
            this.node[0].body.dBodyAddTorque(axes[0]);
        }
        if (this.node[1].body != null) {
            this.node[1].body.dBodyAddTorque(axes[0].reScale(-1.0));
        }
    }

    @Override
    public void setMode(DAMotorJoint.AMotorMode mode) {
        this.dJointSetAMotorMode(mode);
    }

    @Override
    public DAMotorJoint.AMotorMode getMode() {
        return this.dJointGetAMotorMode();
    }

    @Override
    public void setNumAxes(int num) {
        this.dJointSetAMotorNumAxes(num);
    }

    @Override
    public int getNumAxes() {
        return this.dJointGetAMotorNumAxes();
    }

    @Override
    public void setAxis(int anum, int rel, double x, double y, double z) {
        this.dJointSetAMotorAxis(anum, rel, x, y, z);
    }

    @Override
    public void setAxis(int anum, int rel, DVector3C a) {
        this.dJointSetAMotorAxis(anum, rel, a);
    }

    @Override
    public void getAxis(int anum, DVector3 result) {
        this.dJointGetAMotorAxis(anum, result);
    }

    @Override
    public int getAxisRel(int anum) {
        return this.dJointGetAMotorAxisRel(anum);
    }

    @Override
    public void setAngle(int anum, double angle) {
        this.dJointSetAMotorAngle(anum, angle);
    }

    @Override
    public double getAngle(int anum) {
        return this.dJointGetAMotorAngle(anum);
    }

    @Override
    public double getAngleRate(int anum) {
        return this.dJointGetAMotorAngleRate(anum);
    }

    @Override
    public void setParam(DJoint.PARAM_N parameter, double value) {
        this.dJointSetAMotorParam(parameter, value);
    }

    @Override
    public double getParam(DJoint.PARAM_N parameter) {
        return this.dJointGetAMotorParam(parameter);
    }

    @Override
    public void addTorques(double torque1, double torque2, double torque3) {
        this.dJointAddAMotorTorques(torque1, torque2, torque3);
    }

    @Override
    public void setParamFMax(double d) {
        this.dJointSetAMotorParam(DJoint.PARAM_N.dParamFMax1, d);
    }

    @Override
    public void setParamFMax2(double d) {
        this.dJointSetAMotorParam(DJoint.PARAM_N.dParamFMax2, d);
    }

    @Override
    public void setParamFMax3(double d) {
        this.dJointSetAMotorParam(DJoint.PARAM_N.dParamFMax3, d);
    }

    @Override
    public void setParamHiStop(double d) {
        this.dJointSetAMotorParam(DJoint.PARAM_N.dParamHiStop1, d);
    }

    @Override
    public void setParamHiStop2(double d) {
        this.dJointSetAMotorParam(DJoint.PARAM_N.dParamHiStop2, d);
    }

    @Override
    public void setParamHiStop3(double d) {
        this.dJointSetAMotorParam(DJoint.PARAM_N.dParamHiStop3, d);
    }

    @Override
    public void setParamLoStop(double d) {
        this.dJointSetAMotorParam(DJoint.PARAM_N.dParamLoStop1, d);
    }

    @Override
    public void setParamLoStop2(double d) {
        this.dJointSetAMotorParam(DJoint.PARAM_N.dParamLoStop2, d);
    }

    @Override
    public void setParamLoStop3(double d) {
        this.dJointSetAMotorParam(DJoint.PARAM_N.dParamLoStop3, d);
    }

    @Override
    public void setParamVel(double d) {
        this.dJointSetAMotorParam(DJoint.PARAM_N.dParamVel1, d);
    }

    @Override
    public void setParamVel2(double d) {
        this.dJointSetAMotorParam(DJoint.PARAM_N.dParamVel2, d);
    }

    @Override
    public void setParamVel3(double d) {
        this.dJointSetAMotorParam(DJoint.PARAM_N.dParamVel3, d);
    }

    @Override
    public double getParamFMax() {
        return this.dJointGetAMotorParam(DJoint.PARAM_N.dParamFMax1);
    }

    @Override
    public double getParamFMax2() {
        return this.dJointGetAMotorParam(DJoint.PARAM_N.dParamFMax2);
    }

    @Override
    public double getParamFMax3() {
        return this.dJointGetAMotorParam(DJoint.PARAM_N.dParamFMax3);
    }

    @Override
    public double getParamVel() {
        return this.dJointGetAMotorParam(DJoint.PARAM_N.dParamVel1);
    }

    @Override
    public double getParamVel2() {
        return this.dJointGetAMotorParam(DJoint.PARAM_N.dParamVel2);
    }

    @Override
    public double getParamVel3() {
        return this.dJointGetAMotorParam(DJoint.PARAM_N.dParamVel3);
    }
}

