/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal.joints;

import org.ode4j.math.DMatrix3C;
import org.ode4j.math.DQuaternion;
import org.ode4j.math.DQuaternionC;
import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.DBody;
import org.ode4j.ode.DJoint;
import org.ode4j.ode.OdeMath;
import org.ode4j.ode.internal.Common;
import org.ode4j.ode.internal.DObject;
import org.ode4j.ode.internal.DxBody;
import org.ode4j.ode.internal.DxWorld;
import org.ode4j.ode.internal.Rotation;
import org.ode4j.ode.internal.joints.DxJointNode;

public abstract class DxJoint
extends DObject
implements DJoint,
Cloneable {
    private static final int dJOINT_INGROUP = 1;
    private static final int dJOINT_REVERSE = 2;
    private static final int dJOINT_TWOBODIES = 4;
    private static final int dJOINT_DISABLED = 8;
    public int flags;
    public DxJointNode[] node = new DxJointNode[2];
    public DJoint.DJointFeedback feedback;
    public final double[] lambda;

    public abstract void getInfo1(Info1 var1);

    public abstract void getInfo2(Info2 var1);

    abstract void getSureMaxInfo(SureMaxInfo var1);

    protected DxJoint(DxWorld w) {
        super(w);
        Common.dIASSERT(w != null);
        this.flags = 0;
        this.node[0] = new DxJointNode();
        this.node[0].joint = this;
        this.node[0].body = null;
        this.node[0].next = null;
        this.node[1] = new DxJointNode();
        this.node[1].joint = this;
        this.node[1].body = null;
        this.node[1].next = null;
        this.lambda = new double[6];
        DxJoint.addObjectToList(this, w.firstjoint);
        ++w.nj;
        this.feedback = null;
    }

    @Override
    public void DESTRUCTOR() {
        super.DESTRUCTOR();
    }

    public boolean isEnabledAndDynamic() {
        return (this.flags & 8) == 0 && (this.node[0].body.invMass > 0.0 || this.node[1].body != null && this.node[1].body.invMass > 0.0);
    }

    boolean isFlagsReverse() {
        return (this.flags & 2) != 0;
    }

    public boolean isFlagsInGroup() {
        return (this.flags & 1) != 0;
    }

    void setFlagsInGroup() {
        this.flags |= 1;
    }

    void setFlagsTwoBodies() {
        this.flags |= 4;
    }

    void setBall(DxJoint joint, Info2 info, DVector3 anchor1, DVector3 anchor2) {
        DVector3 a1 = new DVector3();
        DVector3 a2 = new DVector3();
        int s = info.rowskip();
        info._J[info.J1lp + 0] = 1.0;
        info._J[info.J1lp + s + 1] = 1.0;
        info._J[info.J1lp + 2 * s + 2] = 1.0;
        OdeMath.dMultiply0_331(a1, joint.node[0].body.posr().R(), (DVector3C)anchor1);
        OdeMath.dSetCrossMatrixMinus(info._J, info.J1ap, a1, s);
        if (joint.node[1].body != null) {
            info._J[info.J2lp + 0] = -1.0;
            info._J[info.J2lp + s + 1] = -1.0;
            info._J[info.J2lp + 2 * s + 2] = -1.0;
            OdeMath.dMultiply0_331(a2, joint.node[1].body.posr().R(), (DVector3C)anchor2);
            OdeMath.dSetCrossMatrixPlus(info._J, info.J2ap, a2, s);
        }
        DxBody b0 = joint.node[0].body;
        DxBody b1 = joint.node[1].body;
        double k = info.fps * info.erp;
        if (joint.node[1].body != null) {
            info.setC(0, k * (a2.get0() + b1.posr().pos().get0() - a1.get0() - b0.posr().pos().get0()));
            info.setC(1, k * (a2.get1() + b1.posr().pos().get1() - a1.get1() - b0.posr().pos().get1()));
            info.setC(2, k * (a2.get2() + b1.posr().pos().get2() - a1.get2() - b0.posr().pos().get2()));
        } else {
            info.setC(0, k * (anchor2.get0() - a1.get0() - b0.posr().pos().get0()));
            info.setC(1, k * (anchor2.get1() - a1.get1() - b0.posr().pos().get1()));
            info.setC(2, k * (anchor2.get2() - a1.get2() - b0.posr().pos().get2()));
        }
    }

    void setBall2(DxJoint joint, Info2 info, DVector3 anchor1, DVector3 anchor2, DVector3 axis, double erp1) {
        DVector3 a1 = new DVector3();
        DVector3 a2 = new DVector3();
        int s = info.rowskip();
        DVector3 q1 = new DVector3();
        DVector3 q2 = new DVector3();
        OdeMath.dPlaneSpace(axis, q1, q2);
        axis.wrapSet(info._J, info.J1lp);
        q1.wrapSet(info._J, info.J1lp + s);
        q2.wrapSet(info._J, info.J1lp + 2 * s);
        OdeMath.dMultiply0_331(a1, joint.node[0].body.posr().R(), (DVector3C)anchor1);
        OdeMath.dCalcVectorCross3(info._J, info.J1ap, a1, axis);
        OdeMath.dCalcVectorCross3(info._J, info.J1ap + s, a1, q1);
        OdeMath.dCalcVectorCross3(info._J, info.J1ap + 2 * s, a1, q2);
        if (joint.node[1].body != null) {
            axis.wrapSub(info._J, info.J2lp);
            q1.wrapSub(info._J, info.J2lp + s);
            q2.wrapSub(info._J, info.J2lp + 2 * s);
            OdeMath.dMultiply0_331(a2, (DMatrix3C)joint.node[1].body._posr.R, (DVector3C)anchor2);
            double[] J = info._J;
            int J2ap = info.J2ap;
            OdeMath.dCalcVectorCross3(J, J2ap, a2, axis);
            OdeMath.dNegateVector3(J, J2ap);
            OdeMath.dCalcVectorCross3(J, J2ap + s, a2, q1);
            OdeMath.dNegateVector3(J, J2ap + s);
            OdeMath.dCalcVectorCross3(J, J2ap + 2 * s, a2, q2);
            OdeMath.dNegateVector3(J, J2ap + 2 * s);
        }
        double k1 = info.fps * erp1;
        double k = info.fps * info.erp;
        a1.add(joint.node[0].body.posr().pos());
        if (joint.node[1].body != null) {
            a2.add(joint.node[1].body.posr().pos());
            DVector3 a2_minus_a1 = new DVector3();
            a2_minus_a1.eqDiff(a2, a1);
            info.setC(0, k1 * OdeMath.dCalcVectorDot3(axis, a2_minus_a1));
            info.setC(1, k * OdeMath.dCalcVectorDot3(q1, a2_minus_a1));
            info.setC(2, k * OdeMath.dCalcVectorDot3(q2, a2_minus_a1));
        } else {
            DVector3 anchor2_minus_a1 = new DVector3();
            anchor2_minus_a1.eqDiff(anchor2, a1);
            info.setC(0, k1 * OdeMath.dCalcVectorDot3(axis, anchor2_minus_a1));
            info.setC(1, k * OdeMath.dCalcVectorDot3(q1, anchor2_minus_a1));
            info.setC(2, k * OdeMath.dCalcVectorDot3(q2, anchor2_minus_a1));
        }
    }

    void setFixedOrientation(DxJoint joint, Info2 info, DQuaternion qrel, int start_row) {
        int s = info.rowskip();
        int start_index = start_row * s;
        info._J[info.J1ap + start_index] = 1.0;
        info._J[info.J1ap + start_index + s + 1] = 1.0;
        info._J[info.J1ap + start_index + s * 2 + 2] = 1.0;
        if (joint.node[1].body != null) {
            info._J[info.J2ap + start_index] = -1.0;
            info._J[info.J2ap + start_index + s + 1] = -1.0;
            info._J[info.J2ap + start_index + s * 2 + 2] = -1.0;
        }
        DQuaternion qerr = new DQuaternion();
        DVector3 e = new DVector3();
        if (joint.node[1].body != null) {
            DQuaternion qq = new DQuaternion();
            Rotation.dQMultiply1(qq, joint.node[0].body._q, joint.node[1].body._q);
            Rotation.dQMultiply2(qerr, qq, qrel);
        } else {
            Rotation.dQMultiply3(qerr, joint.node[0].body._q, qrel);
        }
        if (qerr.get0() < 0.0) {
            qerr.set1(-qerr.get1());
            qerr.set2(-qerr.get2());
            qerr.set3(-qerr.get3());
        }
        DVector3 qerr2 = new DVector3();
        qerr2.set0(qerr.get1());
        qerr2.set1(qerr.get2());
        qerr2.set2(qerr.get3());
        OdeMath.dMultiply0_331(e, joint.node[0].body.posr().R(), (DVector3C)qerr2);
        double k = info.fps * info.erp;
        info.setC(start_row, 2.0 * k * e.get0());
        info.setC(start_row + 1, 2.0 * k * e.get1());
        info.setC(start_row + 2, 2.0 * k * e.get2());
    }

    final void setAnchors(DVector3C xyz, DVector3 anchor1, DVector3 anchor2) {
        if (this.node[0].body != null) {
            DVector3 q = new DVector3();
            q.eqDiff(xyz, this.node[0].body.posr().pos());
            OdeMath.dMultiply1_331(anchor1, this.node[0].body.posr().R(), q);
            if (this.node[1].body != null) {
                q.eqDiff(xyz, this.node[1].body.posr().pos());
                OdeMath.dMultiply1_331(anchor2, this.node[1].body.posr().R(), q);
            } else {
                anchor2.set(xyz);
            }
        }
    }

    void setAxes(double x, double y, double z, DVector3 axis1, DVector3 axis2) {
        if (this.node[0].body != null) {
            DVector3 q = new DVector3(x, y, z);
            OdeMath.dNormalize3(q);
            if (axis1 != null) {
                OdeMath.dMultiply1_331(axis1, this.node[0].body.posr().R(), q);
            }
            if (axis2 != null) {
                if (this.node[1].body != null) {
                    OdeMath.dMultiply1_331(axis2, this.node[1].body.posr().R(), q);
                } else {
                    axis2.set(x, y, z);
                }
            }
        }
    }

    void setAxes(DVector3C axis, DVector3 axis1, DVector3 axis2) {
        if (this.node[0].body != null) {
            DVector3 q = new DVector3(axis);
            OdeMath.dNormalize3(q);
            if (axis1 != null) {
                OdeMath.dMultiply1_331(axis1, this.node[0].body.posr().R(), q);
            }
            if (axis2 != null) {
                if (this.node[1].body != null) {
                    OdeMath.dMultiply1_331(axis2, this.node[1].body.posr().R(), q);
                } else {
                    axis2.set(axis);
                }
            }
        }
    }

    void getAnchor(DVector3 result, DVector3 anchor1) {
        if (this.node[0].body != null) {
            OdeMath.dMultiply0_331(result, this.node[0].body.posr().R(), (DVector3C)anchor1);
            result.add(this.node[0].body.posr().pos());
        }
    }

    void getAnchor2(DVector3 result, DVector3 anchor2) {
        if (this.node[1].body != null) {
            OdeMath.dMultiply0_331(result, this.node[1].body.posr().R(), (DVector3C)anchor2);
            result.add(this.node[1].body.posr().pos());
        } else {
            result.set(anchor2);
        }
    }

    void getAxis(DVector3 result, DVector3C axis1) {
        if (this.node[0].body != null) {
            OdeMath.dMultiply0_331(result, this.node[0].body.posr().R(), axis1);
        }
    }

    void getAxis2(DVector3 result, DVector3C axis2) {
        if (this.node[1].body != null) {
            OdeMath.dMultiply0_331(result, this.node[1].body.posr().R(), axis2);
        } else {
            result.set(axis2);
        }
    }

    double getHingeAngleFromRelativeQuat(DQuaternionC qrel, DVector3C axis) {
        double theta;
        double cost2 = qrel.get0();
        double sint2 = Common.dSqrt(qrel.get1() * qrel.get1() + qrel.get2() * qrel.get2() + qrel.get3() * qrel.get3());
        double d = theta = qrel.get1() * axis.get0() + qrel.get2() * axis.get1() + qrel.get3() * axis.get2() >= 0.0 ? 2.0 * Common.dAtan2(sint2, cost2) : 2.0 * Common.dAtan2(sint2, -cost2);
        if (theta > Math.PI) {
            theta -= Math.PI * 2;
        }
        theta = -theta;
        return theta;
    }

    double getHingeAngle(DxBody body1, DxBody body2, DVector3 axis, DQuaternion q_initial) {
        DQuaternion qrel = new DQuaternion();
        if (body2 != null) {
            DQuaternion qq = new DQuaternion();
            Rotation.dQMultiply1(qq, body1._q, body2._q);
            Rotation.dQMultiply2(qrel, qq, q_initial);
        } else {
            Rotation.dQMultiply3(qrel, body1._q, q_initial);
        }
        return this.getHingeAngleFromRelativeQuat(qrel, axis);
    }

    int dJointGetNumBodies() {
        if (this.node[0].body == null) {
            return 0;
        }
        if (this.node[1].body == null) {
            return 1;
        }
        return 2;
    }

    public void dJointAttach(DBody b1, DBody b2) {
        DxBody body1 = (DxBody)b1;
        DxBody body2 = (DxBody)b2;
        Common.dUASSERT(body1 == null || body1 != body2, "can't have body1==body2");
        DxWorld world = this.world;
        Common.dUASSERT(!(body1 != null && body1.getWorld() != world || body2 != null && body2.getWorld() != world), "joint and bodies must be in same world");
        Common.dUASSERT((this.flags & 4) == 0 || !(body1 != null ^ body2 != null), "joint can not be attached to just one body");
        if (this.node[0].body != null || this.node[1].body != null) {
            this.removeJointReferencesFromAttachedBodies();
        }
        if (body1 == null) {
            body1 = body2;
            body2 = null;
            this.flags |= 2;
        } else {
            this.flags &= 0xFFFFFFFD;
        }
        this.node[0].body = body1;
        this.node[1].body = body2;
        if (body1 != null) {
            this.node[1].next = body1.firstjoint.get();
            body1.firstjoint.set(this.node[1]);
        } else {
            this.node[1].next = null;
        }
        if (body2 != null) {
            this.node[0].next = body2.firstjoint.get();
            body2.firstjoint.set(this.node[0]);
        } else {
            this.node[0].next = null;
        }
        if (body1 != null || body2 != null) {
            this.setRelativeValues();
        }
    }

    void setRelativeValues() {
    }

    @Override
    public void enable() {
        this.flags &= 0xFFFFFFF7;
    }

    @Override
    public void disable() {
        this.flags |= 8;
    }

    @Override
    public boolean isEnabled() {
        return (this.flags & 8) == 0;
    }

    public void removeJointReferencesFromAttachedBodies() {
        int i = 0;
        while (i < 2) {
            DxBody body = this.node[i].body;
            if (body != null) {
                DxJointNode n = body.firstjoint.get();
                DxJointNode last = null;
                while (n != null) {
                    if (n.joint == this) {
                        if (last != null) {
                            last.next = n.next;
                            break;
                        }
                        body.firstjoint.set(n.next);
                        break;
                    }
                    last = n;
                    n = n.next;
                }
            }
            ++i;
        }
        this.node[0].body = null;
        this.node[0].next = null;
        this.node[1].body = null;
        this.node[1].next = null;
    }

    public void dJointSetData(Object data) {
        this.userdata = data;
    }

    public Object dJointGetData() {
        return this.userdata;
    }

    public DxBody dJointGetBody(int index) {
        if (index == 0 || index == 1) {
            if (this.isFlagsReverse()) {
                return this.node[1 - index].body;
            }
            return this.node[index].body;
        }
        return null;
    }

    public void dJointSetFeedback(DJoint.DJointFeedback f) {
        this.feedback = f;
    }

    DJoint.DJointFeedback dJointGetFeedback() {
        return this.feedback;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void destroy() {
    }

    @Override
    public final int getNumBodies() {
        return this.dJointGetNumBodies();
    }

    @Override
    public final void attach(DBody body1, DBody body2) {
        this.dJointAttach(body1, body2);
    }

    @Override
    public final void setData(Object data) {
        this.dJointSetData(data);
    }

    @Override
    public Object getData() {
        return this.dJointGetData();
    }

    @Override
    public final DBody getBody(int index) {
        return this.dJointGetBody(index);
    }

    @Override
    public final void setFeedback(DJoint.DJointFeedback fb) {
        this.dJointSetFeedback(fb);
    }

    @Override
    public final DJoint.DJointFeedback getFeedback() {
        return this.dJointGetFeedback();
    }

    @Override
    public abstract void setParam(DJoint.PARAM_N var1, double var2);

    @Override
    public abstract double getParam(DJoint.PARAM_N var1);

    public static final class Info1 {
        public int m;
        public int nub;

        public int getM() {
            return this.m;
        }

        public void incM() {
            ++this.m;
        }

        public void setM(int m) {
            this.m = m;
        }

        public int getNub() {
            return this.nub;
        }

        public void setNub(int nub) {
            this.nub = nub;
        }

        public final void set(Info1 i) {
            this.m = i.m;
            this.nub = i.nub;
        }
    }

    public static class Info2 {
        public double fps;
        public double erp;
        public int J1lp;
        public int J1ap;
        public int J2lp;
        public int J2ap;
        private int _rowskip;
        double[] _J;
        protected double[] _cA;
        int _cP;
        protected double[] _cfmA;
        int _cfmP;
        private double[] _loA;
        int _loP;
        private double[] _hiA;
        int _hiP;
        private int _findexP;
        private int[] _findexA;

        public int rowskip() {
            return this._rowskip;
        }

        public void setRowskip(int rs) {
            this._rowskip = rs;
        }

        public double[] getJ() {
            return this._J;
        }

        public void setJ(double[] J) {
            this._J = J;
        }

        public void setC(int i, double d) {
            this._cA[this._cP + i] = d;
        }

        public void setC(int i, DVector3C v) {
            this._cA[this._cP + i] = v.get0();
        }

        public double getC(int i) {
            return this._cA[this._cP + i];
        }

        public void setCfm(int i, double d) {
            this._cfmA[this._cfmP + i] = d;
        }

        public void setLo(int i, double d) {
            this._loA[this._loP + i] = d;
        }

        public void setHi(int i, double d) {
            this._hiA[this._hiP + i] = d;
        }

        public void setFindex(int i, int val) {
            this._findexA[this._findexP + i] = val;
        }

        public double getFindex(int i) {
            return this._findexA[this._findexP + i];
        }

        public void setAllP(int i) {
            this._cP = i;
            this._cfmP = i;
            this._loP = i;
            this._hiP = i;
            this._findexP = i;
        }

        public void setArrays(double[] J, double[] c, double[] cfm, double[] lo, double[] hi, int[] findex) {
            this._J = J;
            this._cA = c;
            this._cfmA = cfm;
            this._loA = lo;
            this._hiA = hi;
            this._findexA = findex;
        }
    }

    static class SureMaxInfo {
        int max_m;

        SureMaxInfo() {
        }
    }
}

