/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal.gimpact;

import org.cpp4j.java.ObjArray;
import org.cpp4j.java.RefFloat;
import org.ode4j.ode.internal.gimpact.GimAABBSet;
import org.ode4j.ode.internal.gimpact.GimContact;
import org.ode4j.ode.internal.gimpact.GimDynArray;
import org.ode4j.ode.internal.gimpact.GimGeometry;
import org.ode4j.ode.internal.gimpact.GimTriCollision;
import org.ode4j.ode.internal.gimpact.GimTrimesh;

public class GimTrimeshTrimeshCol {
    private static boolean CLASSIFY_TRI_BY_FACE(GimGeometry.vec3f[] v, GimGeometry.vec4f faceplane, GimGeometry.vec3f _distances) {
        _distances.f[0] = GimGeometry.DISTANCE_PLANE_POINT(faceplane, v[0]);
        _distances.f[1] = _distances.f[0] * GimGeometry.DISTANCE_PLANE_POINT(faceplane, v[1]);
        _distances.f[2] = _distances.f[0] * GimGeometry.DISTANCE_PLANE_POINT(faceplane, v[2]);
        return _distances.f[1] > 0.0f && _distances.f[2] > 0.0f;
    }

    private static boolean CLASSIFY_TRI_BY_FACE(GimGeometry.vec3f[] v, GimGeometry.vec4f faceplane) {
        float d0 = GimGeometry.DISTANCE_PLANE_POINT(faceplane, v[0]);
        float d1 = d0 * GimGeometry.DISTANCE_PLANE_POINT(faceplane, v[1]);
        float d2 = d0 * GimGeometry.DISTANCE_PLANE_POINT(faceplane, v[2]);
        return d1 > 0.0f && d2 > 0.0f;
    }

    private static int MOST_DEEP_POINTS(GimGeometry.vec4f plane, GimGeometry.vec3f[] points, int point_count, GimGeometry.vec3f[] deep_points, RefFloat maxdeep, int[] _max_candidates) {
        maxdeep.d = -1000.0f;
        int deep_points_count = 0;
        int _k = 0;
        while (_k < point_count) {
            float _dist = -GimGeometry.DISTANCE_PLANE_POINT(plane, points[_k]);
            if (_dist > maxdeep.d) {
                maxdeep.d = _dist;
                _max_candidates[0] = _k;
                deep_points_count = 1;
            } else if (_dist + 1.0E-7f >= maxdeep.d) {
                _max_candidates[deep_points_count] = _k;
                ++deep_points_count;
            }
            ++_k;
        }
        if (maxdeep.d < 0.0f) {
            deep_points_count = 0;
        } else {
            _k = 0;
            while (_k < deep_points_count) {
                GimGeometry.VEC_COPY(deep_points[_k], points[_max_candidates[_k]]);
                ++_k;
            }
        }
        return deep_points_count;
    }

    private static int CLIP_TRI_POINTS_BY_TRI_EDGE_PLANES(GimGeometry.vec3f[] tri_points, GimGeometry.vec4f[] tri_edge_planes, int pos, GimGeometry.vec3f[] clipped_points, GimGeometry.vec3f[] _temp_clip, GimGeometry.vec3f[] _temp_clip2) {
        int clipped_point_count = 0;
        int _temp_clip_count = GimTriCollision.PLANE_CLIP_POLYGON(tri_edge_planes[0 + pos], tri_points, 3, _temp_clip, 8);
        if (_temp_clip_count > 0) {
            int _temp_clip_count2 = 0;
            _temp_clip_count2 = GimTriCollision.PLANE_CLIP_POLYGON(tri_edge_planes[1 + pos], _temp_clip, _temp_clip_count, _temp_clip2, 8);
            if (_temp_clip_count2 > 0) {
                clipped_point_count = GimTriCollision.PLANE_CLIP_POLYGON(tri_edge_planes[2 + pos], _temp_clip2, _temp_clip_count2, clipped_points, 8);
            }
        }
        return clipped_point_count;
    }

    static boolean _gim_triangle_triangle_collision(GimTriCollision.GIM_TRIANGLE_DATA tri1, GimTriCollision.GIM_TRIANGLE_DATA tri2, GimTriCollision.GIM_TRIANGLE_CONTACT_DATA contact_data) {
        int[] _max_candidates = new int[8];
        GimGeometry.vec3f[] _temp_clip = new GimGeometry.vec3f[8];
        GimGeometry.vec3f[] _temp_clip2 = new GimGeometry.vec3f[8];
        GimGeometry.vec3f[] clipped_points2 = new GimGeometry.vec3f[8];
        GimGeometry.vec3f[] deep_points2 = new GimGeometry.vec3f[8];
        GimGeometry.vec3f[] clipped_points1 = new GimGeometry.vec3f[8];
        GimGeometry.vec3f[] deep_points1 = new GimGeometry.vec3f[8];
        int i = 0;
        while (i < 8) {
            _temp_clip[i] = new GimGeometry.vec3f();
            _temp_clip2[i] = new GimGeometry.vec3f();
            clipped_points1[i] = new GimGeometry.vec3f();
            clipped_points2[i] = new GimGeometry.vec3f();
            deep_points1[i] = new GimGeometry.vec3f();
            deep_points2[i] = new GimGeometry.vec3f();
            ++i;
        }
        int mostdir = 0;
        int clipped2_count = 0;
        clipped2_count = GimTrimeshTrimeshCol.CLIP_TRI_POINTS_BY_TRI_EDGE_PLANES(tri2.m_vertices, tri1.m_planes.m_planes, 1, clipped_points2, _temp_clip, _temp_clip2);
        if (clipped2_count == 0) {
            return false;
        }
        int deep2_count = 0;
        RefFloat maxdeep = new RefFloat();
        deep2_count = GimTrimeshTrimeshCol.MOST_DEEP_POINTS(tri1.m_planes.m_planes[0], clipped_points2, clipped2_count, deep_points2, maxdeep, _max_candidates);
        if (deep2_count == 0) {
            return false;
        }
        GimGeometry.VEC_SCALE(contact_data.m_separating_normal, -1.0f, tri1.m_planes.m_planes[0]);
        int clipped1_count = 0;
        clipped1_count = GimTrimeshTrimeshCol.CLIP_TRI_POINTS_BY_TRI_EDGE_PLANES(tri1.m_vertices, tri2.m_planes.m_planes, 1, clipped_points1, _temp_clip, _temp_clip2);
        if (clipped2_count == 0) {
            return false;
        }
        int deep1_count = 0;
        RefFloat dist = new RefFloat();
        deep1_count = GimTrimeshTrimeshCol.MOST_DEEP_POINTS(tri2.m_planes.m_planes[0], clipped_points1, clipped1_count, deep_points1, dist, _max_candidates);
        if (deep1_count == 0) {
            return false;
        }
        if (dist.d < maxdeep.d) {
            maxdeep = dist;
            mostdir = 1;
            GimGeometry.VEC_COPY(contact_data.m_separating_normal, tri2.m_planes.m_planes[0]);
        }
        contact_data.m_penetration_depth = maxdeep.d;
        if (mostdir == 0) {
            contact_data.m_point_count = deep2_count;
            mostdir = 0;
            while (mostdir < deep2_count) {
                GimGeometry.VEC_COPY(contact_data.m_points[mostdir], deep_points2[mostdir]);
                ++mostdir;
            }
        } else {
            contact_data.m_point_count = deep1_count;
            mostdir = 0;
            while (mostdir < deep1_count) {
                GimGeometry.VEC_COPY(contact_data.m_points[mostdir], deep_points1[mostdir]);
                ++mostdir;
            }
        }
        return true;
    }

    static boolean gim_triangle_triangle_collision(GimTriCollision.GIM_TRIANGLE_DATA tri1, GimTriCollision.GIM_TRIANGLE_DATA tri2, GimTriCollision.GIM_TRIANGLE_CONTACT_DATA contact_data) {
        if (GimTrimeshTrimeshCol.CLASSIFY_TRI_BY_FACE(tri1.m_vertices, tri2.m_planes.m_planes[0])) {
            return false;
        }
        if (GimTrimeshTrimeshCol.CLASSIFY_TRI_BY_FACE(tri2.m_vertices, tri1.m_planes.m_planes[0])) {
            return false;
        }
        return GimTrimeshTrimeshCol._gim_triangle_triangle_collision(tri1, tri2, contact_data);
    }

    static void gim_trimesh_trimesh_collision(GimTrimesh trimesh1, GimTrimesh trimesh2, GimDynArray<GimContact> contacts) {
        contacts.m_size = 0;
        GimDynArray<GimAABBSet.GIM_PAIR> collision_pairs = GimAABBSet.GIM_CREATE_PAIR_SET();
        GimAABBSet.gim_aabbset_bipartite_intersections(trimesh1.m_aabbset, trimesh2.m_aabbset, collision_pairs);
        if (collision_pairs.size() == 0) {
            collision_pairs.GIM_DYNARRAY_DESTROY();
            return;
        }
        trimesh1.gim_trimesh_locks_work_data();
        trimesh2.gim_trimesh_locks_work_data();
        ObjArray<GimAABBSet.GIM_PAIR> pairs = collision_pairs.GIM_DYNARRAY_POINTER_V();
        GimDynArray<GimContact> dummycontacts = GimContact.GIM_CREATE_CONTACT_LIST();
        GimTriCollision.GIM_TRIANGLE_CONTACT_DATA tri_contact_data = new GimTriCollision.GIM_TRIANGLE_CONTACT_DATA();
        GimTriCollision.GIM_TRIANGLE_DATA tri1data = new GimTriCollision.GIM_TRIANGLE_DATA();
        GimTriCollision.GIM_TRIANGLE_DATA tri2data = new GimTriCollision.GIM_TRIANGLE_DATA();
        int i = 0;
        while (i < collision_pairs.size()) {
            int ti1 = pairs.at((int)i).m_index1;
            int ti2 = pairs.at((int)i).m_index2;
            trimesh1.gim_trimesh_get_triangle_data(ti1, tri1data);
            trimesh2.gim_trimesh_get_triangle_data(ti2, tri2data);
            boolean colresult = GimTrimeshTrimeshCol.gim_triangle_triangle_collision(tri1data, tri2data, tri_contact_data);
            if (colresult) {
                int ci = 0;
                while (ci < tri_contact_data.m_point_count) {
                    GimContact.GIM_PUSH_CONTACT(dummycontacts, tri_contact_data.m_points[ci], tri_contact_data.m_separating_normal, tri_contact_data.m_penetration_depth, trimesh1, trimesh2, ti1, ti2);
                    ++ci;
                }
            }
            ++i;
        }
        if (dummycontacts.size() == 0) {
            dummycontacts.GIM_DYNARRAY_DESTROY();
            collision_pairs.GIM_DYNARRAY_DESTROY();
            return;
        }
        GimContact.gim_merge_contacts(dummycontacts, contacts);
        dummycontacts.GIM_DYNARRAY_DESTROY();
        collision_pairs.GIM_DYNARRAY_DESTROY();
        trimesh1.gim_trimesh_unlocks_work_data();
        trimesh2.gim_trimesh_unlocks_work_data();
    }

    static void gim_trimesh_plane_collision(GimTrimesh trimesh, GimGeometry.vec4f plane, GimDynArray<GimGeometry.vec4f> contacts) {
        contacts.m_size = 0;
        int classify = GimGeometry.PLANE_CLASSIFY_BOX(plane, trimesh.m_aabbset.m_global_bound);
        if (classify > 1) {
            return;
        }
        trimesh.gim_trimesh_locks_work_data();
        int vertcount = trimesh.m_transformed_vertex_buffer.size();
        ObjArray<GimGeometry.vec3f> vertices = trimesh.m_transformed_vertex_buffer.GIM_BUFFER_ARRAY_POINTER(0);
        int i = 0;
        while (i < vertcount) {
            float dist = GimGeometry.DISTANCE_PLANE_POINT(plane, vertices.at(i));
            if (dist <= 0.0f) {
                GimGeometry.vec4f result_contact = new GimGeometry.vec4f();
                GimGeometry.VEC_COPY(result_contact, vertices.at(i));
                result_contact.f[3] = -dist;
                contacts.GIM_DYNARRAY_PUSH_ITEM_TZ(result_contact);
            }
            ++i;
        }
        trimesh.gim_trimesh_unlocks_work_data();
    }
}

