/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal.gimpact;

import org.ode4j.ode.internal.gimpact.GimContact;
import org.ode4j.ode.internal.gimpact.GimDynArray;
import org.ode4j.ode.internal.gimpact.GimDynArrayInt;
import org.ode4j.ode.internal.gimpact.GimGeometry;
import org.ode4j.ode.internal.gimpact.GimMath;
import org.ode4j.ode.internal.gimpact.GimTriCollision;
import org.ode4j.ode.internal.gimpact.GimTrimesh;

public class GimTrimeshSphereCollision {
    static boolean gim_triangle_sphere_collision(GimTriCollision.GIM_TRIANGLE_DATA tri, GimGeometry.vec3f center, float radius, GimTriCollision.GIM_TRIANGLE_CONTACT_DATA contact_data) {
        contact_data.m_point_count = 0;
        float dis = GimGeometry.DISTANCE_PLANE_POINT(tri.m_planes.m_planes[0], center);
        if (dis > radius) {
            return false;
        }
        if (dis < -radius) {
            return false;
        }
        contact_data.m_penetration_depth = dis;
        int most_edge = 4;
        float max_dis = 0.0f;
        dis = GimGeometry.DISTANCE_PLANE_POINT(tri.m_planes.m_planes[1], center);
        if (dis > radius) {
            return false;
        }
        if (dis > 0.0f) {
            max_dis = dis;
            most_edge = 0;
        }
        if ((dis = GimGeometry.DISTANCE_PLANE_POINT(tri.m_planes.m_planes[2], center)) > radius) {
            return false;
        }
        if (dis > max_dis) {
            max_dis = dis;
            most_edge = 1;
        }
        if ((dis = GimGeometry.DISTANCE_PLANE_POINT(tri.m_planes.m_planes[3], center)) > radius) {
            return false;
        }
        if (dis > max_dis) {
            max_dis = dis;
            most_edge = 2;
        }
        if (most_edge == 4) {
            GimGeometry.VEC_COPY(contact_data.m_separating_normal, tri.m_planes.m_planes[0]);
            if (contact_data.m_penetration_depth >= 0.0f) {
                GimGeometry.VEC_SCALE(contact_data.m_points[0], -radius, contact_data.m_separating_normal);
            } else {
                GimGeometry.VEC_SCALE(contact_data.m_points[0], radius, contact_data.m_separating_normal);
            }
            contact_data.m_penetration_depth = radius - contact_data.m_penetration_depth;
            GimGeometry.VEC_SUM(contact_data.m_points[0], contact_data.m_points[0], center);
            GimGeometry.VEC_SCALE(contact_data.m_separating_normal, -1.0f, contact_data.m_separating_normal);
            contact_data.m_point_count = 1;
            return true;
        }
        GimGeometry.vec3f e1 = new GimGeometry.vec3f();
        GimGeometry.vec3f e2 = new GimGeometry.vec3f();
        GimGeometry.VEC_COPY(e1, tri.m_vertices[most_edge]);
        GimGeometry.VEC_COPY(e2, tri.m_vertices[(most_edge + 1) % 3]);
        GimGeometry.CLOSEST_POINT_ON_SEGMENT(contact_data.m_points[0], center, e1, e2);
        GimGeometry.VEC_DIFF(e1, center, contact_data.m_points[0]);
        dis = GimGeometry.VEC_LENGTH(e1);
        if (dis > radius) {
            return false;
        }
        contact_data.m_penetration_depth = radius - dis;
        if (GimMath.IS_ZERO(dis)) {
            GimGeometry.VEC_COPY(contact_data.m_separating_normal, tri.m_planes.m_planes[most_edge + 1]);
            GimGeometry.VEC_SCALE(contact_data.m_points[0], -radius, contact_data.m_separating_normal);
            GimGeometry.VEC_SUM(contact_data.m_points[0], contact_data.m_points[0], center);
        } else {
            GimGeometry.VEC_SCALE(contact_data.m_separating_normal, 1.0f / dis, e1);
            GimGeometry.VEC_SCALE(contact_data.m_points[0], -radius, contact_data.m_separating_normal);
            GimGeometry.VEC_SUM(contact_data.m_points[0], contact_data.m_points[0], center);
        }
        GimGeometry.VEC_SCALE(contact_data.m_separating_normal, -1.0f, contact_data.m_separating_normal);
        contact_data.m_point_count = 1;
        return true;
    }

    static void gim_trimesh_sphere_collision(GimTrimesh trimesh, GimGeometry.vec3f center, float radius, GimDynArray<GimContact> contacts) {
        contacts.m_size = 0;
        GimGeometry.aabb3f test_aabb = new GimGeometry.aabb3f();
        test_aabb.minX = center.f[0] - radius;
        test_aabb.maxX = center.f[0] + radius;
        test_aabb.minY = center.f[1] - radius;
        test_aabb.maxY = center.f[1] + radius;
        test_aabb.minZ = center.f[2] - radius;
        test_aabb.maxZ = center.f[2] + radius;
        GimDynArrayInt collision_result = GimDynArrayInt.GIM_CREATE_BOXQUERY_LIST();
        trimesh.m_aabbset.gim_aabbset_box_collision(test_aabb, collision_result);
        if (collision_result.size() == 0) {
            collision_result.GIM_DYNARRAY_DESTROY();
        }
        trimesh.gim_trimesh_locks_work_data();
        GimDynArray<GimContact> dummycontacts = GimContact.GIM_CREATE_CONTACT_LIST();
        int[] boxesresult = collision_result.GIM_DYNARRAY_POINTER();
        GimTriCollision.GIM_TRIANGLE_CONTACT_DATA tri_contact_data = new GimTriCollision.GIM_TRIANGLE_CONTACT_DATA();
        GimTriCollision.GIM_TRIANGLE_DATA tri_data = new GimTriCollision.GIM_TRIANGLE_DATA();
        int i = 0;
        while (i < collision_result.size()) {
            trimesh.gim_trimesh_get_triangle_data(boxesresult[i], tri_data);
            boolean cresult = GimTrimeshSphereCollision.gim_triangle_sphere_collision(tri_data, center, radius, tri_contact_data);
            if (cresult) {
                GimContact.GIM_PUSH_CONTACT(dummycontacts, tri_contact_data.m_points[0], tri_contact_data.m_separating_normal, tri_contact_data.m_penetration_depth, trimesh, null, boxesresult[i], 0);
            }
            ++i;
        }
        trimesh.gim_trimesh_unlocks_work_data();
        collision_result.GIM_DYNARRAY_DESTROY();
        GimContact.gim_merge_contacts(dummycontacts, contacts);
        dummycontacts.GIM_DYNARRAY_DESTROY();
    }
}

