/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal.gimpact;

import org.cpp4j.java.RefBoolean;
import org.cpp4j.java.RefFloat;
import org.ode4j.ode.internal.gimpact.GimDynArrayInt;
import org.ode4j.ode.internal.gimpact.GimGeometry;
import org.ode4j.ode.internal.gimpact.GimTriCollision;
import org.ode4j.ode.internal.gimpact.GimTrimesh;

public class GimTrimeshRayCollision {
    static int gim_trimesh_ray_collision(GimTrimesh trimesh, GimGeometry.vec3f origin, GimGeometry.vec3f dir, float tmax, GimTriCollision.GIM_TRIANGLE_RAY_CONTACT_DATA contact) {
        GimDynArrayInt collision_result = GimDynArrayInt.GIM_CREATE_BOXQUERY_LIST();
        trimesh.m_aabbset.gim_aabbset_ray_collision(origin, dir, tmax, collision_result);
        if (collision_result.size() == 0) {
            collision_result.GIM_DYNARRAY_DESTROY();
            return 0;
        }
        int[] boxesresult = collision_result.GIM_DYNARRAY_POINTER();
        GimTriCollision.GIM_TRIANGLE_DATA tridata = new GimTriCollision.GIM_TRIANGLE_DATA();
        GimGeometry.vec3f pout = new GimGeometry.vec3f();
        RefFloat tparam = new RefFloat(0.0f);
        RefFloat u = new RefFloat(0.0f);
        RefFloat v = new RefFloat(0.0f);
        RefBoolean does_intersect = new RefBoolean(false);
        trimesh.gim_trimesh_locks_work_data();
        int i = 0;
        while (i < collision_result.size()) {
            trimesh.gim_trimesh_get_triangle_data(boxesresult[i], tridata);
            GimGeometry.vec4f flippedPlane = new GimGeometry.vec4f();
            GimGeometry.VEC_SCALE_4(flippedPlane, -1.0f, tridata.m_planes.m_planes[0]);
            GimTriCollision.RAY_TRIANGLE_INTERSECTION(origin, dir, tridata.m_vertices[0], tridata.m_vertices[1], tridata.m_vertices[2], flippedPlane, pout, u, v, tparam, tmax, does_intersect);
            if (does_intersect.b) {
                contact.tparam = tparam.d;
                contact.u = u.d;
                contact.v = v.d;
                contact.m_face_id = boxesresult[i];
                GimGeometry.VEC_COPY(contact.m_point, pout);
                GimGeometry.VEC_COPY(contact.m_normal, flippedPlane);
                trimesh.gim_trimesh_unlocks_work_data();
                collision_result.GIM_DYNARRAY_DESTROY();
                return 1;
            }
            ++i;
        }
        trimesh.gim_trimesh_unlocks_work_data();
        collision_result.GIM_DYNARRAY_DESTROY();
        return 0;
    }

    static int gim_trimesh_ray_closest_collision(GimTrimesh trimesh, GimGeometry.vec3f origin, GimGeometry.vec3f dir, float tmax, GimTriCollision.GIM_TRIANGLE_RAY_CONTACT_DATA contact) {
        GimDynArrayInt collision_result = GimDynArrayInt.GIM_CREATE_BOXQUERY_LIST();
        trimesh.m_aabbset.gim_aabbset_ray_collision(origin, dir, tmax, collision_result);
        if (collision_result.size() == 0) {
            collision_result.GIM_DYNARRAY_DESTROY();
            return 0;
        }
        int[] boxesresult = collision_result.GIM_DYNARRAY_POINTER();
        GimTriCollision.GIM_TRIANGLE_DATA tridata = new GimTriCollision.GIM_TRIANGLE_DATA();
        GimGeometry.vec3f pout = new GimGeometry.vec3f();
        RefFloat tparam = new RefFloat(0.0f);
        RefFloat u = new RefFloat(0.0f);
        RefFloat v = new RefFloat(0.0f);
        RefBoolean does_intersect = new RefBoolean(false);
        contact.tparam = tmax + 0.1f;
        trimesh.gim_trimesh_locks_work_data();
        int i = 0;
        while (i < collision_result.size()) {
            trimesh.gim_trimesh_get_triangle_data(boxesresult[i], tridata);
            GimGeometry.vec4f flippedPlane = new GimGeometry.vec4f();
            GimGeometry.VEC_SCALE_4(flippedPlane, -1.0f, tridata.m_planes.m_planes[0]);
            GimTriCollision.RAY_TRIANGLE_INTERSECTION(origin, dir, tridata.m_vertices[0], tridata.m_vertices[1], tridata.m_vertices[2], flippedPlane, pout, u, v, tparam, tmax, does_intersect);
            if (does_intersect.b && tparam.d < contact.tparam) {
                contact.tparam = tparam.d;
                contact.u = u.d;
                contact.v = v.d;
                contact.m_face_id = boxesresult[i];
                GimGeometry.VEC_COPY(contact.m_point, pout);
                GimGeometry.VEC_COPY(contact.m_normal, flippedPlane);
            }
            ++i;
        }
        trimesh.gim_trimesh_unlocks_work_data();
        collision_result.GIM_DYNARRAY_DESTROY();
        if (contact.tparam > tmax) {
            return 0;
        }
        return 1;
    }
}

