/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal.gimpact;

import org.cpp4j.java.ObjArray;
import org.ode4j.ode.internal.gimpact.GimContact;
import org.ode4j.ode.internal.gimpact.GimDynArray;
import org.ode4j.ode.internal.gimpact.GimDynArrayInt;
import org.ode4j.ode.internal.gimpact.GimGeometry;
import org.ode4j.ode.internal.gimpact.GimMath;
import org.ode4j.ode.internal.gimpact.GimTriCollision;
import org.ode4j.ode.internal.gimpact.GimTrimesh;

public class GimTrimeshCapsuleCollision {
    private static void CALC_CAPSULE_AABB(GIM_CAPSULE_DATA capsule, GimGeometry.aabb3f aabb) {
        if (capsule.m_point1.f[0] < capsule.m_point2.f[0]) {
            aabb.minX = capsule.m_point1.f[0] - capsule.m_radius;
            aabb.maxX = capsule.m_point2.f[0] + capsule.m_radius;
        } else {
            aabb.minX = capsule.m_point2.f[0] - capsule.m_radius;
            aabb.maxX = capsule.m_point1.f[0] + capsule.m_radius;
        }
        if (capsule.m_point1.f[1] < capsule.m_point2.f[1]) {
            aabb.minY = capsule.m_point1.f[1] - capsule.m_radius;
            aabb.maxY = capsule.m_point2.f[1] + capsule.m_radius;
        } else {
            aabb.minY = capsule.m_point2.f[1] - capsule.m_radius;
            aabb.maxY = capsule.m_point1.f[1] + capsule.m_radius;
        }
        if (capsule.m_point1.f[2] < capsule.m_point2.f[2]) {
            aabb.minZ = capsule.m_point1.f[2] - capsule.m_radius;
            aabb.maxZ = capsule.m_point2.f[2] + capsule.m_radius;
        } else {
            aabb.minZ = capsule.m_point2.f[2] - capsule.m_radius;
            aabb.maxZ = capsule.m_point1.f[2] + capsule.m_radius;
        }
    }

    static void gim_closest_point_triangle_segment(GimTriCollision.GIM_TRIANGLE_DATA triangle, GimGeometry.vec3f s1, GimGeometry.vec3f s2, GimDynArray<GimContact> contacts) {
        GimGeometry.vec3f[] segment_points = new GimGeometry.vec3f[]{new GimGeometry.vec3f(), new GimGeometry.vec3f(), new GimGeometry.vec3f(), new GimGeometry.vec3f()};
        GimGeometry.vec3f[] closest_points = new GimGeometry.vec3f[]{new GimGeometry.vec3f(), new GimGeometry.vec3f()};
        int out_edge = 10;
        GimGeometry.vec4f sdiff = new GimGeometry.vec4f();
        float dis = GimGeometry.DISTANCE_PLANE_POINT(triangle.m_planes.m_planes[0], s1);
        float dis_temp = GimGeometry.DISTANCE_PLANE_POINT(triangle.m_planes.m_planes[0], s2);
        if (dis <= 0.0f && dis_temp <= 0.0f) {
            return;
        }
        GimGeometry.VEC_DIFF(sdiff, s2, s1);
        float perpend = GimGeometry.VEC_DOT(sdiff, triangle.m_planes.m_planes[0]);
        if (!GimMath.IS_ZERO(perpend)) {
            if (dis < dis_temp) {
                GimGeometry.VEC_COPY(closest_points[0], s1);
            } else {
                dis = dis_temp;
                GimGeometry.VEC_COPY(closest_points[0], s2);
            }
            if (dis >= 0.0f && dis_temp >= 0.0f) {
                out_edge = GimGeometry.POINT_IN_HULL_TZ(closest_points[0], triangle.m_planes.m_planes, 1, 3);
                if (out_edge == 0) {
                    GimContact.GIM_PUSH_CONTACT(contacts, closest_points[0], triangle.m_planes.m_planes[0], dis, null, null, 0, 0);
                    return;
                }
            } else {
                GimGeometry.PLANE_CLIP_SEGMENT(s1, s2, triangle.m_planes.m_planes[0], closest_points[1]);
                out_edge = GimGeometry.POINT_IN_HULL_TZ(closest_points[1], triangle.m_planes.m_planes, 1, 3);
                if (out_edge == 0) {
                    GimContact.GIM_PUSH_CONTACT(contacts, closest_points[0], triangle.m_planes.m_planes[0], dis, null, null, 0, 0);
                    return;
                }
            }
        } else {
            int intersection_type = GimGeometry.PLANE_CLIP_SEGMENT_CLOSEST(s1, s2, triangle.m_planes.m_planes[1], segment_points[0], segment_points[1]);
            if (intersection_type == 0 || intersection_type == 1) {
                out_edge = 0;
                GimGeometry.VEC_COPY(closest_points[0], segment_points[0]);
            } else {
                intersection_type = GimGeometry.PLANE_CLIP_SEGMENT_CLOSEST(segment_points[0], segment_points[1], triangle.m_planes.m_planes[2], segment_points[2], segment_points[3]);
                if (intersection_type == 0 || intersection_type == 1) {
                    out_edge = 1;
                    GimGeometry.VEC_COPY(closest_points[0], segment_points[3]);
                } else {
                    intersection_type = GimGeometry.PLANE_CLIP_SEGMENT_CLOSEST(segment_points[2], segment_points[3], triangle.m_planes.m_planes[3], closest_points[0], closest_points[1]);
                    if (intersection_type == 0 || intersection_type == 1) {
                        out_edge = 2;
                    }
                }
            }
            if (out_edge > 2) {
                dis = GimGeometry.VEC_DOT(closest_points[0], triangle.m_planes.m_planes[0]);
                GimContact.GIM_PUSH_CONTACT(contacts, closest_points[0], triangle.m_planes.m_planes[0], dis, null, null, 0, 0);
                GimContact.GIM_PUSH_CONTACT(contacts, closest_points[1], triangle.m_planes.m_planes[0], dis, null, null, 0, 0);
                return;
            }
        }
        out_edge = 10;
        dis = Float.POSITIVE_INFINITY;
        int i = 0;
        while (i < 3) {
            GimGeometry.SEGMENT_COLLISION(s1, s2, triangle.m_vertices[i], triangle.m_vertices[(i + 1) % 3], segment_points[0], segment_points[1]);
            GimGeometry.VEC_DIFF(sdiff, segment_points[0], segment_points[1]);
            dis_temp = GimGeometry.VEC_DOT(sdiff, sdiff);
            if (dis_temp < dis) {
                dis = dis_temp;
                out_edge = i;
                GimGeometry.VEC_COPY(closest_points[0], segment_points[0]);
                GimGeometry.VEC_COPY(closest_points[1], sdiff);
            }
            ++i;
        }
        if (out_edge > 2) {
            return;
        }
        if (GimMath.IS_ZERO(dis)) {
            GimContact.GIM_PUSH_CONTACT(contacts, closest_points[0], triangle.m_planes.m_planes[0], 0.0f, null, null, 0, 0);
        } else {
            dis = GimMath.GIM_SQRT(dis);
            GimGeometry.VEC_SCALE(closest_points[1], 1.0f / dis, closest_points[1]);
            GimContact.GIM_PUSH_CONTACT(contacts, closest_points[0], closest_points[1], dis, null, null, 0, 0);
        }
    }

    static int gim_triangle_capsule_collision(GimTriCollision.GIM_TRIANGLE_DATA triangle, GIM_CAPSULE_DATA capsule, GimDynArray<GimContact> contacts) {
        int old_contact_size = contacts.size();
        GimTrimeshCapsuleCollision.gim_closest_point_triangle_segment(triangle, capsule.m_point1, capsule.m_point2, contacts);
        if (contacts.size() == old_contact_size) {
            return 0;
        }
        ObjArray<GimContact> pcontacts = contacts.GIM_DYNARRAY_POINTER_V();
        pcontacts.inc(old_contact_size);
        if (pcontacts.at0().m_depth > capsule.m_radius) {
            contacts.m_size = old_contact_size;
            return 0;
        }
        GimGeometry.vec3f vec = new GimGeometry.vec3f();
        while (old_contact_size < contacts.size()) {
            GimContact pcontact = pcontacts.at0();
            GimGeometry.VEC_SCALE(pcontact.m_normal, -1.0f, pcontact.m_normal);
            GimGeometry.VEC_SCALE(vec, capsule.m_radius, pcontact.m_normal);
            GimGeometry.VEC_SUM(pcontact.m_point, vec, pcontact.m_point);
            pcontact.m_depth = capsule.m_radius - pcontact.m_depth;
            pcontacts.inc();
            ++old_contact_size;
        }
        return 1;
    }

    static void gim_trimesh_capsule_collision(GimTrimesh trimesh, GIM_CAPSULE_DATA capsule, GimDynArray<GimContact> contacts) {
        contacts.m_size = 0;
        GimGeometry.aabb3f test_aabb = new GimGeometry.aabb3f();
        GimTrimeshCapsuleCollision.CALC_CAPSULE_AABB(capsule, test_aabb);
        GimDynArrayInt collision_result = GimDynArrayInt.GIM_CREATE_BOXQUERY_LIST();
        trimesh.m_aabbset.gim_aabbset_box_collision(test_aabb, collision_result);
        if (collision_result.size() == 0) {
            collision_result.GIM_DYNARRAY_DESTROY();
        }
        trimesh.gim_trimesh_locks_work_data();
        GimDynArray<GimContact> dummycontacts = GimContact.GIM_CREATE_CONTACT_LIST();
        int[] boxesresult = collision_result.GIM_DYNARRAY_POINTER();
        GimTriCollision.GIM_TRIANGLE_DATA tri_data = new GimTriCollision.GIM_TRIANGLE_DATA();
        int i = 0;
        while (i < collision_result.size()) {
            int old_contact_size = dummycontacts.size();
            trimesh.gim_trimesh_get_triangle_data(boxesresult[i], tri_data);
            int cresult = GimTrimeshCapsuleCollision.gim_triangle_capsule_collision(tri_data, capsule, dummycontacts);
            if (cresult != 0) {
                ObjArray<GimContact> pcontacts = dummycontacts.GIM_DYNARRAY_POINTER_V();
                pcontacts.inc(old_contact_size);
                while (old_contact_size < dummycontacts.size()) {
                    GimContact pcontact = pcontacts.at0();
                    pcontact.m_handle1 = trimesh;
                    pcontact.m_handle2 = capsule;
                    pcontact.m_feature1 = boxesresult[i];
                    pcontact.m_feature2 = 0;
                    pcontacts.inc();
                    ++old_contact_size;
                }
            }
            ++i;
        }
        trimesh.gim_trimesh_unlocks_work_data();
        collision_result.GIM_DYNARRAY_DESTROY();
        GimContact.gim_merge_contacts(dummycontacts, contacts);
        dummycontacts.GIM_DYNARRAY_DESTROY();
    }

    public static class GIM_CAPSULE_DATA {
        public float m_radius;
        public final GimGeometry.vec3f m_point1 = new GimGeometry.vec3f();
        public final GimGeometry.vec3f m_point2 = new GimGeometry.vec3f();
    }
}

