/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode.internal.gimpact;

import org.cpp4j.java.IntArray;
import org.cpp4j.java.ObjArray;
import org.ode4j.ode.internal.gimpact.GimAABBSet;
import org.ode4j.ode.internal.gimpact.GimBitSet;
import org.ode4j.ode.internal.gimpact.GimBufferArrayFloat;
import org.ode4j.ode.internal.gimpact.GimBufferArrayInt;
import org.ode4j.ode.internal.gimpact.GimConstants;
import org.ode4j.ode.internal.gimpact.GimContact;
import org.ode4j.ode.internal.gimpact.GimDynArray;
import org.ode4j.ode.internal.gimpact.GimGeometry;
import org.ode4j.ode.internal.gimpact.GimTriCollision;
import org.ode4j.ode.internal.gimpact.GimTrimeshCapsuleCollision;
import org.ode4j.ode.internal.gimpact.GimTrimeshRayCollision;
import org.ode4j.ode.internal.gimpact.GimTrimeshSphereCollision;
import org.ode4j.ode.internal.gimpact.GimTrimeshTrimeshCol;

public class GimTrimesh
implements GimConstants {
    private static final int GIM_TRIMESH_TRANSFORMED_REPLY = 1;
    private static final int GIM_TRIMESH_NEED_UPDATE = 2;
    GimBufferArrayFloat m_source_vertex_buffer;
    GimBufferArrayInt m_tri_index_buffer;
    int m_mask;
    GimBufferArrayFloat m_transformed_vertex_buffer = new GimBufferArrayFloat();
    GimAABBSet m_aabbset;
    GimDynArray<GimTriCollision.GIM_TRIPLANES_CACHE> m_planes_cache_buffer;
    GimBitSet m_planes_cache_bitset;
    gim_update_trimesh_function m_update_callback;
    GimGeometry.mat4f m_transform = new GimGeometry.mat4f();
    private final GimBufferArrayFloat.GIM_PROCESS_BUFFER_ARRAY_FN MULT_MAT_VEC4_KERNEL = new GimBufferArrayFloat.GIM_PROCESS_BUFFER_ARRAY_FN(){

        @Override
        public void run(GimGeometry.mat4f _mat, GimGeometry.vec3f _src, GimGeometry.vec3f _dst) {
            GimGeometry.MAT_DOT_VEC_3X4(_dst, _mat, _src);
        }
    };

    public void gim_trimesh_trimesh_collision(GimTrimesh trimesh2, GimDynArray<GimContact> contacts) {
        GimTrimeshTrimeshCol.gim_trimesh_trimesh_collision(this, trimesh2, contacts);
    }

    public void gim_trimesh_sphere_collision(GimGeometry.vec3f center, float radius, GimDynArray<GimContact> contacts) {
        GimTrimeshSphereCollision.gim_trimesh_sphere_collision(this, center, radius, contacts);
    }

    public void gim_trimesh_capsule_collision(GimTrimeshCapsuleCollision.GIM_CAPSULE_DATA capsule, GimDynArray<GimContact> contacts) {
        GimTrimeshCapsuleCollision.gim_trimesh_capsule_collision(this, capsule, contacts);
    }

    public static GimDynArray<GimGeometry.vec4f> GIM_CREATE_TRIMESHPLANE_CONTACTS() {
        return GimDynArray.GIM_DYNARRAY_CREATE(64);
    }

    public void gim_trimesh_plane_collision(GimGeometry.vec4f plane, GimDynArray<GimGeometry.vec4f> contacts) {
        GimTrimeshTrimeshCol.gim_trimesh_plane_collision(this, plane, contacts);
    }

    public int gim_trimesh_ray_collision(GimGeometry.vec3f origin, GimGeometry.vec3f dir, float tmax, GimTriCollision.GIM_TRIANGLE_RAY_CONTACT_DATA contact) {
        return GimTrimeshRayCollision.gim_trimesh_ray_collision(this, origin, dir, tmax, contact);
    }

    public int gim_trimesh_ray_closest_collision(GimGeometry.vec3f origin, GimGeometry.vec3f dir, float tmax, GimTriCollision.GIM_TRIANGLE_RAY_CONTACT_DATA contact) {
        return GimTrimeshRayCollision.gim_trimesh_ray_closest_collision(this, origin, dir, tmax, contact);
    }

    public int gim_trimesh_get_triangle_count() {
        return this.m_tri_index_buffer.getElementCount() / 3;
    }

    static GimTrimesh gim_trimesh_create_from_arrays(GimBufferArrayFloat vertex_array, GimBufferArrayInt triindex_array, boolean transformed_reply) {
        GimTrimesh trimesh = new GimTrimesh();
        assert (trimesh != null);
        assert (vertex_array != null);
        assert (triindex_array != null);
        trimesh.m_source_vertex_buffer = vertex_array;
        trimesh.m_tri_index_buffer = triindex_array;
        trimesh.m_mask = 2;
        if (transformed_reply) {
            trimesh.m_mask |= 1;
            trimesh.m_transformed_vertex_buffer = vertex_array.cloneValues();
        } else {
            trimesh.m_transformed_vertex_buffer = vertex_array.cloneRefs();
        }
        int facecount = trimesh.gim_trimesh_get_triangle_count();
        trimesh.m_aabbset = GimAABBSet.gim_aabbset_alloc(facecount);
        trimesh.m_planes_cache_buffer = GimDynArray.GIM_DYNARRAY_CREATE_SIZED(facecount);
        trimesh.m_planes_cache_bitset = GimBitSet.GIM_BITSET_CREATE_SIZED(facecount);
        trimesh.m_update_callback = null;
        GimGeometry.IDENTIFY_MATRIX_4X4(trimesh.m_transform);
        return trimesh;
    }

    public static GimTrimesh gim_trimesh_create_from_data(float[] vertex_array, boolean copy_vertices, int[] triindex_array, boolean copy_indices, boolean transformed_reply) {
        GimBufferArrayFloat buffer_vertex_array = copy_vertices ? GimBufferArrayFloat.createCopy(vertex_array) : GimBufferArrayFloat.createRef(vertex_array);
        GimBufferArrayInt buffer_triindex_array = copy_indices ? GimBufferArrayInt.createCopy(triindex_array) : GimBufferArrayInt.createRef(triindex_array);
        GimTrimesh THIS = GimTrimesh.gim_trimesh_create_from_arrays(buffer_vertex_array, buffer_triindex_array, transformed_reply);
        buffer_vertex_array.GIM_BUFFER_ARRAY_DESTROY();
        buffer_triindex_array.GIM_BUFFER_ARRAY_DESTROY();
        return THIS;
    }

    public void gim_trimesh_destroy() {
        this.m_aabbset.gim_aabbset_destroy();
        this.m_planes_cache_buffer.GIM_DYNARRAY_DESTROY();
        this.m_planes_cache_bitset.GIM_DYNARRAY_DESTROY();
        this.m_transformed_vertex_buffer.GIM_BUFFER_ARRAY_DESTROY();
        this.m_source_vertex_buffer.GIM_BUFFER_ARRAY_DESTROY();
        this.m_tri_index_buffer.GIM_BUFFER_ARRAY_DESTROY();
    }

    static GimTrimesh gim_trimesh_copy(GimTrimesh source_trimesh, boolean copy_by_reference, boolean transformed_reply) {
        if (copy_by_reference) {
            System.out.println("Copying TRIMESH by ref is not supported.");
        }
        GimBufferArrayFloat buffer_vertex_array = source_trimesh.m_source_vertex_buffer.cloneValues();
        GimBufferArrayInt buffer_triindex_array = source_trimesh.m_tri_index_buffer.cloneValues();
        GimTrimesh dest_trimesh = GimTrimesh.gim_trimesh_create_from_arrays(buffer_vertex_array, buffer_triindex_array, transformed_reply);
        buffer_vertex_array.GIM_BUFFER_ARRAY_DESTROY();
        buffer_triindex_array.GIM_BUFFER_ARRAY_DESTROY();
        return dest_trimesh;
    }

    public void gim_trimesh_locks_work_data() {
    }

    public void gim_trimesh_unlocks_work_data() {
    }

    boolean gim_trimesh_has_tranformed_reply() {
        return (this.m_mask & 1) != 0;
    }

    boolean gim_trimesh_needs_update() {
        return (this.m_mask & 2) != 0;
    }

    void gim_trimesh_post_update() {
        this.m_mask |= 2;
    }

    void gim_trimesh_update_vertices() {
        if (!this.gim_trimesh_has_tranformed_reply()) {
            return;
        }
        GimBufferArrayFloat psource_vertex_buffer = this.m_source_vertex_buffer;
        GimBufferArrayFloat ptransformed_vertex_buffer = this.m_transformed_vertex_buffer;
        GimGeometry.mat4f transform = new GimGeometry.mat4f();
        GimGeometry.COPY_MATRIX_4X4(transform, this.m_transform);
        GimBufferArrayFloat.GIM_PROCESS_BUFFER_ARRAY(transform, psource_vertex_buffer, ptransformed_vertex_buffer, this.MULT_MAT_VEC4_KERNEL);
    }

    void gim_trimesh_update_aabbset() {
        ObjArray<GimGeometry.vec3f> transformed_vertices = this.m_transformed_vertex_buffer.GIM_BUFFER_ARRAY_POINTER(0);
        assert (transformed_vertices != null);
        IntArray triangle_indices = this.m_tri_index_buffer.GIM_BUFFER_ARRAY_POINTER(0);
        assert (triangle_indices != null);
        int triangle_count = this.gim_trimesh_get_triangle_count();
        int i = 0;
        while (i < triangle_count) {
            GimGeometry.COMPUTEAABB_FOR_TRIANGLE(this.m_aabbset.at(i), transformed_vertices.at(triangle_indices.at(0)), transformed_vertices.at(triangle_indices.at(1)), transformed_vertices.at(triangle_indices.at(2)));
            triangle_indices.inc(3);
            ++i;
        }
        this.m_planes_cache_bitset.GIM_BITSET_CLEAR_ALL();
        this.m_aabbset.gim_aabbset_update();
    }

    public void gim_trimesh_update() {
        if (!this.gim_trimesh_needs_update()) {
            return;
        }
        this.gim_trimesh_update_vertices();
        this.gim_trimesh_locks_work_data();
        this.gim_trimesh_update_aabbset();
        this.gim_trimesh_unlocks_work_data();
        this.m_mask &= 0xFFFFFFFD;
    }

    public void gim_trimesh_set_tranform(GimGeometry.mat4f transform) {
        float diff = 0.0f;
        float[] originaltrans = this.m_transform.f;
        float[] newtrans = transform.f;
        int i = 0;
        while (i < 16) {
            diff += Math.abs(originaltrans[i] - newtrans[i]);
            ++i;
        }
        if (diff < 1.0E-5f) {
            return;
        }
        GimGeometry.COPY_MATRIX_4X4(this.m_transform, transform);
        this.gim_trimesh_post_update();
    }

    void gim_trimesh_get_triangle_data(int triangle_index, GimTriCollision.GIM_TRIANGLE_DATA tri_data) {
        ObjArray<GimGeometry.vec3f> transformed_vertices = this.m_transformed_vertex_buffer.GIM_BUFFER_ARRAY_POINTER(0);
        IntArray triangle_indices = this.m_tri_index_buffer.GIM_BUFFER_ARRAY_POINTER(triangle_index * 3);
        GimGeometry.VEC_COPY(tri_data.m_vertices[0], transformed_vertices.at(triangle_indices.at(0)));
        GimGeometry.VEC_COPY(tri_data.m_vertices[1], transformed_vertices.at(triangle_indices.at(1)));
        GimGeometry.VEC_COPY(tri_data.m_vertices[2], transformed_vertices.at(triangle_indices.at(2)));
        ObjArray<GimTriCollision.GIM_TRIPLANES_CACHE> planes = this.m_planes_cache_buffer.GIM_DYNARRAY_POINTER_V();
        planes.inc(triangle_index);
        if (planes.at0() == null) {
            planes.setAt0(new GimTriCollision.GIM_TRIPLANES_CACHE());
        }
        GimTriCollision.GIM_TRIPLANES_CACHE plane = planes.at0();
        boolean bit_eval = this.m_planes_cache_bitset.GIM_BITSET_GET(triangle_index);
        if (!bit_eval) {
            GimGeometry.TRIANGLE_PLANE(tri_data.m_vertices[0], tri_data.m_vertices[1], tri_data.m_vertices[2], plane.m_planes[0]);
            GimGeometry.EDGE_PLANE(tri_data.m_vertices[0], tri_data.m_vertices[1], plane.m_planes[0], plane.m_planes[1]);
            GimGeometry.EDGE_PLANE(tri_data.m_vertices[1], tri_data.m_vertices[2], plane.m_planes[0], plane.m_planes[2]);
            GimGeometry.EDGE_PLANE(tri_data.m_vertices[2], tri_data.m_vertices[0], plane.m_planes[0], plane.m_planes[3]);
            this.m_planes_cache_bitset.GIM_BITSET_SET(triangle_index);
        }
        GimGeometry.VEC_COPY_4(tri_data.m_planes.m_planes[0], plane.m_planes[0]);
        GimGeometry.VEC_COPY_4(tri_data.m_planes.m_planes[1], plane.m_planes[1]);
        GimGeometry.VEC_COPY_4(tri_data.m_planes.m_planes[2], plane.m_planes[2]);
        GimGeometry.VEC_COPY_4(tri_data.m_planes.m_planes[3], plane.m_planes[3]);
    }

    public void gim_trimesh_get_triangle_vertices(int triangle_index, GimGeometry.vec3f v1, GimGeometry.vec3f v2, GimGeometry.vec3f v3) {
        ObjArray<GimGeometry.vec3f> transformed_vertices = this.m_transformed_vertex_buffer.GIM_BUFFER_ARRAY_POINTER(0);
        IntArray triangle_indices = this.m_tri_index_buffer.GIM_BUFFER_ARRAY_POINTER(triangle_index * 3);
        GimGeometry.VEC_COPY(v1, transformed_vertices.at(triangle_indices.at(0)));
        GimGeometry.VEC_COPY(v2, transformed_vertices.at(triangle_indices.at(1)));
        GimGeometry.VEC_COPY(v3, transformed_vertices.at(triangle_indices.at(2)));
    }

    public GimAABBSet getAabbSet() {
        return this.m_aabbset;
    }

    static interface gim_update_trimesh_function {
        public void run(GimTrimesh var1);
    }
}

